/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.table.management;

import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.jdbc.table.management.AbstractTableManager;
import org.infinispan.persistence.jdbc.table.management.DbMetaData;
import org.infinispan.util.logging.LogFactory;

class SybaseTableManager
extends AbstractTableManager {
    private static final Log LOG = (Log)LogFactory.getLog(SybaseTableManager.class, Log.class);

    SybaseTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData) {
        super(connectionFactory, config, metaData, LOG);
    }

    @Override
    protected String getDropTimestampSql(String indexName) {
        return String.format("DROP INDEX %s.%s", this.getTableName(), this.getIndexName(true, indexName));
    }

    @Override
    public String getUpdateRowSql() {
        if (this.updateRowSql == null) {
            this.updateRowSql = String.format("UPDATE %s SET %s = ? , %s = ? WHERE %s = convert(%s,?)", this.getTableName(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.idColumnType());
        }
        return this.updateRowSql;
    }

    @Override
    public String getSelectRowSql() {
        if (this.selectRowSql == null) {
            this.selectRowSql = String.format("SELECT %s, %s FROM %s WHERE %s = convert(%s,?)", this.config.idColumnName(), this.config.dataColumnName(), this.getTableName(), this.config.idColumnName(), this.config.idColumnType());
        }
        return this.selectRowSql;
    }

    @Override
    public String getSelectMultipleRowSql(int numberOfParams) {
        String selectCriteria = this.config.idColumnName() + " = convert(" + this.config.idColumnType() + ",?)";
        return this.getSelectMultipleRowSql(numberOfParams, selectCriteria);
    }

    @Override
    public String getSelectIdRowSql() {
        if (this.selectIdRowSql == null) {
            this.selectIdRowSql = String.format("SELECT %s FROM %s WHERE %s = convert(%s,?)", this.config.idColumnName(), this.getTableName(), this.config.idColumnName(), this.config.idColumnType());
        }
        return this.selectIdRowSql;
    }

    @Override
    public String getDeleteRowSql() {
        if (this.deleteRowSql == null) {
            this.deleteRowSql = String.format("DELETE FROM %s WHERE %s = convert(%s,?)", this.getTableName(), this.config.idColumnName(), this.config.idColumnType());
        }
        return this.deleteRowSql;
    }

    @Override
    public String getUpsertRowSql() {
        if (this.upsertRowSql == null) {
            this.upsertRowSql = this.metaData.isSegmentedDisabled() ? String.format("MERGE INTO %1$s AS t USING (SELECT ? %2$s, ? %3$s, ? %4$s) AS tmp ON (t.%4$s = tmp.%4$s) WHEN MATCHED THEN UPDATE SET t.%2$s = tmp.%2$s, t.%3$s = tmp.%3$s WHEN NOT MATCHED THEN INSERT VALUES (tmp.%4$s, tmp.%2$s, tmp.%3$s)", this.getTableName(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName()) : String.format("MERGE INTO %1$s AS t USING (SELECT ? %2$s, ? %3$s, ? %4$s, ? %5$s) AS tmp ON (t.%4$s = tmp.%4$s) WHEN MATCHED THEN UPDATE SET t.%2$s = tmp.%2$s, t.%3$s = tmp.%3$s WHEN NOT MATCHED THEN INSERT VALUES (tmp.%4$s, tmp.%2$s, tmp.%3$s, tmp.%5$s)", this.getTableName(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.segmentColumnName());
        }
        return this.upsertRowSql;
    }
}

