/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.exporters;

import io.smallrye.metrics.exporters.ExporterUtil;

public class PrometheusUnit {
    private PrometheusUnit() {
    }

    public static String getBaseUnitAsPrometheusString(String unit) {
        String out;
        switch (unit) {
            case "bits": 
            case "kilobits": 
            case "megabits": 
            case "gigabits": 
            case "kibibits": 
            case "mebibits": 
            case "gibibits": 
            case "bytes": 
            case "kilobytes": 
            case "megabytes": 
            case "gigabytes": {
                out = "bytes";
                break;
            }
            case "nanoseconds": 
            case "microseconds": 
            case "milliseconds": 
            case "seconds": 
            case "minutes": 
            case "hours": 
            case "days": {
                out = "seconds";
                break;
            }
            default: {
                out = unit;
            }
        }
        return out;
    }

    public static Double scaleToBase(String unit, Double value) {
        Double out;
        switch (unit) {
            case "bits": {
                out = value / 8.0;
                break;
            }
            case "kilobits": {
                out = value * 1000.0 / 8.0;
                break;
            }
            case "megabits": {
                out = value * 1000000.0 / 8.0;
                break;
            }
            case "gigabits": {
                out = value * 1.0E9 / 8.0;
                break;
            }
            case "kibibits": {
                out = value * 128.0;
                break;
            }
            case "mebibits": {
                out = value * 1024.0 * 128.0;
                break;
            }
            case "gibibits": {
                out = value * 1024.0 * 1024.0 * 128.0;
                break;
            }
            case "bytes": {
                out = value;
                break;
            }
            case "kilobytes": {
                out = value * 1000.0;
                break;
            }
            case "megabytes": {
                out = value * 1000000.0;
                break;
            }
            case "gigabytes": {
                out = value * 1.0E9;
                break;
            }
            case "nanoseconds": {
                out = ExporterUtil.convertNanosTo(value, "seconds");
                break;
            }
            case "microseconds": {
                out = ExporterUtil.convertNanosTo(value * 1000.0, "seconds");
                break;
            }
            case "milliseconds": {
                out = ExporterUtil.convertNanosTo(value * 1000000.0, "seconds");
                break;
            }
            case "seconds": {
                out = ExporterUtil.convertNanosTo(value * 1.0E9, "seconds");
                break;
            }
            case "minutes": {
                out = ExporterUtil.convertNanosTo(value * 6.0E10, "seconds");
                break;
            }
            case "hours": {
                out = ExporterUtil.convertNanosTo(value * 3.6E12, "seconds");
                break;
            }
            case "days": {
                out = ExporterUtil.convertNanosTo(value * 8.64E13, "seconds");
                break;
            }
            default: {
                out = value;
            }
        }
        return out;
    }
}

