/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronSubsystemParser1_0;
import org.wildfly.extension.elytron.ElytronSubsystemParser1_1;
import org.wildfly.extension.elytron.ElytronSubsystemParser1_2;
import org.wildfly.extension.elytron.ElytronSubsystemParser2_0;
import org.wildfly.extension.elytron.ElytronSubsystemParser3_0;
import org.wildfly.extension.elytron.ElytronSubsystemParser4_0;
import org.wildfly.security.auth.client.AuthenticationContext;

public class ElytronExtension
implements Extension {
    static final String NAMESPACE_1_0 = "urn:wildfly:elytron:1.0";
    static final String NAMESPACE_1_1 = "urn:wildfly:elytron:1.1";
    static final String NAMESPACE_1_2 = "urn:wildfly:elytron:1.2";
    static final String NAMESPACE_2_0 = "urn:wildfly:elytron:2.0";
    static final String NAMESPACE_3_0 = "urn:wildfly:elytron:3.0";
    static final String NAMESPACE_4_0 = "urn:wildfly:elytron:4.0";
    public static final String SUBSYSTEM_NAME = "elytron";
    public static final AttachmentKey<AuthenticationContext> AUTHENTICATION_CONTEXT_KEY = AttachmentKey.create(AuthenticationContext.class);
    static final ModelVersion ELYTRON_1_2_0 = ModelVersion.create((int)1, (int)2);
    static final ModelVersion ELYTRON_2_0_0 = ModelVersion.create((int)2);
    static final ModelVersion ELYTRON_3_0_0 = ModelVersion.create((int)3);
    static final ModelVersion ELYTRON_4_0_0;
    private static final ModelVersion ELYTRON_CURRENT;
    static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected static final PathElement SUBSYSTEM_PATH;
    private static final String RESOURCE_NAME;
    static final ServiceName BASE_SERVICE_NAME;

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefixes) {
        StringBuilder sb = new StringBuilder(SUBSYSTEM_NAME);
        if (keyPrefixes != null) {
            for (String current : keyPrefixes) {
                sb.append(".").append(current);
            }
        }
        return new StandardResourceDescriptionResolver(sb.toString(), RESOURCE_NAME, ElytronExtension.class.getClassLoader(), true, false);
    }

    static boolean isServerOrHostController(ImmutableManagementResourceRegistration resourceRegistration) {
        return resourceRegistration.getProcessType().isServer() || !"profile".equals(resourceRegistration.getPathAddress().getElement(0).getKey());
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE_1_0, () -> new ElytronSubsystemParser1_0());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE_1_1, () -> new ElytronSubsystemParser1_1());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE_1_2, () -> new ElytronSubsystemParser1_2());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE_2_0, () -> new ElytronSubsystemParser2_0());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE_3_0, () -> new ElytronSubsystemParser3_0());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE_4_0, () -> new ElytronSubsystemParser4_0());
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystemRegistration = context.registerSubsystem(SUBSYSTEM_NAME, ELYTRON_CURRENT);
        subsystemRegistration.setHostCapable();
        ManagementResourceRegistration registration = subsystemRegistration.registerSubsystemModel((ResourceDefinition)ElytronDefinition.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystemRegistration.registerXMLElementWriter(() -> new ElytronSubsystemParser4_0());
    }

    static <T> ServiceController<T> getRequiredService(ServiceRegistry serviceRegistry, ServiceName serviceName, Class<T> serviceType) {
        ServiceController controller = serviceRegistry.getRequiredService(serviceName);
        return controller;
    }

    static {
        ELYTRON_CURRENT = ELYTRON_4_0_0 = ModelVersion.create((int)4);
        SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME);
        RESOURCE_NAME = ElytronExtension.class.getPackage().getName() + ".LocalDescriptions";
        BASE_SERVICE_NAME = ServiceName.of((String[])new String[]{SUBSYSTEM_NAME});
    }
}

