/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.util.Bits;
import org.jgroups.util.Util;

public class NakAckHeader2
extends Header {
    public static final byte MSG = 1;
    public static final byte XMIT_REQ = 2;
    public static final byte XMIT_RSP = 3;
    public static final byte HIGHEST_SEQNO = 4;
    byte type;
    long seqno = -1L;
    Address sender;

    public NakAckHeader2() {
    }

    @Override
    public short getMagicId() {
        return 78;
    }

    @Override
    public Supplier<? extends Header> create() {
        return NakAckHeader2::new;
    }

    public static NakAckHeader2 createMessageHeader(long seqno) {
        return new NakAckHeader2(1, seqno);
    }

    public static NakAckHeader2 createXmitRequestHeader(Address orginal_sender) {
        return new NakAckHeader2(2, orginal_sender);
    }

    public static NakAckHeader2 createXmitResponseHeader() {
        return new NakAckHeader2(3, -1L);
    }

    public static NakAckHeader2 createHighestSeqnoHeader(long seqno) {
        return new NakAckHeader2(4, seqno);
    }

    private NakAckHeader2(byte type, long seqno) {
        this.type = type;
        this.seqno = seqno;
    }

    private NakAckHeader2(byte type, Address sender) {
        this.type = type;
        this.sender = sender;
    }

    public byte getType() {
        return this.type;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public Address getSender() {
        return this.sender;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        out.writeByte(this.type);
        switch (this.type) {
            case 1: 
            case 3: 
            case 4: {
                Bits.writeLong(this.seqno, out);
                break;
            }
            case 2: {
                Util.writeAddress(this.sender, out);
            }
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.type = in.readByte();
        switch (this.type) {
            case 1: 
            case 3: 
            case 4: {
                this.seqno = Bits.readLong(in);
                break;
            }
            case 2: {
                this.sender = Util.readAddress(in);
            }
        }
    }

    @Override
    public int serializedSize() {
        int retval = 1;
        switch (this.type) {
            case 1: 
            case 3: 
            case 4: {
                return retval + Bits.size(this.seqno);
            }
            case 2: {
                return retval += Util.size(this.sender);
            }
        }
        return retval;
    }

    public NakAckHeader2 copy() {
        NakAckHeader2 ret = new NakAckHeader2();
        ret.type = this.type;
        ret.seqno = this.seqno;
        ret.sender = this.sender;
        return ret;
    }

    public static String type2Str(byte t) {
        switch (t) {
            case 1: {
                return "MSG";
            }
            case 2: {
                return "XMIT_REQ";
            }
            case 3: {
                return "XMIT_RSP";
            }
            case 4: {
                return "HIGHEST_SEQNO";
            }
        }
        return "<undefined>";
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[").append(NakAckHeader2.type2Str(this.type));
        switch (this.type) {
            case 1: 
            case 3: 
            case 4: {
                ret.append(", seqno=").append(this.seqno);
                break;
            }
        }
        if (this.sender != null) {
            ret.append(", sender=").append(this.sender);
        }
        ret.append(']');
        return ret.toString();
    }
}

