/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import io.reactivex.Flowable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.commons.util.IntSet;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.AbstractCacheStream;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.stream.impl.KeyWatchingCompletionListener;
import org.infinispan.stream.impl.RehashPublisherDecorator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class CompletionRehashPublisherDecorator<S>
extends RehashPublisherDecorator<S> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Consumer<? super Supplier<PrimitiveIterator.OfInt>> userListener;
    private final List<KeyWatchingCompletionListener> completionListeners;

    CompletionRehashPublisherDecorator(AbstractCacheStream.IteratorOperation iteratorOperation, DistributionManager dm, Address localAddress, Consumer<? super Supplier<PrimitiveIterator.OfInt>> userListener, Consumer<? super Supplier<PrimitiveIterator.OfInt>> completedSegments, Consumer<? super Supplier<PrimitiveIterator.OfInt>> lostSegments, Executor executor, Consumer<Object> keyConsumer, Function<S, ?> toKeyFunction) {
        super(iteratorOperation, dm, localAddress, completedSegments, lostSegments, executor, keyConsumer, toKeyFunction);
        this.userListener = userListener;
        this.completionListeners = Collections.synchronizedList(new ArrayList(4));
    }

    public void valueIterated(Object obj) {
        for (KeyWatchingCompletionListener kwcl : this.completionListeners) {
            kwcl.valueIterated(obj);
        }
    }

    public void complete() {
        this.completionListeners.forEach(KeyWatchingCompletionListener::completed);
    }

    @Override
    Log getLog() {
        return log;
    }

    @Override
    public Publisher<S> decorateRemote(ClusterStreamManager.RemoteIteratorPublisher<S> remotePublisher) {
        KeyWatchingCompletionListener kwcl = new KeyWatchingCompletionListener(this.userListener);
        this.completionListeners.add(kwcl);
        Publisher convertedPublisher = s -> remotePublisher.subscribe(s, i -> {
            this.completedSegments.accept(i);
            kwcl.accept((Supplier<PrimitiveIterator.OfInt>)i);
        }, this.lostSegments);
        Publisher publisher = this.iteratorOperation.handlePublisher(this.applySubscribeExecutor(convertedPublisher), this.keyConsumer, this.toKeyFunction);
        return Flowable.fromPublisher(publisher).doOnNext(kwcl::valueAdded);
    }

    @Override
    public Publisher<S> decorateLocal(ConsistentHash beginningCh, boolean onlyLocal, IntSet segmentsToFilter, Publisher<S> localPublisher) {
        KeyWatchingCompletionListener kwcl = new KeyWatchingCompletionListener(this.userListener);
        this.completionListeners.add(kwcl);
        Publisher<S> convertedLocalPublisher = this.decorateLocal(i -> {
            this.completedSegments.accept(i);
            kwcl.accept((Supplier<PrimitiveIterator.OfInt>)i);
        }, beginningCh, onlyLocal, segmentsToFilter, localPublisher);
        return Flowable.fromPublisher(this.iteratorOperation.handlePublisher(convertedLocalPublisher, this.keyConsumer, this.toKeyFunction)).doOnNext(kwcl::valueAdded);
    }
}

