/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.plugin.impl;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerPlugin;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public class NotificationActiveMQServerPlugin
implements ActiveMQServerPlugin {
    private static final Logger logger = Logger.getLogger(NotificationActiveMQServerPlugin.class);
    public static final String SEND_CONNECTION_NOTIFICATIONS = "SEND_CONNECTION_NOTIFICATIONS";
    public static final String SEND_SESSION_NOTIFICATIONS = "SEND_SESSION_NOTIFICATIONS";
    public static final String SEND_ADDRESS_NOTIFICATIONS = "SEND_ADDRESS_NOTIFICATIONS";
    public static final String SEND_DELIVERED_NOTIFICATIONS = "SEND_DELIVERED_NOTIFICATIONS";
    public static final String SEND_EXPIRED_NOTIFICATIONS = "SEND_EXPIRED_NOTIFICATIONS";
    private boolean sendConnectionNotifications;
    private boolean sendSessionNotifications;
    private boolean sendAddressNotifications;
    private boolean sendDeliveredNotifications;
    private boolean sendExpiredNotifications;
    private final AtomicReference<ManagementService> managementService = new AtomicReference();

    @Override
    public void init(Map<String, String> properties) {
        this.sendConnectionNotifications = Boolean.parseBoolean(properties.getOrDefault(SEND_CONNECTION_NOTIFICATIONS, Boolean.FALSE.toString()));
        this.sendSessionNotifications = Boolean.parseBoolean(properties.getOrDefault(SEND_SESSION_NOTIFICATIONS, Boolean.FALSE.toString()));
        this.sendAddressNotifications = Boolean.parseBoolean(properties.getOrDefault(SEND_ADDRESS_NOTIFICATIONS, Boolean.FALSE.toString()));
        this.sendDeliveredNotifications = Boolean.parseBoolean(properties.getOrDefault(SEND_DELIVERED_NOTIFICATIONS, Boolean.FALSE.toString()));
        this.sendExpiredNotifications = Boolean.parseBoolean(properties.getOrDefault(SEND_EXPIRED_NOTIFICATIONS, Boolean.FALSE.toString()));
    }

    @Override
    public void registered(ActiveMQServer server) {
        this.managementService.set(server.getManagementService());
    }

    @Override
    public void unregistered(ActiveMQServer server) {
        this.managementService.set(null);
    }

    @Override
    public void afterCreateConnection(RemotingConnection connection) throws ActiveMQException {
        this.sendConnectionNotification(connection, CoreNotificationType.CONNECTION_CREATED);
    }

    @Override
    public void afterDestroyConnection(RemotingConnection connection) throws ActiveMQException {
        this.sendConnectionNotification(connection, CoreNotificationType.CONNECTION_DESTROYED);
    }

    @Override
    public void afterCreateSession(ServerSession session) throws ActiveMQException {
        this.sendSessionNotification(session, CoreNotificationType.SESSION_CREATED);
    }

    @Override
    public void afterCloseSession(ServerSession session, boolean failed) throws ActiveMQException {
        this.sendSessionNotification(session, CoreNotificationType.SESSION_CLOSED);
    }

    @Override
    public void afterAddAddress(AddressInfo addressInfo, boolean reload) throws ActiveMQException {
        this.sendAddressNotification(addressInfo, CoreNotificationType.ADDRESS_ADDED);
    }

    @Override
    public void afterRemoveAddress(SimpleString address, AddressInfo addressInfo) throws ActiveMQException {
        this.sendAddressNotification(addressInfo, CoreNotificationType.ADDRESS_REMOVED);
    }

    @Override
    public void afterDeliver(ServerConsumer consumer, MessageReference reference) throws ActiveMQException {
        ManagementService managementService = this.getManagementService();
        if (managementService != null && this.sendDeliveredNotifications) {
            try {
                if (!reference.getQueue().getAddress().equals((Object)managementService.getManagementNotificationAddress())) {
                    TypedProperties props = new TypedProperties();
                    props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, consumer.getQueueAddress());
                    props.putByteProperty(ManagementHelper.HDR_ROUTING_TYPE, consumer.getQueueType().getType());
                    props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, consumer.getQueueName());
                    props.putLongProperty(ManagementHelper.HDR_CONSUMER_NAME, consumer.getID());
                    props.putLongProperty(ManagementHelper.HDR_MESSAGE_ID, reference.getMessageID());
                    managementService.sendNotification(new Notification(null, (NotificationType)CoreNotificationType.MESSAGE_DELIVERED, props));
                }
            }
            catch (Exception e) {
                logger.warn("Error sending notification: " + CoreNotificationType.MESSAGE_DELIVERED, (Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void messageExpired(MessageReference message, SimpleString messageExpiryAddress, ServerConsumer consumer) {
        ManagementService managementService = this.getManagementService();
        if (managementService != null && this.sendExpiredNotifications) {
            try {
                if (!message.getQueue().getAddress().equals((Object)managementService.getManagementNotificationAddress())) {
                    TypedProperties props = new TypedProperties();
                    props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, message.getQueue().getAddress());
                    props.putByteProperty(ManagementHelper.HDR_ROUTING_TYPE, message.getQueue().getRoutingType().getType());
                    props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, message.getQueue().getName());
                    props.putLongProperty(ManagementHelper.HDR_MESSAGE_ID, message.getMessageID());
                    if (message.hasConsumerId()) {
                        props.putLongProperty(ManagementHelper.HDR_CONSUMER_NAME, message.getConsumerId());
                    }
                    managementService.sendNotification(new Notification(null, (NotificationType)CoreNotificationType.MESSAGE_EXPIRED, props));
                }
            }
            catch (Exception e) {
                logger.warn("Error sending notification: " + CoreNotificationType.MESSAGE_EXPIRED, (Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sendAddressNotification(AddressInfo addressInfo, CoreNotificationType type) {
        ManagementService managementService = this.getManagementService();
        if (managementService != null && this.sendAddressNotifications) {
            try {
                TypedProperties props = new TypedProperties();
                props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, addressInfo.getName());
                props.putByteProperty(ManagementHelper.HDR_ROUTING_TYPE, addressInfo.getRoutingType().getType());
                managementService.sendNotification(new Notification(null, (NotificationType)type, props));
            }
            catch (Exception e) {
                logger.warn("Error sending notification: " + type, (Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sendConnectionNotification(RemotingConnection connection, CoreNotificationType type) {
        ManagementService managementService = this.getManagementService();
        if (managementService != null && this.sendConnectionNotifications) {
            try {
                TypedProperties props = new TypedProperties();
                props.putSimpleStringProperty(ManagementHelper.HDR_CONNECTION_NAME, SimpleString.toSimpleString((String)connection.getID().toString()));
                props.putSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS, SimpleString.toSimpleString((String)connection.getRemoteAddress()));
                managementService.sendNotification(new Notification(null, (NotificationType)type, props));
            }
            catch (Exception e) {
                logger.warn("Error sending notification: " + type, (Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sendSessionNotification(ServerSession session, CoreNotificationType type) {
        ManagementService managementService = this.getManagementService();
        if (managementService != null && this.sendSessionNotifications) {
            try {
                TypedProperties props = new TypedProperties();
                props.putSimpleStringProperty(ManagementHelper.HDR_CONNECTION_NAME, SimpleString.toSimpleString((String)session.getConnectionID().toString()));
                props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.toSimpleString((String)session.getUsername()));
                props.putSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME, SimpleString.toSimpleString((String)session.getName()));
                managementService.sendNotification(new Notification(null, (NotificationType)type, props));
            }
            catch (Exception e) {
                logger.warn("Error sending notification: " + type, (Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean isSendConnectionNotifications() {
        return this.sendConnectionNotifications;
    }

    public void setSendConnectionNotifications(boolean sendConnectionNotifications) {
        this.sendConnectionNotifications = sendConnectionNotifications;
    }

    public boolean isSendSessionNotifications() {
        return this.sendSessionNotifications;
    }

    public void setSendSessionNotifications(boolean sendSessionNotifications) {
        this.sendSessionNotifications = sendSessionNotifications;
    }

    public boolean isSendDeliveredNotifications() {
        return this.sendDeliveredNotifications;
    }

    public void setSendDeliveredNotifications(boolean sendDeliveredNotifications) {
        this.sendDeliveredNotifications = sendDeliveredNotifications;
    }

    public boolean isSendExpiredNotifications() {
        return this.sendExpiredNotifications;
    }

    public void setSendExpiredNotifications(boolean sendExpiredNotifications) {
        this.sendExpiredNotifications = sendExpiredNotifications;
    }

    public boolean isSendAddressNotifications() {
        return this.sendAddressNotifications;
    }

    public void setSendAddressNotifications(boolean sendAddressNotifications) {
        this.sendAddressNotifications = sendAddressNotifications;
    }

    private ManagementService getManagementService() {
        return this.managementService.get();
    }
}

