/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import javax.json.JsonObjectBuilder;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ProducerFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerProducer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.utils.JsonLoader;

public class ProducerView
extends ActiveMQAbstractView<ServerProducer> {
    private static final String defaultSortColumn = "creationTime";
    private final ActiveMQServer server;

    public ProducerView(ActiveMQServer server) {
        this.server = server;
        this.predicate = new ProducerFilterPredicate(server);
    }

    @Override
    public Class getClassT() {
        return ServerProducer.class;
    }

    @Override
    public JsonObjectBuilder toJson(ServerProducer producer) {
        ServerSession session = this.server.getSessionByID(producer.getSessionID());
        if (session == null) {
            return null;
        }
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add("id", this.toString(producer.getID())).add("session", this.toString(session.getName())).add("clientID", this.toString(session.getRemotingConnection().getClientID())).add("user", this.toString(session.getUsername())).add("protocol", this.toString(session.getRemotingConnection().getProtocolName())).add("address", this.toString(producer.getAddress() != null ? producer.getAddress() : session.getDefaultAddress())).add("localAddress", this.toString(session.getRemotingConnection().getTransportConnection().getLocalAddress())).add("remoteAddress", this.toString(session.getRemotingConnection().getTransportConnection().getRemoteAddress())).add(defaultSortColumn, this.toString(producer.getCreationTime()));
        return obj;
    }

    @Override
    public Object getField(ServerProducer producer, String fieldName) {
        ServerSession session = this.server.getSessionByID(producer.getSessionID());
        if (session == null) {
            return null;
        }
        switch (fieldName) {
            case "id": {
                return producer.getID();
            }
            case "session": {
                return session.getName();
            }
            case "user": {
                return session.getUsername();
            }
            case "clientID": {
                return session.getRemotingConnection().getClientID();
            }
            case "protocol": {
                return session.getRemotingConnection().getProtocolName();
            }
            case "address": {
                return producer.getAddress() != null ? producer.getAddress() : session.getDefaultAddress();
            }
            case "localAddress": {
                return session.getRemotingConnection().getTransportConnection().getLocalAddress();
            }
            case "remoteAddress": {
                return session.getRemotingConnection().getTransportConnection().getRemoteAddress();
            }
            case "creationTime": {
                return producer.getCreationTime();
            }
        }
        throw new IllegalArgumentException("Unsupported field, " + fieldName);
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

