/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.logging;

import java.io.IOException;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYTX", length=4)
public interface TransactionLogger
extends BasicLogger {
    public static final TransactionLogger ROOT_LOGGER = (TransactionLogger)Logger.getMessageLogger(TransactionLogger.class, (String)"org.jboss.as.txn");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1, value="Unable to roll back active transaction")
    public void unableToRollBack(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="Unable to get transaction state")
    public void unableToGetTransactionStatus(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="APPLICATION ERROR: transaction still active in request with status %s")
    public void transactionStillOpen(int var1);

    @Message(id=4, value="Create failed")
    public StartException createFailed(@Cause Throwable var1);

    @Message(id=5, value="%s manager create failed")
    public StartException managerStartFailure(@Cause Throwable var1, String var2);

    @Message(id=6, value="Failed to configure object store browser bean")
    public StartException objectStoreStartFailure(@Cause Throwable var1);

    @Message(id=7, value="Service not started")
    public IllegalStateException serviceNotStarted();

    @Message(id=8, value="Start failed")
    public StartException startFailure(@Cause Throwable var1);

    @Message(id=9, value="Unknown metric %s")
    public String unknownMetric(Object var1);

    @Message(id=10, value="MBean Server service not installed, this functionality is not available if the JMX subsystem has not been installed.")
    public RuntimeException jmxSubsystemNotInstalled();

    @Message(id=12, value="Attributes %s and %s are alternatives; both cannot be set with conflicting values.")
    public OperationFailedException inconsistentStatisticsSettings(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="The %s attribute on the %s is set to the default value. This is a danger for environments running multiple servers. Please make sure the attribute value is unique.")
    public void nodeIdentifierIsSetToDefault(String var1, String var2);

    @Message(id=15, value="Jndi names have to start with java:/ or java:jboss/")
    public OperationFailedException jndiNameInvalidFormat();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16, value="Transaction started in EE Concurrent invocation left open, starting rollback to prevent leak.")
    public void rollbackOfTransactionStartedInEEConcurrentInvocation();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17, value="Failed to rollback transaction.")
    public void failedToRollbackTransaction(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18, value="Failed to suspend transaction.")
    public void failedToSuspendTransaction(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19, value="System error while checking for transaction leak in EE Concurrent invocation.")
    public void systemErrorWhileCheckingForTransactionLeak(@Cause Throwable var1);

    @Message(id=20, value="EE Concurrent ContextHandle serialization must be handled by the factory.")
    public IOException serializationMustBeHandledByTheFactory();

    @Message(id=21, value="EE Concurrent's TransactionSetupProviderService not started.")
    public IllegalStateException transactionSetupProviderServiceNotStarted();

    @Message(id=23, value="%s must be undefined if %s is 'true'.")
    public OperationFailedException mustBeUndefinedIfTrue(String var1, String var2);

    @Message(id=24, value="%s must be defined if %s is defined.")
    public OperationFailedException mustBedefinedIfDefined(String var1, String var2);

    @Message(id=25, value="Either %s must be 'true' or  %s must be defined.")
    public OperationFailedException eitherTrueOrDefined(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=26, value="The transaction %s could not be removed from the cache during cleanup.")
    public void transactionNotFound(Transaction var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=27, value="The pre-jca synchronization %s associated with tx %s failed during after completion")
    public void preJcaSyncAfterCompletionFailed(Synchronization var1, Transaction var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=28, value="The jca synchronization %s associated with tx %s failed during after completion")
    public void jcaSyncAfterCompletionFailed(Synchronization var1, Transaction var2, @Cause Exception var3);

    @Message(id=29, value="Syncs are not allowed to be registered when the tx is in state %s")
    public IllegalStateException syncsnotallowed(int var1);

    @Message(id=30, value="Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed")
    public IllegalStateException indexedChildResourceRegistrationNotAvailable(PathElement var1);

    @Message(id=31, value="The attribute '%s' is no longer supported")
    public XMLStreamException unsupportedAttribute(String var1, @Param Location var2);

    @Message(id=32, value="%s must be defined if %s is 'true'.")
    public OperationFailedException mustBeDefinedIfTrue(String var1, String var2);

    @Message(id=33, value="Only one of %s and %s can be 'true'.")
    public OperationFailedException onlyOneCanBeTrue(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=34, value="relative_to property of the object-store is set to the default value with jboss.server.data.dir")
    public void objectStoreRelativeToIsSetToDefault();

    @Message(id=35, value="Cannot find or import inflow transaction for xid %s and work %s")
    public WorkCompletedException cannotFindOrImportInflowTransaction(Xid var1, Work var2, @Cause Exception var3);

    @Message(id=36, value="Imported jca inflow transaction with xid %s of work %s is inactive")
    public WorkCompletedException importedInflowTransactionIsInactive(Xid var1, Work var2, @Cause Exception var3);

    @Message(id=37, value="Unexpected error on resuming transaction %s for work %s")
    public WorkCompletedException cannotResumeInflowTransactionUnexpectedError(Transaction var1, Work var2, @Cause Exception var3);

    @Message(id=38, value="Unexpected error on suspending transaction for work %s")
    public RuntimeException cannotSuspendInflowTransactionUnexpectedError(Work var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=39, value="A value of zero is not permitted for the maximum timeout, as such the timeout has been set to %s")
    public void timeoutValueIsSetToMaximum(int var1);
}

