/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.digest;

import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;
import org.wildfly.common.Assert;

public final class TruncatedMessageDigest
extends MessageDigest {
    private final MessageDigest delegate;
    private final int bytes;

    public TruncatedMessageDigest(MessageDigest delegate, int bytes) {
        super(delegate.getAlgorithm());
        this.delegate = delegate;
        this.bytes = bytes;
    }

    @Override
    public void update(byte input) {
        this.delegate.update(input);
    }

    @Override
    public void update(byte[] input, int offset, int len) {
        this.delegate.update(input, offset, len);
    }

    @Override
    public void update(byte[] input) {
        this.delegate.update(input);
    }

    @Override
    public byte[] digest() {
        byte[] digest = this.delegate.digest();
        return digest.length > this.bytes ? Arrays.copyOf(digest, this.bytes) : digest;
    }

    @Override
    public int digest(byte[] buf, int offset, int len) throws DigestException {
        Assert.checkNotNullParam("buf", buf);
        if (this.bytes > len) {
            throw new IllegalArgumentException("Output buffer too small for specified offset and length");
        }
        System.arraycopy(this.delegate.digest(), 0, buf, offset, this.bytes);
        return this.bytes;
    }

    @Override
    public byte[] digest(byte[] input) {
        this.update(input);
        return this.digest();
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new TruncatedMessageDigest((MessageDigest)this.delegate.clone(), this.bytes);
    }

    @Override
    protected void engineUpdate(byte input) {
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
    }

    @Override
    protected byte[] engineDigest() {
        return null;
    }

    @Override
    protected void engineReset() {
    }
}

