/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v51.impl;

import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.TransactionalDataRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.expiration.impl.ClusterExpirationManager;
import org.infinispan.expiration.impl.ExpirationManagerImpl;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.TimeSource;
import org.infinispan.hibernate.cache.commons.access.AccessDelegate;
import org.infinispan.hibernate.cache.commons.access.LockingInterceptor;
import org.infinispan.hibernate.cache.commons.access.NonStrictAccessDelegate;
import org.infinispan.hibernate.cache.commons.access.NonTxInvalidationCacheAccessDelegate;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.access.TombstoneAccessDelegate;
import org.infinispan.hibernate.cache.commons.access.TombstoneCallInterceptor;
import org.infinispan.hibernate.cache.commons.access.TxInvalidationCacheAccessDelegate;
import org.infinispan.hibernate.cache.commons.access.UnorderedDistributionInterceptor;
import org.infinispan.hibernate.cache.commons.access.UnorderedReplicationLogic;
import org.infinispan.hibernate.cache.commons.access.VersionedCallInterceptor;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.hibernate.cache.commons.util.FutureUpdate;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.commons.util.Tombstone;
import org.infinispan.hibernate.cache.commons.util.VersionedEntry;
import org.infinispan.hibernate.cache.v51.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.v51.impl.BaseRegion;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.interceptors.distribution.TriangleDistributionInterceptor;
import org.infinispan.interceptors.impl.CallInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;

public abstract class BaseTransactionalDataRegion
extends BaseRegion
implements TransactionalDataRegion,
InfinispanDataRegion {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(BaseTransactionalDataRegion.class);
    private final CacheDataDescription metadata;
    private final CacheKeysFactory cacheKeysFactory;
    private final boolean requiresTransaction;
    private long tombstoneExpiration;
    private PutFromLoadValidator validator;
    private AccessType accessType;
    private Strategy strategy;

    public BaseTransactionalDataRegion(AdvancedCache cache, String name, TransactionManager transactionManager, CacheDataDescription metadata, InfinispanRegionFactory factory, CacheKeysFactory cacheKeysFactory) {
        super(cache, name, transactionManager, factory);
        this.metadata = metadata;
        this.cacheKeysFactory = cacheKeysFactory;
        Configuration configuration = cache.getCacheConfiguration();
        this.requiresTransaction = configuration.transaction().transactionMode().isTransactional() && !configuration.transaction().autoCommit();
        this.tombstoneExpiration = factory.getPendingPutsCacheConfiguration().expiration().maxIdle();
        if (!this.isRegionAccessStrategyEnabled()) {
            this.strategy = Strategy.NONE;
        }
    }

    protected boolean isRegionAccessStrategyEnabled() {
        return true;
    }

    public CacheDataDescription getCacheDataDescription() {
        return this.metadata;
    }

    public CacheKeysFactory getCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    protected synchronized AccessDelegate createAccessDelegate(AccessType accessType) {
        if (accessType == null) {
            throw new IllegalArgumentException();
        }
        if (this.accessType != null && !this.accessType.equals((Object)accessType)) {
            throw new IllegalStateException("This region was already set up for " + this.accessType + ", cannot use using " + accessType);
        }
        this.accessType = accessType;
        CacheMode cacheMode = this.cache.getCacheConfiguration().clustering().cacheMode();
        if (accessType == AccessType.NONSTRICT_READ_WRITE) {
            this.prepareForVersionedEntries(cacheMode);
            return new NonStrictAccessDelegate((InfinispanDataRegion)this, this.getCacheDataDescription().getVersionComparator());
        }
        if (cacheMode.isDistributed() || cacheMode.isReplicated()) {
            this.prepareForTombstones();
            return new TombstoneAccessDelegate((InfinispanDataRegion)this);
        }
        this.prepareForValidation();
        if (this.cache.getCacheConfiguration().transaction().transactionMode().isTransactional()) {
            return new TxInvalidationCacheAccessDelegate((InfinispanDataRegion)this, this.validator);
        }
        return new NonTxInvalidationCacheAccessDelegate((InfinispanDataRegion)this, this.validator);
    }

    protected void prepareForValidation() {
        if (this.strategy != null) {
            assert (this.strategy == Strategy.VALIDATION);
            return;
        }
        this.validator = new PutFromLoadValidator(this.cache, (TimeSource)this.factory, this.factory.getPendingPutsCacheConfiguration());
        this.strategy = Strategy.VALIDATION;
    }

    protected void prepareForVersionedEntries(CacheMode cacheMode) {
        if (this.strategy != null) {
            assert (this.strategy == Strategy.VERSIONED_ENTRIES);
            return;
        }
        this.replaceCommonInterceptors();
        this.replaceExpirationManager();
        VersionedCallInterceptor versionedCallInterceptor = new VersionedCallInterceptor((InfinispanDataRegion)this);
        ComponentRegistry compReg = this.cache.getComponentRegistry();
        compReg.registerComponent((Object)versionedCallInterceptor, VersionedCallInterceptor.class);
        AsyncInterceptorChain interceptorChain = this.cache.getAsyncInterceptorChain();
        interceptorChain.addInterceptorBefore((AsyncInterceptor)versionedCallInterceptor, CallInterceptor.class);
        if (cacheMode.isClustered()) {
            UnorderedReplicationLogic replLogic = new UnorderedReplicationLogic();
            compReg.registerComponent((Object)replLogic, ClusteringDependentLogic.class);
            compReg.rewire();
        }
        this.strategy = Strategy.VERSIONED_ENTRIES;
    }

    private void prepareForTombstones() {
        if (this.strategy != null) {
            assert (this.strategy == Strategy.TOMBSTONES);
            return;
        }
        Configuration configuration = this.cache.getCacheConfiguration();
        if (configuration.memory().isEvictionEnabled()) {
            log.evictionWithTombstones();
        }
        this.replaceCommonInterceptors();
        this.replaceExpirationManager();
        TombstoneCallInterceptor tombstoneCallInterceptor = new TombstoneCallInterceptor((InfinispanDataRegion)this);
        ComponentRegistry compReg = this.cache.getComponentRegistry();
        compReg.registerComponent((Object)tombstoneCallInterceptor, TombstoneCallInterceptor.class);
        AsyncInterceptorChain interceptorChain = this.cache.getAsyncInterceptorChain();
        interceptorChain.addInterceptorBefore((AsyncInterceptor)tombstoneCallInterceptor, CallInterceptor.class);
        UnorderedReplicationLogic replLogic = new UnorderedReplicationLogic();
        compReg.registerComponent((Object)replLogic, ClusteringDependentLogic.class);
        compReg.rewire();
        this.strategy = Strategy.TOMBSTONES;
    }

    private void replaceCommonInterceptors() {
        CacheMode cacheMode = this.cache.getCacheConfiguration().clustering().cacheMode();
        if (!cacheMode.isReplicated() && !cacheMode.isDistributed()) {
            return;
        }
        AsyncInterceptorChain chain = this.cache.getAsyncInterceptorChain();
        LockingInterceptor lockingInterceptor = new LockingInterceptor();
        this.cache.getComponentRegistry().registerComponent((Object)lockingInterceptor, LockingInterceptor.class);
        if (!chain.addInterceptorBefore((AsyncInterceptor)lockingInterceptor, NonTransactionalLockingInterceptor.class)) {
            throw new IllegalStateException("Misconfigured cache, interceptor chain is " + chain);
        }
        this.cache.removeInterceptor(NonTransactionalLockingInterceptor.class);
        UnorderedDistributionInterceptor distributionInterceptor = new UnorderedDistributionInterceptor();
        this.cache.getComponentRegistry().registerComponent((Object)distributionInterceptor, UnorderedDistributionInterceptor.class);
        if (!chain.addInterceptorBefore((AsyncInterceptor)distributionInterceptor, NonTxDistributionInterceptor.class) && !chain.addInterceptorBefore((AsyncInterceptor)distributionInterceptor, TriangleDistributionInterceptor.class)) {
            throw new IllegalStateException("Misconfigured cache, interceptor chain is " + chain);
        }
        this.cache.removeInterceptor(NonTxDistributionInterceptor.class);
        this.cache.removeInterceptor(TriangleDistributionInterceptor.class);
    }

    private void replaceExpirationManager() {
        ExpirationManager expirationManager = (ExpirationManager)this.cache.getComponentRegistry().getComponent(ExpirationManager.class);
        if (expirationManager instanceof ClusterExpirationManager) {
            ((ClusterExpirationManager)expirationManager).stop();
            this.cache.getComponentRegistry().registerComponent((Object)new ExpirationManagerImpl(), ExpirationManager.class);
            this.cache.getComponentRegistry().rewire();
        } else if (!(expirationManager instanceof ExpirationManagerImpl)) {
            throw new IllegalStateException("Expected clustered expiration manager, found " + expirationManager);
        }
    }

    public long getTombstoneExpiration() {
        return this.tombstoneExpiration;
    }

    @Override
    protected void runInvalidation(boolean inTransaction) {
        if (this.strategy == null) {
            throw new IllegalStateException("Strategy was not set");
        }
        switch (this.strategy) {
            case NONE: 
            case VALIDATION: {
                super.runInvalidation(inTransaction);
                return;
            }
            case TOMBSTONES: {
                this.removeEntries(inTransaction, (KeyValueFilter)Tombstone.EXCLUDE_TOMBSTONES);
                return;
            }
            case VERSIONED_ENTRIES: {
                this.removeEntries(inTransaction, (KeyValueFilter)VersionedEntry.EXCLUDE_EMPTY_EXTRACT_VALUE);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntries(boolean inTransaction, KeyValueFilter filter) {
        boolean startedTx = false;
        if (!inTransaction && this.requiresTransaction) {
            try {
                this.tm.begin();
                startedTx = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            AdvancedCache localCache = Caches.localCache((AdvancedCache)this.cache);
            long now = this.nextTimestamp();
            try (CloseableIterator it = Caches.entrySet((AdvancedCache)localCache, (KeyValueFilter)Tombstone.EXCLUDE_TOMBSTONES).iterator();){
                while (it.hasNext()) {
                    CacheEntry entry = (CacheEntry)it.next();
                    switch (this.strategy) {
                        case TOMBSTONES: {
                            localCache.remove(entry.getKey(), entry.getValue());
                            break;
                        }
                        case VERSIONED_ENTRIES: {
                            localCache.put(entry.getKey(), (Object)new VersionedEntry(null, null, now), this.tombstoneExpiration, TimeUnit.MILLISECONDS);
                        }
                    }
                }
            }
        }
        finally {
            if (startedTx) {
                try {
                    this.tm.commit();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public Map toMap() {
        if (this.strategy == null) {
            throw new IllegalStateException("Strategy was not set");
        }
        switch (this.strategy) {
            case NONE: 
            case VALIDATION: {
                return super.toMap();
            }
            case TOMBSTONES: {
                return Caches.entrySet((AdvancedCache)Caches.localCache((AdvancedCache)this.cache), (KeyValueFilter)Tombstone.EXCLUDE_TOMBSTONES).toMap();
            }
            case VERSIONED_ENTRIES: {
                return Caches.entrySet((AdvancedCache)Caches.localCache((AdvancedCache)this.cache), (KeyValueFilter)VersionedEntry.EXCLUDE_EMPTY_EXTRACT_VALUE, (Converter)VersionedEntry.EXCLUDE_EMPTY_EXTRACT_VALUE).toMap();
            }
        }
        throw new IllegalStateException(this.strategy.toString());
    }

    @Override
    public boolean contains(Object key) {
        if (!this.checkValid()) {
            return false;
        }
        Object value = this.cache.get(key);
        if (value instanceof Tombstone) {
            return false;
        }
        if (value instanceof FutureUpdate) {
            return ((FutureUpdate)value).getValue() != null;
        }
        if (value instanceof VersionedEntry) {
            return ((VersionedEntry)value).getValue() != null;
        }
        return value != null;
    }

    public Comparator<Object> getComparator(String subclass) {
        return this.metadata.getVersionComparator();
    }

    @Override
    public void destroy() throws CacheException {
        super.destroy();
        if (this.validator != null) {
            this.validator.destroy();
        }
    }

    protected static enum Strategy {
        NONE,
        VALIDATION,
        TOMBSTONES,
        VERSIONED_ENTRIES;

    }
}

