/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.handlers.PathHandler;
import java.util.Collection;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.HttpInvokerHostService;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowRootDefinition;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;

public class HttpInvokerDefinition
extends PersistentResourceDefinition {
    static final RuntimeCapability<Void> HTTP_INVOKER_HOST_CAPABILITY;
    static final SimpleAttributeDefinition HTTP_AUTHENTICATION_FACTORY;
    protected static final SimpleAttributeDefinition SECURITY_REALM;
    protected static final SimpleAttributeDefinition PATH;
    static final Collection<AttributeDefinition> ATTRIBUTES;
    static final HttpInvokerDefinition INSTANCE;

    private HttpInvokerDefinition() {
        super(new PersistentResourceDefinition.Parameters(UndertowExtension.PATH_HTTP_INVOKER, (ResourceDescriptionResolver)UndertowExtension.getResolver("http-invoker")).setAddHandler((OperationStepHandler)new HttpInvokerAdd()).setRemoveHandler((OperationStepHandler)new HttpInvokerRemove()).setCapabilities(new RuntimeCapability[]{HTTP_INVOKER_HOST_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final class HttpInvokerRemove
    extends ServiceRemoveStepHandler {
        HttpInvokerRemove() {
            super((AbstractAddStepHandler)new HttpInvokerAdd());
        }

        protected ServiceName serviceName(String name, PathAddress address) {
            return HTTP_INVOKER_HOST_CAPABILITY.getCapabilityServiceName(address);
        }
    }

    private static final class HttpInvokerAdd
    extends AbstractAddStepHandler {
        HttpInvokerAdd() {
            super(ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress();
            PathAddress hostAddress = address.getParent();
            PathAddress serverAddress = hostAddress.getParent();
            String path = PATH.resolveModelAttribute(context, model).asString();
            String httpAuthenticationFactory = null;
            String securityRealmString = null;
            ModelNode authFactory = HTTP_AUTHENTICATION_FACTORY.resolveModelAttribute(context, model);
            ModelNode securityRealm = SECURITY_REALM.resolveModelAttribute(context, model);
            if (authFactory.isDefined()) {
                httpAuthenticationFactory = authFactory.asString();
            } else if (securityRealm.isDefined()) {
                securityRealmString = securityRealm.asString();
            }
            HttpInvokerHostService service = new HttpInvokerHostService(path);
            String serverName = serverAddress.getLastElement().getValue();
            String hostName = hostAddress.getLastElement().getValue();
            CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(HTTP_INVOKER_HOST_CAPABILITY, (Service)service).addCapabilityRequirement(UndertowRootDefinition.HTTP_INVOKER_RUNTIME_CAPABILITY.getName(), PathHandler.class, service.getRemoteHttpInvokerServiceInjectedValue()).addCapabilityRequirement("org.wildfly.undertow.host", Host.class, service.getHost(), new String[]{serverName, hostName});
            if (httpAuthenticationFactory != null) {
                builder.addCapabilityRequirement("org.wildfly.security.http-authentication-factory", HttpAuthenticationFactory.class, service.getHttpAuthenticationFactoryInjectedValue(), new String[]{httpAuthenticationFactory});
            } else if (securityRealmString != null) {
                ServiceName realmServiceName = SecurityRealm.ServiceUtil.createServiceName((String)securityRealmString);
                builder.addDependency(realmServiceName, SecurityRealmService.class, service.getRealmService());
            }
            if (context.hasOptionalCapability("org.wildfly.mod_cluster", HTTP_INVOKER_HOST_CAPABILITY.getDynamicName(address), null)) {
                ServiceName svcName = context.getCapabilityServiceName("org.wildfly.mod_cluster", Void.class).append(new String[]{"undertow"});
                builder.addDependency(svcName);
            }
            builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }
}

