/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.remote.ManagedRemoteCacheContainer;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.infinispan.spi.RemoteCacheContainer;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.SuppliedValueService;
import org.wildfly.clustering.service.ValueDependency;

public class RemoteCacheContainerBuilder
extends CapabilityServiceNameProvider
implements ResourceServiceBuilder<RemoteCacheContainer>,
Function<RemoteCacheManager, RemoteCacheContainer>,
Supplier<RemoteCacheManager>,
Consumer<RemoteCacheManager> {
    private ValueDependency<Configuration> configuration;
    private final String name;

    public RemoteCacheContainerBuilder(PathAddress address) {
        super((Capability)RemoteCacheContainerResourceDefinition.Capability.CONTAINER, address);
        this.name = address.getLastElement().getValue();
    }

    public RemoteCacheContainerBuilder configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.configuration = new InjectedValueDependency(InfinispanRequirement.REMOTE_CONTAINER_CONFIGURATION.getServiceName(context, this.name), Configuration.class);
        return this;
    }

    public ServiceBuilder<RemoteCacheContainer> build(ServiceTarget target) {
        SuppliedValueService service = new SuppliedValueService((Function)this, (Supplier)this, (Consumer)this);
        ServiceBuilder builder = new AsynchronousServiceBuilder(this.getServiceName(), (Service)service).build(target).setInitialMode(ServiceController.Mode.ON_DEMAND);
        return this.configuration.register(builder);
    }

    @Override
    public RemoteCacheManager get() {
        Configuration configuration = (Configuration)this.configuration.getValue();
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(configuration);
        remoteCacheManager.start();
        InfinispanLogger.ROOT_LOGGER.remoteCacheContainerStarted(this.name);
        return remoteCacheManager;
    }

    @Override
    public void accept(RemoteCacheManager remoteCacheManager) {
        remoteCacheManager.stop();
        InfinispanLogger.ROOT_LOGGER.remoteCacheContainerStopped(this.name);
    }

    @Override
    public RemoteCacheContainer apply(RemoteCacheManager remoteCacheManager) {
        return new ManagedRemoteCacheContainer(this.name, remoteCacheManager);
    }
}

