/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Immutables;
import org.infinispan.conflict.ConflictManagerFactory;
import org.infinispan.conflict.impl.DefaultConflictManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.AvailabilityStrategy;
import org.infinispan.partitionhandling.impl.AvailabilityStrategyContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.RebalanceType;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.topology.RebalanceConfirmationCollector;
import org.infinispan.topology.RebalancingStatus;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterCacheStatus
implements AvailabilityStrategyContext {
    public static final int INITIAL_TOPOLOGY_ID = 1;
    public static final int INITIAL_REBALANCE_ID = 1;
    private static final Log log = LogFactory.getLog(ClusterCacheStatus.class);
    private static boolean trace = log.isTraceEnabled();
    private final EmbeddedCacheManager cacheManager;
    private final String cacheName;
    private final AvailabilityStrategy availabilityStrategy;
    private final ClusterTopologyManager clusterTopologyManager;
    private final PersistentUUIDManager persistentUUIDManager;
    private final boolean resolveConflictsOnMerge;
    private final RebalanceType rebalanceType;
    private Transport transport;
    private int initialTopologyId = 1;
    private volatile CacheJoinInfo joinInfo;
    private volatile List<Address> expectedMembers;
    private volatile Map<Address, Float> capacityFactors;
    private volatile List<Address> joiners;
    private Optional<ScopedPersistentState> persistentState;
    private volatile CacheTopology currentTopology;
    private volatile CacheTopology stableTopology;
    private volatile AvailabilityMode availabilityMode = AvailabilityMode.AVAILABLE;
    private volatile List<Address> queuedRebalanceMembers;
    private volatile boolean rebalancingEnabled = true;
    private volatile boolean rebalanceInProgress = false;
    private RebalanceConfirmationCollector rebalanceConfirmationCollector;
    private ComponentStatus status;

    public ClusterCacheStatus(EmbeddedCacheManager cacheManager, String cacheName, AvailabilityStrategy availabilityStrategy, RebalanceType rebalanceType, ClusterTopologyManager clusterTopologyManager, Transport transport, Optional<ScopedPersistentState> state, PersistentUUIDManager persistentUUIDManager, boolean resolveConflictsOnMerge) {
        this.cacheManager = cacheManager;
        this.cacheName = cacheName;
        this.availabilityStrategy = availabilityStrategy;
        this.clusterTopologyManager = clusterTopologyManager;
        this.transport = transport;
        this.persistentState = state;
        this.resolveConflictsOnMerge = resolveConflictsOnMerge;
        this.rebalanceType = rebalanceType;
        this.currentTopology = null;
        this.stableTopology = null;
        this.expectedMembers = Collections.emptyList();
        this.capacityFactors = Collections.emptyMap();
        this.joiners = Collections.emptyList();
        this.persistentUUIDManager = persistentUUIDManager;
        state.ifPresent(scopedPersistentState -> {
            this.rebalancingEnabled = false;
            this.availabilityMode = AvailabilityMode.DEGRADED_MODE;
        });
        this.status = ComponentStatus.INSTANTIATED;
        if (trace) {
            log.tracef("Cache %s initialized. Persisted state? %s", cacheName, this.persistentState.isPresent());
        }
    }

    @Override
    public CacheJoinInfo getJoinInfo() {
        return this.joinInfo;
    }

    @Override
    public List<Address> getExpectedMembers() {
        return this.expectedMembers;
    }

    @Override
    public synchronized void queueRebalance(List<Address> newMembers) {
        if (newMembers != null && !newMembers.isEmpty()) {
            log.debugf("Queueing rebalance for cache %s with members %s", this.cacheName, newMembers);
            this.queuedRebalanceMembers = newMembers;
            this.startQueuedRebalance();
        }
    }

    public boolean isTotalOrder() {
        return this.joinInfo.isTotalOrder();
    }

    public boolean isDistributed() {
        return this.joinInfo.getCacheMode().isDistributed();
    }

    @Override
    public Map<Address, Float> getCapacityFactors() {
        return this.capacityFactors;
    }

    @Override
    public CacheTopology getCurrentTopology() {
        return this.currentTopology;
    }

    @Override
    public CacheTopology getStableTopology() {
        return this.stableTopology;
    }

    @Override
    public AvailabilityMode getAvailabilityMode() {
        return this.availabilityMode;
    }

    @Override
    public synchronized void updateAvailabilityMode(List<Address> actualMembers, AvailabilityMode newAvailabilityMode, boolean cancelRebalance) {
        boolean modeChanged = this.setAvailabilityMode(newAvailabilityMode);
        if (modeChanged || !actualMembers.equals(this.currentTopology.getActualMembers())) {
            log.debugf("Updating availability for cache %s to %s", this.cacheName, (Object)newAvailabilityMode);
            ConsistentHash newPendingCH = this.currentTopology.getPendingCH();
            CacheTopology.Phase newPhase = this.currentTopology.getPhase();
            if (cancelRebalance) {
                newPendingCH = null;
                newPhase = CacheTopology.Phase.NO_REBALANCE;
                this.rebalanceConfirmationCollector = null;
            }
            CacheTopology newTopology = new CacheTopology(this.currentTopology.getTopologyId() + 1, this.currentTopology.getRebalanceId(), this.currentTopology.getCurrentCH(), newPendingCH, newPhase, actualMembers, this.persistentUUIDManager.mapAddresses(actualMembers));
            this.setCurrentTopology(newTopology);
            this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, newAvailabilityMode, this.isTotalOrder(), this.isDistributed());
        }
    }

    @Override
    public synchronized void updateTopologiesAfterMerge(CacheTopology currentTopology, CacheTopology stableTopology, AvailabilityMode availabilityMode, boolean resolveConflicts) {
        log.debugf("Updating topologies after merge for cache %s, current topology = %s, stable topology = %s, availability mode = %s, resolveConflicts = %s", new Object[]{this.cacheName, currentTopology, stableTopology, availabilityMode, resolveConflicts});
        this.currentTopology = currentTopology;
        this.stableTopology = stableTopology;
        this.availabilityMode = availabilityMode;
        if (currentTopology != null) {
            this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, currentTopology, availabilityMode, this.isTotalOrder(), this.isDistributed());
            if (this.resolveConflictsOnMerge && resolveConflicts) {
                AdvancedCache cache = this.cacheManager.getCache(this.cacheName).getAdvancedCache();
                DefaultConflictManager conflictManager = (DefaultConflictManager)ConflictManagerFactory.get(cache);
                conflictManager.resolveConflicts(currentTopology);
            }
        }
        if (stableTopology != null) {
            this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, stableTopology, this.isTotalOrder(), this.isDistributed());
        }
    }

    @GuardedBy(value="this")
    private boolean addMember(Address joiner, CacheJoinInfo joinInfo) {
        if (this.expectedMembers.contains(joiner)) {
            return false;
        }
        if (this.persistentState.isPresent()) {
            if (!joinInfo.getPersistentStateChecksum().isPresent()) {
                if (this.status == ComponentStatus.INSTANTIATED) {
                    throw log.nodeWithoutPersistentStateJoiningCacheWithState(joiner, this.cacheName);
                }
            } else if (this.persistentState.get().getChecksum() != joinInfo.getPersistentStateChecksum().get().intValue()) {
                throw log.nodeWithIncompatibleStateJoiningCache(joiner, this.cacheName);
            }
        } else if (joinInfo.getPersistentStateChecksum().isPresent()) {
            throw log.nodeWithPersistentStateJoiningClusterWithoutState(joiner, this.cacheName);
        }
        if (this.joinInfo == null) {
            this.joinInfo = joinInfo;
        }
        HashMap<Address, Float> newCapacityFactors = new HashMap<Address, Float>(this.capacityFactors);
        newCapacityFactors.put(joiner, Float.valueOf(joinInfo.getCapacityFactor()));
        this.capacityFactors = Immutables.immutableMapWrap(newCapacityFactors);
        this.expectedMembers = this.immutableAdd(this.expectedMembers, joiner);
        this.persistentUUIDManager.addPersistentAddressMapping(joiner, joinInfo.getPersistentUUID());
        this.joiners = this.immutableAdd(this.joiners, joiner);
        if (trace) {
            log.tracef("Added joiner %s to cache %s with persistent uuid %s: members = %s, joiners = %s", new Object[]{joiner, this.cacheName, joinInfo.getPersistentUUID(), this.expectedMembers, this.joiners});
        }
        return true;
    }

    @GuardedBy(value="this")
    private boolean removeMember(Address leaver) {
        if (!this.expectedMembers.contains(leaver)) {
            if (trace) {
                log.tracef("Trying to remove node %s from cache %s, but it is not a member: members = %s", leaver, this.cacheName, this.expectedMembers);
            }
            return false;
        }
        this.expectedMembers = this.immutableRemove(this.expectedMembers, leaver);
        HashMap<Address, Float> newCapacityFactors = new HashMap<Address, Float>(this.capacityFactors);
        newCapacityFactors.remove(leaver);
        this.capacityFactors = Immutables.immutableMapWrap(newCapacityFactors);
        this.joiners = this.immutableRemove(this.joiners, leaver);
        if (trace) {
            log.tracef("Removed node %s from cache %s: members = %s, joiners = %s", new Object[]{leaver, this.cacheName, this.expectedMembers, this.joiners});
        }
        return true;
    }

    @GuardedBy(value="this")
    private boolean retainMembers(List<Address> newClusterMembers) {
        if (newClusterMembers.containsAll(this.expectedMembers)) {
            if (trace) {
                log.tracef("Cluster members updated for cache %s, no abrupt leavers detected: cache members = %s. Existing members = %s", this.cacheName, newClusterMembers, this.expectedMembers);
            }
            return false;
        }
        this.expectedMembers = this.immutableRetainAll(this.expectedMembers, newClusterMembers);
        this.joiners = this.immutableRetainAll(this.joiners, newClusterMembers);
        if (trace) {
            log.tracef("Cluster members updated for cache %s: members = %s, joiners = %s", this.cacheName, this.expectedMembers, this.joiners);
        }
        return true;
    }

    @GuardedBy(value="this")
    private void setCurrentTopology(CacheTopology newTopology) {
        this.currentTopology = newTopology;
        if (newTopology != null) {
            this.joiners = this.immutableRemoveAll(this.expectedMembers, newTopology.getCurrentCH().getMembers());
        }
        if (trace) {
            log.tracef("Cache %s topology updated: %s, members = %s, joiners = %s", new Object[]{this.cacheName, this.currentTopology, this.expectedMembers, this.joiners});
        }
        if (newTopology != null) {
            newTopology.logRoutingTableInformation();
        }
    }

    @GuardedBy(value="this")
    private void setStableTopology(CacheTopology newTopology) {
        this.stableTopology = newTopology;
        if (trace) {
            log.tracef("Cache %s stable topology updated: members = %s, joiners = %s, topology = %s", new Object[]{this.cacheName, this.expectedMembers, this.joiners, newTopology});
        }
    }

    private boolean needConsistentHashUpdate() {
        return !this.expectedMembers.equals(this.currentTopology.getMembers());
    }

    private List<Address> pruneInvalidMembers(List<Address> possibleMembers) {
        return this.immutableRetainAll(possibleMembers, this.expectedMembers);
    }

    public boolean isRebalanceInProgress() {
        return this.rebalanceConfirmationCollector != null;
    }

    public RebalancingStatus getRebalancingStatus() {
        if (!this.isRebalanceEnabled()) {
            return RebalancingStatus.SUSPENDED;
        }
        if (this.rebalanceInProgress) {
            return RebalancingStatus.IN_PROGRESS;
        }
        if (this.queuedRebalanceMembers != null) {
            return RebalancingStatus.PENDING;
        }
        return RebalancingStatus.COMPLETE;
    }

    public synchronized void confirmRebalancePhase(Address member, int receivedTopologyId) throws Exception {
        if (this.rebalanceConfirmationCollector == null) {
            throw new CacheException(String.format("Received invalid rebalance confirmation from %s for cache %s, we don't have a rebalance in progress", member, this.cacheName));
        }
        this.rebalanceConfirmationCollector.confirmPhase(member, receivedTopologyId);
    }

    @GuardedBy(value="this")
    private void updateMembers() {
        if (this.rebalanceConfirmationCollector != null) {
            this.rebalanceConfirmationCollector.updateMembers(this.currentTopology.getMembers());
        }
    }

    public synchronized void doHandleClusterView() throws Exception {
        if (this.currentTopology == null) {
            return;
        }
        List<Address> newClusterMembers = this.transport.getMembers();
        boolean cacheMembersModified = this.retainMembers(newClusterMembers);
        this.availabilityStrategy.onClusterViewChange(this, newClusterMembers);
        if (cacheMembersModified) {
            this.updateMembers();
        }
    }

    @GuardedBy(value="this")
    private void endRebalance() {
        CacheTopology newTopology;
        this.rebalanceInProgress = false;
        CacheTopology currentTopology = this.getCurrentTopology();
        if (currentTopology == null) {
            log.tracef("Rebalance finished because there are no more members in cache %s", this.cacheName);
            return;
        }
        assert (currentTopology.getPhase().isRebalance());
        int currentTopologyId = currentTopology.getTopologyId();
        LogFactory.CLUSTER.clusterWideRebalanceCompleted(this.cacheName, currentTopologyId);
        List<Address> members = currentTopology.getMembers();
        switch (this.rebalanceType) {
            case FOUR_PHASE: {
                newTopology = new CacheTopology(currentTopologyId + 1, currentTopology.getRebalanceId(), currentTopology.getCurrentCH(), currentTopology.getPendingCH(), CacheTopology.Phase.READ_ALL_WRITE_ALL, members, this.persistentUUIDManager.mapAddresses(members));
                break;
            }
            case TWO_PHASE: {
                newTopology = new CacheTopology(currentTopologyId + 1, currentTopology.getRebalanceId(), currentTopology.getPendingCH(), null, CacheTopology.Phase.NO_REBALANCE, members, this.persistentUUIDManager.mapAddresses(members));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.setCurrentTopology(newTopology);
        this.rebalanceConfirmationCollector = newTopology.getPhase() != CacheTopology.Phase.NO_REBALANCE ? new RebalanceConfirmationCollector(this.cacheName, currentTopologyId + 1, members, this::endReadAllPhase) : null;
        this.availabilityStrategy.onRebalanceEnd(this);
        this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.availabilityMode, this.isTotalOrder(), this.isDistributed());
        if (newTopology.getPhase() == CacheTopology.Phase.NO_REBALANCE) {
            this.startQueuedRebalance();
        }
    }

    @GuardedBy(value="this")
    private void endReadAllPhase() {
        CacheTopology currentTopology = this.getCurrentTopology();
        assert (currentTopology != null);
        assert (currentTopology.getPhase() == CacheTopology.Phase.READ_ALL_WRITE_ALL);
        List<Address> members = currentTopology.getMembers();
        CacheTopology newTopology = new CacheTopology(currentTopology.getTopologyId() + 1, currentTopology.getRebalanceId(), currentTopology.getCurrentCH(), currentTopology.getPendingCH(), CacheTopology.Phase.READ_NEW_WRITE_ALL, members, this.persistentUUIDManager.mapAddresses(members));
        this.setCurrentTopology(newTopology);
        this.rebalanceConfirmationCollector = new RebalanceConfirmationCollector(this.cacheName, currentTopology.getTopologyId() + 1, members, this::endReadNewPhase);
        this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.availabilityMode, this.isTotalOrder(), this.isDistributed());
    }

    @GuardedBy(value="this")
    private void endReadNewPhase() {
        CacheTopology currentTopology = this.getCurrentTopology();
        assert (currentTopology != null);
        assert (currentTopology.getPhase() == CacheTopology.Phase.READ_NEW_WRITE_ALL);
        List<Address> members = currentTopology.getMembers();
        CacheTopology newTopology = new CacheTopology(currentTopology.getTopologyId() + 1, currentTopology.getRebalanceId(), currentTopology.getPendingCH(), null, CacheTopology.Phase.NO_REBALANCE, members, this.persistentUUIDManager.mapAddresses(members));
        this.setCurrentTopology(newTopology);
        this.rebalanceConfirmationCollector = null;
        this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.availabilityMode, this.isTotalOrder(), this.isDistributed());
        this.startQueuedRebalance();
    }

    @Override
    public synchronized void updateCurrentTopology(List<Address> newMembers) {
        ConsistentHash newCurrentCH;
        List<Address> actualMembers;
        if (this.currentTopology == null) {
            this.createInitialCacheTopology();
        }
        ConsistentHashFactory consistentHashFactory = this.getJoinInfo().getConsistentHashFactory();
        int topologyId = this.currentTopology.getTopologyId();
        int rebalanceId = this.currentTopology.getRebalanceId();
        ConsistentHash currentCH = this.currentTopology.getCurrentCH();
        ConsistentHash pendingCH = this.currentTopology.getPendingCH();
        if (!this.needConsistentHashUpdate()) {
            log.tracef("Cache %s members list was updated, but the cache topology doesn't need to change: %s", this.cacheName, this.currentTopology);
            return;
        }
        if (newMembers.isEmpty()) {
            log.tracef("Cache %s no longer has any members, removing topology", this.cacheName);
            this.setCurrentTopology(null);
            this.setStableTopology(null);
            this.rebalanceConfirmationCollector = null;
            return;
        }
        List<Address> newCurrentMembers = this.pruneInvalidMembers(currentCH.getMembers());
        ConsistentHash newPendingCH = null;
        CacheTopology.Phase newPhase = CacheTopology.Phase.NO_REBALANCE;
        if (newCurrentMembers.isEmpty()) {
            log.tracef("All current members left, re-initializing status for cache %s", this.cacheName);
            this.rebalanceConfirmationCollector = null;
            actualMembers = newCurrentMembers = this.getExpectedMembers();
            newCurrentCH = this.joinInfo.getConsistentHashFactory().create(this.joinInfo.getHashFunction(), this.joinInfo.getNumOwners(), this.joinInfo.getNumSegments(), newCurrentMembers, this.getCapacityFactors());
        } else {
            newCurrentCH = consistentHashFactory.updateMembers(currentCH, newCurrentMembers, this.getCapacityFactors());
            actualMembers = newCurrentMembers;
            if (pendingCH != null) {
                newPhase = this.currentTopology.getPhase();
                newPendingCH = consistentHashFactory.updateMembers(pendingCH, newCurrentMembers, this.getCapacityFactors());
                actualMembers = this.pruneInvalidMembers(pendingCH.getMembers());
            }
        }
        CacheTopology newTopology = new CacheTopology(topologyId + 1, rebalanceId, newCurrentCH, newPendingCH, newPhase, actualMembers, this.persistentUUIDManager.mapAddresses(actualMembers));
        this.setCurrentTopology(newTopology);
        if (this.rebalanceConfirmationCollector != null) {
            log.debugf("Cancelling topology confirmation %s because of another topology update", this.rebalanceConfirmationCollector);
            this.rebalanceConfirmationCollector = null;
        }
        this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.availabilityMode, this.isTotalOrder(), this.isDistributed());
    }

    private boolean setAvailabilityMode(AvailabilityMode newAvailabilityMode) {
        if (newAvailabilityMode == this.availabilityMode) {
            return false;
        }
        log.tracef("Cache %s availability changed: %s -> %s", this.cacheName, (Object)this.availabilityMode, (Object)newAvailabilityMode);
        this.availabilityMode = newAvailabilityMode;
        return true;
    }

    private <T> List<T> immutableAdd(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.add(element);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRemove(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.remove(element);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRemoveAll(List<T> list, List<T> otherList) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.removeAll(otherList);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRetainAll(List<T> list, List<T> otherList) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.retainAll(otherList);
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return "ClusterCacheStatus{cacheName='" + this.cacheName + '\'' + ", members=" + this.expectedMembers + ", joiners=" + this.joiners + ", currentTopology=" + this.currentTopology + ", rebalanceConfirmationCollector=" + this.rebalanceConfirmationCollector + '}';
    }

    public synchronized void doMergePartitions(Map<Address, CacheStatusResponse> statusResponses) {
        try {
            if (statusResponses.isEmpty()) {
                throw new IllegalArgumentException("Should have at least one current topology");
            }
            HashMap<Address, CacheJoinInfo> joinInfos = new HashMap<Address, CacheJoinInfo>();
            HashSet<CacheTopology> currentTopologies = new HashSet<CacheTopology>();
            HashSet<CacheTopology> stableTopologies = new HashSet<CacheTopology>();
            for (Map.Entry<Address, CacheStatusResponse> e : statusResponses.entrySet()) {
                Address sender = e.getKey();
                CacheStatusResponse response = e.getValue();
                joinInfos.put(sender, response.getCacheJoinInfo());
                if (response.getCacheTopology() != null) {
                    currentTopologies.add(response.getCacheTopology());
                }
                if (response.getStableTopology() == null) continue;
                stableTopologies.add(response.getStableTopology());
            }
            log.debugf("Recovered %d partition(s) for cache %s: %s", currentTopologies.size(), this.cacheName, currentTopologies);
            this.recoverMembers(joinInfos, currentTopologies, stableTopologies);
            this.availabilityStrategy.onPartitionMerge(this, statusResponses);
        }
        catch (Exception e) {
            log.failedToRecoverCacheState(this.cacheName, e);
        }
    }

    @GuardedBy(value="this")
    private void recoverMembers(Map<Address, CacheJoinInfo> joinInfos, Collection<CacheTopology> currentTopologies, Collection<CacheTopology> stableTopologies) {
        this.expectedMembers = Collections.emptyList();
        for (CacheTopology cacheTopology : stableTopologies) {
            this.addMembers(cacheTopology.getMembers(), joinInfos);
        }
        for (CacheTopology cacheTopology : currentTopologies) {
            this.addMembers(cacheTopology.getMembers(), joinInfos);
        }
        for (Map.Entry entry : joinInfos.entrySet()) {
            if (this.expectedMembers.contains(entry.getKey())) continue;
            this.addMember((Address)entry.getKey(), (CacheJoinInfo)entry.getValue());
        }
    }

    @GuardedBy(value="this")
    private void addMembers(Collection<Address> membersToAdd, Map<Address, CacheJoinInfo> joinInfos) {
        for (Address member : membersToAdd) {
            CacheJoinInfo joinInfo;
            if (this.expectedMembers.contains(member) || (joinInfo = joinInfos.get(member)) == null) continue;
            this.addMember(member, joinInfo);
        }
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    public synchronized CacheStatusResponse doJoin(Address joiner, CacheJoinInfo joinInfo) throws Exception {
        CacheTopology topologyBeforeRebalance;
        boolean isFirstMember = this.getCurrentTopology() == null;
        boolean memberJoined = this.addMember(joiner, joinInfo);
        if (!isFirstMember && !memberJoined) {
            if (trace) {
                log.tracef("Trying to add node %s to cache %s, but it is already a member: members = %s, joiners = %s", new Object[]{joiner, this.cacheName, this.expectedMembers, this.joiners});
            }
            return new CacheStatusResponse(null, this.currentTopology, this.stableTopology, this.availabilityMode);
        }
        if (this.status == ComponentStatus.INSTANTIATED) {
            if (this.persistentState.isPresent()) {
                CacheTopology topology;
                if (trace) {
                    log.tracef("Node %s joining. Attempting to reform previous cluster", joiner);
                }
                if ((topology = this.restoreCacheTopology(this.persistentState.get())) != null) {
                    this.status = ComponentStatus.RUNNING;
                    this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, topology, this.availabilityMode, this.isTotalOrder(), this.isDistributed());
                    this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, topology, this.isTotalOrder(), this.isDistributed());
                    return new CacheStatusResponse(null, this.currentTopology, this.stableTopology, this.availabilityMode);
                }
            } else if (isFirstMember) {
                CacheTopology initialTopology = this.createInitialCacheTopology();
                this.status = ComponentStatus.RUNNING;
                this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, initialTopology, this.isTotalOrder(), this.isDistributed());
            }
        }
        if ((topologyBeforeRebalance = this.getCurrentTopology()) != null) {
            this.availabilityStrategy.onJoin(this, joiner);
        }
        return new CacheStatusResponse(null, topologyBeforeRebalance, this.stableTopology, this.availabilityMode);
    }

    @GuardedBy(value="this")
    protected CacheTopology restoreCacheTopology(ScopedPersistentState state) {
        ConsistentHash persistedCH;
        if (trace) {
            log.tracef("Attempting to restore CH for cache %s", this.cacheName);
        }
        if ((persistedCH = this.joinInfo.getConsistentHashFactory().fromPersistentState(state).remapAddresses(this.persistentUUIDManager.persistentUUIDToAddress())) == null || !this.getExpectedMembers().containsAll(persistedCH.getMembers())) {
            if (trace) {
                log.tracef("Could not restore CH for cache %s, one or more addresses are missing", this.cacheName);
            }
            return null;
        }
        if (this.getExpectedMembers().size() > persistedCH.getMembers().size()) {
            ArrayList<Address> extraneousMembers = new ArrayList<Address>(this.getExpectedMembers());
            extraneousMembers.removeAll(persistedCH.getMembers());
            throw log.extraneousMembersJoinRestoredCache(extraneousMembers, this.cacheName);
        }
        CacheTopology initialTopology = new CacheTopology(this.initialTopologyId, 1, persistedCH, null, CacheTopology.Phase.NO_REBALANCE, persistedCH.getMembers(), this.persistentUUIDManager.mapAddresses(persistedCH.getMembers()));
        this.setCurrentTopology(initialTopology);
        this.setStableTopology(initialTopology);
        this.rebalancingEnabled = true;
        this.availabilityMode = AvailabilityMode.AVAILABLE;
        return initialTopology;
    }

    @GuardedBy(value="this")
    protected CacheTopology createInitialCacheTopology() {
        log.tracef("Initializing status for cache %s", this.cacheName);
        List<Address> initialMembers = this.getExpectedMembers();
        Object initialCH = this.joinInfo.getConsistentHashFactory().create(this.joinInfo.getHashFunction(), this.joinInfo.getNumOwners(), this.joinInfo.getNumSegments(), initialMembers, this.getCapacityFactors());
        CacheTopology initialTopology = new CacheTopology(this.initialTopologyId, 1, (ConsistentHash)initialCH, null, CacheTopology.Phase.NO_REBALANCE, initialMembers, this.persistentUUIDManager.mapAddresses(initialMembers));
        this.setCurrentTopology(initialTopology);
        this.setStableTopology(initialTopology);
        return initialTopology;
    }

    public synchronized boolean doLeave(Address leaver) throws Exception {
        if (this.currentTopology == null) {
            return false;
        }
        boolean actualLeaver = this.removeMember(leaver);
        if (!actualLeaver) {
            return false;
        }
        this.availabilityStrategy.onGracefulLeave(this, leaver);
        this.updateMembers();
        return this.expectedMembers.isEmpty();
    }

    public synchronized void startQueuedRebalance() {
        if (this.queuedRebalanceMembers == null) {
            if (this.stableTopology == null || this.stableTopology.getTopologyId() < this.currentTopology.getTopologyId()) {
                this.stableTopology = this.currentTopology;
                log.tracef("Updating stable topology for cache %s: %s", this.cacheName, this.stableTopology);
                this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, this.stableTopology, this.isTotalOrder(), this.isDistributed());
            }
            return;
        }
        CacheTopology cacheTopology = this.getCurrentTopology();
        if (!this.isRebalanceEnabled()) {
            log.tracef("Postponing rebalance for cache %s, rebalancing is disabled", this.cacheName);
            return;
        }
        if (this.rebalanceConfirmationCollector != null) {
            log.tracef("Postponing rebalance for cache %s, there's already a topology change in progress: %s", this.cacheName, this.rebalanceConfirmationCollector);
            return;
        }
        if (this.queuedRebalanceMembers.isEmpty()) {
            log.tracef("Ignoring request to rebalance cache %s, it doesn't have any member", this.cacheName);
            return;
        }
        if (cacheTopology == null) {
            this.createInitialCacheTopology();
            return;
        }
        List<Address> newMembers = ClusterCacheStatus.updateMembersPreservingOrder(cacheTopology.getMembers(), this.queuedRebalanceMembers);
        this.queuedRebalanceMembers = null;
        log.tracef("Rebalancing consistent hash for cache %s, members are %s", this.cacheName, newMembers);
        int newTopologyId = cacheTopology.getTopologyId() + 1;
        int newRebalanceId = cacheTopology.getRebalanceId() + 1;
        ConsistentHash currentCH = cacheTopology.getCurrentCH();
        if (currentCH == null) {
            log.tracef("Ignoring request to rebalance cache %s, it doesn't have a consistent hash", this.cacheName);
            return;
        }
        if (!this.expectedMembers.containsAll(newMembers)) {
            newMembers.removeAll(this.expectedMembers);
            log.tracef("Ignoring request to rebalance cache %s, we have new leavers: %s", this.cacheName, newMembers);
            return;
        }
        ConsistentHashFactory chFactory = this.getJoinInfo().getConsistentHashFactory();
        ConsistentHash updatedMembersCH = chFactory.updateMembers(currentCH, newMembers, this.getCapacityFactors());
        ConsistentHash balancedCH = chFactory.rebalance(updatedMembersCH);
        boolean updateTopology = false;
        boolean rebalance = false;
        boolean updateStableTopology = false;
        if (this.rebalanceType == RebalanceType.NONE) {
            updateTopology = true;
        } else if (balancedCH.equals(currentCH)) {
            log.tracef("The balanced CH is the same as the current CH, not rebalancing", new Object[0]);
            updateTopology = cacheTopology.getPendingCH() != null;
            updateStableTopology = cacheTopology.getPendingCH() == null && (this.stableTopology == null || cacheTopology.getTopologyId() != this.stableTopology.getTopologyId());
        } else {
            rebalance = true;
        }
        if (updateTopology) {
            CacheTopology newTopology = new CacheTopology(newTopologyId, cacheTopology.getRebalanceId(), balancedCH, null, CacheTopology.Phase.NO_REBALANCE, balancedCH.getMembers(), this.persistentUUIDManager.mapAddresses(balancedCH.getMembers()));
            log.tracef("Updating cache %s topology without rebalance: %s", this.cacheName, newTopology);
            this.setCurrentTopology(newTopology);
            this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.getAvailabilityMode(), this.isTotalOrder(), this.isDistributed());
        } else if (rebalance) {
            CacheTopology.Phase newPhase;
            switch (this.rebalanceType) {
                case FOUR_PHASE: {
                    newPhase = CacheTopology.Phase.READ_OLD_WRITE_ALL;
                    break;
                }
                case TWO_PHASE: {
                    newPhase = CacheTopology.Phase.TRANSITORY;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            CacheTopology newTopology = new CacheTopology(newTopologyId, newRebalanceId, currentCH, balancedCH, newPhase, balancedCH.getMembers(), this.persistentUUIDManager.mapAddresses(balancedCH.getMembers()));
            log.tracef("Updating cache %s topology for rebalance: %s", this.cacheName, newTopology);
            this.setCurrentTopology(newTopology);
            this.rebalanceInProgress = true;
            assert (this.rebalanceConfirmationCollector == null);
            this.rebalanceConfirmationCollector = new RebalanceConfirmationCollector(this.cacheName, newTopology.getTopologyId(), newTopology.getMembers(), this::endRebalance);
            this.clusterTopologyManager.broadcastRebalanceStart(this.cacheName, newTopology, this.isTotalOrder(), this.isDistributed());
        } else if (updateStableTopology) {
            this.stableTopology = this.currentTopology;
            this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, this.stableTopology, this.isTotalOrder(), this.isDistributed());
        }
    }

    private static List<Address> updateMembersPreservingOrder(List<Address> oldMembers, List<Address> newMembers) {
        ArrayList<Address> membersPreservingOrder = new ArrayList<Address>(oldMembers);
        membersPreservingOrder.retainAll(newMembers);
        for (Address a : newMembers) {
            if (membersPreservingOrder.contains(a)) continue;
            membersPreservingOrder.add(a);
        }
        return membersPreservingOrder;
    }

    public boolean isRebalanceEnabled() {
        return this.rebalancingEnabled && this.clusterTopologyManager.isRebalancingEnabled();
    }

    public synchronized void setRebalanceEnabled(boolean enabled) {
        this.rebalancingEnabled = enabled;
        if (this.rebalancingEnabled) {
            log.debugf("Rebalancing is now enabled for cache %s", this.cacheName);
            this.startQueuedRebalance();
        } else {
            log.debugf("Rebalancing is now disabled for cache %s", this.cacheName);
        }
    }

    public void forceRebalance() {
        this.queueRebalance(this.getCurrentTopology().getMembers());
        this.startQueuedRebalance();
    }

    public void forceAvailabilityMode(AvailabilityMode newAvailabilityMode) {
        this.availabilityStrategy.onManualAvailabilityChange(this, newAvailabilityMode);
    }

    public synchronized void shutdownCache() throws Exception {
        if (this.status == ComponentStatus.RUNNING) {
            this.status = ComponentStatus.STOPPING;
            this.clusterTopologyManager.setRebalancingEnabled(this.cacheName, false);
            this.clusterTopologyManager.broadcastShutdownCache(this.cacheName, this.getCurrentTopology(), this.isTotalOrder(), this.isDistributed());
            this.status = ComponentStatus.TERMINATED;
        }
    }

    public synchronized void setInitialTopologyId(int initialTopologyId) {
        this.initialTopologyId = initialTopologyId;
    }

    @Override
    public boolean resolveConflictsOnMerge() {
        return this.resolveConflictsOnMerge && this.clusterTopologyManager.isRebalancingEnabled() && this.rebalancingEnabled;
    }

    @Override
    public ConsistentHash calculateConflictHash(ConsistentHash preferredHash, Set<ConsistentHash> distinctHashes) {
        ConsistentHashFactory chf = this.getJoinInfo().getConsistentHashFactory();
        ConsistentHash unionHash = distinctHashes.stream().reduce(preferredHash, chf::union);
        return chf.union(unionHash, chf.rebalance(unionHash));
    }
}

