/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.SmallIntSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EntryStreamSupplier<K, V>
implements AbstractLocalCacheStream.StreamSupplier<CacheEntry<K, V>, Stream<CacheEntry<K, V>>> {
    private static final Log log = LogFactory.getLog(EntryStreamSupplier.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Cache<K, V> cache;
    private final ToIntFunction<Object> toIntFunction;
    private final Supplier<Stream<CacheEntry<K, V>>> supplier;

    public EntryStreamSupplier(Cache<K, V> cache, ToIntFunction<Object> toIntFunction, Supplier<Stream<CacheEntry<K, V>>> supplier) {
        this.cache = cache;
        this.toIntFunction = toIntFunction;
        this.supplier = supplier;
    }

    @Override
    public Stream<CacheEntry<K, V>> buildStream(Set<Integer> segmentsToFilter, Set<?> keysToFilter) {
        Stream<CacheEntry<K, V>> stream;
        AdvancedCache<K, V> advancedCache = AbstractDelegatingCache.unwrapCache(this.cache).getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL);
        if (keysToFilter != null) {
            if (trace) {
                log.tracef("Applying key filtering %s", keysToFilter);
            }
            stream = keysToFilter.stream().map(advancedCache::getCacheEntry).filter(Objects::nonNull);
        } else {
            stream = this.supplier.get();
            if (this.cache.getCacheConfiguration().clustering().cacheMode().isScattered()) {
                stream = stream.filter(e -> e.getValue() != null);
            }
        }
        if (segmentsToFilter != null && this.toIntFunction != null) {
            if (trace) {
                log.tracef("Applying segment filter %s", segmentsToFilter);
            }
            SmallIntSet intSet = SmallIntSet.from(segmentsToFilter);
            stream = stream.filter(arg_0 -> this.lambda$buildStream$1((IntSet)intSet, arg_0));
        }
        return stream;
    }

    private /* synthetic */ boolean lambda$buildStream$1(IntSet intSet, CacheEntry k) {
        Object key = k.getKey();
        int segment = this.toIntFunction.applyAsInt(key);
        boolean isPresent = intSet.contains(segment);
        if (trace) {
            log.tracef("Is key %s present in segment %d? %b", key, segment, isPresent);
        }
        return isPresent;
    }
}

