/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.NAMED_CACHE)
public interface StateTransferLock {
    public void acquireExclusiveTopologyLock();

    public void releaseExclusiveTopologyLock();

    public void acquireSharedTopologyLock();

    public void releaseSharedTopologyLock();

    public void notifyTransactionDataReceived(int var1);

    public CompletableFuture<Void> transactionDataFuture(int var1);

    @Deprecated
    default public void waitForTransactionData(int expectedTopologyId, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            CompletableFuture<Void> transactionDataFuture = this.transactionDataFuture(expectedTopologyId);
            transactionDataFuture.get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw new CacheException(e.getCause());
        }
    }

    public boolean transactionDataReceived(int var1);

    public void notifyTopologyInstalled(int var1);

    public CompletableFuture<Void> topologyFuture(int var1);

    @Deprecated
    default public void waitForTopology(int expectedTopologyId, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            CompletableFuture<Void> topologyFuture = this.topologyFuture(expectedTopologyId);
            topologyFuture.get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw new CacheException(e.getCause());
        }
    }

    public boolean topologyReceived(int var1);
}

