/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;

public class BackupConfiguration {
    public static final AttributeDefinition<String> SITE = AttributeDefinition.builder((String)"site", null, String.class).immutable().build();
    public static final AttributeDefinition<BackupStrategy> STRATEGY = AttributeDefinition.builder((String)"strategy", (Object)((Object)BackupStrategy.ASYNC)).immutable().build();
    public static final AttributeDefinition<Long> REPLICATION_TIMEOUT = AttributeDefinition.builder((String)"replicationTimeout", (Object)10000L).xmlName("timeout").build();
    public static final AttributeDefinition<BackupFailurePolicy> FAILURE_POLICY = AttributeDefinition.builder((String)"backupFailurePolicy", (Object)((Object)BackupFailurePolicy.WARN)).xmlName("failure-policy").build();
    public static final AttributeDefinition<String> FAILURE_POLICY_CLASS = AttributeDefinition.builder((String)"failurePolicyClass", null, String.class).immutable().build();
    public static final AttributeDefinition<Boolean> USE_TWO_PHASE_COMMIT = AttributeDefinition.builder((String)"useTwoPhaseCommit", (Object)false).immutable().xmlName("two-phase-commit").build();
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)true).immutable().build();
    private final Attribute<String> site;
    private final Attribute<BackupStrategy> strategy;
    private final Attribute<Long> replicationTimeout;
    private final Attribute<BackupFailurePolicy> backupFailurePolicy;
    private final Attribute<String> failurePolicyClass;
    private final Attribute<Boolean> useTwoPhaseCommit;
    private final Attribute<Boolean> enabled;
    private final AttributeSet attributes;
    private final TakeOfflineConfiguration takeOfflineConfiguration;
    private final XSiteStateTransferConfiguration xSiteStateTransferConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(BackupConfiguration.class, new AttributeDefinition[]{SITE, STRATEGY, REPLICATION_TIMEOUT, FAILURE_POLICY, FAILURE_POLICY_CLASS, USE_TWO_PHASE_COMMIT, ENABLED});
    }

    public BackupConfiguration(AttributeSet attributes, TakeOfflineConfiguration takeOfflineConfiguration, XSiteStateTransferConfiguration xSiteStateTransferConfiguration) {
        this.attributes = attributes.checkProtection();
        this.takeOfflineConfiguration = takeOfflineConfiguration;
        this.xSiteStateTransferConfiguration = xSiteStateTransferConfiguration;
        this.site = attributes.attribute(SITE);
        this.strategy = attributes.attribute(STRATEGY);
        this.replicationTimeout = attributes.attribute(REPLICATION_TIMEOUT);
        this.backupFailurePolicy = attributes.attribute(FAILURE_POLICY);
        this.failurePolicyClass = attributes.attribute(FAILURE_POLICY_CLASS);
        this.useTwoPhaseCommit = attributes.attribute(USE_TWO_PHASE_COMMIT);
        this.enabled = attributes.attribute(ENABLED);
    }

    public String site() {
        return (String)this.site.get();
    }

    public BackupStrategy strategy() {
        return (BackupStrategy)((Object)this.strategy.get());
    }

    public TakeOfflineConfiguration takeOffline() {
        return this.takeOfflineConfiguration;
    }

    public String failurePolicyClass() {
        return (String)this.failurePolicyClass.get();
    }

    public boolean isAsyncBackup() {
        return this.strategy() == BackupStrategy.ASYNC;
    }

    public long replicationTimeout() {
        return (Long)this.replicationTimeout.get();
    }

    public BackupConfiguration replicationTimeout(long timeout) {
        this.replicationTimeout.set((Object)timeout);
        return this;
    }

    public BackupFailurePolicy backupFailurePolicy() {
        return (BackupFailurePolicy)((Object)this.backupFailurePolicy.get());
    }

    public boolean isTwoPhaseCommit() {
        return (Boolean)this.useTwoPhaseCommit.get();
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public XSiteStateTransferConfiguration stateTransfer() {
        return this.xSiteStateTransferConfiguration;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "BackupConfiguration [attributes=" + this.attributes + ", takeOfflineConfiguration=" + this.takeOfflineConfiguration + ", xSiteStateTransferConfiguration=" + this.xSiteStateTransferConfiguration + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackupConfiguration other = (BackupConfiguration)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes)) {
            return false;
        }
        if (this.takeOfflineConfiguration == null ? other.takeOfflineConfiguration != null : !this.takeOfflineConfiguration.equals(other.takeOfflineConfiguration)) {
            return false;
        }
        return !(this.xSiteStateTransferConfiguration == null ? other.xSiteStateTransferConfiguration != null : !this.xSiteStateTransferConfiguration.equals(other.xSiteStateTransferConfiguration));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.takeOfflineConfiguration == null ? 0 : this.takeOfflineConfiguration.hashCode());
        result = 31 * result + (this.xSiteStateTransferConfiguration == null ? 0 : this.xSiteStateTransferConfiguration.hashCode());
        return result;
    }

    public static enum BackupStrategy {
        SYNC,
        ASYNC;

    }
}

