/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jboss.weld.annotated.enhanced.TypeClosureLazyValueHolder;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.collections.ImmutableMap;
import org.jboss.weld.util.collections.ImmutableSet;

public class SharedObjectCache
implements BootstrapService {
    private final ComputingCache<Set<?>, Set<?>> sharedSets = ComputingCacheBuilder.newBuilder().build(new Function<Set<?>, Set<?>>(){

        @Override
        public Set<?> apply(Set<?> from) {
            return ImmutableSet.copyOf(from);
        }
    });
    private final ComputingCache<Map<?, ?>, Map<?, ?>> sharedMaps = ComputingCacheBuilder.newBuilder().build(new Function<Map<?, ?>, Map<?, ?>>(){

        @Override
        public Map<?, ?> apply(Map<?, ?> from) {
            return ImmutableMap.copyOf(from);
        }
    });
    private final ComputingCache<Type, LazyValueHolder<Set<Type>>> typeClosureHolders = ComputingCacheBuilder.newBuilder().build(new Function<Type, LazyValueHolder<Set<Type>>>(){

        @Override
        public LazyValueHolder<Set<Type>> apply(Type input) {
            return new TypeClosureLazyValueHolder(input);
        }
    });

    public static SharedObjectCache instance(BeanManagerImpl manager) {
        return (SharedObjectCache)manager.getServices().get(SharedObjectCache.class);
    }

    public <T> Set<T> getSharedSet(Set<T> set) {
        return (Set)this.sharedSets.getCastValue(set);
    }

    public <K, V> Map<K, V> getSharedMap(Map<K, V> map) {
        return (Map)this.sharedMaps.getCastValue(map);
    }

    public LazyValueHolder<Set<Type>> getTypeClosureHolder(Type type) {
        return (LazyValueHolder)this.typeClosureHolders.getCastValue(type);
    }

    public void cleanupAfterBoot() {
        this.sharedSets.clear();
        this.sharedMaps.clear();
        this.typeClosureHolders.clear();
    }

    public void cleanup() {
        this.cleanupAfterBoot();
    }
}

