/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelType;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class GenericProtocolResourceDefinition<P extends Protocol>
extends ProtocolResourceDefinition<P> {
    public static PathElement pathElement(String name) {
        return ProtocolResourceDefinition.pathElement(String.join((CharSequence)".", "org.jgroups.protocols", name));
    }

    GenericProtocolResourceDefinition(UnaryOperator<ResourceDescriptor> configurator, ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        this(WILDCARD_PATH, configurator, parentBuilderFactory);
    }

    GenericProtocolResourceDefinition(String name, JGroupsModel deprecation, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        this(GenericProtocolResourceDefinition.pathElement(name), configurator, parentBuilderFactory);
        this.setDeprecated(deprecation.getVersion());
    }

    private GenericProtocolResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        super(path, (UnaryOperator<ResourceDescriptor>)new ResourceDescriptorConfigurator(configurator), ProtocolConfigurationBuilder::new, parentBuilderFactory);
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = super.register(parent);
        for (Attribute attribute : EnumSet.allOf(DeprecatedAttribute.class)) {
            registration.registerReadOnlyAttribute((AttributeDefinition)attribute.getDefinition(), null);
        }
        return registration;
    }

    private static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final UnaryOperator<ResourceDescriptor> configurator;

        ResourceDescriptorConfigurator(UnaryOperator<ResourceDescriptor> configurator) {
            this.configurator = configurator;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return ((ResourceDescriptor)this.configurator.apply(descriptor)).addExtraParameters(DeprecatedAttribute.class);
        }
    }

    @Deprecated
    static enum DeprecatedAttribute implements Attribute
    {
        SOCKET_BINDING("socket-binding", ModelType.STRING, JGroupsModel.VERSION_5_0_0);

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, ModelType type, JGroupsModel deprecation) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(false)).setDeprecated(deprecation.getVersion())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

