/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.singleton.DistributedSingletonServiceContext;
import org.wildfly.clustering.server.singleton.PrimaryProxyContext;
import org.wildfly.clustering.server.singleton.PrimaryProxyService;
import org.wildfly.clustering.server.singleton.SingletonContext;
import org.wildfly.clustering.server.singleton.StartCommand;
import org.wildfly.clustering.server.singleton.StopCommand;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.SingletonService;

public class DistributedSingletonService<T>
implements SingletonService<T>,
SingletonContext<T>,
ServiceProviderRegistration.Listener,
PrimaryProxyContext<T> {
    private final Value<ServiceProviderRegistry<ServiceName>> registry;
    private final Value<CommandDispatcherFactory> dispatcherFactory;
    private final ServiceName serviceName;
    private final Service<T> primaryService;
    private final Service<T> backupService;
    private final SingletonElectionPolicy electionPolicy;
    private final int quorum;
    private final AtomicBoolean primary = new AtomicBoolean(false);
    private volatile ServiceController<T> primaryController;
    private volatile ServiceController<T> backupController;
    private volatile CommandDispatcher<SingletonContext<T>> dispatcher;
    private volatile ServiceProviderRegistration<ServiceName> registration;
    private volatile boolean started = false;

    public DistributedSingletonService(DistributedSingletonServiceContext<T> context) {
        this.registry = context.getServiceProviderRegistry();
        this.dispatcherFactory = context.getCommandDispatcherFactory();
        this.serviceName = context.getServiceName();
        this.primaryService = context.getPrimaryService();
        this.backupService = context.getBackupService().orElse(new PrimaryProxyService(this));
        this.electionPolicy = context.getElectionPolicy();
        this.quorum = context.getQuorum();
    }

    public void start(StartContext context) throws StartException {
        ServiceTarget target = context.getChildTarget();
        this.primaryController = target.addService(this.serviceName.append(new String[]{"primary"}), this.primaryService).setInitialMode(ServiceController.Mode.NEVER).install();
        this.backupController = target.addService(this.serviceName.append(new String[]{"backup"}), this.backupService).setInitialMode(ServiceController.Mode.ACTIVE).install();
        this.dispatcher = ((CommandDispatcherFactory)this.dispatcherFactory.getValue()).createCommandDispatcher((Object)this.serviceName, (Object)this);
        this.registration = ((ServiceProviderRegistry)this.registry.getValue()).register((Object)this.serviceName, (ServiceProviderRegistration.Listener)this);
        this.started = true;
    }

    public void stop(StopContext context) {
        this.started = false;
        this.registration.close();
        this.dispatcher.close();
    }

    public boolean isPrimary() {
        return this.primary.get();
    }

    public void providersChanged(Set<Node> nodes) {
        Group group = ((ServiceProviderRegistry)this.registry.getValue()).getGroup();
        ArrayList candidates = new ArrayList(group.getMembership().getMembers());
        candidates.retainAll(nodes);
        if (candidates.isEmpty() || ((Node)candidates.get(0)).equals(group.getLocalMember())) {
            boolean quorumMet;
            int size = candidates.size();
            boolean bl = quorumMet = size >= this.quorum;
            if (this.quorum > 1 && size == this.quorum) {
                ClusteringServerLogger.ROOT_LOGGER.quorumJustReached(this.serviceName.getCanonicalName(), this.quorum);
            }
            Node elected = quorumMet ? this.electionPolicy.elect(candidates) : null;
            try {
                if (elected != null) {
                    ClusteringServerLogger.ROOT_LOGGER.elected(elected.getName(), this.serviceName.getCanonicalName());
                    this.dispatcher.executeOnCluster(new StopCommand(), new Node[]{elected});
                    this.dispatcher.executeOnNode(new StartCommand(), elected);
                } else {
                    if (quorumMet) {
                        ClusteringServerLogger.ROOT_LOGGER.noPrimaryElected(this.serviceName.getCanonicalName());
                    } else {
                        ClusteringServerLogger.ROOT_LOGGER.quorumNotReached(this.serviceName.getCanonicalName(), this.quorum);
                    }
                    this.dispatcher.executeOnCluster(new StopCommand(), new Node[0]);
                }
            }
            catch (CommandDispatcherException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void start() {
        if (this.primary.compareAndSet(false, true)) {
            ClusteringServerLogger.ROOT_LOGGER.startSingleton(this.serviceName.getCanonicalName());
            DistributedSingletonService.toggle(this.backupController, this.primaryController);
        }
    }

    @Override
    public void stop() {
        if (this.primary.compareAndSet(true, false)) {
            ClusteringServerLogger.ROOT_LOGGER.stopSingleton(this.serviceName.getCanonicalName());
            DistributedSingletonService.toggle(this.primaryController, this.backupController);
        }
    }

    private static synchronized void toggle(ServiceController<?> controllerToStop, ServiceController<?> controllerToStart) {
        ServiceContainerHelper.stop(controllerToStop);
        try {
            ServiceContainerHelper.start(controllerToStart);
        }
        catch (StartException e) {
            ClusteringServerLogger.ROOT_LOGGER.serviceStartFailed(e, controllerToStart.getName().getCanonicalName());
            ServiceContainerHelper.stop(controllerToStart);
        }
    }

    public T getValue() {
        while (this.started) {
            try {
                return (T)(this.primary.get() ? this.primaryController : this.backupController).getValue();
            }
            catch (IllegalStateException e) {
                if (this.registration.getProviders().size() < this.quorum) {
                    throw ClusteringServerLogger.ROOT_LOGGER.notStarted(this.serviceName.getCanonicalName());
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw e;
                }
                Thread.yield();
            }
        }
        throw ClusteringServerLogger.ROOT_LOGGER.notStarted(this.serviceName.getCanonicalName());
    }

    @Override
    public Optional<T> getLocalValue() {
        try {
            return this.primary.get() ? Optional.ofNullable(this.primaryController.getValue()) : null;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Override
    public CommandDispatcher<SingletonContext<T>> getCommandDispatcher() {
        return this.dispatcher;
    }

    @Override
    public ServiceName getServiceName() {
        return this.serviceName;
    }
}

