/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.singleton.DistributedSingletonServiceBuilderContext;
import org.wildfly.clustering.server.singleton.DistributedSingletonServiceBuilderFactory;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.singleton.SingletonServiceBuilderFactory;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;

public class CacheSingletonServiceBuilderFactoryBuilder
implements CapabilityServiceBuilder<SingletonServiceBuilderFactory>,
DistributedSingletonServiceBuilderContext,
Value<SingletonServiceBuilderFactory> {
    private final ServiceName name;
    private final String containerName;
    private final String cacheName;
    private volatile Supplier<ValueDependency<ServiceProviderRegistry<ServiceName>>> registry;
    private volatile Supplier<ValueDependency<CommandDispatcherFactory>> dispatcherFactory;

    public CacheSingletonServiceBuilderFactoryBuilder(ServiceName name, String containerName, String cacheName) {
        this.name = name;
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public SingletonServiceBuilderFactory getValue() {
        return new DistributedSingletonServiceBuilderFactory(this);
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<SingletonServiceBuilderFactory> configure(CapabilityServiceSupport support) {
        this.registry = () -> new InjectedValueDependency(ClusteringCacheRequirement.SERVICE_PROVIDER_REGISTRY.getServiceName(support, this.containerName, this.cacheName), ServiceProviderRegistry.class);
        this.dispatcherFactory = () -> new InjectedValueDependency(ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(support, this.containerName), CommandDispatcherFactory.class);
        return this;
    }

    public ServiceBuilder<SingletonServiceBuilderFactory> build(ServiceTarget target) {
        return target.addService(this.name, (Service)new ValueService((Value)this));
    }

    @Override
    public ValueDependency<ServiceProviderRegistry<ServiceName>> getServiceProviderRegistryDependency() {
        return this.registry.get();
    }

    @Override
    public ValueDependency<CommandDispatcherFactory> getCommandDispatcherFactoryDependency() {
        return this.dispatcherFactory.get();
    }
}

