/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.mapped;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import org.apache.activemq.artemis.core.io.mapped.MappedByteBufferCache;

final class MappedFile
implements AutoCloseable {
    private static final ByteBuffer ZERO_PAGE = ByteBuffer.allocateDirect(MappedByteBufferCache.PAGE_SIZE).order(ByteOrder.nativeOrder());
    private final MappedByteBufferCache cache;
    private final int zerosMaxPage;
    private MappedByteBuffer lastMapped;
    private long lastMappedStart;
    private long lastMappedLimit;
    private long position;
    private long length;

    private MappedFile(MappedByteBufferCache cache) throws IOException {
        this.cache = cache;
        this.lastMapped = null;
        this.lastMappedStart = -1L;
        this.lastMappedLimit = -1L;
        this.position = 0L;
        this.length = this.cache.fileSize();
        this.zerosMaxPage = Math.min(ZERO_PAGE.capacity(), (int)Math.min(Integer.MAX_VALUE, cache.overlapBytes()));
    }

    public static MappedFile of(File file, long chunckSize, long overlapSize) throws IOException {
        return new MappedFile(MappedByteBufferCache.of(file, chunckSize, overlapSize));
    }

    public MappedByteBufferCache cache() {
        return this.cache;
    }

    private int checkOffset(long offset, int bytes) throws BufferUnderflowException, IOException {
        if (!MappedByteBufferCache.inside(offset, this.lastMappedStart, this.lastMappedLimit)) {
            try {
                int index = this.cache.indexFor(offset);
                long mappedPosition = this.cache.mappedPositionFor(index);
                long mappedLimit = this.cache.mappedLimitFor(mappedPosition);
                if (offset + (long)bytes > mappedLimit) {
                    throw new IOException("mapping overflow!");
                }
                this.lastMapped = this.cache.acquireMappedByteBuffer(index);
                this.lastMappedStart = mappedPosition;
                this.lastMappedLimit = mappedLimit;
                int bufferPosition = (int)(offset - mappedPosition);
                return bufferPosition;
            }
            catch (IllegalStateException e) {
                throw new IOException(e);
            }
            catch (IllegalArgumentException e) {
                throw new BufferUnderflowException();
            }
        }
        int bufferPosition = (int)(offset - this.lastMappedStart);
        return bufferPosition;
    }

    public void force() {
        if (this.lastMapped != null) {
            this.lastMapped.force();
        }
    }

    public int read(long position, ByteBuf dst, int dstStart, int dstLength) throws IOException {
        int bufferPosition = this.checkOffset(position, dstLength);
        long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (dst.hasMemoryAddress()) {
            long dstAddress = dst.memoryAddress() + (long)dstStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)dstLength);
        } else if (dst.hasArray()) {
            byte[] dstArray = dst.array();
            PlatformDependent.copyMemory((long)srcAddress, (byte[])dstArray, (int)dstStart, (long)dstLength);
        } else {
            throw new IllegalArgumentException("unsupported byte buffer");
        }
        if ((position += (long)dstLength) > this.length) {
            this.length = position;
        }
        return dstLength;
    }

    public int read(long position, ByteBuffer dst, int dstStart, int dstLength) throws IOException {
        int bufferPosition = this.checkOffset(position, dstLength);
        long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (dst.isDirect()) {
            long dstAddress = PlatformDependent.directBufferAddress((ByteBuffer)dst) + (long)dstStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)dstLength);
        } else {
            byte[] dstArray = dst.array();
            PlatformDependent.copyMemory((long)srcAddress, (byte[])dstArray, (int)dstStart, (long)dstLength);
        }
        if ((position += (long)dstLength) > this.length) {
            this.length = position;
        }
        return dstLength;
    }

    public int read(ByteBuf dst, int dstStart, int dstLength) throws IOException {
        int remaining = (int)Math.min(this.length - this.position, Integer.MAX_VALUE);
        int read = Math.min(remaining, dstLength);
        int bufferPosition = this.checkOffset(this.position, read);
        long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (dst.hasMemoryAddress()) {
            long dstAddress = dst.memoryAddress() + (long)dstStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)read);
        } else if (dst.hasArray()) {
            byte[] dstArray = dst.array();
            PlatformDependent.copyMemory((long)srcAddress, (byte[])dstArray, (int)dstStart, (long)read);
        } else {
            throw new IllegalArgumentException("unsupported byte buffer");
        }
        this.position += (long)read;
        return read;
    }

    public int read(ByteBuffer dst, int dstStart, int dstLength) throws IOException {
        int remaining = (int)Math.min(this.length - this.position, Integer.MAX_VALUE);
        int read = Math.min(remaining, dstLength);
        int bufferPosition = this.checkOffset(this.position, read);
        long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (dst.isDirect()) {
            long dstAddress = PlatformDependent.directBufferAddress((ByteBuffer)dst) + (long)dstStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)read);
        } else {
            byte[] dstArray = dst.array();
            PlatformDependent.copyMemory((long)srcAddress, (byte[])dstArray, (int)dstStart, (long)read);
        }
        this.position += (long)read;
        return read;
    }

    public void write(ByteBuf src, int srcStart, int srcLength) throws IOException {
        int bufferPosition = this.checkOffset(this.position, srcLength);
        long destAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (src.hasMemoryAddress()) {
            long srcAddress = src.memoryAddress() + (long)srcStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)destAddress, (long)srcLength);
        } else if (src.hasArray()) {
            byte[] srcArray = src.array();
            PlatformDependent.copyMemory((byte[])srcArray, (int)srcStart, (long)destAddress, (long)srcLength);
        } else {
            throw new IllegalArgumentException("unsupported byte buffer");
        }
        this.position += (long)srcLength;
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    public void write(ByteBuffer src, int srcStart, int srcLength) throws IOException {
        int bufferPosition = this.checkOffset(this.position, srcLength);
        long destAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (src.isDirect()) {
            long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)src) + (long)srcStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)destAddress, (long)srcLength);
        } else {
            byte[] srcArray = src.array();
            PlatformDependent.copyMemory((byte[])srcArray, (int)srcStart, (long)destAddress, (long)srcLength);
        }
        this.position += (long)srcLength;
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    public void write(long position, ByteBuf src, int srcStart, int srcLength) throws IOException {
        int bufferPosition = this.checkOffset(position, srcLength);
        long destAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (src.hasMemoryAddress()) {
            long srcAddress = src.memoryAddress() + (long)srcStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)destAddress, (long)srcLength);
        } else if (src.hasArray()) {
            byte[] srcArray = src.array();
            PlatformDependent.copyMemory((byte[])srcArray, (int)srcStart, (long)destAddress, (long)srcLength);
        } else {
            throw new IllegalArgumentException("unsupported byte buffer");
        }
        if ((position += (long)srcLength) > this.length) {
            this.length = position;
        }
    }

    public void write(long position, ByteBuffer src, int srcStart, int srcLength) throws IOException {
        int bufferPosition = this.checkOffset(position, srcLength);
        long destAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        if (src.isDirect()) {
            long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)src) + (long)srcStart;
            PlatformDependent.copyMemory((long)srcAddress, (long)destAddress, (long)srcLength);
        } else {
            byte[] srcArray = src.array();
            PlatformDependent.copyMemory((byte[])srcArray, (int)srcStart, (long)destAddress, (long)srcLength);
        }
        if ((position += (long)srcLength) > this.length) {
            this.length = position;
        }
    }

    public void zeros(long offset, int count) throws IOException {
        long destAddress;
        int bufferPosition;
        long targetOffset = offset + (long)count;
        int zerosBulkCopies = count / this.zerosMaxPage;
        long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)ZERO_PAGE);
        for (int i = 0; i < zerosBulkCopies; ++i) {
            bufferPosition = this.checkOffset(offset, this.zerosMaxPage);
            destAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
            PlatformDependent.copyMemory((long)srcAddress, (long)destAddress, (long)this.zerosMaxPage);
            offset += (long)this.zerosMaxPage;
        }
        int remainingToBeZeroes = (int)(targetOffset - offset);
        bufferPosition = this.checkOffset(offset, remainingToBeZeroes);
        destAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.lastMapped) + (long)bufferPosition;
        PlatformDependent.copyMemory((long)srcAddress, (long)destAddress, (long)remainingToBeZeroes);
        if (targetOffset > this.length) {
            this.length = targetOffset;
        }
    }

    public long position() {
        return this.position;
    }

    public long position(long newPosition) {
        long oldPosition = this.position;
        this.position = newPosition;
        return oldPosition;
    }

    public long length() {
        return this.length;
    }

    @Override
    public void close() {
        this.cache.close();
    }

    public void closeAndResize(long length) {
        this.cache.closeAndResize(length);
    }
}

