/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.relation.AbstractCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.CommonCollectionMapperData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.Initializor;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.MapCollectionInitializor;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;

public class MapCollectionMapper<T extends Map>
extends AbstractCollectionMapper<T>
implements PropertyMapper {
    protected final MiddleComponentData elementComponentData;
    protected final MiddleComponentData indexComponentData;

    public MapCollectionMapper(CommonCollectionMapperData commonCollectionMapperData, Class<? extends T> collectionClass, Class<? extends T> proxyClass, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData, boolean revisionTypeInId) {
        super(commonCollectionMapperData, collectionClass, proxyClass, false, revisionTypeInId);
        this.elementComponentData = elementComponentData;
        this.indexComponentData = indexComponentData;
    }

    @Override
    protected Initializor<T> getInitializor(EnversService enversService, AuditReaderImplementor versionsReader, Object primaryKey, Number revision, boolean removed) {
        return new MapCollectionInitializor(enversService, versionsReader, this.commonCollectionMapperData.getQueryGenerator(), primaryKey, revision, removed, this.collectionClass, this.elementComponentData, this.indexComponentData);
    }

    @Override
    protected Collection getNewCollectionContent(PersistentCollection newCollection) {
        if (newCollection == null) {
            return null;
        }
        return ((Map)newCollection).entrySet();
    }

    @Override
    protected Collection getOldCollectionContent(Serializable oldCollection) {
        if (oldCollection == null) {
            return null;
        }
        return ((Map)((Object)oldCollection)).entrySet();
    }

    @Override
    protected void mapToMapFromObject(SessionImplementor session, Map<String, Object> idData, Map<String, Object> data, Object changed) {
        this.elementComponentData.getComponentMapper().mapToMapFromObject(session, idData, data, ((Map.Entry)changed).getValue());
        this.indexComponentData.getComponentMapper().mapToMapFromObject(session, idData, data, ((Map.Entry)changed).getKey());
    }

    @Override
    protected Set<Object> buildCollectionChangeSet(Object eventCollection, Collection collection) {
        HashSet<Object> changeSet = new HashSet<Object>();
        if (eventCollection != null) {
            for (Object entry : collection) {
                Map.Entry element;
                if (entry == null || (element = (Map.Entry)Map.Entry.class.cast(entry)).getValue() == null) continue;
                changeSet.add(entry);
            }
        }
        return changeSet;
    }
}

