/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.web.session.RoutingSupport;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.jboss.as.web.session.SimpleRoutingSupport;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.MappedValueService;
import org.wildfly.clustering.web.session.RouteLocator;
import org.wildfly.clustering.web.session.RouteLocatorBuilderProvider;
import org.wildfly.clustering.web.undertow.session.DistributableSessionIdentifierCodec;

public class DistributableSessionIdentifierCodecBuilder
implements CapabilityServiceBuilder<SessionIdentifierCodec>,
Function<RouteLocator, SessionIdentifierCodec> {
    private final ServiceName name;
    private final CapabilityServiceBuilder<RouteLocator> locatorBuilder;
    private final RoutingSupport routing = new SimpleRoutingSupport();

    public DistributableSessionIdentifierCodecBuilder(ServiceName name, String serverName, String deploymentName, RouteLocatorBuilderProvider provider) {
        this.name = name;
        this.locatorBuilder = provider.getRouteLocatorBuilder(serverName, deploymentName);
    }

    @Override
    public SessionIdentifierCodec apply(RouteLocator locator) {
        return new DistributableSessionIdentifierCodec(locator, this.routing);
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<SessionIdentifierCodec> configure(CapabilityServiceSupport support) {
        this.locatorBuilder.configure(support);
        return this;
    }

    public ServiceBuilder<SessionIdentifierCodec> build(ServiceTarget target) {
        this.locatorBuilder.build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        InjectedValue locatorValue = new InjectedValue();
        MappedValueService service = new MappedValueService((Function)this, (Value)locatorValue);
        return target.addService(this.name, (Service)service).addDependency(this.locatorBuilder.getServiceName(), RouteLocator.class, (Injector)locatorValue).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

