/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.parser;

import java.util.List;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.parser.OptionParserException;
import org.jboss.aesh.cl.parser.RequiredOptionException;
import org.jboss.aesh.console.command.Command;

public class AeshCommandLineParserHelper {
    private static final String EQUALS = "=";
    private final ProcessedCommand processedCommand;
    private CommandLine commandLine;
    private Status status;
    private ProcessedOption active;

    public AeshCommandLineParserHelper(ProcessedCommand processedCommand) {
        this.processedCommand = processedCommand;
        this.status = Status.NULL;
    }

    public void parse(CommandLine commandLine, List<String> lines, boolean ignoreRequirements) {
        RequiredOptionException re;
        this.status = Status.NULL;
        this.commandLine = commandLine;
        this.active = null;
        for (int i = 0; i < lines.size(); ++i) {
            String word = lines.get(i);
            ProcessedOption currOption = this.findOption(word);
            if (this.status == Status.ACTIVE) {
                if (currOption == null) {
                    this.addValueToOption(this.active, word);
                    if (this.status != Status.NULL) continue;
                    this.active = null;
                    continue;
                }
                commandLine.addOption(this.active);
                this.active = null;
                this.status = Status.NULL;
                this.preProcessOption(currOption, word);
                continue;
            }
            if (this.status != Status.NULL) continue;
            if (currOption == null) {
                commandLine.addArgumentValue(word);
                continue;
            }
            this.preProcessOption(currOption, word);
        }
        if (this.active != null) {
            commandLine.addOption(this.active);
        }
        if (!ignoreRequirements) {
            this.checkForDefaultValues(commandLine);
        }
        if (!ignoreRequirements && (re = this.checkForMissingRequiredOptions(this.processedCommand, commandLine)) != null) {
            commandLine.setParserException(re);
        }
    }

    private void addValueToOption(ProcessedOption currOption, String word) {
        if (currOption.hasMultipleValues()) {
            if (word.contains(String.valueOf(currOption.getValueSeparator()))) {
                for (String value : word.split(String.valueOf(currOption.getValueSeparator()))) {
                    currOption.addValue(value.trim());
                }
                if (word.endsWith(String.valueOf(currOption.getValueSeparator()))) {
                    currOption.setEndsWithSeparator(true);
                }
                this.commandLine.addOption(currOption);
                this.status = Status.NULL;
            } else {
                currOption.addValue(word);
                this.active = currOption;
            }
        } else {
            currOption.addValue(word);
            this.commandLine.addOption(currOption);
            this.status = Status.NULL;
        }
    }

    private void checkForDefaultValues(CommandLine<? extends Command> commandLine) {
        for (ProcessedOption option : commandLine.getOptions()) {
            if (option.hasValue() && option.getValue() == null) {
                if (!option.hasDefaultValue()) continue;
                for (String value : option.getDefaultValues()) {
                    option.addValue(value);
                }
                continue;
            }
            if (!option.getOptionType().equals((Object)OptionType.BOOLEAN)) continue;
            option.addValue("true");
        }
    }

    private RequiredOptionException checkForMissingRequiredOptions(ProcessedCommand<Command> command, CommandLine<? extends Command> commandLine) {
        for (ProcessedOption o : command.getOptions()) {
            if (!o.isRequired()) continue;
            boolean found = false;
            for (ProcessedOption po : commandLine.getOptions()) {
                if (po.getShortName() != null && o.getShortName() != null && po.getShortName().equals(o.getShortName()) || po.getName() != null && po.getName().equals(o.getName())) {
                    found = true;
                    break;
                }
                if (!po.doOverrideRequired()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return new RequiredOptionException("Option: " + o.getDisplayName() + " is required for this command.");
        }
        return null;
    }

    private ProcessedOption findOption(String word) {
        if (word.startsWith("--")) {
            ProcessedOption currentOption = this.findLongOption(this.processedCommand, word.substring(2));
            if (currentOption != null) {
                currentOption.setLongNameUsed(true);
            }
            return currentOption;
        }
        if (word.startsWith("-")) {
            ProcessedOption currentOption = this.findShortOption(this.processedCommand, word.substring(1));
            if (currentOption != null) {
                currentOption.setLongNameUsed(false);
            }
            return currentOption;
        }
        return null;
    }

    private ProcessedOption findShortOption(ProcessedCommand command, String line) {
        ProcessedOption option = command.findOption(line);
        if (option != null) {
            return option;
        }
        return command.startWithOption(line);
    }

    private ProcessedOption findLongOption(ProcessedCommand command, String line) {
        ProcessedOption option = command.findLongOptionNoActivatorCheck(line);
        if (option != null) {
            return option;
        }
        return command.startWithLongOption(line);
    }

    private void preProcessOption(ProcessedOption option, String line) {
        if (option.isLongNameUsed()) {
            if (line.length() - 2 != option.getName().length()) {
                this.processOption(option, line.substring(2), option.getName());
            } else if (option.getOptionType() == OptionType.BOOLEAN) {
                option.addValue("true");
                this.commandLine.addOption(option);
                this.status = Status.NULL;
            } else {
                this.status = Status.OPTION_FOUND;
            }
        } else if (line.length() > 2) {
            this.processOption(option, line.substring(1), option.getShortName());
        } else if (option.getOptionType() == OptionType.BOOLEAN) {
            option.addValue("true");
            this.commandLine.addOption(option);
            this.status = Status.NULL;
        } else {
            this.status = Status.OPTION_FOUND;
        }
        if (this.status == Status.OPTION_FOUND) {
            if (option.hasValue()) {
                this.active = option;
                this.status = Status.ACTIVE;
            } else {
                this.commandLine.addOption(option);
                this.status = Status.NULL;
            }
        }
    }

    private void processOption(ProcessedOption option, String line, String name) {
        if (option.isProperty()) {
            this.processProperty(option, line, name);
        } else {
            String rest = line.substring(name.length());
            if (option.getOptionType().equals((Object)OptionType.LIST)) {
                this.processList(option, rest);
            } else if (!rest.contains(EQUALS)) {
                if (rest.length() > 0 && !option.isLongNameUsed()) {
                    this.commandLine.addOption(option);
                    for (char shortName : rest.toCharArray()) {
                        ProcessedOption currOption = this.processedCommand.findOption(String.valueOf(shortName));
                        if (currOption != null) {
                            if (!currOption.hasValue()) {
                                currOption.setLongNameUsed(false);
                                currOption.addValue("true");
                                this.commandLine.addOption(currOption);
                                continue;
                            }
                            this.commandLine.setParserException(new OptionParserException("Option: -" + shortName + " can not be grouped with other options since it need to be given a value"));
                            continue;
                        }
                        this.commandLine.setParserException(new OptionParserException("Option: -" + shortName + " was not found."));
                    }
                } else {
                    this.commandLine.setParserException(new OptionParserException("Option: - must be followed by a valid operator"));
                }
            } else {
                this.addValueToOption(option, line.substring(line.indexOf(EQUALS) + 1));
            }
        }
    }

    private void processList(ProcessedOption currOption, String rest) {
        if (rest.length() > 1 && rest.startsWith(EQUALS)) {
            if (rest.indexOf(currOption.getValueSeparator()) > -1) {
                for (String value : rest.substring(1).split(String.valueOf(currOption.getValueSeparator()))) {
                    currOption.addValue(value.trim());
                }
                if (rest.endsWith(String.valueOf(currOption.getValueSeparator()))) {
                    currOption.setEndsWithSeparator(true);
                }
            } else {
                currOption.addValue(rest.substring(1));
            }
            this.commandLine.addOption(currOption);
            this.status = Status.NULL;
        }
    }

    private void processProperty(ProcessedOption currOption, String word, String name) {
        if (word.length() < 1 + name.length() || !word.contains(EQUALS)) {
            this.commandLine.setParserException(new OptionParserException("Option " + currOption.getDisplayName() + ", must be part of a property"));
        } else {
            String propertyName = word.substring(name.length(), word.indexOf(EQUALS));
            String value = word.substring(word.indexOf(EQUALS) + 1);
            if (value.length() < 1) {
                this.commandLine.setParserException(new OptionParserException("Option " + currOption.getDisplayName() + ", must have a value"));
            } else {
                currOption.addProperty(propertyName, value);
                this.commandLine.addOption(currOption);
            }
        }
        this.status = Status.NULL;
    }

    static enum Status {
        NULL,
        OPTION_FOUND,
        ACTIVE;

    }
}

