/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service;

import com.arjuna.ats.internal.jbossatx.jta.XAResourceRecordWrappingPluginImpl;
import com.arjuna.ats.internal.jta.recovery.arjunacore.JTAActionStatusServiceXAResourceOrphanFilter;
import com.arjuna.ats.internal.jta.recovery.arjunacore.JTANodeNameXAResourceOrphanFilter;
import com.arjuna.ats.internal.jta.recovery.arjunacore.JTATransactionLogXAResourceOrphanFilter;
import com.arjuna.ats.internal.jta.recovery.arjunacore.SubordinateJTAXAResourceOrphanFilter;
import com.arjuna.ats.internal.jta.resources.arjunacore.XAResourceRecordWrappingPlugin;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import java.util.Arrays;
import java.util.Collections;
import org.jboss.as.txn.integration.LocalUserTransactionOperationsProvider;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.tm.LastResource;

public class JTAEnvironmentBeanService
implements Service<JTAEnvironmentBean> {
    private final String nodeIdentifier;
    private boolean useActionStatusServiceRecoveryFilter;

    public JTAEnvironmentBeanService(String nodeIdentifier) {
        this.nodeIdentifier = nodeIdentifier;
        this.useActionStatusServiceRecoveryFilter = Boolean.valueOf(System.getProperty("org.jboss.narayana.wildfly.useActionStatusServiceRecoveryFilter.deprecated", "true"));
    }

    public void start(StartContext context) throws StartException {
        JTAEnvironmentBean jtaEnvironmentBean = jtaPropertyManager.getJTAEnvironmentBean();
        jtaEnvironmentBean.setLastResourceOptimisationInterfaceClassName(LastResource.class.getName());
        jtaEnvironmentBean.setXaRecoveryNodes(Collections.singletonList(this.nodeIdentifier));
        if (this.useActionStatusServiceRecoveryFilter) {
            jtaEnvironmentBean.setXaResourceOrphanFilterClassNames(Arrays.asList(JTATransactionLogXAResourceOrphanFilter.class.getName(), JTANodeNameXAResourceOrphanFilter.class.getName(), SubordinateJTAXAResourceOrphanFilter.class.getName(), JTAActionStatusServiceXAResourceOrphanFilter.class.getName()));
        } else {
            jtaEnvironmentBean.setXaResourceOrphanFilterClassNames(Arrays.asList(JTATransactionLogXAResourceOrphanFilter.class.getName(), JTANodeNameXAResourceOrphanFilter.class.getName(), SubordinateJTAXAResourceOrphanFilter.class.getName()));
        }
        jtaEnvironmentBean.setXAResourceRecordWrappingPlugin((XAResourceRecordWrappingPlugin)new XAResourceRecordWrappingPluginImpl());
        jtaEnvironmentBean.setTransactionManagerJNDIContext("java:jboss/TransactionManager");
        jtaEnvironmentBean.setTransactionSynchronizationRegistryJNDIContext("java:jboss/TransactionSynchronizationRegistry");
        jtaEnvironmentBean.setUserTransactionOperationsProviderClassName(LocalUserTransactionOperationsProvider.class.getName());
    }

    public void stop(StopContext context) {
        JTAEnvironmentBean jtaEnvironmentBean = jtaPropertyManager.getJTAEnvironmentBean();
        jtaEnvironmentBean.setXaResourceOrphanFilterClassNames(null);
        jtaEnvironmentBean.setXaRecoveryNodes(null);
        jtaEnvironmentBean.setXAResourceRecordWrappingPlugin(null);
        jtaEnvironmentBean.setLastResourceOptimisationInterfaceClassName(null);
    }

    public JTAEnvironmentBean getValue() throws IllegalStateException, IllegalArgumentException {
        return jtaPropertyManager.getJTAEnvironmentBean();
    }
}

