/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.jboss;

import com.arjuna.ats.internal.jta.resources.arjunacore.SynchronizationImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.Xid;
import org.jboss.tm.ExtendedJBossXATerminator;
import org.jboss.tm.TransactionTimeoutConfiguration;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.transaction.client.SimpleXid;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.provider.jboss.JBossLocalTransactionProvider;

final class JBossJTALocalTransactionProvider
extends JBossLocalTransactionProvider {
    private final Object resourceLock = new Object();
    private static final MethodHandle registerSynchronizationImple = AccessController.doPrivileged(() -> {
        try {
            Method declaredMethod = TransactionImple.class.getDeclaredMethod("registerSynchronizationImple", SynchronizationImple.class);
            declaredMethod.setAccessible(true);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return lookup.unreflect(declaredMethod);
        }
        catch (Throwable t) {
            throw Log.log.unexpectedFailure(t);
        }
    });

    JBossJTALocalTransactionProvider(int staleTransactionTime, ExtendedJBossXATerminator ext, TransactionManager tm) {
        super(ext, staleTransactionTime, tm);
    }

    @Override
    int getTransactionManagerTimeout() throws SystemException {
        TransactionManager tm = this.getTransactionManager();
        if (tm instanceof TransactionTimeoutConfiguration) {
            return ((TransactionTimeoutConfiguration)tm).getTransactionTimeout();
        }
        if (tm instanceof TransactionManagerImple) {
            return ((TransactionManagerImple)tm).getTimeout();
        }
        return 0;
    }

    @Override
    public void registerInterposedSynchronization(@NotNull Transaction transaction, @NotNull Synchronization sync) throws IllegalArgumentException {
        try {
            registerSynchronizationImple.invoke((TransactionImple)transaction, new SynchronizationImple(sync, true));
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Log.log.unexpectedFailure(t);
        }
    }

    @Override
    public Object getResource(@NotNull Transaction transaction, @NotNull Object key) {
        return ((TransactionImple)transaction).getTxLocalResource(key);
    }

    @Override
    public void putResource(@NotNull Transaction transaction, @NotNull Object key, Object value) throws IllegalArgumentException {
        ((TransactionImple)transaction).putTxLocalResource(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putResourceIfAbsent(@NotNull Transaction transaction, @NotNull Object key, Object value) throws IllegalArgumentException {
        Object object = this.resourceLock;
        synchronized (object) {
            Object existing = this.getResource(transaction, key);
            if (existing != null) {
                return existing;
            }
            this.putResource(transaction, key, value);
            return null;
        }
    }

    @Override
    public boolean getRollbackOnly(@NotNull Transaction transaction) throws IllegalArgumentException {
        try {
            return transaction.getStatus() == 1;
        }
        catch (SystemException e) {
            throw Log.log.unexpectedFailure(e);
        }
    }

    @Override
    @NotNull
    public Object getKey(@NotNull Transaction transaction) throws IllegalArgumentException {
        return ((TransactionImple)transaction).get_uid();
    }

    @Override
    public void commitLocal(@NotNull Transaction transaction) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.getEntryFor(transaction, SimpleXid.of(this.getXid(transaction)).withoutBranch()).commitLocal();
    }

    @Override
    public void rollbackLocal(@NotNull Transaction transaction) throws IllegalStateException, SystemException {
        this.getEntryFor(transaction, SimpleXid.of(this.getXid(transaction)).withoutBranch()).rollbackLocal();
    }

    @Override
    public int getTimeout(@NotNull Transaction transaction) {
        return ((TransactionImple)transaction).getTimeout();
    }

    @Override
    @NotNull
    public Xid getXid(@NotNull Transaction transaction) {
        if (transaction instanceof TransactionImple) {
            return ((TransactionImple)transaction).getTxId();
        }
        throw Log.log.unknownTransactionType(TransactionImple.class, transaction.getClass());
    }

    public String toString() {
        return "JBoss JTA transaction provider";
    }
}

