/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

public class ExecuteOperation<T>
extends RetryOnFailureOperation<T> {
    private final String taskName;
    private final Map<String, byte[]> marshalledParams;

    protected ExecuteOperation(Codec codec, TransportFactory transportFactory, byte[] cacheName, AtomicInteger topologyId, int flags, String taskName, Map<String, byte[]> marshalledParams) {
        super(codec, transportFactory, cacheName, topologyId, flags);
        this.taskName = taskName;
        this.marshalledParams = marshalledParams;
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        return this.transportFactory.getTransport(failedServers, this.cacheName);
    }

    @Override
    protected T executeOperation(Transport transport) {
        HeaderParams params = this.writeHeader(transport, (short)43);
        transport.writeString(this.taskName);
        transport.writeVInt(this.marshalledParams.size());
        for (Map.Entry<String, byte[]> entry : this.marshalledParams.entrySet()) {
            transport.writeString(entry.getKey());
            transport.writeArray(entry.getValue());
        }
        transport.flush();
        short status = this.readHeaderAndValidate(transport, params);
        return this.codec.readUnmarshallByteArray(transport, status);
    }
}

