/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.security;

import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.jca.core.spi.security.SecurityContext;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ElytronSecurityContext
implements SecurityContext {
    private Subject authenticatedSubject;

    public Subject getAuthenticatedSubject() {
        return this.authenticatedSubject;
    }

    public void setAuthenticatedSubject(Subject subject) {
        this.authenticatedSubject = subject;
    }

    public String[] getRoles() {
        if (this.authenticatedSubject != null) {
            Set<SecurityIdentity> authenticatedIdentities = this.getPrivateCredentials(SecurityIdentity.class);
            HashSet<String> rolesSet = new HashSet<String>();
            for (SecurityIdentity identity : authenticatedIdentities) {
                for (String role : identity.getRoles("ejb")) {
                    rolesSet.add(role);
                }
            }
            return rolesSet.toArray(new String[rolesSet.size()]);
        }
        return new String[0];
    }

    public void runWork(Runnable work) {
        Set<SecurityIdentity> authenticatedIdentities;
        if (this.authenticatedSubject != null && !(authenticatedIdentities = this.getPrivateCredentials(SecurityIdentity.class)).isEmpty()) {
            SecurityIdentity identity = authenticatedIdentities.iterator().next();
            identity.runAs(work);
            return;
        }
        work.run();
    }

    protected <T> Set<T> getPrivateCredentials(Class<T> credentialClass) {
        if (!WildFlySecurityManager.isChecking()) {
            return this.authenticatedSubject.getPrivateCredentials(credentialClass);
        }
        return AccessController.doPrivileged(() -> this.authenticatedSubject.getPrivateCredentials(credentialClass));
    }
}

