/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jboss.as.controller.client.logging.ControllerClientLogger;
import org.jboss.as.protocol.StreamUtils;

public interface InputStreamEntry
extends Closeable {
    public static final InputStreamEntry EMPTY = new InputStreamEntry(){

        @Override
        public int initialize() throws IOException {
            return 0;
        }

        @Override
        public void copyStream(DataOutput output) throws IOException {
            output.write(new byte[0]);
        }

        @Override
        public void close() throws IOException {
        }
    };

    public int initialize() throws IOException;

    public void copyStream(DataOutput var1) throws IOException;

    public static class FileStreamEntry
    extends FilterInputStream
    implements InputStreamEntry {
        private final Path file;

        public FileStreamEntry(File file) throws IOException {
            this(file.toPath());
        }

        public FileStreamEntry(Path file) throws IOException {
            super(Files.newInputStream(file, new OpenOption[0]));
            this.file = file;
        }

        @Override
        public int initialize() throws IOException {
            return (int)Files.size(this.file);
        }

        @Override
        public void copyStream(DataOutput output) throws IOException {
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0]));){
                StreamUtils.copyStream((InputStream)in, output);
            }
        }
    }

    public static class CachingStreamEntry
    implements InputStreamEntry {
        private final boolean autoClose;
        private final InputStream original;
        private File temp;

        public CachingStreamEntry(InputStream original, boolean autoClose) {
            this.original = original;
            this.autoClose = autoClose;
        }

        @Override
        public synchronized int initialize() throws IOException {
            if (this.temp == null) {
                this.temp = File.createTempFile("client", "stream");
                try {
                    int n = (int)Files.copy(this.original, this.temp.toPath(), new CopyOption[0]);
                    return n;
                }
                finally {
                    if (this.autoClose) {
                        StreamUtils.safeClose(this.original);
                    }
                }
            }
            return (int)this.temp.length();
        }

        @Override
        public synchronized void copyStream(DataOutput output) throws IOException {
            FileInputStream is = new FileInputStream(this.temp);
            try {
                StreamUtils.copyStream((InputStream)is, output);
            }
            finally {
                StreamUtils.safeClose(is);
            }
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.temp.delete()) {
                ControllerClientLogger.ROOT_LOGGER.cannotDeleteTempFile(this.temp.getName());
                this.temp.deleteOnExit();
            }
            this.temp = null;
        }
    }

    public static class InMemoryEntry
    implements InputStreamEntry {
        private final boolean autoClose;
        private final InputStream original;
        private byte[] data;

        public InMemoryEntry(InputStream original, boolean autoClose) {
            this.original = original;
            this.autoClose = autoClose;
        }

        @Override
        public synchronized int initialize() throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                StreamUtils.copyStream(this.original, os);
            }
            finally {
                if (this.autoClose) {
                    StreamUtils.safeClose(this.original);
                }
            }
            this.data = os.toByteArray();
            return this.data.length;
        }

        @Override
        public synchronized void copyStream(DataOutput output) throws IOException {
            try {
                output.write(this.data);
            }
            finally {
                this.data = null;
            }
        }

        @Override
        public void close() throws IOException {
        }
    }
}

