/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolConfiguration;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolServiceNameProvider;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;

public abstract class AbstractThreadPoolFactoryBuilder<T>
extends ThreadPoolServiceNameProvider
implements ResourceServiceBuilder<T>,
ThreadPoolConfiguration {
    private final ThreadPoolDefinition definition;
    private volatile int minThreads;
    private volatile int maxThreads;
    private volatile int queueLength;
    private volatile long keepAliveTime;

    protected AbstractThreadPoolFactoryBuilder(ThreadPoolDefinition definition, PathAddress address) {
        super(address);
        this.definition = definition;
    }

    public Builder<T> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.minThreads = this.definition.getMinThreads().resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.maxThreads = this.definition.getMaxThreads().resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.queueLength = this.definition.getQueueLength().resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.keepAliveTime = this.definition.getKeepAliveTime().resolveModelAttribute((ExpressionResolver)context, model).asLong();
        return this;
    }

    @Override
    public String getThreadGroupPrefix() {
        return this.definition.getThreadGroupPrefix();
    }

    @Override
    public int getMinThreads() {
        return this.minThreads;
    }

    @Override
    public int getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public int getQueueLength() {
        return this.queueLength;
    }

    @Override
    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }
}

