/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal.core;

import java.io.Serializable;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.internal.DefaultDeleteEventListener;
import org.hibernate.event.spi.DeleteEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.jpa.event.spi.jpa.CallbackRegistry;
import org.hibernate.jpa.event.spi.jpa.CallbackRegistryConsumer;
import org.hibernate.persister.entity.EntityPersister;

public class JpaDeleteEventListener
extends DefaultDeleteEventListener
implements CallbackRegistryConsumer {
    private CallbackRegistry callbackRegistry;

    @Override
    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    public JpaDeleteEventListener() {
    }

    public JpaDeleteEventListener(CallbackRegistry callbackRegistry) {
        this();
        this.callbackRegistry = callbackRegistry;
    }

    protected boolean invokeDeleteLifecycle(EventSource session, Object entity, EntityPersister persister) {
        this.callbackRegistry.preRemove(entity);
        return super.invokeDeleteLifecycle(session, entity, persister);
    }

    protected void performDetachedEntityDeletionCheck(DeleteEvent event) {
        EventSource source = event.getSession();
        String entityName = event.getEntityName();
        EntityPersister persister = source.getEntityPersister(entityName, event.getObject());
        Serializable id = persister.getIdentifier(event.getObject(), (SessionImplementor)source);
        entityName = entityName == null ? source.guessEntityName(event.getObject()) : entityName;
        throw new IllegalArgumentException("Removing a detached instance " + entityName + "#" + id);
    }
}

