/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.DescribedTypeConstructor;
import org.apache.qpid.proton.codec.TypeConstructor;

public class DynamicTypeConstructor
implements TypeConstructor {
    private final DescribedTypeConstructor _describedTypeConstructor;
    private final TypeConstructor _underlyingEncoding;

    public DynamicTypeConstructor(DescribedTypeConstructor dtc, TypeConstructor underlyingEncoding) {
        this._describedTypeConstructor = dtc;
        this._underlyingEncoding = underlyingEncoding;
    }

    public Object readValue() {
        try {
            return this._describedTypeConstructor.newInstance(this._underlyingEncoding.readValue());
        }
        catch (NullPointerException npe) {
            throw new DecodeException("Unexpected null value - mandatory field not set? (" + npe.getMessage() + ")", npe);
        }
        catch (ClassCastException cce) {
            throw new DecodeException("Incorrect type used", cce);
        }
    }

    @Override
    public boolean encodesJavaPrimitive() {
        return false;
    }

    public Class getTypeClass() {
        return this._describedTypeConstructor.getTypeClass();
    }
}

