/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoresConfigurationBuilder;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPMappingConfiguration;
import org.picketlink.idm.config.LDAPMappingConfigurationBuilder;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;

public class LDAPStoreConfigurationBuilder
extends IdentityStoreConfigurationBuilder<LDAPIdentityStoreConfiguration, LDAPStoreConfigurationBuilder> {
    private String url;
    private String baseDN;
    private String bindDN;
    private String bindCredential;
    private boolean activeDirectory;
    private Properties connectionProperties;
    private Set<LDAPMappingConfigurationBuilder> mappingBuilders = new HashSet<LDAPMappingConfigurationBuilder>();
    private boolean pagination;
    private String uniqueIdentifierAttributeName;

    public LDAPStoreConfigurationBuilder(IdentityStoresConfigurationBuilder builder) {
        super(builder);
    }

    public LDAPStoreConfigurationBuilder url(String url) {
        this.url = url;
        return this;
    }

    public LDAPStoreConfigurationBuilder baseDN(String baseDN) {
        this.baseDN = baseDN;
        return this;
    }

    public LDAPStoreConfigurationBuilder bindDN(String bindDN) {
        this.bindDN = bindDN;
        return this;
    }

    public LDAPStoreConfigurationBuilder bindCredential(String bindCredential) {
        this.bindCredential = bindCredential;
        return this;
    }

    public LDAPStoreConfigurationBuilder activeDirectory(boolean activeDirectory) {
        this.activeDirectory = activeDirectory;
        return this;
    }

    public LDAPStoreConfigurationBuilder pagination(boolean pagination) {
        this.pagination = pagination;
        return this;
    }

    public LDAPStoreConfigurationBuilder uniqueIdentifierAttributeName(String uniqueIdentifierAttributeName) {
        this.uniqueIdentifierAttributeName = uniqueIdentifierAttributeName;
        return this;
    }

    public LDAPMappingConfigurationBuilder mapping(Class<? extends AttributedType> attributedType) {
        LDAPMappingConfigurationBuilder ldapMappingConfigurationBuilder = new LDAPMappingConfigurationBuilder(attributedType, this);
        this.mappingBuilders.add(ldapMappingConfigurationBuilder);
        this.supportType(attributedType);
        if (Relationship.class.isAssignableFrom(attributedType)) {
            this.supportGlobalRelationship(attributedType);
        }
        return ldapMappingConfigurationBuilder;
    }

    public LDAPStoreConfigurationBuilder connectionProperties(Properties connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    @Override
    protected LDAPIdentityStoreConfiguration create() {
        HashMap<Class<? extends AttributedType>, LDAPMappingConfiguration> mappingConfig = new HashMap<Class<? extends AttributedType>, LDAPMappingConfiguration>();
        for (LDAPMappingConfigurationBuilder builder : this.mappingBuilders) {
            LDAPMappingConfiguration ldapMappingConfiguration = builder.create();
            mappingConfig.put(ldapMappingConfiguration.getMappedClass(), ldapMappingConfiguration);
        }
        return new LDAPIdentityStoreConfiguration(this.url, this.connectionProperties, this.bindDN, this.bindCredential, this.baseDN, this.activeDirectory, this.pagination, this.uniqueIdentifierAttributeName, mappingConfig, this.getSupportedTypes(), this.getUnsupportedTypes(), this.getContextInitializers(), this.getCredentialHandlerProperties(), this.getCredentialHandlers(), this.isSupportCredentials());
    }

    @Override
    protected void validate() {
        super.validate();
        if (StringUtil.isNullOrEmpty((String)this.baseDN)) {
            throw new SecurityConfigurationException("You must provide the Base DN.");
        }
        if (StringUtil.isNullOrEmpty((String)this.bindDN)) {
            throw new SecurityConfigurationException("You must provide the Bind DN.");
        }
        if (StringUtil.isNullOrEmpty((String)this.bindCredential)) {
            throw new SecurityConfigurationException("You must provide the credentials for the Bind DN.");
        }
        if (this.mappingBuilders.isEmpty()) {
            throw new SecurityConfigurationException("No mappings provided.");
        }
        for (LDAPMappingConfigurationBuilder builder : this.mappingBuilders) {
            builder.validate();
        }
        this.unsupportType(Partition.class, new IdentityStoreConfiguration.IdentityOperation[0]);
    }

    protected LDAPStoreConfigurationBuilder readFrom(LDAPIdentityStoreConfiguration configuration) {
        super.readFrom(configuration);
        this.baseDN = configuration.getBaseDN();
        this.bindCredential = configuration.getBindCredential();
        this.bindDN = configuration.getBindDN();
        this.url = configuration.getLdapURL();
        this.activeDirectory = configuration.isActiveDirectory();
        this.connectionProperties = configuration.getConnectionProperties();
        this.pagination = configuration.isPagination();
        this.uniqueIdentifierAttributeName = configuration.getUniqueIdentifierAttributeName();
        for (Class<? extends AttributedType> attributedType : configuration.getMappingConfig().keySet()) {
            LDAPMappingConfiguration mappingConfiguration = configuration.getMappingConfig().get(attributedType);
            this.mapping(attributedType).readFrom(mappingConfiguration);
        }
        return this;
    }
}

