/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.RemoveStepHandlerDescriptor;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.RestartParentResourceAddStepHandler;
import org.jboss.as.clustering.controller.RestartParentResourceRemoveStepHandler;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.controller.transform.LegacyPropertyAddOperationTransformer;
import org.jboss.as.clustering.controller.transform.LegacyPropertyResourceTransformer;
import org.jboss.as.clustering.controller.transform.SimpleOperationTransformer;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationBuilderFactory;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class StackProtocolResourceDefinition
extends ProtocolResourceDefinition {
    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        ProtocolResourceDefinition.addTransformations(version, builder);
        if (JGroupsModel.VERSION_4_1_0.requiresTransformation(version)) {
            builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"add-index"});
        }
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            org.jboss.as.clustering.controller.transform.OperationTransformer addTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    PathAddress stackAddress = address.subAddress(0, address.size() - 1);
                    ModelNode addProtocolOp = operation.clone();
                    addProtocolOp.get("address").set(stackAddress.toModelNode());
                    addProtocolOp.get("operation").set("add-protocol");
                    addProtocolOp = new LegacyPropertyAddOperationTransformer().transformOperation(addProtocolOp);
                    return addProtocolOp;
                }
            };
            builder.addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)new SimpleOperationTransformer(addTransformer)).inheritResourceAttributeDefinitions();
            org.jboss.as.clustering.controller.transform.OperationTransformer removeTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    String protocol = address.getLastElement().getValue();
                    PathAddress stackAddress = address.subAddress(0, address.size() - 1);
                    ModelNode legacyOperation = Util.createOperation((String)"remove-protocol", (PathAddress)stackAddress);
                    legacyOperation.get(ProtocolResourceDefinition.DeprecatedAttribute.TYPE.getDefinition().getName()).set(protocol);
                    return legacyOperation;
                }
            };
            builder.addOperationTransformationOverride("remove").setCustomOperationTransformer((OperationTransformer)new SimpleOperationTransformer(removeTransformer));
            builder.setCustomResourceTransformer((ResourceTransformer)new LegacyPropertyResourceTransformer());
        }
    }

    StackProtocolResourceDefinition(ResourceServiceBuilderFactory<ChannelFactory> stackBuilderFactory) {
        super(stackBuilderFactory);
    }

    @Override
    public void register(ManagementResourceRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(ProtocolResourceDefinition.Attribute.class).addExtraParameters(ProtocolResourceDefinition.DeprecatedAttribute.class).addCapabilities(ProtocolResourceDefinition.Capability.class);
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler((ResourceServiceBuilderFactory)new ProtocolConfigurationBuilderFactory());
        new RestartParentResourceAddStepHandler(this.parentBuilderFactory, (AddStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler).register(registration);
        new RestartParentResourceRemoveStepHandler(this.parentBuilderFactory, (RemoveStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler).register(registration);
        for (ProtocolResourceDefinition.DeprecatedAttribute attribute : ProtocolResourceDefinition.DeprecatedAttribute.values()) {
            registration.registerReadOnlyAttribute(attribute.getDefinition(), null);
        }
        super.register(registration);
    }
}

