/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.java.permission;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.naming.logging.NamingLogger;
import org.wildfly.common.Assert;
import org.wildfly.naming.java.permission.JndiPermission;
import org.wildfly.naming.java.permission.SerializedJndiPermissionCollection;

final class JndiPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = -769684900128311150L;
    private static final JndiPermission[] NO_PERMISSIONS = new JndiPermission[0];
    private final AtomicReference<JndiPermission[]> permissions;

    JndiPermissionCollection() {
        this.permissions = new AtomicReference<JndiPermission[]>(NO_PERMISSIONS);
    }

    JndiPermissionCollection(JndiPermission[] permissions) {
        Assert.checkNotNullParam((String)"permissions", (Object)permissions);
        this.permissions = new AtomicReference<JndiPermission[]>(permissions);
    }

    @Override
    public void add(Permission permission) {
        ArrayList<JndiPermission> newVal;
        JndiPermission[] oldVal;
        if (this.isReadOnly()) {
            throw NamingLogger.ROOT_LOGGER.cannotAddToReadOnlyPermissionCollection();
        }
        if (!(permission instanceof JndiPermission)) {
            throw NamingLogger.ROOT_LOGGER.invalidPermission(permission);
        }
        AtomicReference<JndiPermission[]> permissions = this.permissions;
        JndiPermission jndiPermission = (JndiPermission)permission;
        if (jndiPermission.getActionBits() == 0) {
            return;
        }
        boolean added = false;
        do {
            oldVal = permissions.get();
            newVal = new ArrayList<JndiPermission>(oldVal.length + 1);
            for (JndiPermission testPerm : oldVal) {
                if (testPerm.implies(jndiPermission)) {
                    return;
                }
                if (jndiPermission.implies(testPerm) || !jndiPermission.getName().equals(testPerm.getName())) continue;
                assert (jndiPermission.getActionBits() != testPerm.getActionBits());
                jndiPermission = jndiPermission.withActions(testPerm.getActionBits());
            }
            for (JndiPermission testPerm : oldVal) {
                if (jndiPermission.implies(testPerm)) continue;
                newVal.add(testPerm);
            }
            newVal.add(jndiPermission);
        } while (!permissions.compareAndSet(oldVal, newVal.toArray(NO_PERMISSIONS)));
    }

    @Override
    public boolean implies(Permission permission) {
        JndiPermission[] jndiPermissions;
        for (JndiPermission jndiPermission : jndiPermissions = this.permissions.get()) {
            if (!jndiPermission.implies(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Enumeration<Permission> elements() {
        final JndiPermission[] jndiPermissions = this.permissions.get();
        return new Enumeration<Permission>(){
            int i;

            @Override
            public boolean hasMoreElements() {
                return this.i < jndiPermissions.length;
            }

            @Override
            public Permission nextElement() {
                return jndiPermissions[this.i++];
            }
        };
    }

    Object writeReplace() {
        return new SerializedJndiPermissionCollection(this.isReadOnly(), this.permissions.get());
    }
}

