/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.UnaryRequirement;

public class CapabilityReference
implements CapabilityReferenceRecorder {
    private final Requirement requirement;
    private final Capability capability;
    private final Function<String, Optional<String>> requirementResolver;

    public CapabilityReference(Capability capability, UnaryRequirement requirement) {
        this(capability, (Requirement)requirement, value -> value != null ? Optional.of(requirement.resolve(value)) : Optional.empty());
    }

    CapabilityReference(Capability capability, Requirement requirement, Function<String, Optional<String>> requirementResolver) {
        this.capability = capability;
        this.requirement = requirement;
        this.requirementResolver = requirementResolver;
    }

    public void addCapabilityRequirements(OperationContext context, String attributeName, String ... values) {
        String dependentName = this.capability.resolve(context.getCurrentAddress()).getName();
        Stream.of(values).forEach(value -> this.requirementResolver.apply((String)value).ifPresent(requirementName -> context.registerAdditionalCapabilityRequirement(requirementName, dependentName, attributeName)));
    }

    public void removeCapabilityRequirements(OperationContext context, String attributeName, String ... values) {
        String dependentName = this.capability.resolve(context.getCurrentAddress()).getName();
        Stream.of(values).forEach(value -> this.requirementResolver.apply((String)value).ifPresent(requirementName -> context.deregisterCapabilityRequirement(requirementName, dependentName)));
    }

    public String getBaseDependentName() {
        return ((RuntimeCapability)this.capability.getDefinition()).getName();
    }

    public String getBaseRequirementName() {
        return this.requirement.getName();
    }

    public boolean isDynamicDependent() {
        return ((RuntimeCapability)this.capability.getDefinition()).isDynamicallyNamed();
    }
}

