/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Util;

public class RpcDispatcherSpeedTest
implements MembershipListener {
    Channel channel;
    RpcDispatcher disp;
    String props = null;
    boolean server = false;
    boolean jmx = false;
    int num = 1000;
    int num_threads = 1;
    static final long TIMEOUT = 10000L;
    final Method[] METHODS = new Method[1];
    final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private long sleep = 0L;
    private boolean async;
    private boolean oob;

    public RpcDispatcherSpeedTest(String props, boolean server, boolean async, boolean oob, int num, int num_threads, boolean jmx, long sleep) throws NoSuchMethodException {
        this.props = props;
        this.server = server;
        this.async = async;
        this.oob = oob;
        this.num = num;
        this.num_threads = num_threads;
        this.jmx = jmx;
        this.sleep = sleep;
        this.initMethods();
    }

    final void initMethods() throws NoSuchMethodException {
        Class<?> cl = this.getClass();
        this.METHODS[0] = cl.getMethod("measure", new Class[0]);
    }

    public long measure() throws Exception {
        long retval = System.currentTimeMillis();
        if (this.sleep > 0L) {
            Util.sleep(this.sleep);
        }
        return retval;
    }

    public void start() throws Exception {
        this.channel = new JChannel(this.props);
        this.channel.setDiscardOwnMessages(true);
        this.disp = new RpcDispatcher(this.channel, null, (MembershipListener)this, this);
        this.disp.setMethodLookup(new MethodLookup(){

            @Override
            public Method findMethod(short id) {
                return RpcDispatcherSpeedTest.this.METHODS[0];
            }
        });
        if (this.jmx) {
            MBeanServer srv = Util.getMBeanServer();
            if (srv == null) {
                throw new Exception("No MBeanServers found;\nDraw needs to be run with an MBeanServer present, or inside JDK 5");
            }
            JmxConfigurator.registerChannel((JChannel)this.channel, srv, "jgroups", this.channel.getClusterName(), true);
        }
        this.channel.connect("RpcDispatcherSpeedTestGroup");
        try {
            if (this.server) {
                System.out.println("-- Started as server. Press ctrl-c to kill");
                while (true) {
                    Util.sleep(10000L);
                }
            }
            this.invokeRpcs(this.num, this.num_threads, this.async, this.oob);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            this.channel.close();
            this.disp.stop();
        }
    }

    void invokeRpcs(int num, int num_threads, boolean async, boolean oob) throws Exception {
        int show = num / 10;
        Method measure_method = this.getClass().getMethod("measure", this.EMPTY_CLASS_ARRAY);
        MethodCall measure_method_call = new MethodCall(measure_method, this.EMPTY_OBJECT_ARRAY);
        if (show <= 0) {
            show = 1;
        }
        ResponseMode request_type = async ? ResponseMode.GET_NONE : ResponseMode.GET_ALL;
        measure_method_call = new MethodCall(0, new Object[0]);
        RequestOptions opts = new RequestOptions(request_type, 10000L, false, null, Message.Flag.DONT_BUNDLE, Message.NO_FC);
        if (oob) {
            opts.setFlags(Message.Flag.OOB);
        }
        AtomicInteger sent = new AtomicInteger(0);
        CountDownLatch latch = new CountDownLatch(1);
        Publisher[] senders = new Publisher[num_threads];
        for (int i = 0; i < senders.length; ++i) {
            senders[i] = new Publisher(measure_method_call, sent, num, opts, this.disp, latch);
            senders[i].start();
        }
        long start = System.currentTimeMillis();
        latch.countDown();
        for (Publisher sender : senders) {
            sender.join();
        }
        long stop = System.currentTimeMillis();
        RpcDispatcherSpeedTest.printStats(stop - start, num);
    }

    static void printStats(long total_time, int num) {
        double throughput = (double)num / ((double)total_time / 1000.0);
        System.out.println("time for " + num + " remote calls was " + total_time + "ms, avg=" + (double)total_time / (double)num + "ms/invocation, " + (long)throughput + " calls/sec");
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("-- new view: " + new_view);
    }

    @Override
    public void suspect(Address suspected_mbr) {
    }

    @Override
    public void block() {
    }

    @Override
    public void unblock() {
    }

    public static void main(String[] args) {
        String props = null;
        boolean server = false;
        boolean jmx = false;
        int num = 1000;
        int num_threads = 1;
        long sleep = 0L;
        boolean async = false;
        boolean oob = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-server".equals(args[i])) {
                server = true;
                continue;
            }
            if ("-async".equals(args[i])) {
                async = true;
                continue;
            }
            if ("-num".equals(args[i])) {
                num = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-jmx".equals(args[i])) {
                jmx = true;
                continue;
            }
            if ("-sleep".equals(args[i])) {
                sleep = Long.parseLong(args[++i]);
                continue;
            }
            if ("-num_threads".equals(args[i])) {
                num_threads = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-oob".equals(args[i])) {
                oob = true;
                continue;
            }
            RpcDispatcherSpeedTest.help();
            return;
        }
        try {
            RpcDispatcherSpeedTest test = new RpcDispatcherSpeedTest(props, server, async, oob, num, num_threads, jmx, sleep);
            test.start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println("RpcDispatcherSpeedTest [-help] [-props <props>] [-server] [-async] [-num <number of calls>] [-jmx] [-sleep <ms>]");
    }

    static class Publisher
    extends Thread {
        final MethodCall call;
        final RequestOptions options;
        final AtomicInteger sent;
        final int num_msgs_to_send;
        final RpcDispatcher disp;
        final CountDownLatch latch;
        final int print;

        public Publisher(MethodCall call, AtomicInteger sent, int num, RequestOptions options, RpcDispatcher disp, CountDownLatch latch) {
            this.call = call;
            this.sent = sent;
            this.num_msgs_to_send = num;
            this.options = options;
            this.disp = disp;
            this.latch = latch;
            this.print = this.num_msgs_to_send / 10;
        }

        @Override
        public void run() {
            int tmp;
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while ((tmp = this.sent.incrementAndGet()) <= this.num_msgs_to_send) {
                try {
                    this.disp.callRemoteMethods(null, this.call, this.options);
                    if (tmp <= 0 || tmp % this.print != 0) continue;
                    System.out.println(tmp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

