/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.journal.impl.SyncIOCompletion;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;

public final class SimpleWaitIOCallback
extends SyncIOCompletion {
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile String errorMessage;
    private volatile int errorCode = 0;

    public String toString() {
        return SimpleWaitIOCallback.class.getName();
    }

    @Override
    public void done() {
        this.latch.countDown();
    }

    @Override
    public void onError(int errorCode1, String errorMessage1) {
        this.errorCode = errorCode1;
        this.errorMessage = errorMessage1;
        ActiveMQJournalLogger.LOGGER.errorOnIOCallback(errorMessage1);
        this.latch.countDown();
    }

    @Override
    public void waitCompletion() throws InterruptedException, ActiveMQException {
        while (!this.latch.await(2L, TimeUnit.SECONDS)) {
        }
        if (this.errorMessage != null) {
            throw ActiveMQExceptionType.createException(this.errorCode, this.errorMessage);
        }
    }

    public boolean waitCompletion(long timeout) throws InterruptedException, ActiveMQException {
        boolean retValue = this.latch.await(timeout, TimeUnit.MILLISECONDS);
        if (this.errorMessage != null) {
            throw ActiveMQExceptionType.createException(this.errorCode, this.errorMessage);
        }
        return retValue;
    }

    @Override
    public void storeLineUp() {
    }
}

