// ============================================================================
//
// Copyright (c) 2006-2013, Talend Inc.
//
// This source code has been automatically generated by_Talend Open Studio for Data Integration
// / Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package ovirt_engine_dwh.historydelete_3_5;

import routines.Mathematical;
import routines.DataOperation;
import routines.Relational;
import routines.TalendDate;
import routines.TalendDataGenerator;
import routines.RoutineHistoryETL;
import routines.Numeric;
import routines.TalendString;
import routines.StringHandling;
import routines.system.*;
import routines.system.api.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.math.BigDecimal;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.util.Comparator;

@SuppressWarnings("unused")
/**
 * Job: HistoryDelete Purpose: <br>
 * Description:  <br>
 * @author ydary@redhat.com
 * @version 5.4.1.r111943
 * @status 
 */
public class HistoryDelete implements TalendJob {

	public final Object obj = new Object();

	// for transmiting parameters purpose
	private Object valueObject = null;

	public Object getValueObject() {
		return this.valueObject;
	}

	public void setValueObject(Object valueObject) {
		this.valueObject = valueObject;
	}

	private Object[] multiThreadLockWrite = new Object[0];

	private final static String defaultCharset = java.nio.charset.Charset
			.defaultCharset().name();

	private final static String utf8Charset = "UTF-8";

	// create and load default properties
	private java.util.Properties defaultProps = new java.util.Properties();

	// create application properties with default
	public class ContextProperties extends java.util.Properties {

		private static final long serialVersionUID = 1L;

		public ContextProperties(java.util.Properties properties) {
			super(properties);
		}

		public ContextProperties() {
			super();
		}

		public void synchronizeContext() {

			if (hoursToKeepDaily != null) {

				this.setProperty("hoursToKeepDaily",
						hoursToKeepDaily.toString());

			}

			if (hoursToKeepHourly != null) {

				this.setProperty("hoursToKeepHourly",
						hoursToKeepHourly.toString());

			}

			if (hoursToKeepSamples != null) {

				this.setProperty("hoursToKeepSamples",
						hoursToKeepSamples.toString());

			}

			if (ovirtEngineHistoryDbDriverClass != null) {

				this.setProperty("ovirtEngineHistoryDbDriverClass",
						ovirtEngineHistoryDbDriverClass.toString());

			}

			if (ovirtEngineHistoryDbJdbcConnection != null) {

				this.setProperty("ovirtEngineHistoryDbJdbcConnection",
						ovirtEngineHistoryDbJdbcConnection.toString());

			}

			if (ovirtEngineHistoryDbPassword != null) {

				this.setProperty("ovirtEngineHistoryDbPassword",
						ovirtEngineHistoryDbPassword.toString());

			}

			if (ovirtEngineHistoryDbUser != null) {

				this.setProperty("ovirtEngineHistoryDbUser",
						ovirtEngineHistoryDbUser.toString());

			}

			if (runTime != null) {

				String pattern_runTime = "yyyy-MM-dd HH:mm:ss";
				String value_runTime = "yyyy-MM-dd HH:mm:ss.SSSSSS;2011-07-03 12:46:47.000000";
				String[] parts_runTime = value_runTime.split(";");
				if (parts_runTime.length > 1) {
					pattern_runTime = parts_runTime[0];
					this.setProperty(
							"runTime",
							pattern_runTime
									+ ";"
									+ FormatterUtils.format_Date(runTime,
											pattern_runTime));
				} else {
					this.setProperty("runTime", FormatterUtils.format_Date(
							runTime, pattern_runTime));
				}

			}

			if (limitRows != null) {

				this.setProperty("limitRows", limitRows.toString());

			}

		}

		public Integer hoursToKeepDaily;

		public Integer getHoursToKeepDaily() {
			return this.hoursToKeepDaily;
		}

		public Integer hoursToKeepHourly;

		public Integer getHoursToKeepHourly() {
			return this.hoursToKeepHourly;
		}

		public Integer hoursToKeepSamples;

		public Integer getHoursToKeepSamples() {
			return this.hoursToKeepSamples;
		}

		public String ovirtEngineHistoryDbDriverClass;

		public String getOvirtEngineHistoryDbDriverClass() {
			return this.ovirtEngineHistoryDbDriverClass;
		}

		public String ovirtEngineHistoryDbJdbcConnection;

		public String getOvirtEngineHistoryDbJdbcConnection() {
			return this.ovirtEngineHistoryDbJdbcConnection;
		}

		public java.lang.String ovirtEngineHistoryDbPassword;

		public java.lang.String getOvirtEngineHistoryDbPassword() {
			return this.ovirtEngineHistoryDbPassword;
		}

		public String ovirtEngineHistoryDbUser;

		public String getOvirtEngineHistoryDbUser() {
			return this.ovirtEngineHistoryDbUser;
		}

		public java.util.Date runTime;

		public java.util.Date getRunTime() {
			return this.runTime;
		}

		public String limitRows;

		public String getLimitRows() {
			return this.limitRows;
		}
	}

	private ContextProperties context = new ContextProperties();

	public ContextProperties getContext() {
		return this.context;
	}

	private final String jobVersion = "3.5";
	private final String jobName = "HistoryDelete";
	private final String projectName = "OVIRT_ENGINE_DWH";
	public Integer errorCode = null;
	private String currentComponent = "";

	private final java.util.Map<String, Object> globalMap = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Object>());

	private final java.util.Map<String, Long> start_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Long> end_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Boolean> ok_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Boolean>());
	public final java.util.List<String[]> globalBuffer = java.util.Collections
			.synchronizedList(new java.util.ArrayList<String[]>());

	public boolean isExportedAsOSGI = false;

	// OSGi DataSource
	private final static String KEY_DB_DATASOURCES = "KEY_DB_DATASOURCES";

	public void setDataSources(
			java.util.Map<String, javax.sql.DataSource> dataSources) {
		java.util.Map<String, routines.system.TalendDataSource> talendDataSources = new java.util.HashMap<String, routines.system.TalendDataSource>();
		for (java.util.Map.Entry<String, javax.sql.DataSource> dataSourceEntry : dataSources
				.entrySet()) {
			talendDataSources.put(
					dataSourceEntry.getKey(),
					new routines.system.TalendDataSource(dataSourceEntry
							.getValue()));
		}
		globalMap.put(KEY_DB_DATASOURCES, talendDataSources);
	}

	LogCatcherUtils talendLogs_LOGS = new LogCatcherUtils();

	private final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
	private final java.io.PrintStream errorMessagePS = new java.io.PrintStream(
			new java.io.BufferedOutputStream(baos));

	public String getExceptionStackTrace() {
		if ("failure".equals(this.getStatus())) {
			errorMessagePS.flush();
			return baos.toString();
		}
		return null;
	}

	private java.lang.Exception exception = null;

	public java.lang.Exception getException() {
		if ("failure".equals(this.getStatus())) {
			return this.exception;
		}
		return null;
	}

	private class TalendException extends java.lang.Exception {

		private static final long serialVersionUID = 1L;

		private java.util.Map<String, Object> globalMap = null;
		private java.lang.Exception e = null;
		private String currentComponent = null;
		private String virtualComponentName = null;

		public void setVirtualComponentName(String virtualComponentName) {
			this.virtualComponentName = virtualComponentName;
		}

		private TalendException(java.lang.Exception e, String errorComponent,
				final java.util.Map<String, Object> globalMap) {
			this.currentComponent = errorComponent;
			this.globalMap = globalMap;
			this.e = e;
		}

		public java.lang.Exception getException() {
			return this.e;
		}

		public String getCurrentComponent() {
			return this.currentComponent;
		}

		public String getExceptionCauseMessage(java.lang.Exception e) {
			Throwable cause = e;
			String message = null;
			int i = 10;
			while (null != cause && 0 < i--) {
				message = cause.getMessage();
				if (null == message) {
					cause = cause.getCause();
				} else {
					break;
				}
			}
			if (null == message) {
				message = e.getClass().getName();
			}
			return message;
		}

		@Override
		public void printStackTrace() {
			if (!(e instanceof TalendException || e instanceof TDieException)) {
				if (virtualComponentName != null
						&& currentComponent.indexOf(virtualComponentName + "_") == 0) {
					globalMap.put(virtualComponentName + "_ERROR_MESSAGE",
							getExceptionCauseMessage(e));
				}
				globalMap.put(currentComponent + "_ERROR_MESSAGE",
						getExceptionCauseMessage(e));
				System.err
						.println("Exception in component " + currentComponent);
			}
			if (!(e instanceof TDieException)) {
				if (e instanceof TalendException) {
					e.printStackTrace();
				} else {
					e.printStackTrace();
					e.printStackTrace(errorMessagePS);
					HistoryDelete.this.exception = e;
				}
			}
			if (!(e instanceof TalendException)) {
				try {
					for (java.lang.reflect.Method m : this.getClass()
							.getEnclosingClass().getMethods()) {
						if (m.getName().compareTo(currentComponent + "_error") == 0) {
							m.invoke(HistoryDelete.this, new Object[] { e,
									currentComponent, globalMap });
							break;
						}
					}

					if (!(e instanceof TDieException)) {
						talendLogs_LOGS.addMessage("Java Exception",
								currentComponent, 6, e.getClass().getName()
										+ ":" + e.getMessage(), 1);
						talendLogs_LOGSProcess(globalMap);
					}
				} catch (java.lang.SecurityException e) {
					this.e.printStackTrace();
				} catch (java.lang.IllegalArgumentException e) {
					this.e.printStackTrace();
				} catch (java.lang.IllegalAccessException e) {
					this.e.printStackTrace();
				} catch (java.lang.reflect.InvocationTargetException e) {
					this.e.printStackTrace();
				} catch (TalendException e) {
					// do nothing
				}

			}
		}
	}

	public void tJDBCInput_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_2", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_3", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_4_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_4", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_4_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_4", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_5_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_5", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_5_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_5", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_6_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_6", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_6_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_6", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_7_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_7", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_7_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_7_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_7", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_7_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_8_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_8", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_8_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_8", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_9_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_9", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_9_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_9_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_9", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_9_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_10_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_10", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_10_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_10", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_11_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_11", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_11_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_11_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_11", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_11_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_12_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_12", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_12_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_12_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_12", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_12_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_13_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_13", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_13_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_13_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_13", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_13_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_14_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_14", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_14_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_14_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_14", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_14_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_15_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_15", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_15_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_15_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_15", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_15_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_16_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_16", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_16_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_16_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_16", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_16_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_17_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_17", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_17_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_17_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_17", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_17_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_18_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_18", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_18_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_18_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_18", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_18_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_19_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_19", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_19_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_19_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_19", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_19_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_20_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_20", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_20_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_20_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_20", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_20_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_21_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_21", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_21_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_21_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_21", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_21_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tPrejob_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tPrejob_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tPrejob_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_22_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_22", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_22_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_22_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_22", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_22_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_23_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_23", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_23_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_23_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_23", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_23_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_24_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_24", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_24_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_24_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_24", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_24_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_25_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_25", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_25_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_25_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_25", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_25_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_26_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_26", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_26_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_26_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_26", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_26_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_LOGS_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_CONSOLE_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("talendLogs_CONSOLE", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_3_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_4_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_5_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_6_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_7_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_8_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_9_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_10_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_11_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_12_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_13_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_14_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_15_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_16_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_17_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_18_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_19_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_20_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_21_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tPrejob_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_22_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_23_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_24_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_25_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_26_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void talendLogs_LOGS_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public static class row13Struct implements
			routines.system.IPersistableRow<row13Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row13Struct other = (row13Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row13Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row13Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row13Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row13Struct row13 = new row13Struct();

				/**
				 * [tJDBCOutput_1 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_1", false);
				start_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_1";

				int tos_count_tJDBCOutput_1 = 0;

				int deleteKeyCount_tJDBCOutput_1 = 1;
				if (deleteKeyCount_tJDBCOutput_1 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_1 = 0;
				int nb_line_update_tJDBCOutput_1 = 0;
				int nb_line_inserted_tJDBCOutput_1 = 0;
				int nb_line_deleted_tJDBCOutput_1 = 0;
				int nb_line_rejected_tJDBCOutput_1 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_1 = 0;

				int deletedCount_tJDBCOutput_1 = 0;
				int updatedCount_tJDBCOutput_1 = 0;
				int insertedCount_tJDBCOutput_1 = 0;
				int rejectedCount_tJDBCOutput_1 = 0;

				boolean whetherReject_tJDBCOutput_1 = false;

				java.sql.Connection connection_tJDBCOutput_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_1 = 10000;
				int batchSizeCounter_tJDBCOutput_1 = 0;

				String delete_tJDBCOutput_1 = "DELETE  FROM "
						+ "datacenter_samples_history"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_1 = connection_tJDBCOutput_1
						.prepareStatement(delete_tJDBCOutput_1);

				/**
				 * [tJDBCOutput_1 begin ] stop
				 */

				/**
				 * [tJDBCInput_1 begin ] start
				 */

				ok_Hash.put("tJDBCInput_1", false);
				start_Hash.put("tJDBCInput_1", System.currentTimeMillis());

				currentComponent = "tJDBCInput_1";

				int tos_count_tJDBCInput_1 = 0;

				int nb_line_tJDBCInput_1 = 0;
				java.sql.Connection conn_tJDBCInput_1 = null;
				conn_tJDBCInput_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_1 = conn_tJDBCInput_1
						.createStatement();

				String dbquery_tJDBCInput_1 = "SELECT history_id  FROM datacenter_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_1_QUERY", dbquery_tJDBCInput_1);
				java.sql.ResultSet rs_tJDBCInput_1 = null;
				try {
					rs_tJDBCInput_1 = stmt_tJDBCInput_1
							.executeQuery(dbquery_tJDBCInput_1);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_1 = rs_tJDBCInput_1
							.getMetaData();
					int colQtyInRs_tJDBCInput_1 = rsmd_tJDBCInput_1
							.getColumnCount();

					String tmpContent_tJDBCInput_1 = null;
					int column_index_tJDBCInput_1 = 1;

					while (rs_tJDBCInput_1.next()) {
						nb_line_tJDBCInput_1++;

						column_index_tJDBCInput_1 = 1;

						if (colQtyInRs_tJDBCInput_1 < column_index_tJDBCInput_1) {
							row13.history_id = 0;
						} else {

							if (rs_tJDBCInput_1
									.getObject(column_index_tJDBCInput_1) != null) {
								row13.history_id = rs_tJDBCInput_1
										.getLong(column_index_tJDBCInput_1);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_1 begin ] stop
						 */
						/**
						 * [tJDBCInput_1 main ] start
						 */

						currentComponent = "tJDBCInput_1";

						tos_count_tJDBCInput_1++;

						/**
						 * [tJDBCInput_1 main ] stop
						 */

						/**
						 * [tJDBCOutput_1 main ] start
						 */

						currentComponent = "tJDBCOutput_1";

						whetherReject_tJDBCOutput_1 = false;
						pstmt_tJDBCOutput_1.setLong(1, row13.history_id);

						try {
							deletedCount_tJDBCOutput_1 = deletedCount_tJDBCOutput_1
									+ pstmt_tJDBCOutput_1.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_1 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_1++;

						tos_count_tJDBCOutput_1++;

						/**
						 * [tJDBCOutput_1 main ] stop
						 */

						/**
						 * [tJDBCInput_1 end ] start
						 */

						currentComponent = "tJDBCInput_1";

					}
				} finally {
					rs_tJDBCInput_1.close();
					stmt_tJDBCInput_1.close();

				}
				globalMap.put("tJDBCInput_1_NB_LINE", nb_line_tJDBCInput_1);

				ok_Hash.put("tJDBCInput_1", true);
				end_Hash.put("tJDBCInput_1", System.currentTimeMillis());

				/**
				 * [tJDBCInput_1 end ] stop
				 */

				/**
				 * [tJDBCOutput_1 end ] start
				 */

				currentComponent = "tJDBCOutput_1";

				if (pstmt_tJDBCOutput_1 != null) {

					pstmt_tJDBCOutput_1.close();

				}

				nb_line_deleted_tJDBCOutput_1 = nb_line_deleted_tJDBCOutput_1
						+ deletedCount_tJDBCOutput_1;
				nb_line_update_tJDBCOutput_1 = nb_line_update_tJDBCOutput_1
						+ updatedCount_tJDBCOutput_1;
				nb_line_inserted_tJDBCOutput_1 = nb_line_inserted_tJDBCOutput_1
						+ insertedCount_tJDBCOutput_1;
				nb_line_rejected_tJDBCOutput_1 = nb_line_rejected_tJDBCOutput_1
						+ rejectedCount_tJDBCOutput_1;

				globalMap.put("tJDBCOutput_1_NB_LINE", nb_line_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_1);

				ok_Hash.put("tJDBCOutput_1", true);
				end_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_1 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_1 finally ] start
				 */

				currentComponent = "tJDBCInput_1";

				/**
				 * [tJDBCInput_1 finally ] stop
				 */

				/**
				 * [tJDBCOutput_1 finally ] start
				 */

				currentComponent = "tJDBCOutput_1";

				/**
				 * [tJDBCOutput_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", 1);
	}

	public static class row5Struct implements
			routines.system.IPersistableRow<row5Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row5Struct other = (row5Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row5Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row5Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row5Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row5Struct row5 = new row5Struct();

				/**
				 * [tJDBCOutput_2 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_2", false);
				start_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_2";

				int tos_count_tJDBCOutput_2 = 0;

				int deleteKeyCount_tJDBCOutput_2 = 1;
				if (deleteKeyCount_tJDBCOutput_2 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_2 = 0;
				int nb_line_update_tJDBCOutput_2 = 0;
				int nb_line_inserted_tJDBCOutput_2 = 0;
				int nb_line_deleted_tJDBCOutput_2 = 0;
				int nb_line_rejected_tJDBCOutput_2 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_2 = 0;

				int deletedCount_tJDBCOutput_2 = 0;
				int updatedCount_tJDBCOutput_2 = 0;
				int insertedCount_tJDBCOutput_2 = 0;
				int rejectedCount_tJDBCOutput_2 = 0;

				boolean whetherReject_tJDBCOutput_2 = false;

				java.sql.Connection connection_tJDBCOutput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_2 = 10000;
				int batchSizeCounter_tJDBCOutput_2 = 0;

				String delete_tJDBCOutput_2 = "DELETE  FROM "
						+ "host_samples_history" + " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_2 = connection_tJDBCOutput_2
						.prepareStatement(delete_tJDBCOutput_2);

				/**
				 * [tJDBCOutput_2 begin ] stop
				 */

				/**
				 * [tJDBCInput_2 begin ] start
				 */

				ok_Hash.put("tJDBCInput_2", false);
				start_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				currentComponent = "tJDBCInput_2";

				int tos_count_tJDBCInput_2 = 0;

				int nb_line_tJDBCInput_2 = 0;
				java.sql.Connection conn_tJDBCInput_2 = null;
				conn_tJDBCInput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_2 = conn_tJDBCInput_2
						.createStatement();

				String dbquery_tJDBCInput_2 = "SELECT history_id  FROM host_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_2_QUERY", dbquery_tJDBCInput_2);
				java.sql.ResultSet rs_tJDBCInput_2 = null;
				try {
					rs_tJDBCInput_2 = stmt_tJDBCInput_2
							.executeQuery(dbquery_tJDBCInput_2);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_2 = rs_tJDBCInput_2
							.getMetaData();
					int colQtyInRs_tJDBCInput_2 = rsmd_tJDBCInput_2
							.getColumnCount();

					String tmpContent_tJDBCInput_2 = null;
					int column_index_tJDBCInput_2 = 1;

					while (rs_tJDBCInput_2.next()) {
						nb_line_tJDBCInput_2++;

						column_index_tJDBCInput_2 = 1;

						if (colQtyInRs_tJDBCInput_2 < column_index_tJDBCInput_2) {
							row5.history_id = 0;
						} else {

							if (rs_tJDBCInput_2
									.getObject(column_index_tJDBCInput_2) != null) {
								row5.history_id = rs_tJDBCInput_2
										.getLong(column_index_tJDBCInput_2);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_2 begin ] stop
						 */
						/**
						 * [tJDBCInput_2 main ] start
						 */

						currentComponent = "tJDBCInput_2";

						tos_count_tJDBCInput_2++;

						/**
						 * [tJDBCInput_2 main ] stop
						 */

						/**
						 * [tJDBCOutput_2 main ] start
						 */

						currentComponent = "tJDBCOutput_2";

						whetherReject_tJDBCOutput_2 = false;
						pstmt_tJDBCOutput_2.setLong(1, row5.history_id);

						try {
							deletedCount_tJDBCOutput_2 = deletedCount_tJDBCOutput_2
									+ pstmt_tJDBCOutput_2.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_2 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_2++;

						tos_count_tJDBCOutput_2++;

						/**
						 * [tJDBCOutput_2 main ] stop
						 */

						/**
						 * [tJDBCInput_2 end ] start
						 */

						currentComponent = "tJDBCInput_2";

					}
				} finally {
					rs_tJDBCInput_2.close();
					stmt_tJDBCInput_2.close();

				}
				globalMap.put("tJDBCInput_2_NB_LINE", nb_line_tJDBCInput_2);

				ok_Hash.put("tJDBCInput_2", true);
				end_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				/**
				 * [tJDBCInput_2 end ] stop
				 */

				/**
				 * [tJDBCOutput_2 end ] start
				 */

				currentComponent = "tJDBCOutput_2";

				if (pstmt_tJDBCOutput_2 != null) {

					pstmt_tJDBCOutput_2.close();

				}

				nb_line_deleted_tJDBCOutput_2 = nb_line_deleted_tJDBCOutput_2
						+ deletedCount_tJDBCOutput_2;
				nb_line_update_tJDBCOutput_2 = nb_line_update_tJDBCOutput_2
						+ updatedCount_tJDBCOutput_2;
				nb_line_inserted_tJDBCOutput_2 = nb_line_inserted_tJDBCOutput_2
						+ insertedCount_tJDBCOutput_2;
				nb_line_rejected_tJDBCOutput_2 = nb_line_rejected_tJDBCOutput_2
						+ rejectedCount_tJDBCOutput_2;

				globalMap.put("tJDBCOutput_2_NB_LINE", nb_line_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_2);

				ok_Hash.put("tJDBCOutput_2", true);
				end_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_2 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_2 finally ] start
				 */

				currentComponent = "tJDBCInput_2";

				/**
				 * [tJDBCInput_2 finally ] stop
				 */

				/**
				 * [tJDBCOutput_2 finally ] start
				 */

				currentComponent = "tJDBCOutput_2";

				/**
				 * [tJDBCOutput_2 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 1);
	}

	public static class row4Struct implements
			routines.system.IPersistableRow<row4Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row4Struct other = (row4Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row4Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row4Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row4Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_3Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row4Struct row4 = new row4Struct();

				/**
				 * [tJDBCOutput_3 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_3", false);
				start_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_3";

				int tos_count_tJDBCOutput_3 = 0;

				int deleteKeyCount_tJDBCOutput_3 = 1;
				if (deleteKeyCount_tJDBCOutput_3 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_3 = 0;
				int nb_line_update_tJDBCOutput_3 = 0;
				int nb_line_inserted_tJDBCOutput_3 = 0;
				int nb_line_deleted_tJDBCOutput_3 = 0;
				int nb_line_rejected_tJDBCOutput_3 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_3 = 0;

				int deletedCount_tJDBCOutput_3 = 0;
				int updatedCount_tJDBCOutput_3 = 0;
				int insertedCount_tJDBCOutput_3 = 0;
				int rejectedCount_tJDBCOutput_3 = 0;

				boolean whetherReject_tJDBCOutput_3 = false;

				java.sql.Connection connection_tJDBCOutput_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_3 = 10000;
				int batchSizeCounter_tJDBCOutput_3 = 0;

				String delete_tJDBCOutput_3 = "DELETE  FROM "
						+ "host_interface_samples_history"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_3 = connection_tJDBCOutput_3
						.prepareStatement(delete_tJDBCOutput_3);

				/**
				 * [tJDBCOutput_3 begin ] stop
				 */

				/**
				 * [tJDBCInput_3 begin ] start
				 */

				ok_Hash.put("tJDBCInput_3", false);
				start_Hash.put("tJDBCInput_3", System.currentTimeMillis());

				currentComponent = "tJDBCInput_3";

				int tos_count_tJDBCInput_3 = 0;

				int nb_line_tJDBCInput_3 = 0;
				java.sql.Connection conn_tJDBCInput_3 = null;
				conn_tJDBCInput_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_3 = conn_tJDBCInput_3
						.createStatement();

				String dbquery_tJDBCInput_3 = "SELECT history_id  FROM host_interface_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_3_QUERY", dbquery_tJDBCInput_3);
				java.sql.ResultSet rs_tJDBCInput_3 = null;
				try {
					rs_tJDBCInput_3 = stmt_tJDBCInput_3
							.executeQuery(dbquery_tJDBCInput_3);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_3 = rs_tJDBCInput_3
							.getMetaData();
					int colQtyInRs_tJDBCInput_3 = rsmd_tJDBCInput_3
							.getColumnCount();

					String tmpContent_tJDBCInput_3 = null;
					int column_index_tJDBCInput_3 = 1;

					while (rs_tJDBCInput_3.next()) {
						nb_line_tJDBCInput_3++;

						column_index_tJDBCInput_3 = 1;

						if (colQtyInRs_tJDBCInput_3 < column_index_tJDBCInput_3) {
							row4.history_id = 0;
						} else {

							if (rs_tJDBCInput_3
									.getObject(column_index_tJDBCInput_3) != null) {
								row4.history_id = rs_tJDBCInput_3
										.getLong(column_index_tJDBCInput_3);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_3 begin ] stop
						 */
						/**
						 * [tJDBCInput_3 main ] start
						 */

						currentComponent = "tJDBCInput_3";

						tos_count_tJDBCInput_3++;

						/**
						 * [tJDBCInput_3 main ] stop
						 */

						/**
						 * [tJDBCOutput_3 main ] start
						 */

						currentComponent = "tJDBCOutput_3";

						whetherReject_tJDBCOutput_3 = false;
						pstmt_tJDBCOutput_3.setLong(1, row4.history_id);

						try {
							deletedCount_tJDBCOutput_3 = deletedCount_tJDBCOutput_3
									+ pstmt_tJDBCOutput_3.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_3 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_3++;

						tos_count_tJDBCOutput_3++;

						/**
						 * [tJDBCOutput_3 main ] stop
						 */

						/**
						 * [tJDBCInput_3 end ] start
						 */

						currentComponent = "tJDBCInput_3";

					}
				} finally {
					rs_tJDBCInput_3.close();
					stmt_tJDBCInput_3.close();

				}
				globalMap.put("tJDBCInput_3_NB_LINE", nb_line_tJDBCInput_3);

				ok_Hash.put("tJDBCInput_3", true);
				end_Hash.put("tJDBCInput_3", System.currentTimeMillis());

				/**
				 * [tJDBCInput_3 end ] stop
				 */

				/**
				 * [tJDBCOutput_3 end ] start
				 */

				currentComponent = "tJDBCOutput_3";

				if (pstmt_tJDBCOutput_3 != null) {

					pstmt_tJDBCOutput_3.close();

				}

				nb_line_deleted_tJDBCOutput_3 = nb_line_deleted_tJDBCOutput_3
						+ deletedCount_tJDBCOutput_3;
				nb_line_update_tJDBCOutput_3 = nb_line_update_tJDBCOutput_3
						+ updatedCount_tJDBCOutput_3;
				nb_line_inserted_tJDBCOutput_3 = nb_line_inserted_tJDBCOutput_3
						+ insertedCount_tJDBCOutput_3;
				nb_line_rejected_tJDBCOutput_3 = nb_line_rejected_tJDBCOutput_3
						+ rejectedCount_tJDBCOutput_3;

				globalMap.put("tJDBCOutput_3_NB_LINE", nb_line_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_3);

				ok_Hash.put("tJDBCOutput_3", true);
				end_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_3 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_3 finally ] start
				 */

				currentComponent = "tJDBCInput_3";

				/**
				 * [tJDBCInput_3 finally ] stop
				 */

				/**
				 * [tJDBCOutput_3 finally ] start
				 */

				currentComponent = "tJDBCOutput_3";

				/**
				 * [tJDBCOutput_3 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", 1);
	}

	public static class row3Struct implements
			routines.system.IPersistableRow<row3Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row3Struct other = (row3Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row3Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row3Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row3Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_4Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row3Struct row3 = new row3Struct();

				/**
				 * [tJDBCOutput_4 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_4", false);
				start_Hash.put("tJDBCOutput_4", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_4";

				int tos_count_tJDBCOutput_4 = 0;

				int deleteKeyCount_tJDBCOutput_4 = 1;
				if (deleteKeyCount_tJDBCOutput_4 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_4 = 0;
				int nb_line_update_tJDBCOutput_4 = 0;
				int nb_line_inserted_tJDBCOutput_4 = 0;
				int nb_line_deleted_tJDBCOutput_4 = 0;
				int nb_line_rejected_tJDBCOutput_4 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_4 = 0;

				int deletedCount_tJDBCOutput_4 = 0;
				int updatedCount_tJDBCOutput_4 = 0;
				int insertedCount_tJDBCOutput_4 = 0;
				int rejectedCount_tJDBCOutput_4 = 0;

				boolean whetherReject_tJDBCOutput_4 = false;

				java.sql.Connection connection_tJDBCOutput_4 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_4 = 10000;
				int batchSizeCounter_tJDBCOutput_4 = 0;

				String delete_tJDBCOutput_4 = "DELETE  FROM "
						+ "vm_samples_history" + " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_4 = connection_tJDBCOutput_4
						.prepareStatement(delete_tJDBCOutput_4);

				/**
				 * [tJDBCOutput_4 begin ] stop
				 */

				/**
				 * [tJDBCInput_4 begin ] start
				 */

				ok_Hash.put("tJDBCInput_4", false);
				start_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				currentComponent = "tJDBCInput_4";

				int tos_count_tJDBCInput_4 = 0;

				int nb_line_tJDBCInput_4 = 0;
				java.sql.Connection conn_tJDBCInput_4 = null;
				conn_tJDBCInput_4 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_4 = conn_tJDBCInput_4
						.createStatement();

				String dbquery_tJDBCInput_4 = "SELECT history_id  FROM vm_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_4_QUERY", dbquery_tJDBCInput_4);
				java.sql.ResultSet rs_tJDBCInput_4 = null;
				try {
					rs_tJDBCInput_4 = stmt_tJDBCInput_4
							.executeQuery(dbquery_tJDBCInput_4);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_4 = rs_tJDBCInput_4
							.getMetaData();
					int colQtyInRs_tJDBCInput_4 = rsmd_tJDBCInput_4
							.getColumnCount();

					String tmpContent_tJDBCInput_4 = null;
					int column_index_tJDBCInput_4 = 1;

					while (rs_tJDBCInput_4.next()) {
						nb_line_tJDBCInput_4++;

						column_index_tJDBCInput_4 = 1;

						if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
							row3.history_id = 0;
						} else {

							if (rs_tJDBCInput_4
									.getObject(column_index_tJDBCInput_4) != null) {
								row3.history_id = rs_tJDBCInput_4
										.getLong(column_index_tJDBCInput_4);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_4 begin ] stop
						 */
						/**
						 * [tJDBCInput_4 main ] start
						 */

						currentComponent = "tJDBCInput_4";

						tos_count_tJDBCInput_4++;

						/**
						 * [tJDBCInput_4 main ] stop
						 */

						/**
						 * [tJDBCOutput_4 main ] start
						 */

						currentComponent = "tJDBCOutput_4";

						whetherReject_tJDBCOutput_4 = false;
						pstmt_tJDBCOutput_4.setLong(1, row3.history_id);

						try {
							deletedCount_tJDBCOutput_4 = deletedCount_tJDBCOutput_4
									+ pstmt_tJDBCOutput_4.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_4 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_4++;

						tos_count_tJDBCOutput_4++;

						/**
						 * [tJDBCOutput_4 main ] stop
						 */

						/**
						 * [tJDBCInput_4 end ] start
						 */

						currentComponent = "tJDBCInput_4";

					}
				} finally {
					rs_tJDBCInput_4.close();
					stmt_tJDBCInput_4.close();

				}
				globalMap.put("tJDBCInput_4_NB_LINE", nb_line_tJDBCInput_4);

				ok_Hash.put("tJDBCInput_4", true);
				end_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				/**
				 * [tJDBCInput_4 end ] stop
				 */

				/**
				 * [tJDBCOutput_4 end ] start
				 */

				currentComponent = "tJDBCOutput_4";

				if (pstmt_tJDBCOutput_4 != null) {

					pstmt_tJDBCOutput_4.close();

				}

				nb_line_deleted_tJDBCOutput_4 = nb_line_deleted_tJDBCOutput_4
						+ deletedCount_tJDBCOutput_4;
				nb_line_update_tJDBCOutput_4 = nb_line_update_tJDBCOutput_4
						+ updatedCount_tJDBCOutput_4;
				nb_line_inserted_tJDBCOutput_4 = nb_line_inserted_tJDBCOutput_4
						+ insertedCount_tJDBCOutput_4;
				nb_line_rejected_tJDBCOutput_4 = nb_line_rejected_tJDBCOutput_4
						+ rejectedCount_tJDBCOutput_4;

				globalMap.put("tJDBCOutput_4_NB_LINE", nb_line_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_4);
				globalMap.put("tJDBCOutput_4_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_4);

				ok_Hash.put("tJDBCOutput_4", true);
				end_Hash.put("tJDBCOutput_4", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_4 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_4 finally ] start
				 */

				currentComponent = "tJDBCInput_4";

				/**
				 * [tJDBCInput_4 finally ] stop
				 */

				/**
				 * [tJDBCOutput_4 finally ] start
				 */

				currentComponent = "tJDBCOutput_4";

				/**
				 * [tJDBCOutput_4 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 1);
	}

	public static class row2Struct implements
			routines.system.IPersistableRow<row2Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row2Struct other = (row2Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row2Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row2Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row2Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_5Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row2Struct row2 = new row2Struct();

				/**
				 * [tJDBCOutput_5 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_5", false);
				start_Hash.put("tJDBCOutput_5", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_5";

				int tos_count_tJDBCOutput_5 = 0;

				int deleteKeyCount_tJDBCOutput_5 = 1;
				if (deleteKeyCount_tJDBCOutput_5 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_5 = 0;
				int nb_line_update_tJDBCOutput_5 = 0;
				int nb_line_inserted_tJDBCOutput_5 = 0;
				int nb_line_deleted_tJDBCOutput_5 = 0;
				int nb_line_rejected_tJDBCOutput_5 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_5 = 0;

				int deletedCount_tJDBCOutput_5 = 0;
				int updatedCount_tJDBCOutput_5 = 0;
				int insertedCount_tJDBCOutput_5 = 0;
				int rejectedCount_tJDBCOutput_5 = 0;

				boolean whetherReject_tJDBCOutput_5 = false;

				java.sql.Connection connection_tJDBCOutput_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_5 = 10000;
				int batchSizeCounter_tJDBCOutput_5 = 0;

				String delete_tJDBCOutput_5 = "DELETE  FROM "
						+ "vm_interface_samples_history"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_5 = connection_tJDBCOutput_5
						.prepareStatement(delete_tJDBCOutput_5);

				/**
				 * [tJDBCOutput_5 begin ] stop
				 */

				/**
				 * [tJDBCInput_5 begin ] start
				 */

				ok_Hash.put("tJDBCInput_5", false);
				start_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				currentComponent = "tJDBCInput_5";

				int tos_count_tJDBCInput_5 = 0;

				int nb_line_tJDBCInput_5 = 0;
				java.sql.Connection conn_tJDBCInput_5 = null;
				conn_tJDBCInput_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_5 = conn_tJDBCInput_5
						.createStatement();

				String dbquery_tJDBCInput_5 = "SELECT history_id  FROM vm_interface_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_5_QUERY", dbquery_tJDBCInput_5);
				java.sql.ResultSet rs_tJDBCInput_5 = null;
				try {
					rs_tJDBCInput_5 = stmt_tJDBCInput_5
							.executeQuery(dbquery_tJDBCInput_5);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_5 = rs_tJDBCInput_5
							.getMetaData();
					int colQtyInRs_tJDBCInput_5 = rsmd_tJDBCInput_5
							.getColumnCount();

					String tmpContent_tJDBCInput_5 = null;
					int column_index_tJDBCInput_5 = 1;

					while (rs_tJDBCInput_5.next()) {
						nb_line_tJDBCInput_5++;

						column_index_tJDBCInput_5 = 1;

						if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
							row2.history_id = 0;
						} else {

							if (rs_tJDBCInput_5
									.getObject(column_index_tJDBCInput_5) != null) {
								row2.history_id = rs_tJDBCInput_5
										.getLong(column_index_tJDBCInput_5);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_5 begin ] stop
						 */
						/**
						 * [tJDBCInput_5 main ] start
						 */

						currentComponent = "tJDBCInput_5";

						tos_count_tJDBCInput_5++;

						/**
						 * [tJDBCInput_5 main ] stop
						 */

						/**
						 * [tJDBCOutput_5 main ] start
						 */

						currentComponent = "tJDBCOutput_5";

						whetherReject_tJDBCOutput_5 = false;
						pstmt_tJDBCOutput_5.setLong(1, row2.history_id);

						try {
							deletedCount_tJDBCOutput_5 = deletedCount_tJDBCOutput_5
									+ pstmt_tJDBCOutput_5.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_5 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_5++;

						tos_count_tJDBCOutput_5++;

						/**
						 * [tJDBCOutput_5 main ] stop
						 */

						/**
						 * [tJDBCInput_5 end ] start
						 */

						currentComponent = "tJDBCInput_5";

					}
				} finally {
					rs_tJDBCInput_5.close();
					stmt_tJDBCInput_5.close();

				}
				globalMap.put("tJDBCInput_5_NB_LINE", nb_line_tJDBCInput_5);

				ok_Hash.put("tJDBCInput_5", true);
				end_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				/**
				 * [tJDBCInput_5 end ] stop
				 */

				/**
				 * [tJDBCOutput_5 end ] start
				 */

				currentComponent = "tJDBCOutput_5";

				if (pstmt_tJDBCOutput_5 != null) {

					pstmt_tJDBCOutput_5.close();

				}

				nb_line_deleted_tJDBCOutput_5 = nb_line_deleted_tJDBCOutput_5
						+ deletedCount_tJDBCOutput_5;
				nb_line_update_tJDBCOutput_5 = nb_line_update_tJDBCOutput_5
						+ updatedCount_tJDBCOutput_5;
				nb_line_inserted_tJDBCOutput_5 = nb_line_inserted_tJDBCOutput_5
						+ insertedCount_tJDBCOutput_5;
				nb_line_rejected_tJDBCOutput_5 = nb_line_rejected_tJDBCOutput_5
						+ rejectedCount_tJDBCOutput_5;

				globalMap.put("tJDBCOutput_5_NB_LINE", nb_line_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_5);

				ok_Hash.put("tJDBCOutput_5", true);
				end_Hash.put("tJDBCOutput_5", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_5 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_5 finally ] start
				 */

				currentComponent = "tJDBCInput_5";

				/**
				 * [tJDBCInput_5 finally ] stop
				 */

				/**
				 * [tJDBCOutput_5 finally ] start
				 */

				currentComponent = "tJDBCOutput_5";

				/**
				 * [tJDBCOutput_5 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 1);
	}

	public static class row6Struct implements
			routines.system.IPersistableRow<row6Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row6Struct other = (row6Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row6Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row6Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row6Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_6Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_6_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row6Struct row6 = new row6Struct();

				/**
				 * [tJDBCOutput_6 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_6", false);
				start_Hash.put("tJDBCOutput_6", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_6";

				int tos_count_tJDBCOutput_6 = 0;

				int deleteKeyCount_tJDBCOutput_6 = 1;
				if (deleteKeyCount_tJDBCOutput_6 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_6 = 0;
				int nb_line_update_tJDBCOutput_6 = 0;
				int nb_line_inserted_tJDBCOutput_6 = 0;
				int nb_line_deleted_tJDBCOutput_6 = 0;
				int nb_line_rejected_tJDBCOutput_6 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_6 = 0;

				int deletedCount_tJDBCOutput_6 = 0;
				int updatedCount_tJDBCOutput_6 = 0;
				int insertedCount_tJDBCOutput_6 = 0;
				int rejectedCount_tJDBCOutput_6 = 0;

				boolean whetherReject_tJDBCOutput_6 = false;

				java.sql.Connection connection_tJDBCOutput_6 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_6 = 10000;
				int batchSizeCounter_tJDBCOutput_6 = 0;

				String delete_tJDBCOutput_6 = "DELETE  FROM "
						+ "datacenter_hourly_history" + " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_6 = connection_tJDBCOutput_6
						.prepareStatement(delete_tJDBCOutput_6);

				/**
				 * [tJDBCOutput_6 begin ] stop
				 */

				/**
				 * [tJDBCInput_6 begin ] start
				 */

				ok_Hash.put("tJDBCInput_6", false);
				start_Hash.put("tJDBCInput_6", System.currentTimeMillis());

				currentComponent = "tJDBCInput_6";

				int tos_count_tJDBCInput_6 = 0;

				int nb_line_tJDBCInput_6 = 0;
				java.sql.Connection conn_tJDBCInput_6 = null;
				conn_tJDBCInput_6 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_6 = conn_tJDBCInput_6
						.createStatement();

				String dbquery_tJDBCInput_6 = "SELECT history_id  FROM datacenter_hourly_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepHourly * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_6_QUERY", dbquery_tJDBCInput_6);
				java.sql.ResultSet rs_tJDBCInput_6 = null;
				try {
					rs_tJDBCInput_6 = stmt_tJDBCInput_6
							.executeQuery(dbquery_tJDBCInput_6);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_6 = rs_tJDBCInput_6
							.getMetaData();
					int colQtyInRs_tJDBCInput_6 = rsmd_tJDBCInput_6
							.getColumnCount();

					String tmpContent_tJDBCInput_6 = null;
					int column_index_tJDBCInput_6 = 1;

					while (rs_tJDBCInput_6.next()) {
						nb_line_tJDBCInput_6++;

						column_index_tJDBCInput_6 = 1;

						if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
							row6.history_id = 0;
						} else {

							if (rs_tJDBCInput_6
									.getObject(column_index_tJDBCInput_6) != null) {
								row6.history_id = rs_tJDBCInput_6
										.getLong(column_index_tJDBCInput_6);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_6 begin ] stop
						 */
						/**
						 * [tJDBCInput_6 main ] start
						 */

						currentComponent = "tJDBCInput_6";

						tos_count_tJDBCInput_6++;

						/**
						 * [tJDBCInput_6 main ] stop
						 */

						/**
						 * [tJDBCOutput_6 main ] start
						 */

						currentComponent = "tJDBCOutput_6";

						whetherReject_tJDBCOutput_6 = false;
						pstmt_tJDBCOutput_6.setLong(1, row6.history_id);

						try {
							deletedCount_tJDBCOutput_6 = deletedCount_tJDBCOutput_6
									+ pstmt_tJDBCOutput_6.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_6 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_6++;

						tos_count_tJDBCOutput_6++;

						/**
						 * [tJDBCOutput_6 main ] stop
						 */

						/**
						 * [tJDBCInput_6 end ] start
						 */

						currentComponent = "tJDBCInput_6";

					}
				} finally {
					rs_tJDBCInput_6.close();
					stmt_tJDBCInput_6.close();

				}
				globalMap.put("tJDBCInput_6_NB_LINE", nb_line_tJDBCInput_6);

				ok_Hash.put("tJDBCInput_6", true);
				end_Hash.put("tJDBCInput_6", System.currentTimeMillis());

				/**
				 * [tJDBCInput_6 end ] stop
				 */

				/**
				 * [tJDBCOutput_6 end ] start
				 */

				currentComponent = "tJDBCOutput_6";

				if (pstmt_tJDBCOutput_6 != null) {

					pstmt_tJDBCOutput_6.close();

				}

				nb_line_deleted_tJDBCOutput_6 = nb_line_deleted_tJDBCOutput_6
						+ deletedCount_tJDBCOutput_6;
				nb_line_update_tJDBCOutput_6 = nb_line_update_tJDBCOutput_6
						+ updatedCount_tJDBCOutput_6;
				nb_line_inserted_tJDBCOutput_6 = nb_line_inserted_tJDBCOutput_6
						+ insertedCount_tJDBCOutput_6;
				nb_line_rejected_tJDBCOutput_6 = nb_line_rejected_tJDBCOutput_6
						+ rejectedCount_tJDBCOutput_6;

				globalMap.put("tJDBCOutput_6_NB_LINE", nb_line_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_6);

				ok_Hash.put("tJDBCOutput_6", true);
				end_Hash.put("tJDBCOutput_6", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_6 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_6 finally ] start
				 */

				currentComponent = "tJDBCInput_6";

				/**
				 * [tJDBCInput_6 finally ] stop
				 */

				/**
				 * [tJDBCOutput_6 finally ] start
				 */

				currentComponent = "tJDBCOutput_6";

				/**
				 * [tJDBCOutput_6 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_6_SUBPROCESS_STATE", 1);
	}

	public static class row8Struct implements
			routines.system.IPersistableRow<row8Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row8Struct other = (row8Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row8Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row8Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row8Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_7Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_7_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row8Struct row8 = new row8Struct();

				/**
				 * [tJDBCOutput_7 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_7", false);
				start_Hash.put("tJDBCOutput_7", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_7";

				int tos_count_tJDBCOutput_7 = 0;

				int deleteKeyCount_tJDBCOutput_7 = 1;
				if (deleteKeyCount_tJDBCOutput_7 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_7 = 0;
				int nb_line_update_tJDBCOutput_7 = 0;
				int nb_line_inserted_tJDBCOutput_7 = 0;
				int nb_line_deleted_tJDBCOutput_7 = 0;
				int nb_line_rejected_tJDBCOutput_7 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_7 = 0;

				int deletedCount_tJDBCOutput_7 = 0;
				int updatedCount_tJDBCOutput_7 = 0;
				int insertedCount_tJDBCOutput_7 = 0;
				int rejectedCount_tJDBCOutput_7 = 0;

				boolean whetherReject_tJDBCOutput_7 = false;

				java.sql.Connection connection_tJDBCOutput_7 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_7 = 10000;
				int batchSizeCounter_tJDBCOutput_7 = 0;

				String delete_tJDBCOutput_7 = "DELETE  FROM "
						+ "host_hourly_history" + " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_7 = connection_tJDBCOutput_7
						.prepareStatement(delete_tJDBCOutput_7);

				/**
				 * [tJDBCOutput_7 begin ] stop
				 */

				/**
				 * [tJDBCInput_7 begin ] start
				 */

				ok_Hash.put("tJDBCInput_7", false);
				start_Hash.put("tJDBCInput_7", System.currentTimeMillis());

				currentComponent = "tJDBCInput_7";

				int tos_count_tJDBCInput_7 = 0;

				int nb_line_tJDBCInput_7 = 0;
				java.sql.Connection conn_tJDBCInput_7 = null;
				conn_tJDBCInput_7 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_7 = conn_tJDBCInput_7
						.createStatement();

				String dbquery_tJDBCInput_7 = "SELECT history_id  FROM host_hourly_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepHourly * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_7_QUERY", dbquery_tJDBCInput_7);
				java.sql.ResultSet rs_tJDBCInput_7 = null;
				try {
					rs_tJDBCInput_7 = stmt_tJDBCInput_7
							.executeQuery(dbquery_tJDBCInput_7);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_7 = rs_tJDBCInput_7
							.getMetaData();
					int colQtyInRs_tJDBCInput_7 = rsmd_tJDBCInput_7
							.getColumnCount();

					String tmpContent_tJDBCInput_7 = null;
					int column_index_tJDBCInput_7 = 1;

					while (rs_tJDBCInput_7.next()) {
						nb_line_tJDBCInput_7++;

						column_index_tJDBCInput_7 = 1;

						if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
							row8.history_id = 0;
						} else {

							if (rs_tJDBCInput_7
									.getObject(column_index_tJDBCInput_7) != null) {
								row8.history_id = rs_tJDBCInput_7
										.getLong(column_index_tJDBCInput_7);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_7 begin ] stop
						 */
						/**
						 * [tJDBCInput_7 main ] start
						 */

						currentComponent = "tJDBCInput_7";

						tos_count_tJDBCInput_7++;

						/**
						 * [tJDBCInput_7 main ] stop
						 */

						/**
						 * [tJDBCOutput_7 main ] start
						 */

						currentComponent = "tJDBCOutput_7";

						whetherReject_tJDBCOutput_7 = false;
						pstmt_tJDBCOutput_7.setLong(1, row8.history_id);

						try {
							deletedCount_tJDBCOutput_7 = deletedCount_tJDBCOutput_7
									+ pstmt_tJDBCOutput_7.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_7 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_7++;

						tos_count_tJDBCOutput_7++;

						/**
						 * [tJDBCOutput_7 main ] stop
						 */

						/**
						 * [tJDBCInput_7 end ] start
						 */

						currentComponent = "tJDBCInput_7";

					}
				} finally {
					rs_tJDBCInput_7.close();
					stmt_tJDBCInput_7.close();

				}
				globalMap.put("tJDBCInput_7_NB_LINE", nb_line_tJDBCInput_7);

				ok_Hash.put("tJDBCInput_7", true);
				end_Hash.put("tJDBCInput_7", System.currentTimeMillis());

				/**
				 * [tJDBCInput_7 end ] stop
				 */

				/**
				 * [tJDBCOutput_7 end ] start
				 */

				currentComponent = "tJDBCOutput_7";

				if (pstmt_tJDBCOutput_7 != null) {

					pstmt_tJDBCOutput_7.close();

				}

				nb_line_deleted_tJDBCOutput_7 = nb_line_deleted_tJDBCOutput_7
						+ deletedCount_tJDBCOutput_7;
				nb_line_update_tJDBCOutput_7 = nb_line_update_tJDBCOutput_7
						+ updatedCount_tJDBCOutput_7;
				nb_line_inserted_tJDBCOutput_7 = nb_line_inserted_tJDBCOutput_7
						+ insertedCount_tJDBCOutput_7;
				nb_line_rejected_tJDBCOutput_7 = nb_line_rejected_tJDBCOutput_7
						+ rejectedCount_tJDBCOutput_7;

				globalMap.put("tJDBCOutput_7_NB_LINE", nb_line_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_7);
				globalMap.put("tJDBCOutput_7_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_7);

				ok_Hash.put("tJDBCOutput_7", true);
				end_Hash.put("tJDBCOutput_7", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_7 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_7 finally ] start
				 */

				currentComponent = "tJDBCInput_7";

				/**
				 * [tJDBCInput_7 finally ] stop
				 */

				/**
				 * [tJDBCOutput_7 finally ] start
				 */

				currentComponent = "tJDBCOutput_7";

				/**
				 * [tJDBCOutput_7 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_7_SUBPROCESS_STATE", 1);
	}

	public static class row9Struct implements
			routines.system.IPersistableRow<row9Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row9Struct other = (row9Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row9Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row9Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row9Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_8Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_8_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row9Struct row9 = new row9Struct();

				/**
				 * [tJDBCOutput_8 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_8", false);
				start_Hash.put("tJDBCOutput_8", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_8";

				int tos_count_tJDBCOutput_8 = 0;

				int deleteKeyCount_tJDBCOutput_8 = 1;
				if (deleteKeyCount_tJDBCOutput_8 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_8 = 0;
				int nb_line_update_tJDBCOutput_8 = 0;
				int nb_line_inserted_tJDBCOutput_8 = 0;
				int nb_line_deleted_tJDBCOutput_8 = 0;
				int nb_line_rejected_tJDBCOutput_8 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_8 = 0;

				int deletedCount_tJDBCOutput_8 = 0;
				int updatedCount_tJDBCOutput_8 = 0;
				int insertedCount_tJDBCOutput_8 = 0;
				int rejectedCount_tJDBCOutput_8 = 0;

				boolean whetherReject_tJDBCOutput_8 = false;

				java.sql.Connection connection_tJDBCOutput_8 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_8 = 10000;
				int batchSizeCounter_tJDBCOutput_8 = 0;

				String delete_tJDBCOutput_8 = "DELETE  FROM "
						+ "host_interface_hourly_history"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_8 = connection_tJDBCOutput_8
						.prepareStatement(delete_tJDBCOutput_8);

				/**
				 * [tJDBCOutput_8 begin ] stop
				 */

				/**
				 * [tJDBCInput_8 begin ] start
				 */

				ok_Hash.put("tJDBCInput_8", false);
				start_Hash.put("tJDBCInput_8", System.currentTimeMillis());

				currentComponent = "tJDBCInput_8";

				int tos_count_tJDBCInput_8 = 0;

				int nb_line_tJDBCInput_8 = 0;
				java.sql.Connection conn_tJDBCInput_8 = null;
				conn_tJDBCInput_8 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_8 = conn_tJDBCInput_8
						.createStatement();

				String dbquery_tJDBCInput_8 = "SELECT history_id  FROM host_interface_hourly_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepHourly * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_8_QUERY", dbquery_tJDBCInput_8);
				java.sql.ResultSet rs_tJDBCInput_8 = null;
				try {
					rs_tJDBCInput_8 = stmt_tJDBCInput_8
							.executeQuery(dbquery_tJDBCInput_8);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_8 = rs_tJDBCInput_8
							.getMetaData();
					int colQtyInRs_tJDBCInput_8 = rsmd_tJDBCInput_8
							.getColumnCount();

					String tmpContent_tJDBCInput_8 = null;
					int column_index_tJDBCInput_8 = 1;

					while (rs_tJDBCInput_8.next()) {
						nb_line_tJDBCInput_8++;

						column_index_tJDBCInput_8 = 1;

						if (colQtyInRs_tJDBCInput_8 < column_index_tJDBCInput_8) {
							row9.history_id = 0;
						} else {

							if (rs_tJDBCInput_8
									.getObject(column_index_tJDBCInput_8) != null) {
								row9.history_id = rs_tJDBCInput_8
										.getLong(column_index_tJDBCInput_8);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_8 begin ] stop
						 */
						/**
						 * [tJDBCInput_8 main ] start
						 */

						currentComponent = "tJDBCInput_8";

						tos_count_tJDBCInput_8++;

						/**
						 * [tJDBCInput_8 main ] stop
						 */

						/**
						 * [tJDBCOutput_8 main ] start
						 */

						currentComponent = "tJDBCOutput_8";

						whetherReject_tJDBCOutput_8 = false;
						pstmt_tJDBCOutput_8.setLong(1, row9.history_id);

						try {
							deletedCount_tJDBCOutput_8 = deletedCount_tJDBCOutput_8
									+ pstmt_tJDBCOutput_8.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_8 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_8++;

						tos_count_tJDBCOutput_8++;

						/**
						 * [tJDBCOutput_8 main ] stop
						 */

						/**
						 * [tJDBCInput_8 end ] start
						 */

						currentComponent = "tJDBCInput_8";

					}
				} finally {
					rs_tJDBCInput_8.close();
					stmt_tJDBCInput_8.close();

				}
				globalMap.put("tJDBCInput_8_NB_LINE", nb_line_tJDBCInput_8);

				ok_Hash.put("tJDBCInput_8", true);
				end_Hash.put("tJDBCInput_8", System.currentTimeMillis());

				/**
				 * [tJDBCInput_8 end ] stop
				 */

				/**
				 * [tJDBCOutput_8 end ] start
				 */

				currentComponent = "tJDBCOutput_8";

				if (pstmt_tJDBCOutput_8 != null) {

					pstmt_tJDBCOutput_8.close();

				}

				nb_line_deleted_tJDBCOutput_8 = nb_line_deleted_tJDBCOutput_8
						+ deletedCount_tJDBCOutput_8;
				nb_line_update_tJDBCOutput_8 = nb_line_update_tJDBCOutput_8
						+ updatedCount_tJDBCOutput_8;
				nb_line_inserted_tJDBCOutput_8 = nb_line_inserted_tJDBCOutput_8
						+ insertedCount_tJDBCOutput_8;
				nb_line_rejected_tJDBCOutput_8 = nb_line_rejected_tJDBCOutput_8
						+ rejectedCount_tJDBCOutput_8;

				globalMap.put("tJDBCOutput_8_NB_LINE", nb_line_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_8);
				globalMap.put("tJDBCOutput_8_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_8);

				ok_Hash.put("tJDBCOutput_8", true);
				end_Hash.put("tJDBCOutput_8", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_8 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_8 finally ] start
				 */

				currentComponent = "tJDBCInput_8";

				/**
				 * [tJDBCInput_8 finally ] stop
				 */

				/**
				 * [tJDBCOutput_8 finally ] start
				 */

				currentComponent = "tJDBCOutput_8";

				/**
				 * [tJDBCOutput_8 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_8_SUBPROCESS_STATE", 1);
	}

	public static class row10Struct implements
			routines.system.IPersistableRow<row10Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row10Struct other = (row10Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row10Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row10Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row10Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_9Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_9_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row10Struct row10 = new row10Struct();

				/**
				 * [tJDBCOutput_9 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_9", false);
				start_Hash.put("tJDBCOutput_9", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_9";

				int tos_count_tJDBCOutput_9 = 0;

				int deleteKeyCount_tJDBCOutput_9 = 1;
				if (deleteKeyCount_tJDBCOutput_9 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_9 = 0;
				int nb_line_update_tJDBCOutput_9 = 0;
				int nb_line_inserted_tJDBCOutput_9 = 0;
				int nb_line_deleted_tJDBCOutput_9 = 0;
				int nb_line_rejected_tJDBCOutput_9 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_9 = 0;

				int deletedCount_tJDBCOutput_9 = 0;
				int updatedCount_tJDBCOutput_9 = 0;
				int insertedCount_tJDBCOutput_9 = 0;
				int rejectedCount_tJDBCOutput_9 = 0;

				boolean whetherReject_tJDBCOutput_9 = false;

				java.sql.Connection connection_tJDBCOutput_9 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_9 = 10000;
				int batchSizeCounter_tJDBCOutput_9 = 0;

				String delete_tJDBCOutput_9 = "DELETE  FROM "
						+ "vm_hourly_history" + " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_9 = connection_tJDBCOutput_9
						.prepareStatement(delete_tJDBCOutput_9);

				/**
				 * [tJDBCOutput_9 begin ] stop
				 */

				/**
				 * [tJDBCInput_9 begin ] start
				 */

				ok_Hash.put("tJDBCInput_9", false);
				start_Hash.put("tJDBCInput_9", System.currentTimeMillis());

				currentComponent = "tJDBCInput_9";

				int tos_count_tJDBCInput_9 = 0;

				int nb_line_tJDBCInput_9 = 0;
				java.sql.Connection conn_tJDBCInput_9 = null;
				conn_tJDBCInput_9 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_9 = conn_tJDBCInput_9
						.createStatement();

				String dbquery_tJDBCInput_9 = "SELECT history_id  FROM vm_hourly_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepHourly * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_9_QUERY", dbquery_tJDBCInput_9);
				java.sql.ResultSet rs_tJDBCInput_9 = null;
				try {
					rs_tJDBCInput_9 = stmt_tJDBCInput_9
							.executeQuery(dbquery_tJDBCInput_9);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_9 = rs_tJDBCInput_9
							.getMetaData();
					int colQtyInRs_tJDBCInput_9 = rsmd_tJDBCInput_9
							.getColumnCount();

					String tmpContent_tJDBCInput_9 = null;
					int column_index_tJDBCInput_9 = 1;

					while (rs_tJDBCInput_9.next()) {
						nb_line_tJDBCInput_9++;

						column_index_tJDBCInput_9 = 1;

						if (colQtyInRs_tJDBCInput_9 < column_index_tJDBCInput_9) {
							row10.history_id = 0;
						} else {

							if (rs_tJDBCInput_9
									.getObject(column_index_tJDBCInput_9) != null) {
								row10.history_id = rs_tJDBCInput_9
										.getLong(column_index_tJDBCInput_9);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_9 begin ] stop
						 */
						/**
						 * [tJDBCInput_9 main ] start
						 */

						currentComponent = "tJDBCInput_9";

						tos_count_tJDBCInput_9++;

						/**
						 * [tJDBCInput_9 main ] stop
						 */

						/**
						 * [tJDBCOutput_9 main ] start
						 */

						currentComponent = "tJDBCOutput_9";

						whetherReject_tJDBCOutput_9 = false;
						pstmt_tJDBCOutput_9.setLong(1, row10.history_id);

						try {
							deletedCount_tJDBCOutput_9 = deletedCount_tJDBCOutput_9
									+ pstmt_tJDBCOutput_9.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_9 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_9++;

						tos_count_tJDBCOutput_9++;

						/**
						 * [tJDBCOutput_9 main ] stop
						 */

						/**
						 * [tJDBCInput_9 end ] start
						 */

						currentComponent = "tJDBCInput_9";

					}
				} finally {
					rs_tJDBCInput_9.close();
					stmt_tJDBCInput_9.close();

				}
				globalMap.put("tJDBCInput_9_NB_LINE", nb_line_tJDBCInput_9);

				ok_Hash.put("tJDBCInput_9", true);
				end_Hash.put("tJDBCInput_9", System.currentTimeMillis());

				/**
				 * [tJDBCInput_9 end ] stop
				 */

				/**
				 * [tJDBCOutput_9 end ] start
				 */

				currentComponent = "tJDBCOutput_9";

				if (pstmt_tJDBCOutput_9 != null) {

					pstmt_tJDBCOutput_9.close();

				}

				nb_line_deleted_tJDBCOutput_9 = nb_line_deleted_tJDBCOutput_9
						+ deletedCount_tJDBCOutput_9;
				nb_line_update_tJDBCOutput_9 = nb_line_update_tJDBCOutput_9
						+ updatedCount_tJDBCOutput_9;
				nb_line_inserted_tJDBCOutput_9 = nb_line_inserted_tJDBCOutput_9
						+ insertedCount_tJDBCOutput_9;
				nb_line_rejected_tJDBCOutput_9 = nb_line_rejected_tJDBCOutput_9
						+ rejectedCount_tJDBCOutput_9;

				globalMap.put("tJDBCOutput_9_NB_LINE", nb_line_tJDBCOutput_9);
				globalMap.put("tJDBCOutput_9_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_9);
				globalMap.put("tJDBCOutput_9_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_9);
				globalMap.put("tJDBCOutput_9_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_9);
				globalMap.put("tJDBCOutput_9_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_9);

				ok_Hash.put("tJDBCOutput_9", true);
				end_Hash.put("tJDBCOutput_9", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_9 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_9 finally ] start
				 */

				currentComponent = "tJDBCInput_9";

				/**
				 * [tJDBCInput_9 finally ] stop
				 */

				/**
				 * [tJDBCOutput_9 finally ] start
				 */

				currentComponent = "tJDBCOutput_9";

				/**
				 * [tJDBCOutput_9 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_9_SUBPROCESS_STATE", 1);
	}

	public static class row12Struct implements
			routines.system.IPersistableRow<row12Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row12Struct other = (row12Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row12Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row12Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row12Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_10Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_10_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row12Struct row12 = new row12Struct();

				/**
				 * [tJDBCOutput_10 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_10", false);
				start_Hash.put("tJDBCOutput_10", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_10";

				int tos_count_tJDBCOutput_10 = 0;

				int deleteKeyCount_tJDBCOutput_10 = 1;
				if (deleteKeyCount_tJDBCOutput_10 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_10 = 0;
				int nb_line_update_tJDBCOutput_10 = 0;
				int nb_line_inserted_tJDBCOutput_10 = 0;
				int nb_line_deleted_tJDBCOutput_10 = 0;
				int nb_line_rejected_tJDBCOutput_10 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_10 = 0;

				int deletedCount_tJDBCOutput_10 = 0;
				int updatedCount_tJDBCOutput_10 = 0;
				int insertedCount_tJDBCOutput_10 = 0;
				int rejectedCount_tJDBCOutput_10 = 0;

				boolean whetherReject_tJDBCOutput_10 = false;

				java.sql.Connection connection_tJDBCOutput_10 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_10 = 10000;
				int batchSizeCounter_tJDBCOutput_10 = 0;

				String delete_tJDBCOutput_10 = "DELETE  FROM "
						+ "vm_interface_hourly_history"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_10 = connection_tJDBCOutput_10
						.prepareStatement(delete_tJDBCOutput_10);

				/**
				 * [tJDBCOutput_10 begin ] stop
				 */

				/**
				 * [tJDBCInput_10 begin ] start
				 */

				ok_Hash.put("tJDBCInput_10", false);
				start_Hash.put("tJDBCInput_10", System.currentTimeMillis());

				currentComponent = "tJDBCInput_10";

				int tos_count_tJDBCInput_10 = 0;

				int nb_line_tJDBCInput_10 = 0;
				java.sql.Connection conn_tJDBCInput_10 = null;
				conn_tJDBCInput_10 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_10 = conn_tJDBCInput_10
						.createStatement();

				String dbquery_tJDBCInput_10 = "SELECT history_id  FROM vm_interface_hourly_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepHourly * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_10_QUERY", dbquery_tJDBCInput_10);
				java.sql.ResultSet rs_tJDBCInput_10 = null;
				try {
					rs_tJDBCInput_10 = stmt_tJDBCInput_10
							.executeQuery(dbquery_tJDBCInput_10);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_10 = rs_tJDBCInput_10
							.getMetaData();
					int colQtyInRs_tJDBCInput_10 = rsmd_tJDBCInput_10
							.getColumnCount();

					String tmpContent_tJDBCInput_10 = null;
					int column_index_tJDBCInput_10 = 1;

					while (rs_tJDBCInput_10.next()) {
						nb_line_tJDBCInput_10++;

						column_index_tJDBCInput_10 = 1;

						if (colQtyInRs_tJDBCInput_10 < column_index_tJDBCInput_10) {
							row12.history_id = 0;
						} else {

							if (rs_tJDBCInput_10
									.getObject(column_index_tJDBCInput_10) != null) {
								row12.history_id = rs_tJDBCInput_10
										.getLong(column_index_tJDBCInput_10);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_10 begin ] stop
						 */
						/**
						 * [tJDBCInput_10 main ] start
						 */

						currentComponent = "tJDBCInput_10";

						tos_count_tJDBCInput_10++;

						/**
						 * [tJDBCInput_10 main ] stop
						 */

						/**
						 * [tJDBCOutput_10 main ] start
						 */

						currentComponent = "tJDBCOutput_10";

						whetherReject_tJDBCOutput_10 = false;
						pstmt_tJDBCOutput_10.setLong(1, row12.history_id);

						try {
							deletedCount_tJDBCOutput_10 = deletedCount_tJDBCOutput_10
									+ pstmt_tJDBCOutput_10.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_10 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_10++;

						tos_count_tJDBCOutput_10++;

						/**
						 * [tJDBCOutput_10 main ] stop
						 */

						/**
						 * [tJDBCInput_10 end ] start
						 */

						currentComponent = "tJDBCInput_10";

					}
				} finally {
					rs_tJDBCInput_10.close();
					stmt_tJDBCInput_10.close();

				}
				globalMap.put("tJDBCInput_10_NB_LINE", nb_line_tJDBCInput_10);

				ok_Hash.put("tJDBCInput_10", true);
				end_Hash.put("tJDBCInput_10", System.currentTimeMillis());

				/**
				 * [tJDBCInput_10 end ] stop
				 */

				/**
				 * [tJDBCOutput_10 end ] start
				 */

				currentComponent = "tJDBCOutput_10";

				if (pstmt_tJDBCOutput_10 != null) {

					pstmt_tJDBCOutput_10.close();

				}

				nb_line_deleted_tJDBCOutput_10 = nb_line_deleted_tJDBCOutput_10
						+ deletedCount_tJDBCOutput_10;
				nb_line_update_tJDBCOutput_10 = nb_line_update_tJDBCOutput_10
						+ updatedCount_tJDBCOutput_10;
				nb_line_inserted_tJDBCOutput_10 = nb_line_inserted_tJDBCOutput_10
						+ insertedCount_tJDBCOutput_10;
				nb_line_rejected_tJDBCOutput_10 = nb_line_rejected_tJDBCOutput_10
						+ rejectedCount_tJDBCOutput_10;

				globalMap.put("tJDBCOutput_10_NB_LINE", nb_line_tJDBCOutput_10);
				globalMap.put("tJDBCOutput_10_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_10);
				globalMap.put("tJDBCOutput_10_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_10);
				globalMap.put("tJDBCOutput_10_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_10);
				globalMap.put("tJDBCOutput_10_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_10);

				ok_Hash.put("tJDBCOutput_10", true);
				end_Hash.put("tJDBCOutput_10", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_10 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_10 finally ] start
				 */

				currentComponent = "tJDBCInput_10";

				/**
				 * [tJDBCInput_10 finally ] stop
				 */

				/**
				 * [tJDBCOutput_10 finally ] start
				 */

				currentComponent = "tJDBCOutput_10";

				/**
				 * [tJDBCOutput_10 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_10_SUBPROCESS_STATE", 1);
	}

	public static class row11Struct implements
			routines.system.IPersistableRow<row11Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row11Struct other = (row11Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row11Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row11Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row11Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_11Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_11_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row11Struct row11 = new row11Struct();

				/**
				 * [tJDBCOutput_11 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_11", false);
				start_Hash.put("tJDBCOutput_11", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_11";

				int tos_count_tJDBCOutput_11 = 0;

				int deleteKeyCount_tJDBCOutput_11 = 1;
				if (deleteKeyCount_tJDBCOutput_11 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_11 = 0;
				int nb_line_update_tJDBCOutput_11 = 0;
				int nb_line_inserted_tJDBCOutput_11 = 0;
				int nb_line_deleted_tJDBCOutput_11 = 0;
				int nb_line_rejected_tJDBCOutput_11 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_11 = 0;

				int deletedCount_tJDBCOutput_11 = 0;
				int updatedCount_tJDBCOutput_11 = 0;
				int insertedCount_tJDBCOutput_11 = 0;
				int rejectedCount_tJDBCOutput_11 = 0;

				boolean whetherReject_tJDBCOutput_11 = false;

				java.sql.Connection connection_tJDBCOutput_11 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_11 = 10000;
				int batchSizeCounter_tJDBCOutput_11 = 0;

				String delete_tJDBCOutput_11 = "DELETE  FROM "
						+ "storage_domain_samples_history"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_11 = connection_tJDBCOutput_11
						.prepareStatement(delete_tJDBCOutput_11);

				/**
				 * [tJDBCOutput_11 begin ] stop
				 */

				/**
				 * [tJDBCInput_11 begin ] start
				 */

				ok_Hash.put("tJDBCInput_11", false);
				start_Hash.put("tJDBCInput_11", System.currentTimeMillis());

				currentComponent = "tJDBCInput_11";

				int tos_count_tJDBCInput_11 = 0;

				int nb_line_tJDBCInput_11 = 0;
				java.sql.Connection conn_tJDBCInput_11 = null;
				conn_tJDBCInput_11 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_11 = conn_tJDBCInput_11
						.createStatement();

				String dbquery_tJDBCInput_11 = "SELECT history_id  FROM storage_domain_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_11_QUERY", dbquery_tJDBCInput_11);
				java.sql.ResultSet rs_tJDBCInput_11 = null;
				try {
					rs_tJDBCInput_11 = stmt_tJDBCInput_11
							.executeQuery(dbquery_tJDBCInput_11);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_11 = rs_tJDBCInput_11
							.getMetaData();
					int colQtyInRs_tJDBCInput_11 = rsmd_tJDBCInput_11
							.getColumnCount();

					String tmpContent_tJDBCInput_11 = null;
					int column_index_tJDBCInput_11 = 1;

					while (rs_tJDBCInput_11.next()) {
						nb_line_tJDBCInput_11++;

						column_index_tJDBCInput_11 = 1;

						if (colQtyInRs_tJDBCInput_11 < column_index_tJDBCInput_11) {
							row11.history_id = 0;
						} else {

							if (rs_tJDBCInput_11
									.getObject(column_index_tJDBCInput_11) != null) {
								row11.history_id = rs_tJDBCInput_11
										.getLong(column_index_tJDBCInput_11);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_11 begin ] stop
						 */
						/**
						 * [tJDBCInput_11 main ] start
						 */

						currentComponent = "tJDBCInput_11";

						tos_count_tJDBCInput_11++;

						/**
						 * [tJDBCInput_11 main ] stop
						 */

						/**
						 * [tJDBCOutput_11 main ] start
						 */

						currentComponent = "tJDBCOutput_11";

						whetherReject_tJDBCOutput_11 = false;
						pstmt_tJDBCOutput_11.setLong(1, row11.history_id);

						try {
							deletedCount_tJDBCOutput_11 = deletedCount_tJDBCOutput_11
									+ pstmt_tJDBCOutput_11.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_11 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_11++;

						tos_count_tJDBCOutput_11++;

						/**
						 * [tJDBCOutput_11 main ] stop
						 */

						/**
						 * [tJDBCInput_11 end ] start
						 */

						currentComponent = "tJDBCInput_11";

					}
				} finally {
					rs_tJDBCInput_11.close();
					stmt_tJDBCInput_11.close();

				}
				globalMap.put("tJDBCInput_11_NB_LINE", nb_line_tJDBCInput_11);

				ok_Hash.put("tJDBCInput_11", true);
				end_Hash.put("tJDBCInput_11", System.currentTimeMillis());

				/**
				 * [tJDBCInput_11 end ] stop
				 */

				/**
				 * [tJDBCOutput_11 end ] start
				 */

				currentComponent = "tJDBCOutput_11";

				if (pstmt_tJDBCOutput_11 != null) {

					pstmt_tJDBCOutput_11.close();

				}

				nb_line_deleted_tJDBCOutput_11 = nb_line_deleted_tJDBCOutput_11
						+ deletedCount_tJDBCOutput_11;
				nb_line_update_tJDBCOutput_11 = nb_line_update_tJDBCOutput_11
						+ updatedCount_tJDBCOutput_11;
				nb_line_inserted_tJDBCOutput_11 = nb_line_inserted_tJDBCOutput_11
						+ insertedCount_tJDBCOutput_11;
				nb_line_rejected_tJDBCOutput_11 = nb_line_rejected_tJDBCOutput_11
						+ rejectedCount_tJDBCOutput_11;

				globalMap.put("tJDBCOutput_11_NB_LINE", nb_line_tJDBCOutput_11);
				globalMap.put("tJDBCOutput_11_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_11);
				globalMap.put("tJDBCOutput_11_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_11);
				globalMap.put("tJDBCOutput_11_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_11);
				globalMap.put("tJDBCOutput_11_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_11);

				ok_Hash.put("tJDBCOutput_11", true);
				end_Hash.put("tJDBCOutput_11", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_11 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_11 finally ] start
				 */

				currentComponent = "tJDBCInput_11";

				/**
				 * [tJDBCInput_11 finally ] stop
				 */

				/**
				 * [tJDBCOutput_11 finally ] start
				 */

				currentComponent = "tJDBCOutput_11";

				/**
				 * [tJDBCOutput_11 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_11_SUBPROCESS_STATE", 1);
	}

	public static class row7Struct implements
			routines.system.IPersistableRow<row7Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row7Struct other = (row7Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row7Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row7Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row7Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_12Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_12_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row7Struct row7 = new row7Struct();

				/**
				 * [tJDBCOutput_12 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_12", false);
				start_Hash.put("tJDBCOutput_12", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_12";

				int tos_count_tJDBCOutput_12 = 0;

				int deleteKeyCount_tJDBCOutput_12 = 1;
				if (deleteKeyCount_tJDBCOutput_12 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_12 = 0;
				int nb_line_update_tJDBCOutput_12 = 0;
				int nb_line_inserted_tJDBCOutput_12 = 0;
				int nb_line_deleted_tJDBCOutput_12 = 0;
				int nb_line_rejected_tJDBCOutput_12 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_12 = 0;

				int deletedCount_tJDBCOutput_12 = 0;
				int updatedCount_tJDBCOutput_12 = 0;
				int insertedCount_tJDBCOutput_12 = 0;
				int rejectedCount_tJDBCOutput_12 = 0;

				boolean whetherReject_tJDBCOutput_12 = false;

				java.sql.Connection connection_tJDBCOutput_12 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_12 = 10000;
				int batchSizeCounter_tJDBCOutput_12 = 0;

				String delete_tJDBCOutput_12 = "DELETE  FROM "
						+ "storage_domain_hourly_history"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_12 = connection_tJDBCOutput_12
						.prepareStatement(delete_tJDBCOutput_12);

				/**
				 * [tJDBCOutput_12 begin ] stop
				 */

				/**
				 * [tJDBCInput_12 begin ] start
				 */

				ok_Hash.put("tJDBCInput_12", false);
				start_Hash.put("tJDBCInput_12", System.currentTimeMillis());

				currentComponent = "tJDBCInput_12";

				int tos_count_tJDBCInput_12 = 0;

				int nb_line_tJDBCInput_12 = 0;
				java.sql.Connection conn_tJDBCInput_12 = null;
				conn_tJDBCInput_12 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_12 = conn_tJDBCInput_12
						.createStatement();

				String dbquery_tJDBCInput_12 = "SELECT history_id  FROM storage_domain_hourly_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepHourly * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_12_QUERY", dbquery_tJDBCInput_12);
				java.sql.ResultSet rs_tJDBCInput_12 = null;
				try {
					rs_tJDBCInput_12 = stmt_tJDBCInput_12
							.executeQuery(dbquery_tJDBCInput_12);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_12 = rs_tJDBCInput_12
							.getMetaData();
					int colQtyInRs_tJDBCInput_12 = rsmd_tJDBCInput_12
							.getColumnCount();

					String tmpContent_tJDBCInput_12 = null;
					int column_index_tJDBCInput_12 = 1;

					while (rs_tJDBCInput_12.next()) {
						nb_line_tJDBCInput_12++;

						column_index_tJDBCInput_12 = 1;

						if (colQtyInRs_tJDBCInput_12 < column_index_tJDBCInput_12) {
							row7.history_id = 0;
						} else {

							if (rs_tJDBCInput_12
									.getObject(column_index_tJDBCInput_12) != null) {
								row7.history_id = rs_tJDBCInput_12
										.getLong(column_index_tJDBCInput_12);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_12 begin ] stop
						 */
						/**
						 * [tJDBCInput_12 main ] start
						 */

						currentComponent = "tJDBCInput_12";

						tos_count_tJDBCInput_12++;

						/**
						 * [tJDBCInput_12 main ] stop
						 */

						/**
						 * [tJDBCOutput_12 main ] start
						 */

						currentComponent = "tJDBCOutput_12";

						whetherReject_tJDBCOutput_12 = false;
						pstmt_tJDBCOutput_12.setLong(1, row7.history_id);

						try {
							deletedCount_tJDBCOutput_12 = deletedCount_tJDBCOutput_12
									+ pstmt_tJDBCOutput_12.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_12 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_12++;

						tos_count_tJDBCOutput_12++;

						/**
						 * [tJDBCOutput_12 main ] stop
						 */

						/**
						 * [tJDBCInput_12 end ] start
						 */

						currentComponent = "tJDBCInput_12";

					}
				} finally {
					rs_tJDBCInput_12.close();
					stmt_tJDBCInput_12.close();

				}
				globalMap.put("tJDBCInput_12_NB_LINE", nb_line_tJDBCInput_12);

				ok_Hash.put("tJDBCInput_12", true);
				end_Hash.put("tJDBCInput_12", System.currentTimeMillis());

				/**
				 * [tJDBCInput_12 end ] stop
				 */

				/**
				 * [tJDBCOutput_12 end ] start
				 */

				currentComponent = "tJDBCOutput_12";

				if (pstmt_tJDBCOutput_12 != null) {

					pstmt_tJDBCOutput_12.close();

				}

				nb_line_deleted_tJDBCOutput_12 = nb_line_deleted_tJDBCOutput_12
						+ deletedCount_tJDBCOutput_12;
				nb_line_update_tJDBCOutput_12 = nb_line_update_tJDBCOutput_12
						+ updatedCount_tJDBCOutput_12;
				nb_line_inserted_tJDBCOutput_12 = nb_line_inserted_tJDBCOutput_12
						+ insertedCount_tJDBCOutput_12;
				nb_line_rejected_tJDBCOutput_12 = nb_line_rejected_tJDBCOutput_12
						+ rejectedCount_tJDBCOutput_12;

				globalMap.put("tJDBCOutput_12_NB_LINE", nb_line_tJDBCOutput_12);
				globalMap.put("tJDBCOutput_12_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_12);
				globalMap.put("tJDBCOutput_12_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_12);
				globalMap.put("tJDBCOutput_12_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_12);
				globalMap.put("tJDBCOutput_12_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_12);

				ok_Hash.put("tJDBCOutput_12", true);
				end_Hash.put("tJDBCOutput_12", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_12 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_12 finally ] start
				 */

				currentComponent = "tJDBCInput_12";

				/**
				 * [tJDBCInput_12 finally ] stop
				 */

				/**
				 * [tJDBCOutput_12 finally ] start
				 */

				currentComponent = "tJDBCOutput_12";

				/**
				 * [tJDBCOutput_12 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_12_SUBPROCESS_STATE", 1);
	}

	public static class row1Struct implements
			routines.system.IPersistableRow<row1Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row1Struct other = (row1Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row1Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row1Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row1Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_13Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_13_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row1Struct row1 = new row1Struct();

				/**
				 * [tJDBCOutput_13 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_13", false);
				start_Hash.put("tJDBCOutput_13", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_13";

				int tos_count_tJDBCOutput_13 = 0;

				int deleteKeyCount_tJDBCOutput_13 = 1;
				if (deleteKeyCount_tJDBCOutput_13 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_13 = 0;
				int nb_line_update_tJDBCOutput_13 = 0;
				int nb_line_inserted_tJDBCOutput_13 = 0;
				int nb_line_deleted_tJDBCOutput_13 = 0;
				int nb_line_rejected_tJDBCOutput_13 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_13 = 0;

				int deletedCount_tJDBCOutput_13 = 0;
				int updatedCount_tJDBCOutput_13 = 0;
				int insertedCount_tJDBCOutput_13 = 0;
				int rejectedCount_tJDBCOutput_13 = 0;

				boolean whetherReject_tJDBCOutput_13 = false;

				java.sql.Connection connection_tJDBCOutput_13 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_13 = 10000;
				int batchSizeCounter_tJDBCOutput_13 = 0;

				String delete_tJDBCOutput_13 = "DELETE  FROM "
						+ "vm_disk_samples_history" + " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_13 = connection_tJDBCOutput_13
						.prepareStatement(delete_tJDBCOutput_13);

				/**
				 * [tJDBCOutput_13 begin ] stop
				 */

				/**
				 * [tJDBCInput_13 begin ] start
				 */

				ok_Hash.put("tJDBCInput_13", false);
				start_Hash.put("tJDBCInput_13", System.currentTimeMillis());

				currentComponent = "tJDBCInput_13";

				int tos_count_tJDBCInput_13 = 0;

				int nb_line_tJDBCInput_13 = 0;
				java.sql.Connection conn_tJDBCInput_13 = null;
				conn_tJDBCInput_13 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_13 = conn_tJDBCInput_13
						.createStatement();

				String dbquery_tJDBCInput_13 = "SELECT history_id  FROM vm_disk_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_13_QUERY", dbquery_tJDBCInput_13);
				java.sql.ResultSet rs_tJDBCInput_13 = null;
				try {
					rs_tJDBCInput_13 = stmt_tJDBCInput_13
							.executeQuery(dbquery_tJDBCInput_13);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_13 = rs_tJDBCInput_13
							.getMetaData();
					int colQtyInRs_tJDBCInput_13 = rsmd_tJDBCInput_13
							.getColumnCount();

					String tmpContent_tJDBCInput_13 = null;
					int column_index_tJDBCInput_13 = 1;

					while (rs_tJDBCInput_13.next()) {
						nb_line_tJDBCInput_13++;

						column_index_tJDBCInput_13 = 1;

						if (colQtyInRs_tJDBCInput_13 < column_index_tJDBCInput_13) {
							row1.history_id = 0;
						} else {

							if (rs_tJDBCInput_13
									.getObject(column_index_tJDBCInput_13) != null) {
								row1.history_id = rs_tJDBCInput_13
										.getLong(column_index_tJDBCInput_13);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_13 begin ] stop
						 */
						/**
						 * [tJDBCInput_13 main ] start
						 */

						currentComponent = "tJDBCInput_13";

						tos_count_tJDBCInput_13++;

						/**
						 * [tJDBCInput_13 main ] stop
						 */

						/**
						 * [tJDBCOutput_13 main ] start
						 */

						currentComponent = "tJDBCOutput_13";

						whetherReject_tJDBCOutput_13 = false;
						pstmt_tJDBCOutput_13.setLong(1, row1.history_id);

						try {
							deletedCount_tJDBCOutput_13 = deletedCount_tJDBCOutput_13
									+ pstmt_tJDBCOutput_13.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_13 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_13++;

						tos_count_tJDBCOutput_13++;

						/**
						 * [tJDBCOutput_13 main ] stop
						 */

						/**
						 * [tJDBCInput_13 end ] start
						 */

						currentComponent = "tJDBCInput_13";

					}
				} finally {
					rs_tJDBCInput_13.close();
					stmt_tJDBCInput_13.close();

				}
				globalMap.put("tJDBCInput_13_NB_LINE", nb_line_tJDBCInput_13);

				ok_Hash.put("tJDBCInput_13", true);
				end_Hash.put("tJDBCInput_13", System.currentTimeMillis());

				/**
				 * [tJDBCInput_13 end ] stop
				 */

				/**
				 * [tJDBCOutput_13 end ] start
				 */

				currentComponent = "tJDBCOutput_13";

				if (pstmt_tJDBCOutput_13 != null) {

					pstmt_tJDBCOutput_13.close();

				}

				nb_line_deleted_tJDBCOutput_13 = nb_line_deleted_tJDBCOutput_13
						+ deletedCount_tJDBCOutput_13;
				nb_line_update_tJDBCOutput_13 = nb_line_update_tJDBCOutput_13
						+ updatedCount_tJDBCOutput_13;
				nb_line_inserted_tJDBCOutput_13 = nb_line_inserted_tJDBCOutput_13
						+ insertedCount_tJDBCOutput_13;
				nb_line_rejected_tJDBCOutput_13 = nb_line_rejected_tJDBCOutput_13
						+ rejectedCount_tJDBCOutput_13;

				globalMap.put("tJDBCOutput_13_NB_LINE", nb_line_tJDBCOutput_13);
				globalMap.put("tJDBCOutput_13_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_13);
				globalMap.put("tJDBCOutput_13_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_13);
				globalMap.put("tJDBCOutput_13_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_13);
				globalMap.put("tJDBCOutput_13_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_13);

				ok_Hash.put("tJDBCOutput_13", true);
				end_Hash.put("tJDBCOutput_13", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_13 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_13 finally ] start
				 */

				currentComponent = "tJDBCInput_13";

				/**
				 * [tJDBCInput_13 finally ] stop
				 */

				/**
				 * [tJDBCOutput_13 finally ] start
				 */

				currentComponent = "tJDBCOutput_13";

				/**
				 * [tJDBCOutput_13 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_13_SUBPROCESS_STATE", 1);
	}

	public static class row14Struct implements
			routines.system.IPersistableRow<row14Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row14Struct other = (row14Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row14Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row14Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row14Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_14Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_14_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row14Struct row14 = new row14Struct();

				/**
				 * [tJDBCOutput_14 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_14", false);
				start_Hash.put("tJDBCOutput_14", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_14";

				int tos_count_tJDBCOutput_14 = 0;

				int deleteKeyCount_tJDBCOutput_14 = 1;
				if (deleteKeyCount_tJDBCOutput_14 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_14 = 0;
				int nb_line_update_tJDBCOutput_14 = 0;
				int nb_line_inserted_tJDBCOutput_14 = 0;
				int nb_line_deleted_tJDBCOutput_14 = 0;
				int nb_line_rejected_tJDBCOutput_14 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_14 = 0;

				int deletedCount_tJDBCOutput_14 = 0;
				int updatedCount_tJDBCOutput_14 = 0;
				int insertedCount_tJDBCOutput_14 = 0;
				int rejectedCount_tJDBCOutput_14 = 0;

				boolean whetherReject_tJDBCOutput_14 = false;

				java.sql.Connection connection_tJDBCOutput_14 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_14 = 10000;
				int batchSizeCounter_tJDBCOutput_14 = 0;

				String delete_tJDBCOutput_14 = "DELETE  FROM "
						+ "vm_disk_hourly_history" + " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_14 = connection_tJDBCOutput_14
						.prepareStatement(delete_tJDBCOutput_14);

				/**
				 * [tJDBCOutput_14 begin ] stop
				 */

				/**
				 * [tJDBCInput_14 begin ] start
				 */

				ok_Hash.put("tJDBCInput_14", false);
				start_Hash.put("tJDBCInput_14", System.currentTimeMillis());

				currentComponent = "tJDBCInput_14";

				int tos_count_tJDBCInput_14 = 0;

				int nb_line_tJDBCInput_14 = 0;
				java.sql.Connection conn_tJDBCInput_14 = null;
				conn_tJDBCInput_14 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_14 = conn_tJDBCInput_14
						.createStatement();

				String dbquery_tJDBCInput_14 = "SELECT history_id  FROM vm_disk_hourly_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepHourly * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_14_QUERY", dbquery_tJDBCInput_14);
				java.sql.ResultSet rs_tJDBCInput_14 = null;
				try {
					rs_tJDBCInput_14 = stmt_tJDBCInput_14
							.executeQuery(dbquery_tJDBCInput_14);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_14 = rs_tJDBCInput_14
							.getMetaData();
					int colQtyInRs_tJDBCInput_14 = rsmd_tJDBCInput_14
							.getColumnCount();

					String tmpContent_tJDBCInput_14 = null;
					int column_index_tJDBCInput_14 = 1;

					while (rs_tJDBCInput_14.next()) {
						nb_line_tJDBCInput_14++;

						column_index_tJDBCInput_14 = 1;

						if (colQtyInRs_tJDBCInput_14 < column_index_tJDBCInput_14) {
							row14.history_id = 0;
						} else {

							if (rs_tJDBCInput_14
									.getObject(column_index_tJDBCInput_14) != null) {
								row14.history_id = rs_tJDBCInput_14
										.getLong(column_index_tJDBCInput_14);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_14 begin ] stop
						 */
						/**
						 * [tJDBCInput_14 main ] start
						 */

						currentComponent = "tJDBCInput_14";

						tos_count_tJDBCInput_14++;

						/**
						 * [tJDBCInput_14 main ] stop
						 */

						/**
						 * [tJDBCOutput_14 main ] start
						 */

						currentComponent = "tJDBCOutput_14";

						whetherReject_tJDBCOutput_14 = false;
						pstmt_tJDBCOutput_14.setLong(1, row14.history_id);

						try {
							deletedCount_tJDBCOutput_14 = deletedCount_tJDBCOutput_14
									+ pstmt_tJDBCOutput_14.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_14 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_14++;

						tos_count_tJDBCOutput_14++;

						/**
						 * [tJDBCOutput_14 main ] stop
						 */

						/**
						 * [tJDBCInput_14 end ] start
						 */

						currentComponent = "tJDBCInput_14";

					}
				} finally {
					rs_tJDBCInput_14.close();
					stmt_tJDBCInput_14.close();

				}
				globalMap.put("tJDBCInput_14_NB_LINE", nb_line_tJDBCInput_14);

				ok_Hash.put("tJDBCInput_14", true);
				end_Hash.put("tJDBCInput_14", System.currentTimeMillis());

				/**
				 * [tJDBCInput_14 end ] stop
				 */

				/**
				 * [tJDBCOutput_14 end ] start
				 */

				currentComponent = "tJDBCOutput_14";

				if (pstmt_tJDBCOutput_14 != null) {

					pstmt_tJDBCOutput_14.close();

				}

				nb_line_deleted_tJDBCOutput_14 = nb_line_deleted_tJDBCOutput_14
						+ deletedCount_tJDBCOutput_14;
				nb_line_update_tJDBCOutput_14 = nb_line_update_tJDBCOutput_14
						+ updatedCount_tJDBCOutput_14;
				nb_line_inserted_tJDBCOutput_14 = nb_line_inserted_tJDBCOutput_14
						+ insertedCount_tJDBCOutput_14;
				nb_line_rejected_tJDBCOutput_14 = nb_line_rejected_tJDBCOutput_14
						+ rejectedCount_tJDBCOutput_14;

				globalMap.put("tJDBCOutput_14_NB_LINE", nb_line_tJDBCOutput_14);
				globalMap.put("tJDBCOutput_14_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_14);
				globalMap.put("tJDBCOutput_14_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_14);
				globalMap.put("tJDBCOutput_14_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_14);
				globalMap.put("tJDBCOutput_14_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_14);

				ok_Hash.put("tJDBCOutput_14", true);
				end_Hash.put("tJDBCOutput_14", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_14 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_14 finally ] start
				 */

				currentComponent = "tJDBCInput_14";

				/**
				 * [tJDBCInput_14 finally ] stop
				 */

				/**
				 * [tJDBCOutput_14 finally ] start
				 */

				currentComponent = "tJDBCOutput_14";

				/**
				 * [tJDBCOutput_14 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_14_SUBPROCESS_STATE", 1);
	}

	public static class row15Struct implements
			routines.system.IPersistableRow<row15Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public int history_id;

		public int getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row15Struct other = (row15Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row15Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row15Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readInt();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// int

				dos.writeInt(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row15Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_15Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_15_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row15Struct row15 = new row15Struct();

				/**
				 * [tJDBCOutput_15 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_15", false);
				start_Hash.put("tJDBCOutput_15", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_15";

				int tos_count_tJDBCOutput_15 = 0;

				int deleteKeyCount_tJDBCOutput_15 = 1;
				if (deleteKeyCount_tJDBCOutput_15 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_15 = 0;
				int nb_line_update_tJDBCOutput_15 = 0;
				int nb_line_inserted_tJDBCOutput_15 = 0;
				int nb_line_deleted_tJDBCOutput_15 = 0;
				int nb_line_rejected_tJDBCOutput_15 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_15 = 0;

				int deletedCount_tJDBCOutput_15 = 0;
				int updatedCount_tJDBCOutput_15 = 0;
				int insertedCount_tJDBCOutput_15 = 0;
				int rejectedCount_tJDBCOutput_15 = 0;

				boolean whetherReject_tJDBCOutput_15 = false;

				java.sql.Connection connection_tJDBCOutput_15 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_15 = 10000;
				int batchSizeCounter_tJDBCOutput_15 = 0;

				String delete_tJDBCOutput_15 = "DELETE  FROM "
						+ "datacenter_daily_history" + " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_15 = connection_tJDBCOutput_15
						.prepareStatement(delete_tJDBCOutput_15);

				/**
				 * [tJDBCOutput_15 begin ] stop
				 */

				/**
				 * [tJDBCInput_15 begin ] start
				 */

				ok_Hash.put("tJDBCInput_15", false);
				start_Hash.put("tJDBCInput_15", System.currentTimeMillis());

				currentComponent = "tJDBCInput_15";

				int tos_count_tJDBCInput_15 = 0;

				int nb_line_tJDBCInput_15 = 0;
				java.sql.Connection conn_tJDBCInput_15 = null;
				conn_tJDBCInput_15 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_15 = conn_tJDBCInput_15
						.createStatement();

				String dbquery_tJDBCInput_15 = "SELECT history_id  FROM datacenter_daily_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepDaily * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_15_QUERY", dbquery_tJDBCInput_15);
				java.sql.ResultSet rs_tJDBCInput_15 = null;
				try {
					rs_tJDBCInput_15 = stmt_tJDBCInput_15
							.executeQuery(dbquery_tJDBCInput_15);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_15 = rs_tJDBCInput_15
							.getMetaData();
					int colQtyInRs_tJDBCInput_15 = rsmd_tJDBCInput_15
							.getColumnCount();

					String tmpContent_tJDBCInput_15 = null;
					int column_index_tJDBCInput_15 = 1;

					while (rs_tJDBCInput_15.next()) {
						nb_line_tJDBCInput_15++;

						column_index_tJDBCInput_15 = 1;

						if (colQtyInRs_tJDBCInput_15 < column_index_tJDBCInput_15) {
							row15.history_id = 0;
						} else {

							if (rs_tJDBCInput_15
									.getObject(column_index_tJDBCInput_15) != null) {
								row15.history_id = rs_tJDBCInput_15
										.getInt(column_index_tJDBCInput_15);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_15 begin ] stop
						 */
						/**
						 * [tJDBCInput_15 main ] start
						 */

						currentComponent = "tJDBCInput_15";

						tos_count_tJDBCInput_15++;

						/**
						 * [tJDBCInput_15 main ] stop
						 */

						/**
						 * [tJDBCOutput_15 main ] start
						 */

						currentComponent = "tJDBCOutput_15";

						whetherReject_tJDBCOutput_15 = false;
						pstmt_tJDBCOutput_15.setInt(1, row15.history_id);

						try {
							deletedCount_tJDBCOutput_15 = deletedCount_tJDBCOutput_15
									+ pstmt_tJDBCOutput_15.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_15 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_15++;

						tos_count_tJDBCOutput_15++;

						/**
						 * [tJDBCOutput_15 main ] stop
						 */

						/**
						 * [tJDBCInput_15 end ] start
						 */

						currentComponent = "tJDBCInput_15";

					}
				} finally {
					rs_tJDBCInput_15.close();
					stmt_tJDBCInput_15.close();

				}
				globalMap.put("tJDBCInput_15_NB_LINE", nb_line_tJDBCInput_15);

				ok_Hash.put("tJDBCInput_15", true);
				end_Hash.put("tJDBCInput_15", System.currentTimeMillis());

				/**
				 * [tJDBCInput_15 end ] stop
				 */

				/**
				 * [tJDBCOutput_15 end ] start
				 */

				currentComponent = "tJDBCOutput_15";

				if (pstmt_tJDBCOutput_15 != null) {

					pstmt_tJDBCOutput_15.close();

				}

				nb_line_deleted_tJDBCOutput_15 = nb_line_deleted_tJDBCOutput_15
						+ deletedCount_tJDBCOutput_15;
				nb_line_update_tJDBCOutput_15 = nb_line_update_tJDBCOutput_15
						+ updatedCount_tJDBCOutput_15;
				nb_line_inserted_tJDBCOutput_15 = nb_line_inserted_tJDBCOutput_15
						+ insertedCount_tJDBCOutput_15;
				nb_line_rejected_tJDBCOutput_15 = nb_line_rejected_tJDBCOutput_15
						+ rejectedCount_tJDBCOutput_15;

				globalMap.put("tJDBCOutput_15_NB_LINE", nb_line_tJDBCOutput_15);
				globalMap.put("tJDBCOutput_15_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_15);
				globalMap.put("tJDBCOutput_15_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_15);
				globalMap.put("tJDBCOutput_15_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_15);
				globalMap.put("tJDBCOutput_15_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_15);

				ok_Hash.put("tJDBCOutput_15", true);
				end_Hash.put("tJDBCOutput_15", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_15 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_15 finally ] start
				 */

				currentComponent = "tJDBCInput_15";

				/**
				 * [tJDBCInput_15 finally ] stop
				 */

				/**
				 * [tJDBCOutput_15 finally ] start
				 */

				currentComponent = "tJDBCOutput_15";

				/**
				 * [tJDBCOutput_15 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_15_SUBPROCESS_STATE", 1);
	}

	public static class row16Struct implements
			routines.system.IPersistableRow<row16Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row16Struct other = (row16Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row16Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row16Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row16Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_16Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_16_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row16Struct row16 = new row16Struct();

				/**
				 * [tJDBCOutput_16 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_16", false);
				start_Hash.put("tJDBCOutput_16", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_16";

				int tos_count_tJDBCOutput_16 = 0;

				int deleteKeyCount_tJDBCOutput_16 = 1;
				if (deleteKeyCount_tJDBCOutput_16 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_16 = 0;
				int nb_line_update_tJDBCOutput_16 = 0;
				int nb_line_inserted_tJDBCOutput_16 = 0;
				int nb_line_deleted_tJDBCOutput_16 = 0;
				int nb_line_rejected_tJDBCOutput_16 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_16 = 0;

				int deletedCount_tJDBCOutput_16 = 0;
				int updatedCount_tJDBCOutput_16 = 0;
				int insertedCount_tJDBCOutput_16 = 0;
				int rejectedCount_tJDBCOutput_16 = 0;

				boolean whetherReject_tJDBCOutput_16 = false;

				java.sql.Connection connection_tJDBCOutput_16 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_16 = 10000;
				int batchSizeCounter_tJDBCOutput_16 = 0;

				String delete_tJDBCOutput_16 = "DELETE  FROM "
						+ "storage_domain_daily_history"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_16 = connection_tJDBCOutput_16
						.prepareStatement(delete_tJDBCOutput_16);

				/**
				 * [tJDBCOutput_16 begin ] stop
				 */

				/**
				 * [tJDBCInput_16 begin ] start
				 */

				ok_Hash.put("tJDBCInput_16", false);
				start_Hash.put("tJDBCInput_16", System.currentTimeMillis());

				currentComponent = "tJDBCInput_16";

				int tos_count_tJDBCInput_16 = 0;

				int nb_line_tJDBCInput_16 = 0;
				java.sql.Connection conn_tJDBCInput_16 = null;
				conn_tJDBCInput_16 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_16 = conn_tJDBCInput_16
						.createStatement();

				String dbquery_tJDBCInput_16 = "SELECT history_id  FROM storage_domain_daily_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepDaily * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_16_QUERY", dbquery_tJDBCInput_16);
				java.sql.ResultSet rs_tJDBCInput_16 = null;
				try {
					rs_tJDBCInput_16 = stmt_tJDBCInput_16
							.executeQuery(dbquery_tJDBCInput_16);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_16 = rs_tJDBCInput_16
							.getMetaData();
					int colQtyInRs_tJDBCInput_16 = rsmd_tJDBCInput_16
							.getColumnCount();

					String tmpContent_tJDBCInput_16 = null;
					int column_index_tJDBCInput_16 = 1;

					while (rs_tJDBCInput_16.next()) {
						nb_line_tJDBCInput_16++;

						column_index_tJDBCInput_16 = 1;

						if (colQtyInRs_tJDBCInput_16 < column_index_tJDBCInput_16) {
							row16.history_id = 0;
						} else {

							if (rs_tJDBCInput_16
									.getObject(column_index_tJDBCInput_16) != null) {
								row16.history_id = rs_tJDBCInput_16
										.getLong(column_index_tJDBCInput_16);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_16 begin ] stop
						 */
						/**
						 * [tJDBCInput_16 main ] start
						 */

						currentComponent = "tJDBCInput_16";

						tos_count_tJDBCInput_16++;

						/**
						 * [tJDBCInput_16 main ] stop
						 */

						/**
						 * [tJDBCOutput_16 main ] start
						 */

						currentComponent = "tJDBCOutput_16";

						whetherReject_tJDBCOutput_16 = false;
						pstmt_tJDBCOutput_16.setLong(1, row16.history_id);

						try {
							deletedCount_tJDBCOutput_16 = deletedCount_tJDBCOutput_16
									+ pstmt_tJDBCOutput_16.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_16 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_16++;

						tos_count_tJDBCOutput_16++;

						/**
						 * [tJDBCOutput_16 main ] stop
						 */

						/**
						 * [tJDBCInput_16 end ] start
						 */

						currentComponent = "tJDBCInput_16";

					}
				} finally {
					rs_tJDBCInput_16.close();
					stmt_tJDBCInput_16.close();

				}
				globalMap.put("tJDBCInput_16_NB_LINE", nb_line_tJDBCInput_16);

				ok_Hash.put("tJDBCInput_16", true);
				end_Hash.put("tJDBCInput_16", System.currentTimeMillis());

				/**
				 * [tJDBCInput_16 end ] stop
				 */

				/**
				 * [tJDBCOutput_16 end ] start
				 */

				currentComponent = "tJDBCOutput_16";

				if (pstmt_tJDBCOutput_16 != null) {

					pstmt_tJDBCOutput_16.close();

				}

				nb_line_deleted_tJDBCOutput_16 = nb_line_deleted_tJDBCOutput_16
						+ deletedCount_tJDBCOutput_16;
				nb_line_update_tJDBCOutput_16 = nb_line_update_tJDBCOutput_16
						+ updatedCount_tJDBCOutput_16;
				nb_line_inserted_tJDBCOutput_16 = nb_line_inserted_tJDBCOutput_16
						+ insertedCount_tJDBCOutput_16;
				nb_line_rejected_tJDBCOutput_16 = nb_line_rejected_tJDBCOutput_16
						+ rejectedCount_tJDBCOutput_16;

				globalMap.put("tJDBCOutput_16_NB_LINE", nb_line_tJDBCOutput_16);
				globalMap.put("tJDBCOutput_16_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_16);
				globalMap.put("tJDBCOutput_16_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_16);
				globalMap.put("tJDBCOutput_16_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_16);
				globalMap.put("tJDBCOutput_16_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_16);

				ok_Hash.put("tJDBCOutput_16", true);
				end_Hash.put("tJDBCOutput_16", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_16 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_16 finally ] start
				 */

				currentComponent = "tJDBCInput_16";

				/**
				 * [tJDBCInput_16 finally ] stop
				 */

				/**
				 * [tJDBCOutput_16 finally ] start
				 */

				currentComponent = "tJDBCOutput_16";

				/**
				 * [tJDBCOutput_16 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_16_SUBPROCESS_STATE", 1);
	}

	public static class row17Struct implements
			routines.system.IPersistableRow<row17Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row17Struct other = (row17Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row17Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row17Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row17Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_17Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_17_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row17Struct row17 = new row17Struct();

				/**
				 * [tJDBCOutput_17 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_17", false);
				start_Hash.put("tJDBCOutput_17", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_17";

				int tos_count_tJDBCOutput_17 = 0;

				int deleteKeyCount_tJDBCOutput_17 = 1;
				if (deleteKeyCount_tJDBCOutput_17 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_17 = 0;
				int nb_line_update_tJDBCOutput_17 = 0;
				int nb_line_inserted_tJDBCOutput_17 = 0;
				int nb_line_deleted_tJDBCOutput_17 = 0;
				int nb_line_rejected_tJDBCOutput_17 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_17 = 0;

				int deletedCount_tJDBCOutput_17 = 0;
				int updatedCount_tJDBCOutput_17 = 0;
				int insertedCount_tJDBCOutput_17 = 0;
				int rejectedCount_tJDBCOutput_17 = 0;

				boolean whetherReject_tJDBCOutput_17 = false;

				java.sql.Connection connection_tJDBCOutput_17 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_17 = 10000;
				int batchSizeCounter_tJDBCOutput_17 = 0;

				String delete_tJDBCOutput_17 = "DELETE  FROM "
						+ "host_daily_history" + " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_17 = connection_tJDBCOutput_17
						.prepareStatement(delete_tJDBCOutput_17);

				/**
				 * [tJDBCOutput_17 begin ] stop
				 */

				/**
				 * [tJDBCInput_17 begin ] start
				 */

				ok_Hash.put("tJDBCInput_17", false);
				start_Hash.put("tJDBCInput_17", System.currentTimeMillis());

				currentComponent = "tJDBCInput_17";

				int tos_count_tJDBCInput_17 = 0;

				int nb_line_tJDBCInput_17 = 0;
				java.sql.Connection conn_tJDBCInput_17 = null;
				conn_tJDBCInput_17 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_17 = conn_tJDBCInput_17
						.createStatement();

				String dbquery_tJDBCInput_17 = "SELECT history_id  FROM host_daily_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepDaily * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_17_QUERY", dbquery_tJDBCInput_17);
				java.sql.ResultSet rs_tJDBCInput_17 = null;
				try {
					rs_tJDBCInput_17 = stmt_tJDBCInput_17
							.executeQuery(dbquery_tJDBCInput_17);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_17 = rs_tJDBCInput_17
							.getMetaData();
					int colQtyInRs_tJDBCInput_17 = rsmd_tJDBCInput_17
							.getColumnCount();

					String tmpContent_tJDBCInput_17 = null;
					int column_index_tJDBCInput_17 = 1;

					while (rs_tJDBCInput_17.next()) {
						nb_line_tJDBCInput_17++;

						column_index_tJDBCInput_17 = 1;

						if (colQtyInRs_tJDBCInput_17 < column_index_tJDBCInput_17) {
							row17.history_id = 0;
						} else {

							if (rs_tJDBCInput_17
									.getObject(column_index_tJDBCInput_17) != null) {
								row17.history_id = rs_tJDBCInput_17
										.getLong(column_index_tJDBCInput_17);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_17 begin ] stop
						 */
						/**
						 * [tJDBCInput_17 main ] start
						 */

						currentComponent = "tJDBCInput_17";

						tos_count_tJDBCInput_17++;

						/**
						 * [tJDBCInput_17 main ] stop
						 */

						/**
						 * [tJDBCOutput_17 main ] start
						 */

						currentComponent = "tJDBCOutput_17";

						whetherReject_tJDBCOutput_17 = false;
						pstmt_tJDBCOutput_17.setLong(1, row17.history_id);

						try {
							deletedCount_tJDBCOutput_17 = deletedCount_tJDBCOutput_17
									+ pstmt_tJDBCOutput_17.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_17 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_17++;

						tos_count_tJDBCOutput_17++;

						/**
						 * [tJDBCOutput_17 main ] stop
						 */

						/**
						 * [tJDBCInput_17 end ] start
						 */

						currentComponent = "tJDBCInput_17";

					}
				} finally {
					rs_tJDBCInput_17.close();
					stmt_tJDBCInput_17.close();

				}
				globalMap.put("tJDBCInput_17_NB_LINE", nb_line_tJDBCInput_17);

				ok_Hash.put("tJDBCInput_17", true);
				end_Hash.put("tJDBCInput_17", System.currentTimeMillis());

				/**
				 * [tJDBCInput_17 end ] stop
				 */

				/**
				 * [tJDBCOutput_17 end ] start
				 */

				currentComponent = "tJDBCOutput_17";

				if (pstmt_tJDBCOutput_17 != null) {

					pstmt_tJDBCOutput_17.close();

				}

				nb_line_deleted_tJDBCOutput_17 = nb_line_deleted_tJDBCOutput_17
						+ deletedCount_tJDBCOutput_17;
				nb_line_update_tJDBCOutput_17 = nb_line_update_tJDBCOutput_17
						+ updatedCount_tJDBCOutput_17;
				nb_line_inserted_tJDBCOutput_17 = nb_line_inserted_tJDBCOutput_17
						+ insertedCount_tJDBCOutput_17;
				nb_line_rejected_tJDBCOutput_17 = nb_line_rejected_tJDBCOutput_17
						+ rejectedCount_tJDBCOutput_17;

				globalMap.put("tJDBCOutput_17_NB_LINE", nb_line_tJDBCOutput_17);
				globalMap.put("tJDBCOutput_17_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_17);
				globalMap.put("tJDBCOutput_17_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_17);
				globalMap.put("tJDBCOutput_17_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_17);
				globalMap.put("tJDBCOutput_17_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_17);

				ok_Hash.put("tJDBCOutput_17", true);
				end_Hash.put("tJDBCOutput_17", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_17 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_17 finally ] start
				 */

				currentComponent = "tJDBCInput_17";

				/**
				 * [tJDBCInput_17 finally ] stop
				 */

				/**
				 * [tJDBCOutput_17 finally ] start
				 */

				currentComponent = "tJDBCOutput_17";

				/**
				 * [tJDBCOutput_17 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_17_SUBPROCESS_STATE", 1);
	}

	public static class row18Struct implements
			routines.system.IPersistableRow<row18Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row18Struct other = (row18Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row18Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row18Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row18Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_18Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_18_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row18Struct row18 = new row18Struct();

				/**
				 * [tJDBCOutput_18 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_18", false);
				start_Hash.put("tJDBCOutput_18", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_18";

				int tos_count_tJDBCOutput_18 = 0;

				int deleteKeyCount_tJDBCOutput_18 = 1;
				if (deleteKeyCount_tJDBCOutput_18 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_18 = 0;
				int nb_line_update_tJDBCOutput_18 = 0;
				int nb_line_inserted_tJDBCOutput_18 = 0;
				int nb_line_deleted_tJDBCOutput_18 = 0;
				int nb_line_rejected_tJDBCOutput_18 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_18 = 0;

				int deletedCount_tJDBCOutput_18 = 0;
				int updatedCount_tJDBCOutput_18 = 0;
				int insertedCount_tJDBCOutput_18 = 0;
				int rejectedCount_tJDBCOutput_18 = 0;

				boolean whetherReject_tJDBCOutput_18 = false;

				java.sql.Connection connection_tJDBCOutput_18 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_18 = 10000;
				int batchSizeCounter_tJDBCOutput_18 = 0;

				String delete_tJDBCOutput_18 = "DELETE  FROM "
						+ "host_interface_daily_history"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_18 = connection_tJDBCOutput_18
						.prepareStatement(delete_tJDBCOutput_18);

				/**
				 * [tJDBCOutput_18 begin ] stop
				 */

				/**
				 * [tJDBCInput_18 begin ] start
				 */

				ok_Hash.put("tJDBCInput_18", false);
				start_Hash.put("tJDBCInput_18", System.currentTimeMillis());

				currentComponent = "tJDBCInput_18";

				int tos_count_tJDBCInput_18 = 0;

				int nb_line_tJDBCInput_18 = 0;
				java.sql.Connection conn_tJDBCInput_18 = null;
				conn_tJDBCInput_18 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_18 = conn_tJDBCInput_18
						.createStatement();

				String dbquery_tJDBCInput_18 = "SELECT history_id  FROM host_interface_daily_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepDaily * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_18_QUERY", dbquery_tJDBCInput_18);
				java.sql.ResultSet rs_tJDBCInput_18 = null;
				try {
					rs_tJDBCInput_18 = stmt_tJDBCInput_18
							.executeQuery(dbquery_tJDBCInput_18);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_18 = rs_tJDBCInput_18
							.getMetaData();
					int colQtyInRs_tJDBCInput_18 = rsmd_tJDBCInput_18
							.getColumnCount();

					String tmpContent_tJDBCInput_18 = null;
					int column_index_tJDBCInput_18 = 1;

					while (rs_tJDBCInput_18.next()) {
						nb_line_tJDBCInput_18++;

						column_index_tJDBCInput_18 = 1;

						if (colQtyInRs_tJDBCInput_18 < column_index_tJDBCInput_18) {
							row18.history_id = 0;
						} else {

							if (rs_tJDBCInput_18
									.getObject(column_index_tJDBCInput_18) != null) {
								row18.history_id = rs_tJDBCInput_18
										.getLong(column_index_tJDBCInput_18);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_18 begin ] stop
						 */
						/**
						 * [tJDBCInput_18 main ] start
						 */

						currentComponent = "tJDBCInput_18";

						tos_count_tJDBCInput_18++;

						/**
						 * [tJDBCInput_18 main ] stop
						 */

						/**
						 * [tJDBCOutput_18 main ] start
						 */

						currentComponent = "tJDBCOutput_18";

						whetherReject_tJDBCOutput_18 = false;
						pstmt_tJDBCOutput_18.setLong(1, row18.history_id);

						try {
							deletedCount_tJDBCOutput_18 = deletedCount_tJDBCOutput_18
									+ pstmt_tJDBCOutput_18.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_18 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_18++;

						tos_count_tJDBCOutput_18++;

						/**
						 * [tJDBCOutput_18 main ] stop
						 */

						/**
						 * [tJDBCInput_18 end ] start
						 */

						currentComponent = "tJDBCInput_18";

					}
				} finally {
					rs_tJDBCInput_18.close();
					stmt_tJDBCInput_18.close();

				}
				globalMap.put("tJDBCInput_18_NB_LINE", nb_line_tJDBCInput_18);

				ok_Hash.put("tJDBCInput_18", true);
				end_Hash.put("tJDBCInput_18", System.currentTimeMillis());

				/**
				 * [tJDBCInput_18 end ] stop
				 */

				/**
				 * [tJDBCOutput_18 end ] start
				 */

				currentComponent = "tJDBCOutput_18";

				if (pstmt_tJDBCOutput_18 != null) {

					pstmt_tJDBCOutput_18.close();

				}

				nb_line_deleted_tJDBCOutput_18 = nb_line_deleted_tJDBCOutput_18
						+ deletedCount_tJDBCOutput_18;
				nb_line_update_tJDBCOutput_18 = nb_line_update_tJDBCOutput_18
						+ updatedCount_tJDBCOutput_18;
				nb_line_inserted_tJDBCOutput_18 = nb_line_inserted_tJDBCOutput_18
						+ insertedCount_tJDBCOutput_18;
				nb_line_rejected_tJDBCOutput_18 = nb_line_rejected_tJDBCOutput_18
						+ rejectedCount_tJDBCOutput_18;

				globalMap.put("tJDBCOutput_18_NB_LINE", nb_line_tJDBCOutput_18);
				globalMap.put("tJDBCOutput_18_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_18);
				globalMap.put("tJDBCOutput_18_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_18);
				globalMap.put("tJDBCOutput_18_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_18);
				globalMap.put("tJDBCOutput_18_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_18);

				ok_Hash.put("tJDBCOutput_18", true);
				end_Hash.put("tJDBCOutput_18", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_18 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_18 finally ] start
				 */

				currentComponent = "tJDBCInput_18";

				/**
				 * [tJDBCInput_18 finally ] stop
				 */

				/**
				 * [tJDBCOutput_18 finally ] start
				 */

				currentComponent = "tJDBCOutput_18";

				/**
				 * [tJDBCOutput_18 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_18_SUBPROCESS_STATE", 1);
	}

	public static class row19Struct implements
			routines.system.IPersistableRow<row19Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row19Struct other = (row19Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row19Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row19Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row19Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_19Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_19_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row19Struct row19 = new row19Struct();

				/**
				 * [tJDBCOutput_19 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_19", false);
				start_Hash.put("tJDBCOutput_19", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_19";

				int tos_count_tJDBCOutput_19 = 0;

				int deleteKeyCount_tJDBCOutput_19 = 1;
				if (deleteKeyCount_tJDBCOutput_19 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_19 = 0;
				int nb_line_update_tJDBCOutput_19 = 0;
				int nb_line_inserted_tJDBCOutput_19 = 0;
				int nb_line_deleted_tJDBCOutput_19 = 0;
				int nb_line_rejected_tJDBCOutput_19 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_19 = 0;

				int deletedCount_tJDBCOutput_19 = 0;
				int updatedCount_tJDBCOutput_19 = 0;
				int insertedCount_tJDBCOutput_19 = 0;
				int rejectedCount_tJDBCOutput_19 = 0;

				boolean whetherReject_tJDBCOutput_19 = false;

				java.sql.Connection connection_tJDBCOutput_19 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_19 = 10000;
				int batchSizeCounter_tJDBCOutput_19 = 0;

				String delete_tJDBCOutput_19 = "DELETE  FROM "
						+ "vm_daily_history" + " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_19 = connection_tJDBCOutput_19
						.prepareStatement(delete_tJDBCOutput_19);

				/**
				 * [tJDBCOutput_19 begin ] stop
				 */

				/**
				 * [tJDBCInput_19 begin ] start
				 */

				ok_Hash.put("tJDBCInput_19", false);
				start_Hash.put("tJDBCInput_19", System.currentTimeMillis());

				currentComponent = "tJDBCInput_19";

				int tos_count_tJDBCInput_19 = 0;

				int nb_line_tJDBCInput_19 = 0;
				java.sql.Connection conn_tJDBCInput_19 = null;
				conn_tJDBCInput_19 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_19 = conn_tJDBCInput_19
						.createStatement();

				String dbquery_tJDBCInput_19 = "SELECT history_id  FROM vm_daily_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepDaily * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_19_QUERY", dbquery_tJDBCInput_19);
				java.sql.ResultSet rs_tJDBCInput_19 = null;
				try {
					rs_tJDBCInput_19 = stmt_tJDBCInput_19
							.executeQuery(dbquery_tJDBCInput_19);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_19 = rs_tJDBCInput_19
							.getMetaData();
					int colQtyInRs_tJDBCInput_19 = rsmd_tJDBCInput_19
							.getColumnCount();

					String tmpContent_tJDBCInput_19 = null;
					int column_index_tJDBCInput_19 = 1;

					while (rs_tJDBCInput_19.next()) {
						nb_line_tJDBCInput_19++;

						column_index_tJDBCInput_19 = 1;

						if (colQtyInRs_tJDBCInput_19 < column_index_tJDBCInput_19) {
							row19.history_id = 0;
						} else {

							if (rs_tJDBCInput_19
									.getObject(column_index_tJDBCInput_19) != null) {
								row19.history_id = rs_tJDBCInput_19
										.getLong(column_index_tJDBCInput_19);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_19 begin ] stop
						 */
						/**
						 * [tJDBCInput_19 main ] start
						 */

						currentComponent = "tJDBCInput_19";

						tos_count_tJDBCInput_19++;

						/**
						 * [tJDBCInput_19 main ] stop
						 */

						/**
						 * [tJDBCOutput_19 main ] start
						 */

						currentComponent = "tJDBCOutput_19";

						whetherReject_tJDBCOutput_19 = false;
						pstmt_tJDBCOutput_19.setLong(1, row19.history_id);

						try {
							deletedCount_tJDBCOutput_19 = deletedCount_tJDBCOutput_19
									+ pstmt_tJDBCOutput_19.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_19 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_19++;

						tos_count_tJDBCOutput_19++;

						/**
						 * [tJDBCOutput_19 main ] stop
						 */

						/**
						 * [tJDBCInput_19 end ] start
						 */

						currentComponent = "tJDBCInput_19";

					}
				} finally {
					rs_tJDBCInput_19.close();
					stmt_tJDBCInput_19.close();

				}
				globalMap.put("tJDBCInput_19_NB_LINE", nb_line_tJDBCInput_19);

				ok_Hash.put("tJDBCInput_19", true);
				end_Hash.put("tJDBCInput_19", System.currentTimeMillis());

				/**
				 * [tJDBCInput_19 end ] stop
				 */

				/**
				 * [tJDBCOutput_19 end ] start
				 */

				currentComponent = "tJDBCOutput_19";

				if (pstmt_tJDBCOutput_19 != null) {

					pstmt_tJDBCOutput_19.close();

				}

				nb_line_deleted_tJDBCOutput_19 = nb_line_deleted_tJDBCOutput_19
						+ deletedCount_tJDBCOutput_19;
				nb_line_update_tJDBCOutput_19 = nb_line_update_tJDBCOutput_19
						+ updatedCount_tJDBCOutput_19;
				nb_line_inserted_tJDBCOutput_19 = nb_line_inserted_tJDBCOutput_19
						+ insertedCount_tJDBCOutput_19;
				nb_line_rejected_tJDBCOutput_19 = nb_line_rejected_tJDBCOutput_19
						+ rejectedCount_tJDBCOutput_19;

				globalMap.put("tJDBCOutput_19_NB_LINE", nb_line_tJDBCOutput_19);
				globalMap.put("tJDBCOutput_19_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_19);
				globalMap.put("tJDBCOutput_19_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_19);
				globalMap.put("tJDBCOutput_19_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_19);
				globalMap.put("tJDBCOutput_19_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_19);

				ok_Hash.put("tJDBCOutput_19", true);
				end_Hash.put("tJDBCOutput_19", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_19 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_19 finally ] start
				 */

				currentComponent = "tJDBCInput_19";

				/**
				 * [tJDBCInput_19 finally ] stop
				 */

				/**
				 * [tJDBCOutput_19 finally ] start
				 */

				currentComponent = "tJDBCOutput_19";

				/**
				 * [tJDBCOutput_19 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_19_SUBPROCESS_STATE", 1);
	}

	public static class row20Struct implements
			routines.system.IPersistableRow<row20Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row20Struct other = (row20Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row20Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row20Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row20Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_20Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_20_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row20Struct row20 = new row20Struct();

				/**
				 * [tJDBCOutput_20 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_20", false);
				start_Hash.put("tJDBCOutput_20", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_20";

				int tos_count_tJDBCOutput_20 = 0;

				int deleteKeyCount_tJDBCOutput_20 = 1;
				if (deleteKeyCount_tJDBCOutput_20 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_20 = 0;
				int nb_line_update_tJDBCOutput_20 = 0;
				int nb_line_inserted_tJDBCOutput_20 = 0;
				int nb_line_deleted_tJDBCOutput_20 = 0;
				int nb_line_rejected_tJDBCOutput_20 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_20 = 0;

				int deletedCount_tJDBCOutput_20 = 0;
				int updatedCount_tJDBCOutput_20 = 0;
				int insertedCount_tJDBCOutput_20 = 0;
				int rejectedCount_tJDBCOutput_20 = 0;

				boolean whetherReject_tJDBCOutput_20 = false;

				java.sql.Connection connection_tJDBCOutput_20 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_20 = 10000;
				int batchSizeCounter_tJDBCOutput_20 = 0;

				String delete_tJDBCOutput_20 = "DELETE  FROM "
						+ "vm_interface_daily_history"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_20 = connection_tJDBCOutput_20
						.prepareStatement(delete_tJDBCOutput_20);

				/**
				 * [tJDBCOutput_20 begin ] stop
				 */

				/**
				 * [tJDBCInput_20 begin ] start
				 */

				ok_Hash.put("tJDBCInput_20", false);
				start_Hash.put("tJDBCInput_20", System.currentTimeMillis());

				currentComponent = "tJDBCInput_20";

				int tos_count_tJDBCInput_20 = 0;

				int nb_line_tJDBCInput_20 = 0;
				java.sql.Connection conn_tJDBCInput_20 = null;
				conn_tJDBCInput_20 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_20 = conn_tJDBCInput_20
						.createStatement();

				String dbquery_tJDBCInput_20 = "SELECT history_id  FROM vm_interface_daily_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepDaily * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_20_QUERY", dbquery_tJDBCInput_20);
				java.sql.ResultSet rs_tJDBCInput_20 = null;
				try {
					rs_tJDBCInput_20 = stmt_tJDBCInput_20
							.executeQuery(dbquery_tJDBCInput_20);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_20 = rs_tJDBCInput_20
							.getMetaData();
					int colQtyInRs_tJDBCInput_20 = rsmd_tJDBCInput_20
							.getColumnCount();

					String tmpContent_tJDBCInput_20 = null;
					int column_index_tJDBCInput_20 = 1;

					while (rs_tJDBCInput_20.next()) {
						nb_line_tJDBCInput_20++;

						column_index_tJDBCInput_20 = 1;

						if (colQtyInRs_tJDBCInput_20 < column_index_tJDBCInput_20) {
							row20.history_id = 0;
						} else {

							if (rs_tJDBCInput_20
									.getObject(column_index_tJDBCInput_20) != null) {
								row20.history_id = rs_tJDBCInput_20
										.getLong(column_index_tJDBCInput_20);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_20 begin ] stop
						 */
						/**
						 * [tJDBCInput_20 main ] start
						 */

						currentComponent = "tJDBCInput_20";

						tos_count_tJDBCInput_20++;

						/**
						 * [tJDBCInput_20 main ] stop
						 */

						/**
						 * [tJDBCOutput_20 main ] start
						 */

						currentComponent = "tJDBCOutput_20";

						whetherReject_tJDBCOutput_20 = false;
						pstmt_tJDBCOutput_20.setLong(1, row20.history_id);

						try {
							deletedCount_tJDBCOutput_20 = deletedCount_tJDBCOutput_20
									+ pstmt_tJDBCOutput_20.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_20 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_20++;

						tos_count_tJDBCOutput_20++;

						/**
						 * [tJDBCOutput_20 main ] stop
						 */

						/**
						 * [tJDBCInput_20 end ] start
						 */

						currentComponent = "tJDBCInput_20";

					}
				} finally {
					rs_tJDBCInput_20.close();
					stmt_tJDBCInput_20.close();

				}
				globalMap.put("tJDBCInput_20_NB_LINE", nb_line_tJDBCInput_20);

				ok_Hash.put("tJDBCInput_20", true);
				end_Hash.put("tJDBCInput_20", System.currentTimeMillis());

				/**
				 * [tJDBCInput_20 end ] stop
				 */

				/**
				 * [tJDBCOutput_20 end ] start
				 */

				currentComponent = "tJDBCOutput_20";

				if (pstmt_tJDBCOutput_20 != null) {

					pstmt_tJDBCOutput_20.close();

				}

				nb_line_deleted_tJDBCOutput_20 = nb_line_deleted_tJDBCOutput_20
						+ deletedCount_tJDBCOutput_20;
				nb_line_update_tJDBCOutput_20 = nb_line_update_tJDBCOutput_20
						+ updatedCount_tJDBCOutput_20;
				nb_line_inserted_tJDBCOutput_20 = nb_line_inserted_tJDBCOutput_20
						+ insertedCount_tJDBCOutput_20;
				nb_line_rejected_tJDBCOutput_20 = nb_line_rejected_tJDBCOutput_20
						+ rejectedCount_tJDBCOutput_20;

				globalMap.put("tJDBCOutput_20_NB_LINE", nb_line_tJDBCOutput_20);
				globalMap.put("tJDBCOutput_20_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_20);
				globalMap.put("tJDBCOutput_20_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_20);
				globalMap.put("tJDBCOutput_20_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_20);
				globalMap.put("tJDBCOutput_20_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_20);

				ok_Hash.put("tJDBCOutput_20", true);
				end_Hash.put("tJDBCOutput_20", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_20 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_20 finally ] start
				 */

				currentComponent = "tJDBCInput_20";

				/**
				 * [tJDBCInput_20 finally ] stop
				 */

				/**
				 * [tJDBCOutput_20 finally ] start
				 */

				currentComponent = "tJDBCOutput_20";

				/**
				 * [tJDBCOutput_20 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_20_SUBPROCESS_STATE", 1);
	}

	public static class row21Struct implements
			routines.system.IPersistableRow<row21Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row21Struct other = (row21Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row21Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row21Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row21Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_21Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_21_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row21Struct row21 = new row21Struct();

				/**
				 * [tJDBCOutput_21 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_21", false);
				start_Hash.put("tJDBCOutput_21", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_21";

				int tos_count_tJDBCOutput_21 = 0;

				int deleteKeyCount_tJDBCOutput_21 = 1;
				if (deleteKeyCount_tJDBCOutput_21 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_21 = 0;
				int nb_line_update_tJDBCOutput_21 = 0;
				int nb_line_inserted_tJDBCOutput_21 = 0;
				int nb_line_deleted_tJDBCOutput_21 = 0;
				int nb_line_rejected_tJDBCOutput_21 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_21 = 0;

				int deletedCount_tJDBCOutput_21 = 0;
				int updatedCount_tJDBCOutput_21 = 0;
				int insertedCount_tJDBCOutput_21 = 0;
				int rejectedCount_tJDBCOutput_21 = 0;

				boolean whetherReject_tJDBCOutput_21 = false;

				java.sql.Connection connection_tJDBCOutput_21 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_21 = 10000;
				int batchSizeCounter_tJDBCOutput_21 = 0;

				String delete_tJDBCOutput_21 = "DELETE  FROM "
						+ "vm_disk_daily_history" + " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_21 = connection_tJDBCOutput_21
						.prepareStatement(delete_tJDBCOutput_21);

				/**
				 * [tJDBCOutput_21 begin ] stop
				 */

				/**
				 * [tJDBCInput_21 begin ] start
				 */

				ok_Hash.put("tJDBCInput_21", false);
				start_Hash.put("tJDBCInput_21", System.currentTimeMillis());

				currentComponent = "tJDBCInput_21";

				int tos_count_tJDBCInput_21 = 0;

				int nb_line_tJDBCInput_21 = 0;
				java.sql.Connection conn_tJDBCInput_21 = null;
				conn_tJDBCInput_21 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_21 = conn_tJDBCInput_21
						.createStatement();

				String dbquery_tJDBCInput_21 = "SELECT history_id  FROM vm_disk_daily_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepDaily * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_21_QUERY", dbquery_tJDBCInput_21);
				java.sql.ResultSet rs_tJDBCInput_21 = null;
				try {
					rs_tJDBCInput_21 = stmt_tJDBCInput_21
							.executeQuery(dbquery_tJDBCInput_21);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_21 = rs_tJDBCInput_21
							.getMetaData();
					int colQtyInRs_tJDBCInput_21 = rsmd_tJDBCInput_21
							.getColumnCount();

					String tmpContent_tJDBCInput_21 = null;
					int column_index_tJDBCInput_21 = 1;

					while (rs_tJDBCInput_21.next()) {
						nb_line_tJDBCInput_21++;

						column_index_tJDBCInput_21 = 1;

						if (colQtyInRs_tJDBCInput_21 < column_index_tJDBCInput_21) {
							row21.history_id = 0;
						} else {

							if (rs_tJDBCInput_21
									.getObject(column_index_tJDBCInput_21) != null) {
								row21.history_id = rs_tJDBCInput_21
										.getLong(column_index_tJDBCInput_21);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_21 begin ] stop
						 */
						/**
						 * [tJDBCInput_21 main ] start
						 */

						currentComponent = "tJDBCInput_21";

						tos_count_tJDBCInput_21++;

						/**
						 * [tJDBCInput_21 main ] stop
						 */

						/**
						 * [tJDBCOutput_21 main ] start
						 */

						currentComponent = "tJDBCOutput_21";

						whetherReject_tJDBCOutput_21 = false;
						pstmt_tJDBCOutput_21.setLong(1, row21.history_id);

						try {
							deletedCount_tJDBCOutput_21 = deletedCount_tJDBCOutput_21
									+ pstmt_tJDBCOutput_21.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_21 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_21++;

						tos_count_tJDBCOutput_21++;

						/**
						 * [tJDBCOutput_21 main ] stop
						 */

						/**
						 * [tJDBCInput_21 end ] start
						 */

						currentComponent = "tJDBCInput_21";

					}
				} finally {
					rs_tJDBCInput_21.close();
					stmt_tJDBCInput_21.close();

				}
				globalMap.put("tJDBCInput_21_NB_LINE", nb_line_tJDBCInput_21);

				ok_Hash.put("tJDBCInput_21", true);
				end_Hash.put("tJDBCInput_21", System.currentTimeMillis());

				/**
				 * [tJDBCInput_21 end ] stop
				 */

				/**
				 * [tJDBCOutput_21 end ] start
				 */

				currentComponent = "tJDBCOutput_21";

				if (pstmt_tJDBCOutput_21 != null) {

					pstmt_tJDBCOutput_21.close();

				}

				nb_line_deleted_tJDBCOutput_21 = nb_line_deleted_tJDBCOutput_21
						+ deletedCount_tJDBCOutput_21;
				nb_line_update_tJDBCOutput_21 = nb_line_update_tJDBCOutput_21
						+ updatedCount_tJDBCOutput_21;
				nb_line_inserted_tJDBCOutput_21 = nb_line_inserted_tJDBCOutput_21
						+ insertedCount_tJDBCOutput_21;
				nb_line_rejected_tJDBCOutput_21 = nb_line_rejected_tJDBCOutput_21
						+ rejectedCount_tJDBCOutput_21;

				globalMap.put("tJDBCOutput_21_NB_LINE", nb_line_tJDBCOutput_21);
				globalMap.put("tJDBCOutput_21_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_21);
				globalMap.put("tJDBCOutput_21_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_21);
				globalMap.put("tJDBCOutput_21_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_21);
				globalMap.put("tJDBCOutput_21_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_21);

				ok_Hash.put("tJDBCOutput_21", true);
				end_Hash.put("tJDBCOutput_21", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_21 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_21 finally ] start
				 */

				currentComponent = "tJDBCInput_21";

				/**
				 * [tJDBCInput_21 finally ] stop
				 */

				/**
				 * [tJDBCOutput_21 finally ] start
				 */

				currentComponent = "tJDBCOutput_21";

				/**
				 * [tJDBCOutput_21 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_21_SUBPROCESS_STATE", 1);
	}

	public void tPrejob_1Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tPrejob_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tPrejob_1 begin ] start
				 */

				ok_Hash.put("tPrejob_1", false);
				start_Hash.put("tPrejob_1", System.currentTimeMillis());

				currentComponent = "tPrejob_1";

				int tos_count_tPrejob_1 = 0;

				/**
				 * [tPrejob_1 begin ] stop
				 */
				/**
				 * [tPrejob_1 main ] start
				 */

				currentComponent = "tPrejob_1";

				tos_count_tPrejob_1++;

				/**
				 * [tPrejob_1 main ] stop
				 */
				/**
				 * [tPrejob_1 end ] start
				 */

				currentComponent = "tPrejob_1";

				ok_Hash.put("tPrejob_1", true);
				end_Hash.put("tPrejob_1", System.currentTimeMillis());

				tJDBCConnection_1Process(globalMap);

				/**
				 * [tPrejob_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tPrejob_1 finally ] start
				 */

				currentComponent = "tPrejob_1";

				/**
				 * [tPrejob_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tPrejob_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_1 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_1", false);
				start_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_1";

				int tos_count_tJDBCConnection_1 = 0;

				String url_tJDBCConnection_1 = context.ovirtEngineHistoryDbJdbcConnection;

				String userName_tJDBCConnection_1 = context.ovirtEngineHistoryDbUser;
				String password_tJDBCConnection_1 = context.ovirtEngineHistoryDbPassword;

				java.sql.Connection conn_tJDBCConnection_1 = null;

				String sharedConnectionName_tJDBCConnection_1 = "delete_ovirt_engine_history";
				conn_tJDBCConnection_1 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_1, userName_tJDBCConnection_1,
						password_tJDBCConnection_1,
						sharedConnectionName_tJDBCConnection_1);
				if (null != conn_tJDBCConnection_1) {

					conn_tJDBCConnection_1.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_1", conn_tJDBCConnection_1);
				globalMap.put("url_tJDBCConnection_1", url_tJDBCConnection_1);
				// globalMap.put("user_tJDBCConnection_1",
				// userName_tJDBCConnection_1);
				// globalMap.put("pass_tJDBCConnection_1",
				// password_tJDBCConnection_1);

				/**
				 * [tJDBCConnection_1 begin ] stop
				 */
				/**
				 * [tJDBCConnection_1 main ] start
				 */

				currentComponent = "tJDBCConnection_1";

				tos_count_tJDBCConnection_1++;

				/**
				 * [tJDBCConnection_1 main ] stop
				 */
				/**
				 * [tJDBCConnection_1 end ] start
				 */

				currentComponent = "tJDBCConnection_1";

				ok_Hash.put("tJDBCConnection_1", true);
				end_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				/**
				 * [tJDBCConnection_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_1 finally ] start
				 */

				currentComponent = "tJDBCConnection_1";

				/**
				 * [tJDBCConnection_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 1);
	}

	public static class row22Struct implements
			routines.system.IPersistableRow<row22Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row22Struct other = (row22Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row22Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row22Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row22Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_22Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_22_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row22Struct row22 = new row22Struct();

				/**
				 * [tJDBCOutput_22 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_22", false);
				start_Hash.put("tJDBCOutput_22", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_22";

				int tos_count_tJDBCOutput_22 = 0;

				int deleteKeyCount_tJDBCOutput_22 = 1;
				if (deleteKeyCount_tJDBCOutput_22 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_22 = 0;
				int nb_line_update_tJDBCOutput_22 = 0;
				int nb_line_inserted_tJDBCOutput_22 = 0;
				int nb_line_deleted_tJDBCOutput_22 = 0;
				int nb_line_rejected_tJDBCOutput_22 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_22 = 0;

				int deletedCount_tJDBCOutput_22 = 0;
				int updatedCount_tJDBCOutput_22 = 0;
				int insertedCount_tJDBCOutput_22 = 0;
				int rejectedCount_tJDBCOutput_22 = 0;

				boolean whetherReject_tJDBCOutput_22 = false;

				java.sql.Connection connection_tJDBCOutput_22 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_22 = 10000;
				int batchSizeCounter_tJDBCOutput_22 = 0;

				String delete_tJDBCOutput_22 = "DELETE  FROM "
						+ "vm_disks_usage_samples_history"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_22 = connection_tJDBCOutput_22
						.prepareStatement(delete_tJDBCOutput_22);

				/**
				 * [tJDBCOutput_22 begin ] stop
				 */

				/**
				 * [tJDBCInput_22 begin ] start
				 */

				ok_Hash.put("tJDBCInput_22", false);
				start_Hash.put("tJDBCInput_22", System.currentTimeMillis());

				currentComponent = "tJDBCInput_22";

				int tos_count_tJDBCInput_22 = 0;

				int nb_line_tJDBCInput_22 = 0;
				java.sql.Connection conn_tJDBCInput_22 = null;
				conn_tJDBCInput_22 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_22 = conn_tJDBCInput_22
						.createStatement();

				String dbquery_tJDBCInput_22 = "SELECT history_id  FROM vm_disks_usage_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_22_QUERY", dbquery_tJDBCInput_22);
				java.sql.ResultSet rs_tJDBCInput_22 = null;
				try {
					rs_tJDBCInput_22 = stmt_tJDBCInput_22
							.executeQuery(dbquery_tJDBCInput_22);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_22 = rs_tJDBCInput_22
							.getMetaData();
					int colQtyInRs_tJDBCInput_22 = rsmd_tJDBCInput_22
							.getColumnCount();

					String tmpContent_tJDBCInput_22 = null;
					int column_index_tJDBCInput_22 = 1;

					while (rs_tJDBCInput_22.next()) {
						nb_line_tJDBCInput_22++;

						column_index_tJDBCInput_22 = 1;

						if (colQtyInRs_tJDBCInput_22 < column_index_tJDBCInput_22) {
							row22.history_id = 0;
						} else {

							if (rs_tJDBCInput_22
									.getObject(column_index_tJDBCInput_22) != null) {
								row22.history_id = rs_tJDBCInput_22
										.getLong(column_index_tJDBCInput_22);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_22 begin ] stop
						 */
						/**
						 * [tJDBCInput_22 main ] start
						 */

						currentComponent = "tJDBCInput_22";

						tos_count_tJDBCInput_22++;

						/**
						 * [tJDBCInput_22 main ] stop
						 */

						/**
						 * [tJDBCOutput_22 main ] start
						 */

						currentComponent = "tJDBCOutput_22";

						whetherReject_tJDBCOutput_22 = false;
						pstmt_tJDBCOutput_22.setLong(1, row22.history_id);

						try {
							deletedCount_tJDBCOutput_22 = deletedCount_tJDBCOutput_22
									+ pstmt_tJDBCOutput_22.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_22 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_22++;

						tos_count_tJDBCOutput_22++;

						/**
						 * [tJDBCOutput_22 main ] stop
						 */

						/**
						 * [tJDBCInput_22 end ] start
						 */

						currentComponent = "tJDBCInput_22";

					}
				} finally {
					rs_tJDBCInput_22.close();
					stmt_tJDBCInput_22.close();

				}
				globalMap.put("tJDBCInput_22_NB_LINE", nb_line_tJDBCInput_22);

				ok_Hash.put("tJDBCInput_22", true);
				end_Hash.put("tJDBCInput_22", System.currentTimeMillis());

				/**
				 * [tJDBCInput_22 end ] stop
				 */

				/**
				 * [tJDBCOutput_22 end ] start
				 */

				currentComponent = "tJDBCOutput_22";

				if (pstmt_tJDBCOutput_22 != null) {

					pstmt_tJDBCOutput_22.close();

				}

				nb_line_deleted_tJDBCOutput_22 = nb_line_deleted_tJDBCOutput_22
						+ deletedCount_tJDBCOutput_22;
				nb_line_update_tJDBCOutput_22 = nb_line_update_tJDBCOutput_22
						+ updatedCount_tJDBCOutput_22;
				nb_line_inserted_tJDBCOutput_22 = nb_line_inserted_tJDBCOutput_22
						+ insertedCount_tJDBCOutput_22;
				nb_line_rejected_tJDBCOutput_22 = nb_line_rejected_tJDBCOutput_22
						+ rejectedCount_tJDBCOutput_22;

				globalMap.put("tJDBCOutput_22_NB_LINE", nb_line_tJDBCOutput_22);
				globalMap.put("tJDBCOutput_22_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_22);
				globalMap.put("tJDBCOutput_22_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_22);
				globalMap.put("tJDBCOutput_22_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_22);
				globalMap.put("tJDBCOutput_22_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_22);

				ok_Hash.put("tJDBCOutput_22", true);
				end_Hash.put("tJDBCOutput_22", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_22 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_22 finally ] start
				 */

				currentComponent = "tJDBCInput_22";

				/**
				 * [tJDBCInput_22 finally ] stop
				 */

				/**
				 * [tJDBCOutput_22 finally ] start
				 */

				currentComponent = "tJDBCOutput_22";

				/**
				 * [tJDBCOutput_22 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_22_SUBPROCESS_STATE", 1);
	}

	public static class row23Struct implements
			routines.system.IPersistableRow<row23Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row23Struct other = (row23Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row23Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row23Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row23Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_23Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_23_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row23Struct row23 = new row23Struct();

				/**
				 * [tJDBCOutput_23 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_23", false);
				start_Hash.put("tJDBCOutput_23", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_23";

				int tos_count_tJDBCOutput_23 = 0;

				int deleteKeyCount_tJDBCOutput_23 = 1;
				if (deleteKeyCount_tJDBCOutput_23 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_23 = 0;
				int nb_line_update_tJDBCOutput_23 = 0;
				int nb_line_inserted_tJDBCOutput_23 = 0;
				int nb_line_deleted_tJDBCOutput_23 = 0;
				int nb_line_rejected_tJDBCOutput_23 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_23 = 0;

				int deletedCount_tJDBCOutput_23 = 0;
				int updatedCount_tJDBCOutput_23 = 0;
				int insertedCount_tJDBCOutput_23 = 0;
				int rejectedCount_tJDBCOutput_23 = 0;

				boolean whetherReject_tJDBCOutput_23 = false;

				java.sql.Connection connection_tJDBCOutput_23 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_23 = 10000;
				int batchSizeCounter_tJDBCOutput_23 = 0;

				String delete_tJDBCOutput_23 = "DELETE  FROM "
						+ "vm_disks_usage_hourly_history"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_23 = connection_tJDBCOutput_23
						.prepareStatement(delete_tJDBCOutput_23);

				/**
				 * [tJDBCOutput_23 begin ] stop
				 */

				/**
				 * [tJDBCInput_23 begin ] start
				 */

				ok_Hash.put("tJDBCInput_23", false);
				start_Hash.put("tJDBCInput_23", System.currentTimeMillis());

				currentComponent = "tJDBCInput_23";

				int tos_count_tJDBCInput_23 = 0;

				int nb_line_tJDBCInput_23 = 0;
				java.sql.Connection conn_tJDBCInput_23 = null;
				conn_tJDBCInput_23 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_23 = conn_tJDBCInput_23
						.createStatement();

				String dbquery_tJDBCInput_23 = "SELECT history_id  FROM vm_disks_usage_hourly_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepHourly * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_23_QUERY", dbquery_tJDBCInput_23);
				java.sql.ResultSet rs_tJDBCInput_23 = null;
				try {
					rs_tJDBCInput_23 = stmt_tJDBCInput_23
							.executeQuery(dbquery_tJDBCInput_23);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_23 = rs_tJDBCInput_23
							.getMetaData();
					int colQtyInRs_tJDBCInput_23 = rsmd_tJDBCInput_23
							.getColumnCount();

					String tmpContent_tJDBCInput_23 = null;
					int column_index_tJDBCInput_23 = 1;

					while (rs_tJDBCInput_23.next()) {
						nb_line_tJDBCInput_23++;

						column_index_tJDBCInput_23 = 1;

						if (colQtyInRs_tJDBCInput_23 < column_index_tJDBCInput_23) {
							row23.history_id = 0;
						} else {

							if (rs_tJDBCInput_23
									.getObject(column_index_tJDBCInput_23) != null) {
								row23.history_id = rs_tJDBCInput_23
										.getLong(column_index_tJDBCInput_23);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_23 begin ] stop
						 */
						/**
						 * [tJDBCInput_23 main ] start
						 */

						currentComponent = "tJDBCInput_23";

						tos_count_tJDBCInput_23++;

						/**
						 * [tJDBCInput_23 main ] stop
						 */

						/**
						 * [tJDBCOutput_23 main ] start
						 */

						currentComponent = "tJDBCOutput_23";

						whetherReject_tJDBCOutput_23 = false;
						pstmt_tJDBCOutput_23.setLong(1, row23.history_id);

						try {
							deletedCount_tJDBCOutput_23 = deletedCount_tJDBCOutput_23
									+ pstmt_tJDBCOutput_23.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_23 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_23++;

						tos_count_tJDBCOutput_23++;

						/**
						 * [tJDBCOutput_23 main ] stop
						 */

						/**
						 * [tJDBCInput_23 end ] start
						 */

						currentComponent = "tJDBCInput_23";

					}
				} finally {
					rs_tJDBCInput_23.close();
					stmt_tJDBCInput_23.close();

				}
				globalMap.put("tJDBCInput_23_NB_LINE", nb_line_tJDBCInput_23);

				ok_Hash.put("tJDBCInput_23", true);
				end_Hash.put("tJDBCInput_23", System.currentTimeMillis());

				/**
				 * [tJDBCInput_23 end ] stop
				 */

				/**
				 * [tJDBCOutput_23 end ] start
				 */

				currentComponent = "tJDBCOutput_23";

				if (pstmt_tJDBCOutput_23 != null) {

					pstmt_tJDBCOutput_23.close();

				}

				nb_line_deleted_tJDBCOutput_23 = nb_line_deleted_tJDBCOutput_23
						+ deletedCount_tJDBCOutput_23;
				nb_line_update_tJDBCOutput_23 = nb_line_update_tJDBCOutput_23
						+ updatedCount_tJDBCOutput_23;
				nb_line_inserted_tJDBCOutput_23 = nb_line_inserted_tJDBCOutput_23
						+ insertedCount_tJDBCOutput_23;
				nb_line_rejected_tJDBCOutput_23 = nb_line_rejected_tJDBCOutput_23
						+ rejectedCount_tJDBCOutput_23;

				globalMap.put("tJDBCOutput_23_NB_LINE", nb_line_tJDBCOutput_23);
				globalMap.put("tJDBCOutput_23_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_23);
				globalMap.put("tJDBCOutput_23_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_23);
				globalMap.put("tJDBCOutput_23_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_23);
				globalMap.put("tJDBCOutput_23_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_23);

				ok_Hash.put("tJDBCOutput_23", true);
				end_Hash.put("tJDBCOutput_23", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_23 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_23 finally ] start
				 */

				currentComponent = "tJDBCInput_23";

				/**
				 * [tJDBCInput_23 finally ] stop
				 */

				/**
				 * [tJDBCOutput_23 finally ] start
				 */

				currentComponent = "tJDBCOutput_23";

				/**
				 * [tJDBCOutput_23 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_23_SUBPROCESS_STATE", 1);
	}

	public static class row24Struct implements
			routines.system.IPersistableRow<row24Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row24Struct other = (row24Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row24Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row24Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row24Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_24Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_24_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row24Struct row24 = new row24Struct();

				/**
				 * [tJDBCOutput_24 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_24", false);
				start_Hash.put("tJDBCOutput_24", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_24";

				int tos_count_tJDBCOutput_24 = 0;

				int deleteKeyCount_tJDBCOutput_24 = 1;
				if (deleteKeyCount_tJDBCOutput_24 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_24 = 0;
				int nb_line_update_tJDBCOutput_24 = 0;
				int nb_line_inserted_tJDBCOutput_24 = 0;
				int nb_line_deleted_tJDBCOutput_24 = 0;
				int nb_line_rejected_tJDBCOutput_24 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_24 = 0;

				int deletedCount_tJDBCOutput_24 = 0;
				int updatedCount_tJDBCOutput_24 = 0;
				int insertedCount_tJDBCOutput_24 = 0;
				int rejectedCount_tJDBCOutput_24 = 0;

				boolean whetherReject_tJDBCOutput_24 = false;

				java.sql.Connection connection_tJDBCOutput_24 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_24 = 10000;
				int batchSizeCounter_tJDBCOutput_24 = 0;

				String delete_tJDBCOutput_24 = "DELETE  FROM "
						+ "vm_disks_usage_daily_history"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_24 = connection_tJDBCOutput_24
						.prepareStatement(delete_tJDBCOutput_24);

				/**
				 * [tJDBCOutput_24 begin ] stop
				 */

				/**
				 * [tJDBCInput_24 begin ] start
				 */

				ok_Hash.put("tJDBCInput_24", false);
				start_Hash.put("tJDBCInput_24", System.currentTimeMillis());

				currentComponent = "tJDBCInput_24";

				int tos_count_tJDBCInput_24 = 0;

				int nb_line_tJDBCInput_24 = 0;
				java.sql.Connection conn_tJDBCInput_24 = null;
				conn_tJDBCInput_24 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_24 = conn_tJDBCInput_24
						.createStatement();

				String dbquery_tJDBCInput_24 = "SELECT history_id  FROM vm_disks_usage_daily_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepDaily * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_24_QUERY", dbquery_tJDBCInput_24);
				java.sql.ResultSet rs_tJDBCInput_24 = null;
				try {
					rs_tJDBCInput_24 = stmt_tJDBCInput_24
							.executeQuery(dbquery_tJDBCInput_24);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_24 = rs_tJDBCInput_24
							.getMetaData();
					int colQtyInRs_tJDBCInput_24 = rsmd_tJDBCInput_24
							.getColumnCount();

					String tmpContent_tJDBCInput_24 = null;
					int column_index_tJDBCInput_24 = 1;

					while (rs_tJDBCInput_24.next()) {
						nb_line_tJDBCInput_24++;

						column_index_tJDBCInput_24 = 1;

						if (colQtyInRs_tJDBCInput_24 < column_index_tJDBCInput_24) {
							row24.history_id = 0;
						} else {

							if (rs_tJDBCInput_24
									.getObject(column_index_tJDBCInput_24) != null) {
								row24.history_id = rs_tJDBCInput_24
										.getLong(column_index_tJDBCInput_24);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_24 begin ] stop
						 */
						/**
						 * [tJDBCInput_24 main ] start
						 */

						currentComponent = "tJDBCInput_24";

						tos_count_tJDBCInput_24++;

						/**
						 * [tJDBCInput_24 main ] stop
						 */

						/**
						 * [tJDBCOutput_24 main ] start
						 */

						currentComponent = "tJDBCOutput_24";

						whetherReject_tJDBCOutput_24 = false;
						pstmt_tJDBCOutput_24.setLong(1, row24.history_id);

						try {
							deletedCount_tJDBCOutput_24 = deletedCount_tJDBCOutput_24
									+ pstmt_tJDBCOutput_24.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_24 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_24++;

						tos_count_tJDBCOutput_24++;

						/**
						 * [tJDBCOutput_24 main ] stop
						 */

						/**
						 * [tJDBCInput_24 end ] start
						 */

						currentComponent = "tJDBCInput_24";

					}
				} finally {
					rs_tJDBCInput_24.close();
					stmt_tJDBCInput_24.close();

				}
				globalMap.put("tJDBCInput_24_NB_LINE", nb_line_tJDBCInput_24);

				ok_Hash.put("tJDBCInput_24", true);
				end_Hash.put("tJDBCInput_24", System.currentTimeMillis());

				/**
				 * [tJDBCInput_24 end ] stop
				 */

				/**
				 * [tJDBCOutput_24 end ] start
				 */

				currentComponent = "tJDBCOutput_24";

				if (pstmt_tJDBCOutput_24 != null) {

					pstmt_tJDBCOutput_24.close();

				}

				nb_line_deleted_tJDBCOutput_24 = nb_line_deleted_tJDBCOutput_24
						+ deletedCount_tJDBCOutput_24;
				nb_line_update_tJDBCOutput_24 = nb_line_update_tJDBCOutput_24
						+ updatedCount_tJDBCOutput_24;
				nb_line_inserted_tJDBCOutput_24 = nb_line_inserted_tJDBCOutput_24
						+ insertedCount_tJDBCOutput_24;
				nb_line_rejected_tJDBCOutput_24 = nb_line_rejected_tJDBCOutput_24
						+ rejectedCount_tJDBCOutput_24;

				globalMap.put("tJDBCOutput_24_NB_LINE", nb_line_tJDBCOutput_24);
				globalMap.put("tJDBCOutput_24_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_24);
				globalMap.put("tJDBCOutput_24_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_24);
				globalMap.put("tJDBCOutput_24_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_24);
				globalMap.put("tJDBCOutput_24_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_24);

				ok_Hash.put("tJDBCOutput_24", true);
				end_Hash.put("tJDBCOutput_24", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_24 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_24 finally ] start
				 */

				currentComponent = "tJDBCInput_24";

				/**
				 * [tJDBCInput_24 finally ] stop
				 */

				/**
				 * [tJDBCOutput_24 finally ] start
				 */

				currentComponent = "tJDBCOutput_24";

				/**
				 * [tJDBCOutput_24 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_24_SUBPROCESS_STATE", 1);
	}

	public static class row25Struct implements
			routines.system.IPersistableRow<row25Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row25Struct other = (row25Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row25Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row25Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row25Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_25Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_25_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row25Struct row25 = new row25Struct();

				/**
				 * [tJDBCOutput_25 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_25", false);
				start_Hash.put("tJDBCOutput_25", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_25";

				int tos_count_tJDBCOutput_25 = 0;

				int deleteKeyCount_tJDBCOutput_25 = 1;
				if (deleteKeyCount_tJDBCOutput_25 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_25 = 0;
				int nb_line_update_tJDBCOutput_25 = 0;
				int nb_line_inserted_tJDBCOutput_25 = 0;
				int nb_line_deleted_tJDBCOutput_25 = 0;
				int nb_line_rejected_tJDBCOutput_25 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_25 = 0;

				int deletedCount_tJDBCOutput_25 = 0;
				int updatedCount_tJDBCOutput_25 = 0;
				int insertedCount_tJDBCOutput_25 = 0;
				int rejectedCount_tJDBCOutput_25 = 0;

				boolean whetherReject_tJDBCOutput_25 = false;

				java.sql.Connection connection_tJDBCOutput_25 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_25 = 10000;
				int batchSizeCounter_tJDBCOutput_25 = 0;

				String delete_tJDBCOutput_25 = "DELETE  FROM "
						+ "statistics_vms_users_usage_hourly"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_25 = connection_tJDBCOutput_25
						.prepareStatement(delete_tJDBCOutput_25);

				/**
				 * [tJDBCOutput_25 begin ] stop
				 */

				/**
				 * [tJDBCInput_25 begin ] start
				 */

				ok_Hash.put("tJDBCInput_25", false);
				start_Hash.put("tJDBCInput_25", System.currentTimeMillis());

				currentComponent = "tJDBCInput_25";

				int tos_count_tJDBCInput_25 = 0;

				int nb_line_tJDBCInput_25 = 0;
				java.sql.Connection conn_tJDBCInput_25 = null;
				conn_tJDBCInput_25 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_25 = conn_tJDBCInput_25
						.createStatement();

				String dbquery_tJDBCInput_25 = "SELECT history_id  FROM statistics_vms_users_usage_hourly  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepHourly * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_25_QUERY", dbquery_tJDBCInput_25);
				java.sql.ResultSet rs_tJDBCInput_25 = null;
				try {
					rs_tJDBCInput_25 = stmt_tJDBCInput_25
							.executeQuery(dbquery_tJDBCInput_25);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_25 = rs_tJDBCInput_25
							.getMetaData();
					int colQtyInRs_tJDBCInput_25 = rsmd_tJDBCInput_25
							.getColumnCount();

					String tmpContent_tJDBCInput_25 = null;
					int column_index_tJDBCInput_25 = 1;

					while (rs_tJDBCInput_25.next()) {
						nb_line_tJDBCInput_25++;

						column_index_tJDBCInput_25 = 1;

						if (colQtyInRs_tJDBCInput_25 < column_index_tJDBCInput_25) {
							row25.history_id = 0;
						} else {

							if (rs_tJDBCInput_25
									.getObject(column_index_tJDBCInput_25) != null) {
								row25.history_id = rs_tJDBCInput_25
										.getLong(column_index_tJDBCInput_25);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_25 begin ] stop
						 */
						/**
						 * [tJDBCInput_25 main ] start
						 */

						currentComponent = "tJDBCInput_25";

						tos_count_tJDBCInput_25++;

						/**
						 * [tJDBCInput_25 main ] stop
						 */

						/**
						 * [tJDBCOutput_25 main ] start
						 */

						currentComponent = "tJDBCOutput_25";

						whetherReject_tJDBCOutput_25 = false;
						pstmt_tJDBCOutput_25.setLong(1, row25.history_id);

						try {
							deletedCount_tJDBCOutput_25 = deletedCount_tJDBCOutput_25
									+ pstmt_tJDBCOutput_25.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_25 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_25++;

						tos_count_tJDBCOutput_25++;

						/**
						 * [tJDBCOutput_25 main ] stop
						 */

						/**
						 * [tJDBCInput_25 end ] start
						 */

						currentComponent = "tJDBCInput_25";

					}
				} finally {
					rs_tJDBCInput_25.close();
					stmt_tJDBCInput_25.close();

				}
				globalMap.put("tJDBCInput_25_NB_LINE", nb_line_tJDBCInput_25);

				ok_Hash.put("tJDBCInput_25", true);
				end_Hash.put("tJDBCInput_25", System.currentTimeMillis());

				/**
				 * [tJDBCInput_25 end ] stop
				 */

				/**
				 * [tJDBCOutput_25 end ] start
				 */

				currentComponent = "tJDBCOutput_25";

				if (pstmt_tJDBCOutput_25 != null) {

					pstmt_tJDBCOutput_25.close();

				}

				nb_line_deleted_tJDBCOutput_25 = nb_line_deleted_tJDBCOutput_25
						+ deletedCount_tJDBCOutput_25;
				nb_line_update_tJDBCOutput_25 = nb_line_update_tJDBCOutput_25
						+ updatedCount_tJDBCOutput_25;
				nb_line_inserted_tJDBCOutput_25 = nb_line_inserted_tJDBCOutput_25
						+ insertedCount_tJDBCOutput_25;
				nb_line_rejected_tJDBCOutput_25 = nb_line_rejected_tJDBCOutput_25
						+ rejectedCount_tJDBCOutput_25;

				globalMap.put("tJDBCOutput_25_NB_LINE", nb_line_tJDBCOutput_25);
				globalMap.put("tJDBCOutput_25_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_25);
				globalMap.put("tJDBCOutput_25_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_25);
				globalMap.put("tJDBCOutput_25_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_25);
				globalMap.put("tJDBCOutput_25_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_25);

				ok_Hash.put("tJDBCOutput_25", true);
				end_Hash.put("tJDBCOutput_25", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_25 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_25 finally ] start
				 */

				currentComponent = "tJDBCInput_25";

				/**
				 * [tJDBCInput_25 finally ] stop
				 */

				/**
				 * [tJDBCOutput_25 finally ] start
				 */

				currentComponent = "tJDBCOutput_25";

				/**
				 * [tJDBCOutput_25 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_25_SUBPROCESS_STATE", 1);
	}

	public static class row26Struct implements
			routines.system.IPersistableRow<row26Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public long history_id;

		public long getHistory_id() {
			return this.history_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime * result + (int) this.history_id;

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row26Struct other = (row26Struct) obj;

			if (this.history_id != other.history_id)
				return false;

			return true;
		}

		public void copyDataTo(row26Struct other) {

			other.history_id = this.history_id;

		}

		public void copyKeysDataTo(row26Struct other) {

			other.history_id = this.history_id;

		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.history_id = dis.readLong();

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// long

				dos.writeLong(this.history_id);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row26Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.history_id,
					other.history_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_26Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_26_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row26Struct row26 = new row26Struct();

				/**
				 * [tJDBCOutput_26 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_26", false);
				start_Hash.put("tJDBCOutput_26", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_26";

				int tos_count_tJDBCOutput_26 = 0;

				int deleteKeyCount_tJDBCOutput_26 = 1;
				if (deleteKeyCount_tJDBCOutput_26 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_26 = 0;
				int nb_line_update_tJDBCOutput_26 = 0;
				int nb_line_inserted_tJDBCOutput_26 = 0;
				int nb_line_deleted_tJDBCOutput_26 = 0;
				int nb_line_rejected_tJDBCOutput_26 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_26 = 0;

				int deletedCount_tJDBCOutput_26 = 0;
				int updatedCount_tJDBCOutput_26 = 0;
				int insertedCount_tJDBCOutput_26 = 0;
				int rejectedCount_tJDBCOutput_26 = 0;

				boolean whetherReject_tJDBCOutput_26 = false;

				java.sql.Connection connection_tJDBCOutput_26 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_26 = 10000;
				int batchSizeCounter_tJDBCOutput_26 = 0;

				String delete_tJDBCOutput_26 = "DELETE  FROM "
						+ "statistics_vms_users_usage_daily"
						+ " WHERE history_id = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_26 = connection_tJDBCOutput_26
						.prepareStatement(delete_tJDBCOutput_26);

				/**
				 * [tJDBCOutput_26 begin ] stop
				 */

				/**
				 * [tJDBCInput_26 begin ] start
				 */

				ok_Hash.put("tJDBCInput_26", false);
				start_Hash.put("tJDBCInput_26", System.currentTimeMillis());

				currentComponent = "tJDBCInput_26";

				int tos_count_tJDBCInput_26 = 0;

				int nb_line_tJDBCInput_26 = 0;
				java.sql.Connection conn_tJDBCInput_26 = null;
				conn_tJDBCInput_26 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_26 = conn_tJDBCInput_26
						.createStatement();

				String dbquery_tJDBCInput_26 = "SELECT history_id  FROM statistics_vms_users_usage_daily  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepDaily * -1, "HH"))
						+ "'" + context.limitRows;

				globalMap.put("tJDBCInput_26_QUERY", dbquery_tJDBCInput_26);
				java.sql.ResultSet rs_tJDBCInput_26 = null;
				try {
					rs_tJDBCInput_26 = stmt_tJDBCInput_26
							.executeQuery(dbquery_tJDBCInput_26);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_26 = rs_tJDBCInput_26
							.getMetaData();
					int colQtyInRs_tJDBCInput_26 = rsmd_tJDBCInput_26
							.getColumnCount();

					String tmpContent_tJDBCInput_26 = null;
					int column_index_tJDBCInput_26 = 1;

					while (rs_tJDBCInput_26.next()) {
						nb_line_tJDBCInput_26++;

						column_index_tJDBCInput_26 = 1;

						if (colQtyInRs_tJDBCInput_26 < column_index_tJDBCInput_26) {
							row26.history_id = 0;
						} else {

							if (rs_tJDBCInput_26
									.getObject(column_index_tJDBCInput_26) != null) {
								row26.history_id = rs_tJDBCInput_26
										.getLong(column_index_tJDBCInput_26);
							} else {

								throw new RuntimeException(
										"Null value in non-Nullable column");
							}

						}

						/**
						 * [tJDBCInput_26 begin ] stop
						 */
						/**
						 * [tJDBCInput_26 main ] start
						 */

						currentComponent = "tJDBCInput_26";

						tos_count_tJDBCInput_26++;

						/**
						 * [tJDBCInput_26 main ] stop
						 */

						/**
						 * [tJDBCOutput_26 main ] start
						 */

						currentComponent = "tJDBCOutput_26";

						whetherReject_tJDBCOutput_26 = false;
						pstmt_tJDBCOutput_26.setLong(1, row26.history_id);

						try {
							deletedCount_tJDBCOutput_26 = deletedCount_tJDBCOutput_26
									+ pstmt_tJDBCOutput_26.executeUpdate();
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_26 = true;
							throw (e);
						}

						nb_line_tJDBCOutput_26++;

						tos_count_tJDBCOutput_26++;

						/**
						 * [tJDBCOutput_26 main ] stop
						 */

						/**
						 * [tJDBCInput_26 end ] start
						 */

						currentComponent = "tJDBCInput_26";

					}
				} finally {
					rs_tJDBCInput_26.close();
					stmt_tJDBCInput_26.close();

				}
				globalMap.put("tJDBCInput_26_NB_LINE", nb_line_tJDBCInput_26);

				ok_Hash.put("tJDBCInput_26", true);
				end_Hash.put("tJDBCInput_26", System.currentTimeMillis());

				/**
				 * [tJDBCInput_26 end ] stop
				 */

				/**
				 * [tJDBCOutput_26 end ] start
				 */

				currentComponent = "tJDBCOutput_26";

				if (pstmt_tJDBCOutput_26 != null) {

					pstmt_tJDBCOutput_26.close();

				}

				nb_line_deleted_tJDBCOutput_26 = nb_line_deleted_tJDBCOutput_26
						+ deletedCount_tJDBCOutput_26;
				nb_line_update_tJDBCOutput_26 = nb_line_update_tJDBCOutput_26
						+ updatedCount_tJDBCOutput_26;
				nb_line_inserted_tJDBCOutput_26 = nb_line_inserted_tJDBCOutput_26
						+ insertedCount_tJDBCOutput_26;
				nb_line_rejected_tJDBCOutput_26 = nb_line_rejected_tJDBCOutput_26
						+ rejectedCount_tJDBCOutput_26;

				globalMap.put("tJDBCOutput_26_NB_LINE", nb_line_tJDBCOutput_26);
				globalMap.put("tJDBCOutput_26_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_26);
				globalMap.put("tJDBCOutput_26_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_26);
				globalMap.put("tJDBCOutput_26_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_26);
				globalMap.put("tJDBCOutput_26_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_26);

				ok_Hash.put("tJDBCOutput_26", true);
				end_Hash.put("tJDBCOutput_26", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_26 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_26 finally ] start
				 */

				currentComponent = "tJDBCInput_26";

				/**
				 * [tJDBCInput_26 finally ] stop
				 */

				/**
				 * [tJDBCOutput_26 finally ] start
				 */

				currentComponent = "tJDBCOutput_26";

				/**
				 * [tJDBCOutput_26 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_26_SUBPROCESS_STATE", 1);
	}

	public static class row_talendLogs_LOGSStruct implements
			routines.system.IPersistableRow<row_talendLogs_LOGSStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[0];

		public java.util.Date moment;

		public java.util.Date getMoment() {
			return this.moment;
		}

		public String pid;

		public String getPid() {
			return this.pid;
		}

		public String root_pid;

		public String getRoot_pid() {
			return this.root_pid;
		}

		public String father_pid;

		public String getFather_pid() {
			return this.father_pid;
		}

		public String project;

		public String getProject() {
			return this.project;
		}

		public String job;

		public String getJob() {
			return this.job;
		}

		public String context;

		public String getContext() {
			return this.context;
		}

		public Integer priority;

		public Integer getPriority() {
			return this.priority;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String origin;

		public String getOrigin() {
			return this.origin;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		public Integer code;

		public Integer getCode() {
			return this.code;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HistoryDelete, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryDelete) {

				try {

					int length = 0;

					this.moment = readDate(dis);

					this.pid = readString(dis);

					this.root_pid = readString(dis);

					this.father_pid = readString(dis);

					this.project = readString(dis);

					this.job = readString(dis);

					this.context = readString(dis);

					this.priority = readInteger(dis);

					this.type = readString(dis);

					this.origin = readString(dis);

					this.message = readString(dis);

					this.code = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.moment, dos);

				// String

				writeString(this.pid, dos);

				// String

				writeString(this.root_pid, dos);

				// String

				writeString(this.father_pid, dos);

				// String

				writeString(this.project, dos);

				// String

				writeString(this.job, dos);

				// String

				writeString(this.context, dos);

				// Integer

				writeInteger(this.priority, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.origin, dos);

				// String

				writeString(this.message, dos);

				// Integer

				writeInteger(this.code, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("moment=" + String.valueOf(moment));
			sb.append(",pid=" + pid);
			sb.append(",root_pid=" + root_pid);
			sb.append(",father_pid=" + father_pid);
			sb.append(",project=" + project);
			sb.append(",job=" + job);
			sb.append(",context=" + context);
			sb.append(",priority=" + String.valueOf(priority));
			sb.append(",type=" + type);
			sb.append(",origin=" + origin);
			sb.append(",message=" + message);
			sb.append(",code=" + String.valueOf(code));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row_talendLogs_LOGSStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void talendLogs_LOGSProcess(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row_talendLogs_LOGSStruct row_talendLogs_LOGS = new row_talendLogs_LOGSStruct();

				/**
				 * [talendLogs_CONSOLE begin ] start
				 */

				ok_Hash.put("talendLogs_CONSOLE", false);
				start_Hash
						.put("talendLogs_CONSOLE", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				int tos_count_talendLogs_CONSOLE = 0;

				// /////////////////////

				final String OUTPUT_FIELD_SEPARATOR_talendLogs_CONSOLE = "|";
				java.io.PrintStream consoleOut_talendLogs_CONSOLE = null;

				StringBuilder strBuffer_talendLogs_CONSOLE = null;
				int nb_line_talendLogs_CONSOLE = 0;
				// /////////////////////

				/**
				 * [talendLogs_CONSOLE begin ] stop
				 */

				/**
				 * [talendLogs_LOGS begin ] start
				 */

				ok_Hash.put("talendLogs_LOGS", false);
				start_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				int tos_count_talendLogs_LOGS = 0;

				for (LogCatcherUtils.LogCatcherMessage lcm : talendLogs_LOGS
						.getMessages()) {
					row_talendLogs_LOGS.type = lcm.getType();
					row_talendLogs_LOGS.origin = (lcm.getOrigin() == null
							|| lcm.getOrigin().length() < 1 ? null : lcm
							.getOrigin());
					row_talendLogs_LOGS.priority = lcm.getPriority();
					row_talendLogs_LOGS.message = lcm.getMessage();
					row_talendLogs_LOGS.code = lcm.getCode();

					row_talendLogs_LOGS.moment = java.util.Calendar
							.getInstance().getTime();

					row_talendLogs_LOGS.pid = pid;
					row_talendLogs_LOGS.root_pid = rootPid;
					row_talendLogs_LOGS.father_pid = fatherPid;

					row_talendLogs_LOGS.project = projectName;
					row_talendLogs_LOGS.job = jobName;
					row_talendLogs_LOGS.context = contextStr;

					/**
					 * [talendLogs_LOGS begin ] stop
					 */
					/**
					 * [talendLogs_LOGS main ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

					tos_count_talendLogs_LOGS++;

					/**
					 * [talendLogs_LOGS main ] stop
					 */

					/**
					 * [talendLogs_CONSOLE main ] start
					 */

					currentVirtualComponent = "talendLogs_CONSOLE";

					currentComponent = "talendLogs_CONSOLE";

					// /////////////////////

					strBuffer_talendLogs_CONSOLE = new StringBuilder();

					if (row_talendLogs_LOGS.moment != null) { //

						strBuffer_talendLogs_CONSOLE.append(FormatterUtils
								.format_Date(row_talendLogs_LOGS.moment,
										"yyyy-MM-dd HH:mm:ss"));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.root_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.root_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.father_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.father_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.project != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.project));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.job != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.job));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.context != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.context));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.priority != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.priority));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.type != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.type));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.origin != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.origin));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.message != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.message));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.code != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.code));

					} //

					if (globalMap.get("tLogRow_CONSOLE") != null) {
						consoleOut_talendLogs_CONSOLE = (java.io.PrintStream) globalMap
								.get("tLogRow_CONSOLE");
					} else {
						consoleOut_talendLogs_CONSOLE = new java.io.PrintStream(
								new java.io.BufferedOutputStream(System.out));
						globalMap.put("tLogRow_CONSOLE",
								consoleOut_talendLogs_CONSOLE);
					}

					consoleOut_talendLogs_CONSOLE
							.println(strBuffer_talendLogs_CONSOLE.toString());
					consoleOut_talendLogs_CONSOLE.flush();
					nb_line_talendLogs_CONSOLE++;
					// ////

					// ////

					// /////////////////////

					tos_count_talendLogs_CONSOLE++;

					/**
					 * [talendLogs_CONSOLE main ] stop
					 */

					/**
					 * [talendLogs_LOGS end ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

				}

				ok_Hash.put("talendLogs_LOGS", true);
				end_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				/**
				 * [talendLogs_LOGS end ] stop
				 */

				/**
				 * [talendLogs_CONSOLE end ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				// ////
				// ////
				globalMap.put("talendLogs_CONSOLE_NB_LINE",
						nb_line_talendLogs_CONSOLE);

				// /////////////////////

				ok_Hash.put("talendLogs_CONSOLE", true);
				end_Hash.put("talendLogs_CONSOLE", System.currentTimeMillis());

				/**
				 * [talendLogs_CONSOLE end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [talendLogs_LOGS finally ] start
				 */

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				/**
				 * [talendLogs_LOGS finally ] stop
				 */

				/**
				 * [talendLogs_CONSOLE finally ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				/**
				 * [talendLogs_CONSOLE finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 1);
	}

	public String resuming_logs_dir_path = null;
	public String resuming_checkpoint_path = null;
	public String parent_part_launcher = null;
	private String resumeEntryMethodName = null;
	private boolean globalResumeTicket = false;

	public boolean watch = false;
	// portStats is null, it means don't execute the statistics
	public Integer portStats = null;
	public int portTraces = 4334;
	public String clientHost;
	public String defaultClientHost = "localhost";
	public String contextStr = "Default";
	public boolean isDefaultContext = true;
	public String pid = "0";
	public String rootPid = null;
	public String fatherPid = null;
	public String fatherNode = null;
	public long startTime = 0;
	public boolean isChildJob = false;
	public String log4jLevel = "";

	private boolean execStat = true;

	private ThreadLocal<java.util.Map<String, String>> threadLocal = new ThreadLocal<java.util.Map<String, String>>() {
		protected java.util.Map<String, String> initialValue() {
			java.util.Map<String, String> threadRunResultMap = new java.util.HashMap<String, String>();
			threadRunResultMap.put("errorCode", null);
			threadRunResultMap.put("status", "");
			return threadRunResultMap;
		};
	};

	private SyncInt runningThreadCount = new SyncInt();

	private class SyncInt {
		private int count = 0;

		public synchronized void add(int i) {
			count += i;
		}

		public synchronized int getCount() {
			return count;
		}
	}

	private java.util.Properties context_param = new java.util.Properties();
	public java.util.Map<String, Object> parentContextMap = new java.util.HashMap<String, Object>();

	public String status = "";

	public static void main(String[] args) {
		final HistoryDelete HistoryDeleteClass = new HistoryDelete();

		int exitCode = HistoryDeleteClass.runJobInTOS(args);

		System.exit(exitCode);
	}

	public String[][] runJob(String[] args) {

		int exitCode = runJobInTOS(args);
		String[][] bufferValue = new String[][] { { Integer.toString(exitCode) } };

		return bufferValue;
	}

	public int runJobInTOS(String[] args) {
		// reset status
		status = "";

		String lastStr = "";
		for (String arg : args) {
			if (arg.equalsIgnoreCase("--context_param")) {
				lastStr = arg;
			} else if (lastStr.equals("")) {
				evalParam(arg);
			} else {
				evalParam(lastStr + " " + arg);
				lastStr = "";
			}
		}

		if (clientHost == null) {
			clientHost = defaultClientHost;
		}

		if (pid == null || "0".equals(pid)) {
			pid = TalendString.getAsciiRandomString(6);
		}

		if (rootPid == null) {
			rootPid = pid;
		}
		if (fatherPid == null) {
			fatherPid = pid;
		} else {
			isChildJob = true;
		}

		try {
			// call job/subjob with an existing context, like:
			// --context=production. if without this parameter, there will use
			// the default context instead.
			java.io.InputStream inContext = HistoryDelete.class
					.getClassLoader().getResourceAsStream(
							"ovirt_engine_dwh/historydelete_3_5/contexts/"
									+ contextStr + ".properties");
			if (isDefaultContext && inContext == null) {

			} else {
				if (inContext != null) {
					// defaultProps is in order to keep the original context
					// value
					defaultProps.load(inContext);
					inContext.close();
					context = new ContextProperties(defaultProps);
				} else {
					// print info and job continue to run, for case:
					// context_param is not empty.
					System.err.println("Could not find the context "
							+ contextStr);
				}
			}

			if (!context_param.isEmpty()) {
				context.putAll(context_param);
			}
			try {
				context.hoursToKeepDaily = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepDaily"));
			} catch (NumberFormatException e) {
				context.hoursToKeepDaily = null;
			}
			try {
				context.hoursToKeepHourly = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepHourly"));
			} catch (NumberFormatException e) {
				context.hoursToKeepHourly = null;
			}
			try {
				context.hoursToKeepSamples = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepSamples"));
			} catch (NumberFormatException e) {
				context.hoursToKeepSamples = null;
			}
			context.ovirtEngineHistoryDbDriverClass = (String) context
					.getProperty("ovirtEngineHistoryDbDriverClass");
			context.ovirtEngineHistoryDbJdbcConnection = (String) context
					.getProperty("ovirtEngineHistoryDbJdbcConnection");
			context.ovirtEngineHistoryDbPassword = (java.lang.String) context
					.getProperty("ovirtEngineHistoryDbPassword");
			context.ovirtEngineHistoryDbUser = (String) context
					.getProperty("ovirtEngineHistoryDbUser");
			try {
				String context_runTime_value = context.getProperty("runTime");
				if (context_runTime_value == null) {
					context_runTime_value = "";
				}
				int context_runTime_pos = context_runTime_value.indexOf(";");
				String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_runTime_pos > -1) {
					context_runTime_pattern = context_runTime_value.substring(
							0, context_runTime_pos);
					context_runTime_value = context_runTime_value
							.substring(context_runTime_pos + 1);
				}

				context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
						context_runTime_pattern).parse(context_runTime_value));

			} catch (ParseException e) {
				context.runTime = null;
			}
			context.limitRows = (String) context.getProperty("limitRows");
		} catch (java.io.IOException ie) {
			System.err.println("Could not load context " + contextStr);
			ie.printStackTrace();
		}

		// get context value from parent directly
		if (parentContextMap != null && !parentContextMap.isEmpty()) {
			if (parentContextMap.containsKey("hoursToKeepDaily")) {
				context.hoursToKeepDaily = (Integer) parentContextMap
						.get("hoursToKeepDaily");
			}
			if (parentContextMap.containsKey("hoursToKeepHourly")) {
				context.hoursToKeepHourly = (Integer) parentContextMap
						.get("hoursToKeepHourly");
			}
			if (parentContextMap.containsKey("hoursToKeepSamples")) {
				context.hoursToKeepSamples = (Integer) parentContextMap
						.get("hoursToKeepSamples");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbDriverClass")) {
				context.ovirtEngineHistoryDbDriverClass = (String) parentContextMap
						.get("ovirtEngineHistoryDbDriverClass");
			}
			if (parentContextMap
					.containsKey("ovirtEngineHistoryDbJdbcConnection")) {
				context.ovirtEngineHistoryDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineHistoryDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbPassword")) {
				context.ovirtEngineHistoryDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineHistoryDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbUser")) {
				context.ovirtEngineHistoryDbUser = (String) parentContextMap
						.get("ovirtEngineHistoryDbUser");
			}
			if (parentContextMap.containsKey("runTime")) {
				context.runTime = (java.util.Date) parentContextMap
						.get("runTime");
			}
			if (parentContextMap.containsKey("limitRows")) {
				context.limitRows = (String) parentContextMap.get("limitRows");
			}
		}

		// Resume: init the resumeUtil
		resumeEntryMethodName = ResumeUtil
				.getResumeEntryMethodName(resuming_checkpoint_path);
		resumeUtil = new ResumeUtil(resuming_logs_dir_path, isChildJob, rootPid);
		resumeUtil.initCommonInfo(pid, rootPid, fatherPid, projectName,
				jobName, contextStr, jobVersion);

		// Resume: jobStart
		resumeUtil.addLog("JOB_STARTED", "JOB:" + jobName,
				parent_part_launcher, Thread.currentThread().getId() + "", "",
				"", "", "", resumeUtil.convertToJsonText(context));

		java.util.concurrent.ConcurrentHashMap<Object, Object> concurrentHashMap = new java.util.concurrent.ConcurrentHashMap<Object, Object>();
		globalMap.put("concurrentHashMap", concurrentHashMap);

		long startUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		long endUsedMemory = 0;
		long end = 0;

		startTime = System.currentTimeMillis();

		this.globalResumeTicket = true;// to run tPreJob

		try {
			errorCode = null;
			tPrejob_1Process(globalMap);
			if (!"failure".equals(status)) {
				status = "end";
			}
		} catch (TalendException e_tPrejob_1) {
			globalMap.put("tPrejob_1_SUBPROCESS_STATE", -1);

			e_tPrejob_1.printStackTrace();

		}

		this.globalResumeTicket = false;// to run others jobs

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_1Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_1) {
					globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", -1);

					e_tJDBCInput_1.printStackTrace();

				} catch (Error e_tJDBCInput_1) {
					globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", -1);

					e_tJDBCInput_1.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_2Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_2) {
					globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", -1);

					e_tJDBCInput_2.printStackTrace();

				} catch (Error e_tJDBCInput_2) {
					globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", -1);

					e_tJDBCInput_2.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_3Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_3) {
					globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", -1);

					e_tJDBCInput_3.printStackTrace();

				} catch (Error e_tJDBCInput_3) {
					globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", -1);

					e_tJDBCInput_3.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_4Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_4) {
					globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", -1);

					e_tJDBCInput_4.printStackTrace();

				} catch (Error e_tJDBCInput_4) {
					globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", -1);

					e_tJDBCInput_4.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_5Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_5) {
					globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", -1);

					e_tJDBCInput_5.printStackTrace();

				} catch (Error e_tJDBCInput_5) {
					globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", -1);

					e_tJDBCInput_5.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_6Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_6) {
					globalMap.put("tJDBCInput_6_SUBPROCESS_STATE", -1);

					e_tJDBCInput_6.printStackTrace();

				} catch (Error e_tJDBCInput_6) {
					globalMap.put("tJDBCInput_6_SUBPROCESS_STATE", -1);

					e_tJDBCInput_6.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_7Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_7) {
					globalMap.put("tJDBCInput_7_SUBPROCESS_STATE", -1);

					e_tJDBCInput_7.printStackTrace();

				} catch (Error e_tJDBCInput_7) {
					globalMap.put("tJDBCInput_7_SUBPROCESS_STATE", -1);

					e_tJDBCInput_7.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_8Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_8) {
					globalMap.put("tJDBCInput_8_SUBPROCESS_STATE", -1);

					e_tJDBCInput_8.printStackTrace();

				} catch (Error e_tJDBCInput_8) {
					globalMap.put("tJDBCInput_8_SUBPROCESS_STATE", -1);

					e_tJDBCInput_8.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_9Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_9) {
					globalMap.put("tJDBCInput_9_SUBPROCESS_STATE", -1);

					e_tJDBCInput_9.printStackTrace();

				} catch (Error e_tJDBCInput_9) {
					globalMap.put("tJDBCInput_9_SUBPROCESS_STATE", -1);

					e_tJDBCInput_9.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_10Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_10) {
					globalMap.put("tJDBCInput_10_SUBPROCESS_STATE", -1);

					e_tJDBCInput_10.printStackTrace();

				} catch (Error e_tJDBCInput_10) {
					globalMap.put("tJDBCInput_10_SUBPROCESS_STATE", -1);

					e_tJDBCInput_10.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_11Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_11) {
					globalMap.put("tJDBCInput_11_SUBPROCESS_STATE", -1);

					e_tJDBCInput_11.printStackTrace();

				} catch (Error e_tJDBCInput_11) {
					globalMap.put("tJDBCInput_11_SUBPROCESS_STATE", -1);

					e_tJDBCInput_11.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_12Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_12) {
					globalMap.put("tJDBCInput_12_SUBPROCESS_STATE", -1);

					e_tJDBCInput_12.printStackTrace();

				} catch (Error e_tJDBCInput_12) {
					globalMap.put("tJDBCInput_12_SUBPROCESS_STATE", -1);

					e_tJDBCInput_12.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_13Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_13) {
					globalMap.put("tJDBCInput_13_SUBPROCESS_STATE", -1);

					e_tJDBCInput_13.printStackTrace();

				} catch (Error e_tJDBCInput_13) {
					globalMap.put("tJDBCInput_13_SUBPROCESS_STATE", -1);

					e_tJDBCInput_13.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_14Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_14) {
					globalMap.put("tJDBCInput_14_SUBPROCESS_STATE", -1);

					e_tJDBCInput_14.printStackTrace();

				} catch (Error e_tJDBCInput_14) {
					globalMap.put("tJDBCInput_14_SUBPROCESS_STATE", -1);

					e_tJDBCInput_14.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_15Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_15) {
					globalMap.put("tJDBCInput_15_SUBPROCESS_STATE", -1);

					e_tJDBCInput_15.printStackTrace();

				} catch (Error e_tJDBCInput_15) {
					globalMap.put("tJDBCInput_15_SUBPROCESS_STATE", -1);

					e_tJDBCInput_15.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_16Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_16) {
					globalMap.put("tJDBCInput_16_SUBPROCESS_STATE", -1);

					e_tJDBCInput_16.printStackTrace();

				} catch (Error e_tJDBCInput_16) {
					globalMap.put("tJDBCInput_16_SUBPROCESS_STATE", -1);

					e_tJDBCInput_16.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_17Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_17) {
					globalMap.put("tJDBCInput_17_SUBPROCESS_STATE", -1);

					e_tJDBCInput_17.printStackTrace();

				} catch (Error e_tJDBCInput_17) {
					globalMap.put("tJDBCInput_17_SUBPROCESS_STATE", -1);

					e_tJDBCInput_17.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_18Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_18) {
					globalMap.put("tJDBCInput_18_SUBPROCESS_STATE", -1);

					e_tJDBCInput_18.printStackTrace();

				} catch (Error e_tJDBCInput_18) {
					globalMap.put("tJDBCInput_18_SUBPROCESS_STATE", -1);

					e_tJDBCInput_18.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_19Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_19) {
					globalMap.put("tJDBCInput_19_SUBPROCESS_STATE", -1);

					e_tJDBCInput_19.printStackTrace();

				} catch (Error e_tJDBCInput_19) {
					globalMap.put("tJDBCInput_19_SUBPROCESS_STATE", -1);

					e_tJDBCInput_19.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_20Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_20) {
					globalMap.put("tJDBCInput_20_SUBPROCESS_STATE", -1);

					e_tJDBCInput_20.printStackTrace();

				} catch (Error e_tJDBCInput_20) {
					globalMap.put("tJDBCInput_20_SUBPROCESS_STATE", -1);

					e_tJDBCInput_20.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_21Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_21) {
					globalMap.put("tJDBCInput_21_SUBPROCESS_STATE", -1);

					e_tJDBCInput_21.printStackTrace();

				} catch (Error e_tJDBCInput_21) {
					globalMap.put("tJDBCInput_21_SUBPROCESS_STATE", -1);

					e_tJDBCInput_21.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_22Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_22) {
					globalMap.put("tJDBCInput_22_SUBPROCESS_STATE", -1);

					e_tJDBCInput_22.printStackTrace();

				} catch (Error e_tJDBCInput_22) {
					globalMap.put("tJDBCInput_22_SUBPROCESS_STATE", -1);

					e_tJDBCInput_22.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_23Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_23) {
					globalMap.put("tJDBCInput_23_SUBPROCESS_STATE", -1);

					e_tJDBCInput_23.printStackTrace();

				} catch (Error e_tJDBCInput_23) {
					globalMap.put("tJDBCInput_23_SUBPROCESS_STATE", -1);

					e_tJDBCInput_23.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_24Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_24) {
					globalMap.put("tJDBCInput_24_SUBPROCESS_STATE", -1);

					e_tJDBCInput_24.printStackTrace();

				} catch (Error e_tJDBCInput_24) {
					globalMap.put("tJDBCInput_24_SUBPROCESS_STATE", -1);

					e_tJDBCInput_24.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_25Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_25) {
					globalMap.put("tJDBCInput_25_SUBPROCESS_STATE", -1);

					e_tJDBCInput_25.printStackTrace();

				} catch (Error e_tJDBCInput_25) {
					globalMap.put("tJDBCInput_25_SUBPROCESS_STATE", -1);

					e_tJDBCInput_25.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCInput_26Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCInput_26) {
					globalMap.put("tJDBCInput_26_SUBPROCESS_STATE", -1);

					e_tJDBCInput_26.printStackTrace();

				} catch (Error e_tJDBCInput_26) {
					globalMap.put("tJDBCInput_26_SUBPROCESS_STATE", -1);

					e_tJDBCInput_26.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		while (runningThreadCount.getCount() > 0) {
			try {
				Thread.sleep(10);
			} catch (java.lang.Exception e) {
				e.printStackTrace();
			}
		}

		this.globalResumeTicket = true;// to run tPostJob

		end = System.currentTimeMillis();

		if (watch) {
			System.out.println((end - startTime) + " milliseconds");
		}

		endUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		if (false) {
			System.out.println((endUsedMemory - startUsedMemory)
					+ " bytes memory increase when running : HistoryDelete");
		}

		int returnCode = 0;
		if (errorCode == null) {
			returnCode = status != null && status.equals("failure") ? 1 : 0;
		} else {
			returnCode = errorCode.intValue();
		}
		resumeUtil.addLog("JOB_ENDED", "JOB:" + jobName, parent_part_launcher,
				Thread.currentThread().getId() + "", "", "" + returnCode, "",
				"", "");

		return returnCode;

	}

	public void destroy() {

	}

	private java.util.Map<String, Object> getSharedConnections4REST() {
		java.util.Map<String, Object> connections = new java.util.HashMap<String, Object>();
		return connections;
	}

	private void evalParam(String arg) {
		if (arg.startsWith("--resuming_logs_dir_path")) {
			resuming_logs_dir_path = arg.substring(25);
		} else if (arg.startsWith("--resuming_checkpoint_path")) {
			resuming_checkpoint_path = arg.substring(27);
		} else if (arg.startsWith("--parent_part_launcher")) {
			parent_part_launcher = arg.substring(23);
		} else if (arg.startsWith("--watch")) {
			watch = true;
		} else if (arg.startsWith("--stat_port=")) {
			String portStatsStr = arg.substring(12);
			if (portStatsStr != null && !portStatsStr.equals("null")) {
				portStats = Integer.parseInt(portStatsStr);
			}
		} else if (arg.startsWith("--trace_port=")) {
			portTraces = Integer.parseInt(arg.substring(13));
		} else if (arg.startsWith("--client_host=")) {
			clientHost = arg.substring(14);
		} else if (arg.startsWith("--context=")) {
			contextStr = arg.substring(10);
			isDefaultContext = false;
		} else if (arg.startsWith("--father_pid=")) {
			fatherPid = arg.substring(13);
		} else if (arg.startsWith("--root_pid=")) {
			rootPid = arg.substring(11);
		} else if (arg.startsWith("--father_node=")) {
			fatherNode = arg.substring(14);
		} else if (arg.startsWith("--pid=")) {
			pid = arg.substring(6);
		} else if (arg.startsWith("--context_param")) {
			String keyValue = arg.substring(16);
			int index = -1;
			if (keyValue != null && (index = keyValue.indexOf('=')) > -1) {
				if (fatherPid == null) {
					context_param.put(keyValue.substring(0, index),
							replaceEscapeChars(keyValue.substring(index + 1)));
				} else { // the subjob won't escape the especial chars
					context_param.put(keyValue.substring(0, index),
							keyValue.substring(index + 1));
				}
			}
		} else if (arg.startsWith("--log4jLevel=")) {
			log4jLevel = arg.substring(13);
		}

	}

	private final String[][] escapeChars = { { "\\n", "\n" }, { "\\'", "\'" },
			{ "\\r", "\r" }, { "\\f", "\f" }, { "\\b", "\b" }, { "\\t", "\t" },
			{ "\\\\", "\\" } };

	private String replaceEscapeChars(String keyValue) {
		if (keyValue == null || ("").equals(keyValue.trim())) {
			return keyValue;
		}
		for (String[] strArray : escapeChars) {
			keyValue = keyValue.replace(strArray[0], strArray[1]);
		}
		return keyValue;
	}

	public Integer getErrorCode() {
		return errorCode;
	}

	public String getStatus() {
		return status;
	}

	ResumeUtil resumeUtil = null;
}
/************************************************************************************************
 * 388492 characters generated by Talend Open Studio for Data Integration on the
 * June 7, 2015 12:43:20 PM IDT
 ************************************************************************************************/
