// ============================================================================
//
// Copyright (c) 2006-2013, Talend Inc.
//
// This source code has been automatically generated by_Talend Open Studio for Data Integration
// / Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package ovirt_engine_dwh.osenumupdate_3_5;

import routines.Mathematical;
import routines.DataOperation;
import routines.Relational;
import routines.TalendDate;
import routines.TalendDataGenerator;
import routines.RoutineHistoryETL;
import routines.Numeric;
import routines.TalendString;
import routines.StringHandling;
import routines.system.*;
import routines.system.api.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.math.BigDecimal;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.util.Comparator;

@SuppressWarnings("unused")
/**
 * Job: OsEnumUpdate Purpose: <br>
 * Description:  <br>
 * @author test@talend.com
 * @version 5.4.1.r111943
 * @status 
 */
public class OsEnumUpdate implements TalendJob {

	public final Object obj = new Object();

	// for transmiting parameters purpose
	private Object valueObject = null;

	public Object getValueObject() {
		return this.valueObject;
	}

	public void setValueObject(Object valueObject) {
		this.valueObject = valueObject;
	}

	private final static String defaultCharset = java.nio.charset.Charset
			.defaultCharset().name();

	private final static String utf8Charset = "UTF-8";

	// create and load default properties
	private java.util.Properties defaultProps = new java.util.Properties();

	// create application properties with default
	public class ContextProperties extends java.util.Properties {

		private static final long serialVersionUID = 1L;

		public ContextProperties(java.util.Properties properties) {
			super(properties);
		}

		public ContextProperties() {
			super();
		}

		public void synchronizeContext() {

			if (ovirtEngineDbDriverClass != null) {

				this.setProperty("ovirtEngineDbDriverClass",
						ovirtEngineDbDriverClass.toString());

			}

			if (ovirtEngineDbJdbcConnection != null) {

				this.setProperty("ovirtEngineDbJdbcConnection",
						ovirtEngineDbJdbcConnection.toString());

			}

			if (ovirtEngineDbPassword != null) {

				this.setProperty("ovirtEngineDbPassword",
						ovirtEngineDbPassword.toString());

			}

			if (ovirtEngineDbUser != null) {

				this.setProperty("ovirtEngineDbUser",
						ovirtEngineDbUser.toString());

			}

			if (ovirtEngineHistoryDbDriverClass != null) {

				this.setProperty("ovirtEngineHistoryDbDriverClass",
						ovirtEngineHistoryDbDriverClass.toString());

			}

			if (ovirtEngineHistoryDbJdbcConnection != null) {

				this.setProperty("ovirtEngineHistoryDbJdbcConnection",
						ovirtEngineHistoryDbJdbcConnection.toString());

			}

			if (ovirtEngineHistoryDbPassword != null) {

				this.setProperty("ovirtEngineHistoryDbPassword",
						ovirtEngineHistoryDbPassword.toString());

			}

			if (ovirtEngineHistoryDbUser != null) {

				this.setProperty("ovirtEngineHistoryDbUser",
						ovirtEngineHistoryDbUser.toString());

			}

			if (runTime != null) {

				String pattern_runTime = "yyyy-MM-dd HH:mm:ss";
				String value_runTime = "yyyy-MM-dd HH:mm:ss.SSSSSS;2011-07-03 12:46:47.000000";
				String[] parts_runTime = value_runTime.split(";");
				if (parts_runTime.length > 1) {
					pattern_runTime = parts_runTime[0];
					this.setProperty(
							"runTime",
							pattern_runTime
									+ ";"
									+ FormatterUtils.format_Date(runTime,
											pattern_runTime));
				} else {
					this.setProperty("runTime", FormatterUtils.format_Date(
							runTime, pattern_runTime));
				}

			}

			if (lastOsinfoUpdate != null) {

				String pattern_lastOsinfoUpdate = "yyyy-MM-dd HH:mm:ss";
				String value_lastOsinfoUpdate = "";
				String[] parts_lastOsinfoUpdate = value_lastOsinfoUpdate
						.split(";");
				if (parts_lastOsinfoUpdate.length > 1) {
					pattern_lastOsinfoUpdate = parts_lastOsinfoUpdate[0];
					this.setProperty(
							"lastOsinfoUpdate",
							pattern_lastOsinfoUpdate
									+ ";"
									+ FormatterUtils.format_Date(
											lastOsinfoUpdate,
											pattern_lastOsinfoUpdate));
				} else {
					this.setProperty("lastOsinfoUpdate", FormatterUtils
							.format_Date(lastOsinfoUpdate,
									pattern_lastOsinfoUpdate));
				}

			}

			if (lastOsinfoSync != null) {

				String pattern_lastOsinfoSync = "yyyy-MM-dd HH:mm:ss";
				String value_lastOsinfoSync = "yyyy-MM-dd HH:mm:ss;2000-01-01 00:00:00";
				String[] parts_lastOsinfoSync = value_lastOsinfoSync.split(";");
				if (parts_lastOsinfoSync.length > 1) {
					pattern_lastOsinfoSync = parts_lastOsinfoSync[0];
					this.setProperty(
							"lastOsinfoSync",
							pattern_lastOsinfoSync
									+ ";"
									+ FormatterUtils.format_Date(
											lastOsinfoSync,
											pattern_lastOsinfoSync));
				} else {
					this.setProperty("lastOsinfoSync",
							FormatterUtils.format_Date(lastOsinfoSync,
									pattern_lastOsinfoSync));
				}

			}

		}

		public String ovirtEngineDbDriverClass;

		public String getOvirtEngineDbDriverClass() {
			return this.ovirtEngineDbDriverClass;
		}

		public String ovirtEngineDbJdbcConnection;

		public String getOvirtEngineDbJdbcConnection() {
			return this.ovirtEngineDbJdbcConnection;
		}

		public java.lang.String ovirtEngineDbPassword;

		public java.lang.String getOvirtEngineDbPassword() {
			return this.ovirtEngineDbPassword;
		}

		public String ovirtEngineDbUser;

		public String getOvirtEngineDbUser() {
			return this.ovirtEngineDbUser;
		}

		public String ovirtEngineHistoryDbDriverClass;

		public String getOvirtEngineHistoryDbDriverClass() {
			return this.ovirtEngineHistoryDbDriverClass;
		}

		public String ovirtEngineHistoryDbJdbcConnection;

		public String getOvirtEngineHistoryDbJdbcConnection() {
			return this.ovirtEngineHistoryDbJdbcConnection;
		}

		public java.lang.String ovirtEngineHistoryDbPassword;

		public java.lang.String getOvirtEngineHistoryDbPassword() {
			return this.ovirtEngineHistoryDbPassword;
		}

		public String ovirtEngineHistoryDbUser;

		public String getOvirtEngineHistoryDbUser() {
			return this.ovirtEngineHistoryDbUser;
		}

		public java.util.Date runTime;

		public java.util.Date getRunTime() {
			return this.runTime;
		}

		public java.util.Date lastOsinfoUpdate;

		public java.util.Date getLastOsinfoUpdate() {
			return this.lastOsinfoUpdate;
		}

		public java.util.Date lastOsinfoSync;

		public java.util.Date getLastOsinfoSync() {
			return this.lastOsinfoSync;
		}
	}

	private ContextProperties context = new ContextProperties();

	public ContextProperties getContext() {
		return this.context;
	}

	private final String jobVersion = "3.5";
	private final String jobName = "OsEnumUpdate";
	private final String projectName = "OVIRT_ENGINE_DWH";
	public Integer errorCode = null;
	private String currentComponent = "";

	private final java.util.Map<String, Object> globalMap = new java.util.HashMap<String, Object>();

	private final java.util.Map<String, Long> start_Hash = new java.util.HashMap<String, Long>();
	private final java.util.Map<String, Long> end_Hash = new java.util.HashMap<String, Long>();
	private final java.util.Map<String, Boolean> ok_Hash = new java.util.HashMap<String, Boolean>();
	public final java.util.List<String[]> globalBuffer = new java.util.ArrayList<String[]>();

	public boolean isExportedAsOSGI = false;

	// OSGi DataSource
	private final static String KEY_DB_DATASOURCES = "KEY_DB_DATASOURCES";

	public void setDataSources(
			java.util.Map<String, javax.sql.DataSource> dataSources) {
		java.util.Map<String, routines.system.TalendDataSource> talendDataSources = new java.util.HashMap<String, routines.system.TalendDataSource>();
		for (java.util.Map.Entry<String, javax.sql.DataSource> dataSourceEntry : dataSources
				.entrySet()) {
			talendDataSources.put(
					dataSourceEntry.getKey(),
					new routines.system.TalendDataSource(dataSourceEntry
							.getValue()));
		}
		globalMap.put(KEY_DB_DATASOURCES, talendDataSources);
	}

	LogCatcherUtils talendLogs_LOGS = new LogCatcherUtils();

	private final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
	private final java.io.PrintStream errorMessagePS = new java.io.PrintStream(
			new java.io.BufferedOutputStream(baos));

	public String getExceptionStackTrace() {
		if ("failure".equals(this.getStatus())) {
			errorMessagePS.flush();
			return baos.toString();
		}
		return null;
	}

	private java.lang.Exception exception = null;

	public java.lang.Exception getException() {
		if ("failure".equals(this.getStatus())) {
			return this.exception;
		}
		return null;
	}

	private class TalendException extends java.lang.Exception {

		private static final long serialVersionUID = 1L;

		private java.util.Map<String, Object> globalMap = null;
		private java.lang.Exception e = null;
		private String currentComponent = null;
		private String virtualComponentName = null;

		public void setVirtualComponentName(String virtualComponentName) {
			this.virtualComponentName = virtualComponentName;
		}

		private TalendException(java.lang.Exception e, String errorComponent,
				final java.util.Map<String, Object> globalMap) {
			this.currentComponent = errorComponent;
			this.globalMap = globalMap;
			this.e = e;
		}

		public java.lang.Exception getException() {
			return this.e;
		}

		public String getCurrentComponent() {
			return this.currentComponent;
		}

		public String getExceptionCauseMessage(java.lang.Exception e) {
			Throwable cause = e;
			String message = null;
			int i = 10;
			while (null != cause && 0 < i--) {
				message = cause.getMessage();
				if (null == message) {
					cause = cause.getCause();
				} else {
					break;
				}
			}
			if (null == message) {
				message = e.getClass().getName();
			}
			return message;
		}

		@Override
		public void printStackTrace() {
			if (!(e instanceof TalendException || e instanceof TDieException)) {
				if (virtualComponentName != null
						&& currentComponent.indexOf(virtualComponentName + "_") == 0) {
					globalMap.put(virtualComponentName + "_ERROR_MESSAGE",
							getExceptionCauseMessage(e));
				}
				globalMap.put(currentComponent + "_ERROR_MESSAGE",
						getExceptionCauseMessage(e));
				System.err
						.println("Exception in component " + currentComponent);
			}
			if (!(e instanceof TDieException)) {
				if (e instanceof TalendException) {
					e.printStackTrace();
				} else {
					e.printStackTrace();
					e.printStackTrace(errorMessagePS);
					OsEnumUpdate.this.exception = e;
				}
			}
			if (!(e instanceof TalendException)) {
				try {
					for (java.lang.reflect.Method m : this.getClass()
							.getEnclosingClass().getMethods()) {
						if (m.getName().compareTo(currentComponent + "_error") == 0) {
							m.invoke(OsEnumUpdate.this, new Object[] { e,
									currentComponent, globalMap });
							break;
						}
					}

					if (!(e instanceof TDieException)) {
						talendLogs_LOGS.addMessage("Java Exception",
								currentComponent, 6, e.getClass().getName()
										+ ":" + e.getMessage(), 1);
						talendLogs_LOGSProcess(globalMap);
					}
				} catch (java.lang.SecurityException e) {
					this.e.printStackTrace();
				} catch (java.lang.IllegalArgumentException e) {
					this.e.printStackTrace();
				} catch (java.lang.IllegalAccessException e) {
					this.e.printStackTrace();
				} catch (java.lang.reflect.InvocationTargetException e) {
					this.e.printStackTrace();
				} catch (TalendException e) {
					// do nothing
				}

			}
		}
	}

	public void tJDBCConnection_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

		status = "failure";

		tJDBCConnection_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

		status = "failure";

		tJDBCConnection_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_4_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_4", System.currentTimeMillis());

		status = "failure";

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tContextLoad_1", System.currentTimeMillis());

		status = "failure";

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRowGenerator_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tRowGenerator_1", System.currentTimeMillis());

		status = "failure";

		tRowGenerator_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

		status = "failure";

		tRowGenerator_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_2", System.currentTimeMillis());

		status = "failure";

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

		status = "failure";

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_5_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_5", System.currentTimeMillis());

		status = "failure";

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_3", System.currentTimeMillis());

		status = "failure";

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

		status = "failure";

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_LOGS_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

		status = "failure";

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_CONSOLE_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("talendLogs_CONSOLE", System.currentTimeMillis());

		status = "failure";

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_4_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tRowGenerator_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_5_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void talendLogs_LOGS_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_2 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_2", false);
				start_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_2";

				int tos_count_tJDBCConnection_2 = 0;

				String url_tJDBCConnection_2 = context.ovirtEngineDbJdbcConnection;

				String userName_tJDBCConnection_2 = context.ovirtEngineDbUser;
				String password_tJDBCConnection_2 = context.ovirtEngineDbPassword;

				java.sql.Connection conn_tJDBCConnection_2 = null;

				String sharedConnectionName_tJDBCConnection_2 = "engine";
				conn_tJDBCConnection_2 = SharedDBConnection.getDBConnection(
						context.ovirtEngineDbDriverClass,
						url_tJDBCConnection_2, userName_tJDBCConnection_2,
						password_tJDBCConnection_2,
						sharedConnectionName_tJDBCConnection_2);
				if (null != conn_tJDBCConnection_2) {

					conn_tJDBCConnection_2.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_2", conn_tJDBCConnection_2);
				globalMap.put("url_tJDBCConnection_2", url_tJDBCConnection_2);
				// globalMap.put("user_tJDBCConnection_2",
				// userName_tJDBCConnection_2);
				// globalMap.put("pass_tJDBCConnection_2",
				// password_tJDBCConnection_2);

				/**
				 * [tJDBCConnection_2 begin ] stop
				 */
				/**
				 * [tJDBCConnection_2 main ] start
				 */

				currentComponent = "tJDBCConnection_2";

				tos_count_tJDBCConnection_2++;

				/**
				 * [tJDBCConnection_2 main ] stop
				 */
				/**
				 * [tJDBCConnection_2 end ] start
				 */

				currentComponent = "tJDBCConnection_2";

				ok_Hash.put("tJDBCConnection_2", true);
				end_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

				tJDBCConnection_1Process(globalMap);

				/**
				 * [tJDBCConnection_2 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_2 finally ] start
				 */

				currentComponent = "tJDBCConnection_2";

				/**
				 * [tJDBCConnection_2 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_1 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_1", false);
				start_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_1";

				int tos_count_tJDBCConnection_1 = 0;

				String url_tJDBCConnection_1 = context.ovirtEngineHistoryDbJdbcConnection;

				String userName_tJDBCConnection_1 = context.ovirtEngineHistoryDbUser;
				String password_tJDBCConnection_1 = context.ovirtEngineHistoryDbPassword;

				java.sql.Connection conn_tJDBCConnection_1 = null;

				String sharedConnectionName_tJDBCConnection_1 = "sample_ovirt_engine_history";
				conn_tJDBCConnection_1 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_1, userName_tJDBCConnection_1,
						password_tJDBCConnection_1,
						sharedConnectionName_tJDBCConnection_1);
				if (null != conn_tJDBCConnection_1) {

					conn_tJDBCConnection_1.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_1", conn_tJDBCConnection_1);
				globalMap.put("url_tJDBCConnection_1", url_tJDBCConnection_1);
				// globalMap.put("user_tJDBCConnection_1",
				// userName_tJDBCConnection_1);
				// globalMap.put("pass_tJDBCConnection_1",
				// password_tJDBCConnection_1);

				/**
				 * [tJDBCConnection_1 begin ] stop
				 */
				/**
				 * [tJDBCConnection_1 main ] start
				 */

				currentComponent = "tJDBCConnection_1";

				tos_count_tJDBCConnection_1++;

				/**
				 * [tJDBCConnection_1 main ] stop
				 */
				/**
				 * [tJDBCConnection_1 end ] start
				 */

				currentComponent = "tJDBCConnection_1";

				ok_Hash.put("tJDBCConnection_1", true);
				end_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				/**
				 * [tJDBCConnection_1 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil.addLog("CHECKPOINT",
						"CONNECTION:SUBJOB_OK:tJDBCConnection_1:OnSubjobOk",
						"", Thread.currentThread().getId() + "", "", "", "",
						"", "");
			}

			tJDBCInput_4Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_1 finally ] start
				 */

				currentComponent = "tJDBCConnection_1";

				/**
				 * [tJDBCConnection_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 1);
	}

	public static class row3Struct implements
			routines.system.IPersistableRow<row3Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public java.util.Date value;

		public java.util.Date getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_OsEnumUpdate) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// java.util.Date

				writeDate(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + String.valueOf(value));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row3Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_4Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row3Struct row3 = new row3Struct();

				/**
				 * [tContextLoad_1 begin ] start
				 */

				ok_Hash.put("tContextLoad_1", false);
				start_Hash.put("tContextLoad_1", System.currentTimeMillis());

				currentComponent = "tContextLoad_1";

				int tos_count_tContextLoad_1 = 0;

				java.util.List<String> assignList_tContextLoad_1 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_1 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_1 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_1 = 0;

				/**
				 * [tContextLoad_1 begin ] stop
				 */

				/**
				 * [tJDBCInput_4 begin ] start
				 */

				ok_Hash.put("tJDBCInput_4", false);
				start_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				currentComponent = "tJDBCInput_4";

				int tos_count_tJDBCInput_4 = 0;

				int nb_line_tJDBCInput_4 = 0;
				java.sql.Connection conn_tJDBCInput_4 = null;
				conn_tJDBCInput_4 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_4 = conn_tJDBCInput_4
						.createStatement();

				String dbquery_tJDBCInput_4 = "SELECT var_name, var_datetime  FROM  dwh_history_timekeeping  where var_name = 'lastOsinfoUpdate'       OR var_name = 'lastOsinfoSync'";

				globalMap.put("tJDBCInput_4_QUERY", dbquery_tJDBCInput_4);
				java.sql.ResultSet rs_tJDBCInput_4 = null;
				try {
					rs_tJDBCInput_4 = stmt_tJDBCInput_4
							.executeQuery(dbquery_tJDBCInput_4);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_4 = rs_tJDBCInput_4
							.getMetaData();
					int colQtyInRs_tJDBCInput_4 = rsmd_tJDBCInput_4
							.getColumnCount();

					String tmpContent_tJDBCInput_4 = null;
					int column_index_tJDBCInput_4 = 1;

					while (rs_tJDBCInput_4.next()) {
						nb_line_tJDBCInput_4++;

						column_index_tJDBCInput_4 = 1;

						if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
							row3.key = null;
						} else {

							tmpContent_tJDBCInput_4 = rs_tJDBCInput_4
									.getString(column_index_tJDBCInput_4);
							if (tmpContent_tJDBCInput_4 != null) {
								row3.key = tmpContent_tJDBCInput_4;
							} else {
								row3.key = null;
							}

						}

						column_index_tJDBCInput_4 = 2;

						if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
							row3.value = null;
						} else {

							java.util.Date date_tJDBCInput_4 = null;
							try {
								date_tJDBCInput_4 = rs_tJDBCInput_4
										.getTimestamp(column_index_tJDBCInput_4);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_4 = rs_tJDBCInput_4
										.getDate(column_index_tJDBCInput_4);
							}
							row3.value = date_tJDBCInput_4;

						}

						/**
						 * [tJDBCInput_4 begin ] stop
						 */
						/**
						 * [tJDBCInput_4 main ] start
						 */

						currentComponent = "tJDBCInput_4";

						tos_count_tJDBCInput_4++;

						/**
						 * [tJDBCInput_4 main ] stop
						 */

						/**
						 * [tContextLoad_1 main ] start
						 */

						currentComponent = "tContextLoad_1";

						// ////////////////////////
						String tmp_key_tContextLoad_1 = null;

						String key_tContextLoad_1 = null;
						if (row3.key != null) {
							tmp_key_tContextLoad_1 = row3.key.trim();
							if ((tmp_key_tContextLoad_1.startsWith("#") || tmp_key_tContextLoad_1
									.startsWith("!"))) {
								tmp_key_tContextLoad_1 = null;
							} else {
								row3.key = tmp_key_tContextLoad_1;
							}
						}
						if (row3.key != null) {

							key_tContextLoad_1 =

							row3.key;

						}

						String value_tContextLoad_1 = null;
						if (row3.value != null) {

							value_tContextLoad_1 =

							FormatterUtils.format_Date(row3.value,
									"yyyy-MM-dd HH:mm:ss.SSSSSS");

						}

						if (tmp_key_tContextLoad_1 != null) {
							try {
								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbPassword = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbUser = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "runTime".equals(key_tContextLoad_1)) {
									String context_runTime_value = context
											.getProperty("runTime");
									if (context_runTime_value == null)
										context_runTime_value = "";
									int context_runTime_pos = context_runTime_value
											.indexOf(";");
									String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_runTime_pos > -1) {
										context_runTime_pattern = context_runTime_value
												.substring(0,
														context_runTime_pos);
									}
									context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
											context_runTime_pattern)
											.parse(value_tContextLoad_1));

								}

								if (key_tContextLoad_1 != null
										&& "lastOsinfoUpdate"
												.equals(key_tContextLoad_1)) {
									String context_lastOsinfoUpdate_value = context
											.getProperty("lastOsinfoUpdate");
									if (context_lastOsinfoUpdate_value == null)
										context_lastOsinfoUpdate_value = "";
									int context_lastOsinfoUpdate_pos = context_lastOsinfoUpdate_value
											.indexOf(";");
									String context_lastOsinfoUpdate_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_lastOsinfoUpdate_pos > -1) {
										context_lastOsinfoUpdate_pattern = context_lastOsinfoUpdate_value
												.substring(0,
														context_lastOsinfoUpdate_pos);
									}
									context.lastOsinfoUpdate = (java.util.Date) (new java.text.SimpleDateFormat(
											context_lastOsinfoUpdate_pattern)
											.parse(value_tContextLoad_1));

								}

								if (key_tContextLoad_1 != null
										&& "lastOsinfoSync"
												.equals(key_tContextLoad_1)) {
									String context_lastOsinfoSync_value = context
											.getProperty("lastOsinfoSync");
									if (context_lastOsinfoSync_value == null)
										context_lastOsinfoSync_value = "";
									int context_lastOsinfoSync_pos = context_lastOsinfoSync_value
											.indexOf(";");
									String context_lastOsinfoSync_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_lastOsinfoSync_pos > -1) {
										context_lastOsinfoSync_pattern = context_lastOsinfoSync_value
												.substring(0,
														context_lastOsinfoSync_pos);
									}
									context.lastOsinfoSync = (java.util.Date) (new java.text.SimpleDateFormat(
											context_lastOsinfoSync_pattern)
											.parse(value_tContextLoad_1));

								}

								if (context.getProperty(key_tContextLoad_1) != null) {
									assignList_tContextLoad_1
											.add(key_tContextLoad_1);
								} else {
									newPropertyList_tContextLoad_1
											.add(key_tContextLoad_1);
								}
								context.setProperty(key_tContextLoad_1,
										value_tContextLoad_1);
							} catch (java.lang.Exception e) {

								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_1
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_1++;

						}
						// ////////////////////////

						tos_count_tContextLoad_1++;

						/**
						 * [tContextLoad_1 main ] stop
						 */

						/**
						 * [tJDBCInput_4 end ] start
						 */

						currentComponent = "tJDBCInput_4";

					}
				} finally {
					rs_tJDBCInput_4.close();
					stmt_tJDBCInput_4.close();

				}
				globalMap.put("tJDBCInput_4_NB_LINE", nb_line_tJDBCInput_4);

				ok_Hash.put("tJDBCInput_4", true);
				end_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				if (TalendDate.compareDate(context.lastOsinfoSync,
						context.lastOsinfoUpdate) < 0) {

					tRowGenerator_1Process(globalMap);
				}

				/**
				 * [tJDBCInput_4 end ] stop
				 */

				/**
				 * [tContextLoad_1 end ] start
				 */

				currentComponent = "tContextLoad_1";

				java.util.Enumeration<?> enu_tContextLoad_1 = context
						.propertyNames();
				while (enu_tContextLoad_1.hasMoreElements()) {
					String key_tContextLoad_1 = (String) enu_tContextLoad_1
							.nextElement();
					if (!assignList_tContextLoad_1.contains(key_tContextLoad_1)
							&& !newPropertyList_tContextLoad_1
									.contains(key_tContextLoad_1)) {
						noAssignList_tContextLoad_1.add(key_tContextLoad_1);
					}
				}

				String newPropertyStr_tContextLoad_1 = newPropertyList_tContextLoad_1
						.toString();
				String newProperty_tContextLoad_1 = newPropertyStr_tContextLoad_1
						.substring(1,
								newPropertyStr_tContextLoad_1.length() - 1);

				String noAssignStr_tContextLoad_1 = noAssignList_tContextLoad_1
						.toString();
				String noAssign_tContextLoad_1 = noAssignStr_tContextLoad_1
						.substring(1, noAssignStr_tContextLoad_1.length() - 1);

				globalMap.put("tContextLoad_1_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_1);
				globalMap.put("tContextLoad_1_KEY_NOT_LOADED",
						noAssign_tContextLoad_1);

				globalMap.put("tContextLoad_1_NB_LINE", nb_line_tContextLoad_1);

				resumeUtil.addLog("NODE", "NODE:tContextLoad_1", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context));

				ok_Hash.put("tContextLoad_1", true);
				end_Hash.put("tContextLoad_1", System.currentTimeMillis());

				/**
				 * [tContextLoad_1 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_4 finally ] start
				 */

				currentComponent = "tJDBCInput_4";

				/**
				 * [tJDBCInput_4 finally ] stop
				 */

				/**
				 * [tContextLoad_1 finally ] start
				 */

				currentComponent = "tContextLoad_1";

				/**
				 * [tContextLoad_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 1);
	}

	public static class row1Struct implements
			routines.system.IPersistableRow<row1Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public String enum_type;

		public String getEnum_type() {
			return this.enum_type;
		}

		public String language_code;

		public String getLanguage_code() {
			return this.language_code;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.enum_type == null) ? 0 : this.enum_type
								.hashCode());

				result = prime
						* result
						+ ((this.language_code == null) ? 0
								: this.language_code.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row1Struct other = (row1Struct) obj;

			if (this.enum_type == null) {
				if (other.enum_type != null)
					return false;

			} else if (!this.enum_type.equals(other.enum_type))

				return false;

			if (this.language_code == null) {
				if (other.language_code != null)
					return false;

			} else if (!this.language_code.equals(other.language_code))

				return false;

			return true;
		}

		public void copyDataTo(row1Struct other) {

			other.enum_type = this.enum_type;
			other.language_code = this.language_code;

		}

		public void copyKeysDataTo(row1Struct other) {

			other.enum_type = this.enum_type;
			other.language_code = this.language_code;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_OsEnumUpdate) {

				try {

					int length = 0;

					this.enum_type = readString(dis);

					this.language_code = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.enum_type, dos);

				// String

				writeString(this.language_code, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("enum_type=" + enum_type);
			sb.append(",language_code=" + language_code);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row1Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.enum_type, other.enum_type);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.language_code,
					other.language_code);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tRowGenerator_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tRowGenerator_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row1Struct row1 = new row1Struct();

				/**
				 * [tJDBCOutput_3 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_3", false);
				start_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_3";

				int tos_count_tJDBCOutput_3 = 0;

				int deleteKeyCount_tJDBCOutput_3 = 2;
				if (deleteKeyCount_tJDBCOutput_3 < 1) {
					throw new RuntimeException(
							"For delete, Schema must have a key");
				}

				int nb_line_tJDBCOutput_3 = 0;
				int nb_line_update_tJDBCOutput_3 = 0;
				int nb_line_inserted_tJDBCOutput_3 = 0;
				int nb_line_deleted_tJDBCOutput_3 = 0;
				int nb_line_rejected_tJDBCOutput_3 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_3 = 0;

				int deletedCount_tJDBCOutput_3 = 0;
				int updatedCount_tJDBCOutput_3 = 0;
				int insertedCount_tJDBCOutput_3 = 0;
				int rejectedCount_tJDBCOutput_3 = 0;

				boolean whetherReject_tJDBCOutput_3 = false;

				java.sql.Connection connection_tJDBCOutput_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_3 = 10000;
				int batchSizeCounter_tJDBCOutput_3 = 0;

				String delete_tJDBCOutput_3 = "DELETE  FROM "
						+ "enum_translator"
						+ " WHERE enum_type = ? AND language_code = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_3 = connection_tJDBCOutput_3
						.prepareStatement(delete_tJDBCOutput_3);

				/**
				 * [tJDBCOutput_3 begin ] stop
				 */

				/**
				 * [tRowGenerator_1 begin ] start
				 */

				ok_Hash.put("tRowGenerator_1", false);
				start_Hash.put("tRowGenerator_1", System.currentTimeMillis());

				currentComponent = "tRowGenerator_1";

				int tos_count_tRowGenerator_1 = 0;

				int nb_line_tRowGenerator_1 = 0;
				int nb_max_row_tRowGenerator_1 = 1;

				class tRowGenerator_1Randomizer {
					public String getRandomenum_type() {

						return "OS_TYPE";

					}

					public String getRandomlanguage_code() {

						return "en_US";

					}
				}
				tRowGenerator_1Randomizer randtRowGenerator_1 = new tRowGenerator_1Randomizer();

				for (int itRowGenerator_1 = 0; itRowGenerator_1 < nb_max_row_tRowGenerator_1; itRowGenerator_1++) {
					row1.enum_type = randtRowGenerator_1.getRandomenum_type();

					row1.language_code = randtRowGenerator_1
							.getRandomlanguage_code();

					nb_line_tRowGenerator_1++;

					/**
					 * [tRowGenerator_1 begin ] stop
					 */
					/**
					 * [tRowGenerator_1 main ] start
					 */

					currentComponent = "tRowGenerator_1";

					tos_count_tRowGenerator_1++;

					/**
					 * [tRowGenerator_1 main ] stop
					 */

					/**
					 * [tJDBCOutput_3 main ] start
					 */

					currentComponent = "tJDBCOutput_3";

					whetherReject_tJDBCOutput_3 = false;
					if (row1.enum_type == null) {
						pstmt_tJDBCOutput_3.setNull(1, java.sql.Types.VARCHAR);
					} else {
						pstmt_tJDBCOutput_3.setString(1, row1.enum_type);
					}

					if (row1.language_code == null) {
						pstmt_tJDBCOutput_3.setNull(2, java.sql.Types.VARCHAR);
					} else {
						pstmt_tJDBCOutput_3.setString(2, row1.language_code);
					}

					try {
						deletedCount_tJDBCOutput_3 = deletedCount_tJDBCOutput_3
								+ pstmt_tJDBCOutput_3.executeUpdate();
					} catch (java.lang.Exception e) {
						whetherReject_tJDBCOutput_3 = true;
						throw (e);
					}

					nb_line_tJDBCOutput_3++;

					tos_count_tJDBCOutput_3++;

					/**
					 * [tJDBCOutput_3 main ] stop
					 */

					/**
					 * [tRowGenerator_1 end ] start
					 */

					currentComponent = "tRowGenerator_1";

				}
				globalMap.put("tRowGenerator_1_NB_LINE",
						nb_line_tRowGenerator_1);

				ok_Hash.put("tRowGenerator_1", true);
				end_Hash.put("tRowGenerator_1", System.currentTimeMillis());

				/**
				 * [tRowGenerator_1 end ] stop
				 */

				/**
				 * [tJDBCOutput_3 end ] start
				 */

				currentComponent = "tJDBCOutput_3";

				if (pstmt_tJDBCOutput_3 != null) {

					pstmt_tJDBCOutput_3.close();

				}

				nb_line_deleted_tJDBCOutput_3 = nb_line_deleted_tJDBCOutput_3
						+ deletedCount_tJDBCOutput_3;
				nb_line_update_tJDBCOutput_3 = nb_line_update_tJDBCOutput_3
						+ updatedCount_tJDBCOutput_3;
				nb_line_inserted_tJDBCOutput_3 = nb_line_inserted_tJDBCOutput_3
						+ insertedCount_tJDBCOutput_3;
				nb_line_rejected_tJDBCOutput_3 = nb_line_rejected_tJDBCOutput_3
						+ rejectedCount_tJDBCOutput_3;

				globalMap.put("tJDBCOutput_3_NB_LINE", nb_line_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_3);

				ok_Hash.put("tJDBCOutput_3", true);
				end_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_3 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tRowGenerator_1:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_2Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tRowGenerator_1 finally ] start
				 */

				currentComponent = "tRowGenerator_1";

				/**
				 * [tRowGenerator_1 finally ] stop
				 */

				/**
				 * [tJDBCOutput_3 finally ] start
				 */

				currentComponent = "tJDBCOutput_3";

				/**
				 * [tJDBCOutput_3 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tRowGenerator_1_SUBPROCESS_STATE", 1);
	}

	public static class row2Struct implements
			routines.system.IPersistableRow<row2Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public String enum_type;

		public String getEnum_type() {
			return this.enum_type;
		}

		public Short enum_key;

		public Short getEnum_key() {
			return this.enum_key;
		}

		public String language_code;

		public String getLanguage_code() {
			return this.language_code;
		}

		public String value;

		public String getValue() {
			return this.value;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.enum_type == null) ? 0 : this.enum_type
								.hashCode());

				result = prime
						* result
						+ ((this.enum_key == null) ? 0 : this.enum_key
								.hashCode());

				result = prime
						* result
						+ ((this.language_code == null) ? 0
								: this.language_code.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row2Struct other = (row2Struct) obj;

			if (this.enum_type == null) {
				if (other.enum_type != null)
					return false;

			} else if (!this.enum_type.equals(other.enum_type))

				return false;

			if (this.enum_key == null) {
				if (other.enum_key != null)
					return false;

			} else if (!this.enum_key.equals(other.enum_key))

				return false;

			if (this.language_code == null) {
				if (other.language_code != null)
					return false;

			} else if (!this.language_code.equals(other.language_code))

				return false;

			return true;
		}

		public void copyDataTo(row2Struct other) {

			other.enum_type = this.enum_type;
			other.enum_key = this.enum_key;
			other.language_code = this.language_code;
			other.value = this.value;

		}

		public void copyKeysDataTo(row2Struct other) {

			other.enum_type = this.enum_type;
			other.enum_key = this.enum_key;
			other.language_code = this.language_code;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_OsEnumUpdate) {

				try {

					int length = 0;

					this.enum_type = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.enum_key = null;
					} else {
						this.enum_key = dis.readShort();
					}

					this.language_code = readString(dis);

					this.value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.enum_type, dos);

				// Short

				if (this.enum_key == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.enum_key);
				}

				// String

				writeString(this.language_code, dos);

				// String

				writeString(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("enum_type=" + enum_type);
			sb.append(",enum_key=" + String.valueOf(enum_key));
			sb.append(",language_code=" + language_code);
			sb.append(",value=" + value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row2Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.enum_type, other.enum_type);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.enum_key, other.enum_key);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.language_code,
					other.language_code);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row2Struct row2 = new row2Struct();

				/**
				 * [tJDBCOutput_1 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_1", false);
				start_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_1";

				int tos_count_tJDBCOutput_1 = 0;

				int nb_line_tJDBCOutput_1 = 0;
				int nb_line_update_tJDBCOutput_1 = 0;
				int nb_line_inserted_tJDBCOutput_1 = 0;
				int nb_line_deleted_tJDBCOutput_1 = 0;
				int nb_line_rejected_tJDBCOutput_1 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_1 = 0;

				int deletedCount_tJDBCOutput_1 = 0;
				int updatedCount_tJDBCOutput_1 = 0;
				int insertedCount_tJDBCOutput_1 = 0;
				int rejectedCount_tJDBCOutput_1 = 0;

				boolean whetherReject_tJDBCOutput_1 = false;

				java.sql.Connection connection_tJDBCOutput_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				int batchSize_tJDBCOutput_1 = 10000;
				int batchSizeCounter_tJDBCOutput_1 = 0;

				String insert_tJDBCOutput_1 = "INSERT INTO "
						+ "enum_translator"
						+ " (enum_type,enum_key,language_code,value) VALUES (?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_1 = connection_tJDBCOutput_1
						.prepareStatement(insert_tJDBCOutput_1);

				/**
				 * [tJDBCOutput_1 begin ] stop
				 */

				/**
				 * [tJDBCInput_2 begin ] start
				 */

				ok_Hash.put("tJDBCInput_2", false);
				start_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				currentComponent = "tJDBCInput_2";

				int tos_count_tJDBCInput_2 = 0;

				int nb_line_tJDBCInput_2 = 0;
				java.sql.Connection conn_tJDBCInput_2 = null;
				conn_tJDBCInput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_2 = conn_tJDBCInput_2
						.createStatement();

				String dbquery_tJDBCInput_2 = "SELECT 'OS_TYPE',         os_id as enum_key,         'en_US',         os_name as value   FROM dwh_osinfo";

				globalMap.put("tJDBCInput_2_QUERY", dbquery_tJDBCInput_2);
				java.sql.ResultSet rs_tJDBCInput_2 = null;
				try {
					rs_tJDBCInput_2 = stmt_tJDBCInput_2
							.executeQuery(dbquery_tJDBCInput_2);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_2 = rs_tJDBCInput_2
							.getMetaData();
					int colQtyInRs_tJDBCInput_2 = rsmd_tJDBCInput_2
							.getColumnCount();

					String tmpContent_tJDBCInput_2 = null;
					int column_index_tJDBCInput_2 = 1;

					while (rs_tJDBCInput_2.next()) {
						nb_line_tJDBCInput_2++;

						column_index_tJDBCInput_2 = 1;

						if (colQtyInRs_tJDBCInput_2 < column_index_tJDBCInput_2) {
							row2.enum_type = null;
						} else {

							tmpContent_tJDBCInput_2 = rs_tJDBCInput_2
									.getString(column_index_tJDBCInput_2);
							if (tmpContent_tJDBCInput_2 != null) {
								row2.enum_type = tmpContent_tJDBCInput_2;
							} else {
								row2.enum_type = null;
							}

						}

						column_index_tJDBCInput_2 = 2;

						if (colQtyInRs_tJDBCInput_2 < column_index_tJDBCInput_2) {
							row2.enum_key = null;
						} else {

							if (rs_tJDBCInput_2
									.getObject(column_index_tJDBCInput_2) != null) {
								row2.enum_key = rs_tJDBCInput_2
										.getShort(column_index_tJDBCInput_2);
							} else {
								row2.enum_key = null;
							}

						}

						column_index_tJDBCInput_2 = 3;

						if (colQtyInRs_tJDBCInput_2 < column_index_tJDBCInput_2) {
							row2.language_code = null;
						} else {

							tmpContent_tJDBCInput_2 = rs_tJDBCInput_2
									.getString(column_index_tJDBCInput_2);
							if (tmpContent_tJDBCInput_2 != null) {
								row2.language_code = tmpContent_tJDBCInput_2;
							} else {
								row2.language_code = null;
							}

						}

						column_index_tJDBCInput_2 = 4;

						if (colQtyInRs_tJDBCInput_2 < column_index_tJDBCInput_2) {
							row2.value = null;
						} else {

							tmpContent_tJDBCInput_2 = rs_tJDBCInput_2
									.getString(column_index_tJDBCInput_2);
							if (tmpContent_tJDBCInput_2 != null) {
								row2.value = tmpContent_tJDBCInput_2;
							} else {
								row2.value = null;
							}

						}

						/**
						 * [tJDBCInput_2 begin ] stop
						 */
						/**
						 * [tJDBCInput_2 main ] start
						 */

						currentComponent = "tJDBCInput_2";

						tos_count_tJDBCInput_2++;

						/**
						 * [tJDBCInput_2 main ] stop
						 */

						/**
						 * [tJDBCOutput_1 main ] start
						 */

						currentComponent = "tJDBCOutput_1";

						whetherReject_tJDBCOutput_1 = false;
						if (row2.enum_type == null) {
							pstmt_tJDBCOutput_1.setNull(1,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_1.setString(1, row2.enum_type);
						}

						if (row2.enum_key == null) {
							pstmt_tJDBCOutput_1.setNull(2,
									java.sql.Types.INTEGER);
						} else {
							pstmt_tJDBCOutput_1.setShort(2, row2.enum_key);
						}

						if (row2.language_code == null) {
							pstmt_tJDBCOutput_1.setNull(3,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_1
									.setString(3, row2.language_code);
						}

						if (row2.value == null) {
							pstmt_tJDBCOutput_1.setNull(4,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_1.setString(4, row2.value);
						}

						try {
							insertedCount_tJDBCOutput_1 = insertedCount_tJDBCOutput_1
									+ pstmt_tJDBCOutput_1.executeUpdate();
							nb_line_tJDBCOutput_1++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_1 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_1++;

						/**
						 * [tJDBCOutput_1 main ] stop
						 */

						/**
						 * [tJDBCInput_2 end ] start
						 */

						currentComponent = "tJDBCInput_2";

					}
				} finally {
					rs_tJDBCInput_2.close();
					stmt_tJDBCInput_2.close();

				}
				globalMap.put("tJDBCInput_2_NB_LINE", nb_line_tJDBCInput_2);

				ok_Hash.put("tJDBCInput_2", true);
				end_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				/**
				 * [tJDBCInput_2 end ] stop
				 */

				/**
				 * [tJDBCOutput_1 end ] start
				 */

				currentComponent = "tJDBCOutput_1";

				if (pstmt_tJDBCOutput_1 != null) {

					pstmt_tJDBCOutput_1.close();

				}

				nb_line_deleted_tJDBCOutput_1 = nb_line_deleted_tJDBCOutput_1
						+ deletedCount_tJDBCOutput_1;
				nb_line_update_tJDBCOutput_1 = nb_line_update_tJDBCOutput_1
						+ updatedCount_tJDBCOutput_1;
				nb_line_inserted_tJDBCOutput_1 = nb_line_inserted_tJDBCOutput_1
						+ insertedCount_tJDBCOutput_1;
				nb_line_rejected_tJDBCOutput_1 = nb_line_rejected_tJDBCOutput_1
						+ rejectedCount_tJDBCOutput_1;

				globalMap.put("tJDBCOutput_1_NB_LINE", nb_line_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_1);

				ok_Hash.put("tJDBCOutput_1", true);
				end_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_1 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_2:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_5Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_2 finally ] start
				 */

				currentComponent = "tJDBCInput_2";

				/**
				 * [tJDBCInput_2 finally ] stop
				 */

				/**
				 * [tJDBCOutput_1 finally ] start
				 */

				currentComponent = "tJDBCOutput_1";

				/**
				 * [tJDBCOutput_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 1);
	}

	public static class update_lastSyncStruct implements
			routines.system.IPersistableRow<update_lastSyncStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public String var_name;

		public String getVar_name() {
			return this.var_name;
		}

		public java.util.Date var_datetime;

		public java.util.Date getVar_datetime() {
			return this.var_datetime;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.var_name == null) ? 0 : this.var_name
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final update_lastSyncStruct other = (update_lastSyncStruct) obj;

			if (this.var_name == null) {
				if (other.var_name != null)
					return false;

			} else if (!this.var_name.equals(other.var_name))

				return false;

			return true;
		}

		public void copyDataTo(update_lastSyncStruct other) {

			other.var_name = this.var_name;
			other.var_datetime = this.var_datetime;

		}

		public void copyKeysDataTo(update_lastSyncStruct other) {

			other.var_name = this.var_name;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_OsEnumUpdate) {

				try {

					int length = 0;

					this.var_name = readString(dis);

					this.var_datetime = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.var_name, dos);

				// java.util.Date

				writeDate(this.var_datetime, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("var_name=" + var_name);
			sb.append(",var_datetime=" + String.valueOf(var_datetime));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(update_lastSyncStruct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.var_name, other.var_name);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row4Struct implements
			routines.system.IPersistableRow<row4Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[0];

		public String var_name;

		public String getVar_name() {
			return this.var_name;
		}

		public java.util.Date var_datetime;

		public java.util.Date getVar_datetime() {
			return this.var_datetime;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_OsEnumUpdate) {

				try {

					int length = 0;

					this.var_name = readString(dis);

					this.var_datetime = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.var_name, dos);

				// java.util.Date

				writeDate(this.var_datetime, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("var_name=" + var_name);
			sb.append(",var_datetime=" + String.valueOf(var_datetime));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row4Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_5Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row4Struct row4 = new row4Struct();
				update_lastSyncStruct update_lastSync = new update_lastSyncStruct();

				/**
				 * [tJDBCOutput_2 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_2", false);
				start_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_2";

				int tos_count_tJDBCOutput_2 = 0;

				int updateKeyCount_tJDBCOutput_2 = 1;
				if (updateKeyCount_tJDBCOutput_2 < 1) {
					throw new RuntimeException(
							"For update, Schema must have a key");
				}

				int nb_line_tJDBCOutput_2 = 0;
				int nb_line_update_tJDBCOutput_2 = 0;
				int nb_line_inserted_tJDBCOutput_2 = 0;
				int nb_line_deleted_tJDBCOutput_2 = 0;
				int nb_line_rejected_tJDBCOutput_2 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_2 = 0;

				int deletedCount_tJDBCOutput_2 = 0;
				int updatedCount_tJDBCOutput_2 = 0;
				int insertedCount_tJDBCOutput_2 = 0;
				int rejectedCount_tJDBCOutput_2 = 0;

				boolean whetherReject_tJDBCOutput_2 = false;

				java.sql.Connection connection_tJDBCOutput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				int batchSize_tJDBCOutput_2 = 10000;
				int batchSizeCounter_tJDBCOutput_2 = 0;

				java.sql.PreparedStatement pstmt_tJDBCOutput_2 = connection_tJDBCOutput_2
						.prepareStatement("SELECT COUNT(1) FROM "
								+ "dwh_history_timekeeping"
								+ " WHERE var_name = ?");
				String insert_tJDBCOutput_2 = "INSERT INTO "
						+ "dwh_history_timekeeping"
						+ " (var_name,var_datetime) VALUES (?,?)";
				java.sql.PreparedStatement pstmtInsert_tJDBCOutput_2 = connection_tJDBCOutput_2
						.prepareStatement(insert_tJDBCOutput_2);
				String update_tJDBCOutput_2 = "UPDATE "
						+ "dwh_history_timekeeping"
						+ " SET var_datetime = ? WHERE var_name = ?";
				java.sql.PreparedStatement pstmtUpdate_tJDBCOutput_2 = connection_tJDBCOutput_2
						.prepareStatement(update_tJDBCOutput_2);

				/**
				 * [tJDBCOutput_2 begin ] stop
				 */

				/**
				 * [tMap_3 begin ] start
				 */

				ok_Hash.put("tMap_3", false);
				start_Hash.put("tMap_3", System.currentTimeMillis());

				currentComponent = "tMap_3";

				int tos_count_tMap_3 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_3__Struct {
				}
				Var__tMap_3__Struct Var__tMap_3 = new Var__tMap_3__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				update_lastSyncStruct update_lastSync_tmp = new update_lastSyncStruct();
				// ###############################

				/**
				 * [tMap_3 begin ] stop
				 */

				/**
				 * [tJDBCInput_5 begin ] start
				 */

				ok_Hash.put("tJDBCInput_5", false);
				start_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				currentComponent = "tJDBCInput_5";

				int tos_count_tJDBCInput_5 = 0;

				int nb_line_tJDBCInput_5 = 0;
				java.sql.Connection conn_tJDBCInput_5 = null;
				conn_tJDBCInput_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_5 = conn_tJDBCInput_5
						.createStatement();

				String dbquery_tJDBCInput_5 = "SELECT 'lastOsinfoSync', var_datetime  FROM  dwh_history_timekeeping  where var_name = 'lastOsinfoUpdate'";

				globalMap.put("tJDBCInput_5_QUERY", dbquery_tJDBCInput_5);
				java.sql.ResultSet rs_tJDBCInput_5 = null;
				try {
					rs_tJDBCInput_5 = stmt_tJDBCInput_5
							.executeQuery(dbquery_tJDBCInput_5);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_5 = rs_tJDBCInput_5
							.getMetaData();
					int colQtyInRs_tJDBCInput_5 = rsmd_tJDBCInput_5
							.getColumnCount();

					String tmpContent_tJDBCInput_5 = null;
					int column_index_tJDBCInput_5 = 1;

					while (rs_tJDBCInput_5.next()) {
						nb_line_tJDBCInput_5++;

						column_index_tJDBCInput_5 = 1;

						if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
							row4.var_name = null;
						} else {

							tmpContent_tJDBCInput_5 = rs_tJDBCInput_5
									.getString(column_index_tJDBCInput_5);
							if (tmpContent_tJDBCInput_5 != null) {
								row4.var_name = tmpContent_tJDBCInput_5;
							} else {
								row4.var_name = null;
							}

						}

						column_index_tJDBCInput_5 = 2;

						if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
							row4.var_datetime = null;
						} else {

							java.util.Date date_tJDBCInput_5 = null;
							try {
								date_tJDBCInput_5 = rs_tJDBCInput_5
										.getTimestamp(column_index_tJDBCInput_5);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_5 = rs_tJDBCInput_5
										.getDate(column_index_tJDBCInput_5);
							}
							row4.var_datetime = date_tJDBCInput_5;

						}

						/**
						 * [tJDBCInput_5 begin ] stop
						 */
						/**
						 * [tJDBCInput_5 main ] start
						 */

						currentComponent = "tJDBCInput_5";

						tos_count_tJDBCInput_5++;

						/**
						 * [tJDBCInput_5 main ] stop
						 */

						/**
						 * [tMap_3 main ] start
						 */

						currentComponent = "tMap_3";

						boolean hasCasePrimitiveKeyWithNull_tMap_3 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_3 = false;
						boolean mainRowRejected_tMap_3 = false;

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_3__Struct Var = Var__tMap_3;// ###############################
							// ###############################
							// # Output tables

							update_lastSync = null;

							// # Output table : 'update_lastSync'
							update_lastSync_tmp.var_name = row4.var_name;
							update_lastSync_tmp.var_datetime = row4.var_datetime;
							update_lastSync = update_lastSync_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_3 = false;

						tos_count_tMap_3++;

						/**
						 * [tMap_3 main ] stop
						 */
						// Start of branch "update_lastSync"
						if (update_lastSync != null) {

							/**
							 * [tJDBCOutput_2 main ] start
							 */

							currentComponent = "tJDBCOutput_2";

							whetherReject_tJDBCOutput_2 = false;
							if (update_lastSync.var_name == null) {
								pstmt_tJDBCOutput_2.setNull(1,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_2.setString(1,
										update_lastSync.var_name);
							}

							java.sql.ResultSet rs_tJDBCOutput_2 = pstmt_tJDBCOutput_2
									.executeQuery();
							int checkCount_tJDBCOutput_2 = -1;
							while (rs_tJDBCOutput_2.next()) {
								checkCount_tJDBCOutput_2 = rs_tJDBCOutput_2
										.getInt(1);
							}
							if (checkCount_tJDBCOutput_2 > 0) {
								if (update_lastSync.var_datetime != null) {
									pstmtUpdate_tJDBCOutput_2
											.setTimestamp(
													1,
													new java.sql.Timestamp(
															update_lastSync.var_datetime
																	.getTime()));
								} else {
									pstmtUpdate_tJDBCOutput_2.setNull(1,
											java.sql.Types.DATE);
								}

								if (update_lastSync.var_name == null) {
									pstmtUpdate_tJDBCOutput_2.setNull(2,
											java.sql.Types.VARCHAR);
								} else {
									pstmtUpdate_tJDBCOutput_2.setString(2,
											update_lastSync.var_name);
								}

								try {
									updatedCount_tJDBCOutput_2 = updatedCount_tJDBCOutput_2
											+ pstmtUpdate_tJDBCOutput_2
													.executeUpdate();
								} catch (java.lang.Exception e) {
									whetherReject_tJDBCOutput_2 = true;
									throw (e);
								}
							} else {
								if (update_lastSync.var_name == null) {
									pstmtInsert_tJDBCOutput_2.setNull(1,
											java.sql.Types.VARCHAR);
								} else {
									pstmtInsert_tJDBCOutput_2.setString(1,
											update_lastSync.var_name);
								}

								if (update_lastSync.var_datetime != null) {
									pstmtInsert_tJDBCOutput_2
											.setTimestamp(
													2,
													new java.sql.Timestamp(
															update_lastSync.var_datetime
																	.getTime()));
								} else {
									pstmtInsert_tJDBCOutput_2.setNull(2,
											java.sql.Types.DATE);
								}

								try {
									insertedCount_tJDBCOutput_2 = insertedCount_tJDBCOutput_2
											+ pstmtInsert_tJDBCOutput_2
													.executeUpdate();
								} catch (java.lang.Exception e) {
									whetherReject_tJDBCOutput_2 = true;
									throw (e);
								}
							}
							nb_line_tJDBCOutput_2++;

							tos_count_tJDBCOutput_2++;

							/**
							 * [tJDBCOutput_2 main ] stop
							 */

						} // End of branch "update_lastSync"

						/**
						 * [tJDBCInput_5 end ] start
						 */

						currentComponent = "tJDBCInput_5";

					}
				} finally {
					rs_tJDBCInput_5.close();
					stmt_tJDBCInput_5.close();

				}
				globalMap.put("tJDBCInput_5_NB_LINE", nb_line_tJDBCInput_5);

				ok_Hash.put("tJDBCInput_5", true);
				end_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				/**
				 * [tJDBCInput_5 end ] stop
				 */

				/**
				 * [tMap_3 end ] start
				 */

				currentComponent = "tMap_3";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_3", true);
				end_Hash.put("tMap_3", System.currentTimeMillis());

				/**
				 * [tMap_3 end ] stop
				 */

				/**
				 * [tJDBCOutput_2 end ] start
				 */

				currentComponent = "tJDBCOutput_2";

				if (pstmtUpdate_tJDBCOutput_2 != null) {

					pstmtUpdate_tJDBCOutput_2.close();

				}
				if (pstmtInsert_tJDBCOutput_2 != null) {

					pstmtInsert_tJDBCOutput_2.close();

				}
				if (pstmt_tJDBCOutput_2 != null) {

					pstmt_tJDBCOutput_2.close();

				}

				nb_line_deleted_tJDBCOutput_2 = nb_line_deleted_tJDBCOutput_2
						+ deletedCount_tJDBCOutput_2;
				nb_line_update_tJDBCOutput_2 = nb_line_update_tJDBCOutput_2
						+ updatedCount_tJDBCOutput_2;
				nb_line_inserted_tJDBCOutput_2 = nb_line_inserted_tJDBCOutput_2
						+ insertedCount_tJDBCOutput_2;
				nb_line_rejected_tJDBCOutput_2 = nb_line_rejected_tJDBCOutput_2
						+ rejectedCount_tJDBCOutput_2;

				globalMap.put("tJDBCOutput_2_NB_LINE", nb_line_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_2);

				ok_Hash.put("tJDBCOutput_2", true);
				end_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_2 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_5 finally ] start
				 */

				currentComponent = "tJDBCInput_5";

				/**
				 * [tJDBCInput_5 finally ] stop
				 */

				/**
				 * [tMap_3 finally ] start
				 */

				currentComponent = "tMap_3";

				/**
				 * [tMap_3 finally ] stop
				 */

				/**
				 * [tJDBCOutput_2 finally ] start
				 */

				currentComponent = "tJDBCOutput_2";

				/**
				 * [tJDBCOutput_2 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 1);
	}

	public static class row_talendLogs_LOGSStruct implements
			routines.system.IPersistableRow<row_talendLogs_LOGSStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[0];

		public java.util.Date moment;

		public java.util.Date getMoment() {
			return this.moment;
		}

		public String pid;

		public String getPid() {
			return this.pid;
		}

		public String root_pid;

		public String getRoot_pid() {
			return this.root_pid;
		}

		public String father_pid;

		public String getFather_pid() {
			return this.father_pid;
		}

		public String project;

		public String getProject() {
			return this.project;
		}

		public String job;

		public String getJob() {
			return this.job;
		}

		public String context;

		public String getContext() {
			return this.context;
		}

		public Integer priority;

		public Integer getPriority() {
			return this.priority;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String origin;

		public String getOrigin() {
			return this.origin;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		public Integer code;

		public Integer getCode() {
			return this.code;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_OsEnumUpdate, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_OsEnumUpdate) {

				try {

					int length = 0;

					this.moment = readDate(dis);

					this.pid = readString(dis);

					this.root_pid = readString(dis);

					this.father_pid = readString(dis);

					this.project = readString(dis);

					this.job = readString(dis);

					this.context = readString(dis);

					this.priority = readInteger(dis);

					this.type = readString(dis);

					this.origin = readString(dis);

					this.message = readString(dis);

					this.code = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.moment, dos);

				// String

				writeString(this.pid, dos);

				// String

				writeString(this.root_pid, dos);

				// String

				writeString(this.father_pid, dos);

				// String

				writeString(this.project, dos);

				// String

				writeString(this.job, dos);

				// String

				writeString(this.context, dos);

				// Integer

				writeInteger(this.priority, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.origin, dos);

				// String

				writeString(this.message, dos);

				// Integer

				writeInteger(this.code, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("moment=" + String.valueOf(moment));
			sb.append(",pid=" + pid);
			sb.append(",root_pid=" + root_pid);
			sb.append(",father_pid=" + father_pid);
			sb.append(",project=" + project);
			sb.append(",job=" + job);
			sb.append(",context=" + context);
			sb.append(",priority=" + String.valueOf(priority));
			sb.append(",type=" + type);
			sb.append(",origin=" + origin);
			sb.append(",message=" + message);
			sb.append(",code=" + String.valueOf(code));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row_talendLogs_LOGSStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void talendLogs_LOGSProcess(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row_talendLogs_LOGSStruct row_talendLogs_LOGS = new row_talendLogs_LOGSStruct();

				/**
				 * [talendLogs_CONSOLE begin ] start
				 */

				ok_Hash.put("talendLogs_CONSOLE", false);
				start_Hash
						.put("talendLogs_CONSOLE", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				int tos_count_talendLogs_CONSOLE = 0;

				// /////////////////////

				final String OUTPUT_FIELD_SEPARATOR_talendLogs_CONSOLE = "|";
				java.io.PrintStream consoleOut_talendLogs_CONSOLE = null;

				StringBuilder strBuffer_talendLogs_CONSOLE = null;
				int nb_line_talendLogs_CONSOLE = 0;
				// /////////////////////

				/**
				 * [talendLogs_CONSOLE begin ] stop
				 */

				/**
				 * [talendLogs_LOGS begin ] start
				 */

				ok_Hash.put("talendLogs_LOGS", false);
				start_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				int tos_count_talendLogs_LOGS = 0;

				for (LogCatcherUtils.LogCatcherMessage lcm : talendLogs_LOGS
						.getMessages()) {
					row_talendLogs_LOGS.type = lcm.getType();
					row_talendLogs_LOGS.origin = (lcm.getOrigin() == null
							|| lcm.getOrigin().length() < 1 ? null : lcm
							.getOrigin());
					row_talendLogs_LOGS.priority = lcm.getPriority();
					row_talendLogs_LOGS.message = lcm.getMessage();
					row_talendLogs_LOGS.code = lcm.getCode();

					row_talendLogs_LOGS.moment = java.util.Calendar
							.getInstance().getTime();

					row_talendLogs_LOGS.pid = pid;
					row_talendLogs_LOGS.root_pid = rootPid;
					row_talendLogs_LOGS.father_pid = fatherPid;

					row_talendLogs_LOGS.project = projectName;
					row_talendLogs_LOGS.job = jobName;
					row_talendLogs_LOGS.context = contextStr;

					/**
					 * [talendLogs_LOGS begin ] stop
					 */
					/**
					 * [talendLogs_LOGS main ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

					tos_count_talendLogs_LOGS++;

					/**
					 * [talendLogs_LOGS main ] stop
					 */

					/**
					 * [talendLogs_CONSOLE main ] start
					 */

					currentVirtualComponent = "talendLogs_CONSOLE";

					currentComponent = "talendLogs_CONSOLE";

					// /////////////////////

					strBuffer_talendLogs_CONSOLE = new StringBuilder();

					if (row_talendLogs_LOGS.moment != null) { //

						strBuffer_talendLogs_CONSOLE.append(FormatterUtils
								.format_Date(row_talendLogs_LOGS.moment,
										"yyyy-MM-dd HH:mm:ss"));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.root_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.root_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.father_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.father_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.project != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.project));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.job != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.job));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.context != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.context));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.priority != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.priority));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.type != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.type));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.origin != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.origin));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.message != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.message));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.code != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.code));

					} //

					if (globalMap.get("tLogRow_CONSOLE") != null) {
						consoleOut_talendLogs_CONSOLE = (java.io.PrintStream) globalMap
								.get("tLogRow_CONSOLE");
					} else {
						consoleOut_talendLogs_CONSOLE = new java.io.PrintStream(
								new java.io.BufferedOutputStream(System.out));
						globalMap.put("tLogRow_CONSOLE",
								consoleOut_talendLogs_CONSOLE);
					}

					consoleOut_talendLogs_CONSOLE
							.println(strBuffer_talendLogs_CONSOLE.toString());
					consoleOut_talendLogs_CONSOLE.flush();
					nb_line_talendLogs_CONSOLE++;
					// ////

					// ////

					// /////////////////////

					tos_count_talendLogs_CONSOLE++;

					/**
					 * [talendLogs_CONSOLE main ] stop
					 */

					/**
					 * [talendLogs_LOGS end ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

				}

				ok_Hash.put("talendLogs_LOGS", true);
				end_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				/**
				 * [talendLogs_LOGS end ] stop
				 */

				/**
				 * [talendLogs_CONSOLE end ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				// ////
				// ////
				globalMap.put("talendLogs_CONSOLE_NB_LINE",
						nb_line_talendLogs_CONSOLE);

				// /////////////////////

				ok_Hash.put("talendLogs_CONSOLE", true);
				end_Hash.put("talendLogs_CONSOLE", System.currentTimeMillis());

				/**
				 * [talendLogs_CONSOLE end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [talendLogs_LOGS finally ] start
				 */

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				/**
				 * [talendLogs_LOGS finally ] stop
				 */

				/**
				 * [talendLogs_CONSOLE finally ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				/**
				 * [talendLogs_CONSOLE finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 1);
	}

	public String resuming_logs_dir_path = null;
	public String resuming_checkpoint_path = null;
	public String parent_part_launcher = null;
	private String resumeEntryMethodName = null;
	private boolean globalResumeTicket = false;

	public boolean watch = false;
	// portStats is null, it means don't execute the statistics
	public Integer portStats = null;
	public int portTraces = 4334;
	public String clientHost;
	public String defaultClientHost = "localhost";
	public String contextStr = "Default";
	public boolean isDefaultContext = true;
	public String pid = "0";
	public String rootPid = null;
	public String fatherPid = null;
	public String fatherNode = null;
	public long startTime = 0;
	public boolean isChildJob = false;
	public String log4jLevel = "";

	private boolean execStat = true;

	private ThreadLocal<java.util.Map<String, String>> threadLocal = new ThreadLocal<java.util.Map<String, String>>() {
		protected java.util.Map<String, String> initialValue() {
			java.util.Map<String, String> threadRunResultMap = new java.util.HashMap<String, String>();
			threadRunResultMap.put("errorCode", null);
			threadRunResultMap.put("status", "");
			return threadRunResultMap;
		};
	};

	private java.util.Properties context_param = new java.util.Properties();
	public java.util.Map<String, Object> parentContextMap = new java.util.HashMap<String, Object>();

	public String status = "";

	public static void main(String[] args) {
		final OsEnumUpdate OsEnumUpdateClass = new OsEnumUpdate();

		int exitCode = OsEnumUpdateClass.runJobInTOS(args);

		System.exit(exitCode);
	}

	public String[][] runJob(String[] args) {

		int exitCode = runJobInTOS(args);
		String[][] bufferValue = new String[][] { { Integer.toString(exitCode) } };

		return bufferValue;
	}

	public int runJobInTOS(String[] args) {
		// reset status
		status = "";

		String lastStr = "";
		for (String arg : args) {
			if (arg.equalsIgnoreCase("--context_param")) {
				lastStr = arg;
			} else if (lastStr.equals("")) {
				evalParam(arg);
			} else {
				evalParam(lastStr + " " + arg);
				lastStr = "";
			}
		}

		if (clientHost == null) {
			clientHost = defaultClientHost;
		}

		if (pid == null || "0".equals(pid)) {
			pid = TalendString.getAsciiRandomString(6);
		}

		if (rootPid == null) {
			rootPid = pid;
		}
		if (fatherPid == null) {
			fatherPid = pid;
		} else {
			isChildJob = true;
		}

		try {
			// call job/subjob with an existing context, like:
			// --context=production. if without this parameter, there will use
			// the default context instead.
			java.io.InputStream inContext = OsEnumUpdate.class.getClassLoader()
					.getResourceAsStream(
							"ovirt_engine_dwh/osenumupdate_3_5/contexts/"
									+ contextStr + ".properties");
			if (isDefaultContext && inContext == null) {

			} else {
				if (inContext != null) {
					// defaultProps is in order to keep the original context
					// value
					defaultProps.load(inContext);
					inContext.close();
					context = new ContextProperties(defaultProps);
				} else {
					// print info and job continue to run, for case:
					// context_param is not empty.
					System.err.println("Could not find the context "
							+ contextStr);
				}
			}

			if (!context_param.isEmpty()) {
				context.putAll(context_param);
			}
			context.ovirtEngineDbDriverClass = (String) context
					.getProperty("ovirtEngineDbDriverClass");
			context.ovirtEngineDbJdbcConnection = (String) context
					.getProperty("ovirtEngineDbJdbcConnection");
			context.ovirtEngineDbPassword = (java.lang.String) context
					.getProperty("ovirtEngineDbPassword");
			context.ovirtEngineDbUser = (String) context
					.getProperty("ovirtEngineDbUser");
			context.ovirtEngineHistoryDbDriverClass = (String) context
					.getProperty("ovirtEngineHistoryDbDriverClass");
			context.ovirtEngineHistoryDbJdbcConnection = (String) context
					.getProperty("ovirtEngineHistoryDbJdbcConnection");
			context.ovirtEngineHistoryDbPassword = (java.lang.String) context
					.getProperty("ovirtEngineHistoryDbPassword");
			context.ovirtEngineHistoryDbUser = (String) context
					.getProperty("ovirtEngineHistoryDbUser");
			try {
				String context_runTime_value = context.getProperty("runTime");
				if (context_runTime_value == null) {
					context_runTime_value = "";
				}
				int context_runTime_pos = context_runTime_value.indexOf(";");
				String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_runTime_pos > -1) {
					context_runTime_pattern = context_runTime_value.substring(
							0, context_runTime_pos);
					context_runTime_value = context_runTime_value
							.substring(context_runTime_pos + 1);
				}

				context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
						context_runTime_pattern).parse(context_runTime_value));

			} catch (ParseException e) {
				context.runTime = null;
			}
			try {
				String context_lastOsinfoUpdate_value = context
						.getProperty("lastOsinfoUpdate");
				if (context_lastOsinfoUpdate_value == null) {
					context_lastOsinfoUpdate_value = "";
				}
				int context_lastOsinfoUpdate_pos = context_lastOsinfoUpdate_value
						.indexOf(";");
				String context_lastOsinfoUpdate_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_lastOsinfoUpdate_pos > -1) {
					context_lastOsinfoUpdate_pattern = context_lastOsinfoUpdate_value
							.substring(0, context_lastOsinfoUpdate_pos);
					context_lastOsinfoUpdate_value = context_lastOsinfoUpdate_value
							.substring(context_lastOsinfoUpdate_pos + 1);
				}

				context.lastOsinfoUpdate = (java.util.Date) (new java.text.SimpleDateFormat(
						context_lastOsinfoUpdate_pattern)
						.parse(context_lastOsinfoUpdate_value));

			} catch (ParseException e) {
				context.lastOsinfoUpdate = null;
			}
			try {
				String context_lastOsinfoSync_value = context
						.getProperty("lastOsinfoSync");
				if (context_lastOsinfoSync_value == null) {
					context_lastOsinfoSync_value = "";
				}
				int context_lastOsinfoSync_pos = context_lastOsinfoSync_value
						.indexOf(";");
				String context_lastOsinfoSync_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_lastOsinfoSync_pos > -1) {
					context_lastOsinfoSync_pattern = context_lastOsinfoSync_value
							.substring(0, context_lastOsinfoSync_pos);
					context_lastOsinfoSync_value = context_lastOsinfoSync_value
							.substring(context_lastOsinfoSync_pos + 1);
				}

				context.lastOsinfoSync = (java.util.Date) (new java.text.SimpleDateFormat(
						context_lastOsinfoSync_pattern)
						.parse(context_lastOsinfoSync_value));

			} catch (ParseException e) {
				context.lastOsinfoSync = null;
			}
		} catch (java.io.IOException ie) {
			System.err.println("Could not load context " + contextStr);
			ie.printStackTrace();
		}

		// get context value from parent directly
		if (parentContextMap != null && !parentContextMap.isEmpty()) {
			if (parentContextMap.containsKey("ovirtEngineDbDriverClass")) {
				context.ovirtEngineDbDriverClass = (String) parentContextMap
						.get("ovirtEngineDbDriverClass");
			}
			if (parentContextMap.containsKey("ovirtEngineDbJdbcConnection")) {
				context.ovirtEngineDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineDbPassword")) {
				context.ovirtEngineDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineDbUser")) {
				context.ovirtEngineDbUser = (String) parentContextMap
						.get("ovirtEngineDbUser");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbDriverClass")) {
				context.ovirtEngineHistoryDbDriverClass = (String) parentContextMap
						.get("ovirtEngineHistoryDbDriverClass");
			}
			if (parentContextMap
					.containsKey("ovirtEngineHistoryDbJdbcConnection")) {
				context.ovirtEngineHistoryDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineHistoryDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbPassword")) {
				context.ovirtEngineHistoryDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineHistoryDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbUser")) {
				context.ovirtEngineHistoryDbUser = (String) parentContextMap
						.get("ovirtEngineHistoryDbUser");
			}
			if (parentContextMap.containsKey("runTime")) {
				context.runTime = (java.util.Date) parentContextMap
						.get("runTime");
			}
			if (parentContextMap.containsKey("lastOsinfoUpdate")) {
				context.lastOsinfoUpdate = (java.util.Date) parentContextMap
						.get("lastOsinfoUpdate");
			}
			if (parentContextMap.containsKey("lastOsinfoSync")) {
				context.lastOsinfoSync = (java.util.Date) parentContextMap
						.get("lastOsinfoSync");
			}
		}

		// Resume: init the resumeUtil
		resumeEntryMethodName = ResumeUtil
				.getResumeEntryMethodName(resuming_checkpoint_path);
		resumeUtil = new ResumeUtil(resuming_logs_dir_path, isChildJob, rootPid);
		resumeUtil.initCommonInfo(pid, rootPid, fatherPid, projectName,
				jobName, contextStr, jobVersion);

		// Resume: jobStart
		resumeUtil.addLog("JOB_STARTED", "JOB:" + jobName,
				parent_part_launcher, Thread.currentThread().getId() + "", "",
				"", "", "", resumeUtil.convertToJsonText(context));

		java.util.concurrent.ConcurrentHashMap<Object, Object> concurrentHashMap = new java.util.concurrent.ConcurrentHashMap<Object, Object>();
		globalMap.put("concurrentHashMap", concurrentHashMap);

		long startUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		long endUsedMemory = 0;
		long end = 0;

		startTime = System.currentTimeMillis();

		this.globalResumeTicket = true;// to run tPreJob

		this.globalResumeTicket = false;// to run others jobs

		try {
			errorCode = null;
			tJDBCConnection_2Process(globalMap);
			if (!"failure".equals(status)) {
				status = "end";
			}
		} catch (TalendException e_tJDBCConnection_2) {
			globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", -1);

			e_tJDBCConnection_2.printStackTrace();

		}

		this.globalResumeTicket = true;// to run tPostJob

		end = System.currentTimeMillis();

		if (watch) {
			System.out.println((end - startTime) + " milliseconds");
		}

		endUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		if (false) {
			System.out.println((endUsedMemory - startUsedMemory)
					+ " bytes memory increase when running : OsEnumUpdate");
		}

		int returnCode = 0;
		if (errorCode == null) {
			returnCode = status != null && status.equals("failure") ? 1 : 0;
		} else {
			returnCode = errorCode.intValue();
		}
		resumeUtil.addLog("JOB_ENDED", "JOB:" + jobName, parent_part_launcher,
				Thread.currentThread().getId() + "", "", "" + returnCode, "",
				"", "");

		return returnCode;

	}

	public void destroy() {

	}

	private java.util.Map<String, Object> getSharedConnections4REST() {
		java.util.Map<String, Object> connections = new java.util.HashMap<String, Object>();
		return connections;
	}

	private void evalParam(String arg) {
		if (arg.startsWith("--resuming_logs_dir_path")) {
			resuming_logs_dir_path = arg.substring(25);
		} else if (arg.startsWith("--resuming_checkpoint_path")) {
			resuming_checkpoint_path = arg.substring(27);
		} else if (arg.startsWith("--parent_part_launcher")) {
			parent_part_launcher = arg.substring(23);
		} else if (arg.startsWith("--watch")) {
			watch = true;
		} else if (arg.startsWith("--stat_port=")) {
			String portStatsStr = arg.substring(12);
			if (portStatsStr != null && !portStatsStr.equals("null")) {
				portStats = Integer.parseInt(portStatsStr);
			}
		} else if (arg.startsWith("--trace_port=")) {
			portTraces = Integer.parseInt(arg.substring(13));
		} else if (arg.startsWith("--client_host=")) {
			clientHost = arg.substring(14);
		} else if (arg.startsWith("--context=")) {
			contextStr = arg.substring(10);
			isDefaultContext = false;
		} else if (arg.startsWith("--father_pid=")) {
			fatherPid = arg.substring(13);
		} else if (arg.startsWith("--root_pid=")) {
			rootPid = arg.substring(11);
		} else if (arg.startsWith("--father_node=")) {
			fatherNode = arg.substring(14);
		} else if (arg.startsWith("--pid=")) {
			pid = arg.substring(6);
		} else if (arg.startsWith("--context_param")) {
			String keyValue = arg.substring(16);
			int index = -1;
			if (keyValue != null && (index = keyValue.indexOf('=')) > -1) {
				if (fatherPid == null) {
					context_param.put(keyValue.substring(0, index),
							replaceEscapeChars(keyValue.substring(index + 1)));
				} else { // the subjob won't escape the especial chars
					context_param.put(keyValue.substring(0, index),
							keyValue.substring(index + 1));
				}
			}
		} else if (arg.startsWith("--log4jLevel=")) {
			log4jLevel = arg.substring(13);
		}

	}

	private final String[][] escapeChars = { { "\\n", "\n" }, { "\\'", "\'" },
			{ "\\r", "\r" }, { "\\f", "\f" }, { "\\b", "\b" }, { "\\t", "\t" },
			{ "\\\\", "\\" } };

	private String replaceEscapeChars(String keyValue) {
		if (keyValue == null || ("").equals(keyValue.trim())) {
			return keyValue;
		}
		for (String[] strArray : escapeChars) {
			keyValue = keyValue.replace(strArray[0], strArray[1]);
		}
		return keyValue;
	}

	public Integer getErrorCode() {
		return errorCode;
	}

	public String getStatus() {
		return status;
	}

	ResumeUtil resumeUtil = null;
}
/************************************************************************************************
 * 122736 characters generated by Talend Open Studio for Data Integration on the
 * January 21, 2014 3:54:27 PM IST
 ************************************************************************************************/
