import React, { PropTypes } from 'react'
const { string, node } = PropTypes
import $ from 'jquery'
import { msg } from '../../intl-messages'

class ModalDialog extends React.Component {

  render () {
    return (
      <div className={`modal fade ${this.props.modalContainerClass}`} role='dialog' ref={(e) => { this._modalContainer = e }}>
        <div className='modal-dialog'>
          <div className='modal-content'>

            <div className='modal-header'>
              <button type='button' className='close' data-dismiss='modal'>&times;</button>
              <h4 className='modal-title'>{this.props.title}</h4>
            </div>

            <div className='modal-body'>{this.props.children}</div>

            <div className='modal-footer'>
              <button type='button' className='btn btn-primary' data-dismiss='modal'>{msg.closeButton()}</button>
            </div>

          </div>
        </div>
      </div>
    )
  }

  show () {
    $(this._modalContainer).modal()
  }

}

ModalDialog.propTypes = {
  children: node,
  title: string.isRequired,
  modalContainerClass: string
}

ModalDialog.defaultProps = {
  modalContainerClass: ''
}

export default ModalDialog
