Name:           imgbased
Version:        1.0.3
Release:        %{?_release}%{?!_release:0.1}%{?dist}
Summary:        Tools to work with an image based rootfs

License:        GPLv2+
URL:            https://www.github.com/fabiand/imgbased
Source0:        http://resources.ovirt.org/pub/src/%{name}/%{name}-%{version}.tar.xz

BuildArch:      noarch

%if 0%{?fedora} || 0%{?rhel} >= 8
%global with_python3 1
%else
%global with_python2 1
%endif

# Skips check since rhel default repos lack pep8, pyflakes and python-nose
%if ! 0%{?rhel}
%{!?with_check:%global with_check 1}
%else
%{!?with_check:%global with_check 0}
%endif

BuildRequires:       make
BuildRequires:       automake
BuildRequires:       autoconf
BuildRequires:       rpm-build
BuildRequires:       git
BuildRequires:       asciidoc
BuildRequires:       systemd-units
BuildRequires:       rpm-python

%if 0%{?with_python2}
Requires:            python-imgbased
%else
Requires:            python3-imgbased
%endif

Requires:            lvm2
Requires:            util-linux
Requires:            augeas
Requires:            rsync
Requires:            yum

%{!?_licensedir:%global license %%doc}

%description
This tool enforces a special usage pattern for LVM.
Basically this is about having read-only bases and writable
layers atop.

%if 0%{?with_python2}
%package -n python-imgbased
Summary: A python 2 module for imgbased
%if 0%{?with_python2} && 0%{?with_check}
BuildRequires:       python-pep8
BuildRequires:       pyflakes
BuildRequires:       python-nose
BuildRequires:       python-devel
BuildRequires:       python-six
%endif

%description -n python-imgbased
python3-imgbased is a python 3 library to manage lvm layers
%endif

%if 0%{?with_python3}
%package -n python3-imgbased
Summary: A python 3 module for imgbased
BuildRequires:       python3-devel
BuildRequires:       python3-pep8
BuildRequires:       python3-pyflakes
BuildRequires:       python3-nose
BuildRequires:       python3-six
Recommends:          systemd-python3

%description -n python3-imgbased
python3-imgbased is a python 3 library to manage lvm layers
%endif

%prep
%setup -q


%build
%configure
make %{?_smp_mflags}

%install
%if 0%{?fedora}
install -Dm 0644 src/plugin-dnf/imgbased-persist.conf \
                 %{buildroot}/%{_sysconfdir}/dnf/pluginconf.d/imgbased-persist.conf
install -Dm 0644 src/plugin-dnf/imgbased-persist.py \
                 %{buildroot}/%{python3_sitelib}/dnf-plugins/imgbased-persist.py
%else
install -Dm 0644 src/plugin-yum/imgbased-persist.py \
                 %{buildroot}/%{_prefix}/lib/yum-plugins/imgbased-persist.py
install -Dm 0644 src/plugin-yum/imgbased-persist.conf \
                 %{buildroot}/%{_sysconfdir}/yum/pluginconf.d/imgbased-persist.conf
%endif
install -Dm 0644 data/imgbase-clean-grub.service %{buildroot}%{_unitdir}/imgbase-clean-grub.service
install -Dm 0644 data/imgbase-copy-bootfiles.service %{buildroot}%{_unitdir}/imgbase-copy-bootfiles.service
install -Dm 0644 data/imgbase-generate-iqn.service %{buildroot}%{_unitdir}/imgbase-generate-iqn.service
install -Dm 0644 data/imgbase-config-vdsm.service %{buildroot}%{_unitdir}/imgbase-config-vdsm.service
install -Dm 0444 data/imgbased-pool.profile %{buildroot}%{_sysconfdir}/lvm/profile/imgbased-pool.profile
install -Dm 0755 scripts/grub/09_node %{buildroot}%{_sysconfdir}/grub.d/09_node
%make_install DESTDIR="%{buildroot}"


%files
%doc README.md
%license LICENSE
%{_sbindir}/imgbase
%{_sbindir}/imgbase-copy-bootfiles
%{_datadir}/%{name}/hooks.d/
%{_mandir}/man8/imgbase.8*
%{_mandir}/man8/imgbase-copy-bootfiles.8*
/%{_docdir}/%{name}/*.asc
%{_unitdir}/imgbase-*.service
%{_sysconfdir}/grub.d/09_node
%{_sysconfdir}/lvm/profile/imgbased-pool.profile
%if 0%{?fedora}
%{_sysconfdir}/dnf/pluginconf.d/imgbased-persist.conf
%{python3_sitelib}/dnf-plugins/imgbased-persist.py*
%{python3_sitelib}/dnf-plugins/__pycache__/imgbased*
%else
%{_sysconfdir}/yum/pluginconf.d/imgbased-persist.conf
%{_prefix}/lib/yum-plugins/imgbased-persist.py*
%endif

%if 0%{?with_python2}
%files -n python-imgbased
%doc README.md
%license LICENSE
%{python_sitelib}/%{name}/
%endif

%if 0%{?with_python3}
%files -n python3-imgbased
%doc README.md
%license LICENSE
%{python3_sitelib}/%{name}/
%endif

%changelog
* Tue Nov 28 2017 Ryan Barry <rbarry@redhat.com> - 1.0.3-0
- Don't migrate 'restrict' as a chrony keywoard

* Wed Nov 15 2017 Ryan Barry <rbarry@redhat.com> - 1.0.2-0
- Migrate NTP configurations to chrony if they're present

* Wed Sep 27 2017 Ryan Barry <rbarry@redhat.com> - 1.0.1-0
- Sort the NIST partition list before creating them

* Mon Aug 21 2017 Ryan Barry <rbarry@redhat.com> - 1.0.0-0
- Branch for 4.2

* Mon Mar 06 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 0.9.999-0
- Development for 4.2

* Mon Mar 06 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 0.9.16-0
- Added systemd unit for running vdsm-tool configure
- Resolves: BZ#1429288

* Fri Mar 03 2017 Ryan Barry <rbarry@redhat.com> - 0.9.15-0
- Add unmount to imgbased.utils

* Thu Feb 23 2017 Ryan Barry <rbarry@redhat.com> - 0.9.14-0
- Rescan all LVs on update

* Wed Feb 22 2017 Ryan Barry <rbarry@redhat.com> - 0.9.12-0
- Fix an error with imgbase --init

* Mon Feb 20 2017 Ryan Barry <rbarry@redhat.com> - 0.9.11-0
- Fix some logic problems in imgbased's handling of bases

* Mon Feb 20 2017 Douglas Schilling Landgraf <dougsland@redhat.com> - 0.9.10-0
- Keep unmodified configuration files
- Switch to a NIST partition layout on upgrades

* Thu Feb 02 2017 Douglas Schilling Landgraf <dougsland@redhat.com> - 0.9.7-0
- split the imgbase in two packages for python3 support

* Fri Jan 20 2017 Ryan Barry <rbarry@redhat.com> - 0.9.6-1
- Copy kernel FIPS signatures into /boot

* Wed Jan 18 2017 Ryan Barry <rbarry@redhat.com> - 0.9.5-1
- Revert selinux relabeling on upgrades

* Wed Jan 04 2017 Ryan Barry <rbarry@redhat.com> - 0.9.4-1
- Also keep depinstalled and depupdated for persistence

* Wed Jan 04 2017 Ryan Barry <rbarry@redhat.com> - 0.9.3-1
- Ensure new layers have enough space for hosted engine
- Copy the kernel and initrd to /boot so grub2-mkconfig and virt-v2v work

* Wed Jan 04 2017 Ryan Barry <rbarry@redhat.com> - 0.9.2-1
- Use GB instead of GiB in osupdater /boot validation

* Tue Jan 03 2017 Ryan Barry <rbarry@redhat.com> - 0.9.1-1
- Fix a typo in utils.SystemRelease which blocks installs

* Tue Dec 20 2016 Ryan Barry <rbarry@redhat.com> - 0.9.0-1
- Add a yum plugin to persist RPMs through upgrades
- Remove existing yum/dnf plugins

* Mon Nov 14 2016 Ryan Barry <rbarry@redhat.com> - 0.8.10-1
- Enable IQN randomization

* Fri Nov 11 2016 Ryan Barry <rbarry@redhat.com> - 0.8.9-1
- Also relocate on updates

* Thu Nov 10 2016 Ryan Barry <rbarry@redhat.com> - 0.8.8-1
- Relocate /var/lib/yum to /usr

* Fri Nov 4 2016 Ryan Barry <rbarry@redhat.com> - 0.8.7-1
- Fix a regression with the last patch in interactive installs

* Wed Oct 19 2016 Ryan Barry <rbarry@redhat.com> - 0.8.6-1
- Ensure disabled services stay disabled after upgrade

* Thu Sep 15 2016 Ryan Barry <rbarry@fedoraproject.org> - 0.8.5-1
- Remove non-imgbased entries at boot

* Wed Apr 02 2014 Fabian Deutsch <fabiand@fedoraproject.org> - 0.1-0.1
- Initial package
