#
# vdsm-jsonrpc-java - vdsm json rpc
# Copyright (C) 2013-2015 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global		package_version 1.0.14
%global		package_maven_version 1.0.14
# Version 1.9 of jackson currently no available for rhel or centos

%if 0%{?fedora:1}
%global	_use_maven 1
%global	_use_mockito 1
%global	jackson_deps_available 1
%endif
%if 0%{?rhel:1}
%if %{rhel} >= 7
%global	_mvn_opts -Pno-test
%global	_use_maven 1
%global	_use_mockito 0
%global	jackson_deps_available 1
%else
%global	_use_maven 0
%global	_use_repolib 1
%global	maven2brewrepodir %{_javadir}/repository.jboss.com/maven2-brew/dummy
%global	jackson_deps_available 0
%endif
%endif

Summary:	oVirt JsonRpc java client (%{name})
Name:		vdsm-jsonrpc-java
Version:	1.0.14
Release:	1%{?dist}
License:	LGPLv2+
URL:		http://www.ovirt.org
Source:		http://resources.ovirt.org/pub/ovirt-3.5-snapshot/src/%{name}/%{name}-%{package_version}.tar.gz
Group:		Development/Libraries

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:	noarch


%if 0%{?rhel}
%if 0%{?rhel} >= 7
BuildRequires:	java-devel >= 1.7.0
%else
BuildRequires:	java7-devel
%endif
%endif
%if 0%{?fedora}
BuildRequires:	java-devel >= 1.7.0
%endif

Requires:	java-1.7.0-openjdk


%if %{_use_maven}
BuildRequires:	apache-commons-logging
BuildRequires:	jackson
BuildRequires:	junit
BuildRequires:	maven-compiler-plugin
BuildRequires:	maven-enforcer-plugin
BuildRequires:	maven-install-plugin
BuildRequires:	maven-jar-plugin
BuildRequires:	maven-javadoc-plugin
BuildRequires:	maven-local
BuildRequires:	maven-source-plugin
BuildRequires:	maven-surefire-provider-junit
%if %{_use_mockito}
BuildRequires:	mockito
%endif
Requires:	apache-commons-logging
Requires:	jackson
%else
BuildRequires:	jakarta-commons-logging
BuildRequires:	junit4
# Package not in rhel. it is only build time, at this point (until rhel-7) we can accept that
# BuildRequires:	mockito
%if %{jackson_deps_available}
BuildRequires:	codehaus-jackson-core-asl
BuildRequires:	codehaus-jackson-mapper-asl
Requires:	jackson >= 1.9
%endif
Requires:	jakarta-commons-logging
%endif

%description
vdsm jsonrpc java

%if %{_use_maven}
%package javadoc
Summary:	Javadocs for %{name}
Group:		Documentation

%description javadoc
This package contains the API documentation for %{name}.
%endif

%if 0%{?_use_repolib:1}
%package repolib
Summary:	%{name} maven repo
%description repolib
%{name} maven repo
%endif

%prep
%setup -q -n %{name}-%{package_version}

%build
%if %{_use_maven}
%global conf --with-maven --disable-java-build
%else
%if !%{jackson_deps_available}
%global conf --with-maven --enable-java-build
%else
%global conf \\\
	JACKSON_CORE_ASL=$(build-classpath codehaus-jackson/jackson-core-asl) \\\
	JACKSON_MAPPER_ASL=$(build-classpath codehaus-jackson/jackson-mapper-asl) \\\
	COMMONS_LOGGING_JAR=$(build-classpath commons-logging) \\\
	JAVAC=/usr/lib/jvm/java-1.7.0/bin/javac \\\
	JAR=/usr/lib/jvm/java-1.7.0/bin/jar \\\
	%{?null}
%endif
%endif
%configure %{?conf}
make %{?_smp_mflags}

%if %{_use_maven}
%mvn_build -- %{?_mvn_opts}
%endif

%install
%if 0%{?_use_repolib:1}
rm -rf "%{buildroot}"
%endif
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%if %{_use_maven}
%mvn_install
%else
install -d "%{buildroot}%{_javadir}/%{name}"
install target/%{name}-client-%{package_maven_version}.jar %{buildroot}%{_javadir}/%{name}
ln -s %{name}-client-%{package_maven_version}.jar %{buildroot}%{_javadir}/%{name}/%{name}-client.jar
%endif

%if 0%{?_use_repolib:1}
install -d "%{buildroot}%{maven2brewrepodir}/root"
install -d "%{buildroot}%{maven2brewrepodir}/%{name}"
cp pom.xml "%{buildroot}%{maven2brewrepodir}/root/root-%{package_maven_version}.pom"
cp "%{buildroot}%{_javadir}/%{name}/%{name}-client.jar" "%{buildroot}%{maven2brewrepodir}/%{name}/%{name}-client-%{package_maven_version}.jar"
cp client/pom.xml "%{buildroot}%{maven2brewrepodir}/%{name}/%{name}-client-%{package_maven_version}.pom"
%endif

%if %{_use_maven}
%files -f .mfiles
%dir %{_javadir}/%{name}
%else
%files
%dir %{_javadir}/%{name}
%{_javadir}/%{name}/%{name}*.jar
%endif

%if %{_use_maven}
%files javadoc -f .mfiles-javadoc
%endif

%if 0%{?_use_repolib:1}
%files repolib
%{maven2brewrepodir}/
%endif

%changelog
* Mon Dec 22 2014 Piotr Kliczewski<pkliczew@redhat.com> 1.0.14
- NPE when removing empty tracked request

* Mon Dec 15 2014 Piotr Kliczewski <pkliczew@redhat.com> 1.0.13
- handling of network events for multipe connection

* Wed Dec 10 2014 Piotr Kliczewski <pkliczew@redhat.com> 1.0.12
- wait on OS buff to empty

* Fri Nov 21 2014 Piotr Kliczewski <pkliczew@redhat.com> 1.0.11
- require one java package
- json parser flags

* Sun Nov 2 2014 Piotr Kliczewski <pkliczew@redhat.com> 1.0.10
- Reduced verbosity of logging

* Thu Oct 23 2014 Piotr Kliczewski <pkliczew@redhat.com> 1.0.9
- Events based on networking issues
- handle unrecognized messages

* Mon Oct  6 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.8-1
- 1.0.8-1
* Wed Oct 1 2014 Piotr Kliczewski <pkliczew@redhat.com> 1.0.7
- Fixed reconnection issues
- Added timeout to CONNECT call
* Wed Sep 10 2014 Piotr Kliczewski <pkliczew@redhat.com> 1.0.6
- Fixed SSL errors after resetting the retry policy
* Mon Sep 8 2014 Piotr Kliczewski <pkliczew@redhat.com> 1.0.5
- Add ability to change the retry policy of a connection
* Tue Aug 26 2014 Piotr Kliczewski <pkliczew@redhat.com> 1.0.3
- Fix numerous races in package
* Mon Aug 18 2014 Piotr Kliczewski <pkliczew@redhat.com> 1.0.2
- Log json message without logging stomp part of a frame
- json serialization optimization
- single tracking thread
- test: Mitigate test failures on loaded machines
- coverity fix
- build: update version for mvn as well
- Junit fail on heavy loaded machines
- Buffer overflow in ssl

* Tue Jun 24 2014 Piotr Kliczewski <pkliczew@redhat.com> 1.0.1
- Make jackson dependency conditional for rhel and centos

* Thu Dec 19 2013 Piotr Kliczewski <pkliczew@redhat.com> 1.0
- Initial template for vdsm-jsonrpc-java.

* Wed Nov 20 2013 Alon Bar-Lev <alonbl@redhat.com> - 1.1.0-1
- Initial template.
