## runcommand.py
## An example plugin for sos

### This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import sos.plugintools

# Class name must be the same as file name and method names must not change
class runcommand(sos.plugintools.PluginBase):
    """This is a very simple example plugin that just runs one command in a shell. That
    command could be a script supplied with your package which outputs information of interest
    to support. When the script or command is run, stdout is collected and included in the
    report generated by sosreport, and stderr is collected and copied into the sos log.

    This is useful for people who have minimal knowledge of python, who wish to write
    collection tools in other languages, or who have existing tools.

    If your script or command generates output files that you want included in the sosreport
    collection of files, include sosCp calls to include them.

    The only method required for this simple plugin is collect().

    Your finished plugin should be included with your package and installed in python's
    site-packages/sos/plugins/ directory
    """
    def setup(self):
        ''' Run a command. Output is automatically included in the report.
        '''
        self.collectExtOutput("/path/to/my/script --myoption --anotheroption")

        # if (for example) that command created files /foo/bar/baz.txt and
        # we want to include that in our report, we include the next line:
        #self.pit.sosCp("/foo/bar/baz.txt")
