/* <<< Start of information >>>                                             */
/* This file is part of the xwatch package.                                 */
/* Copyright (C) 1995 Karel Kubat.  All rights reserved.                    */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include "xwatch.h"

void scanfile (int i, int showinfo)
{
    struct stat
	statbuf;
    register FILE
	*f;
    char
	buf [1000];
    time_t
	now;
    struct tm
	*loctime;
    int
        index,
	old_offset,
	current_offset,
	bufpos;

    /* check that file is still here */ 
    if (stat (finfo [i].name, &statbuf))
    {
	if (finfo [i].active)
	{
	    warning ("File %s has disappeared", finfo [i].name);
	    finfo [i].active = 0;
	}
	return;
    }

    /* check for reappeared files */
    if (! finfo [i].active)
    {
	warning ("File %s has reappeared", finfo [i].name);
	finfo [i].active = 1;
	finfo [i].offset = 0;
    }

    current_offset = statbuf.st_size;
    old_offset = finfo [i].offset;
    finfo [i].offset = current_offset;

    /* just adjust offset if we don't have to show it */ 
    if (! showinfo)
	return;

    /* check that file hasn't shortened */
    if (current_offset < old_offset)
    {
	warning ("File %s has shortened", finfo [i].name);
	return;
    }

    /* check that something at all happened */
    if (current_offset == old_offset)
	return;

    /* now open the file */
    if (! (f = fopen (finfo [i].name, "r")) )
    {
	warning ("Cannot read %s: %s", finfo [i].name, strerror (errno));
	finfo [i].active = 0;
	return;
    }

    /* create first text: HH:MM:SS file */
    buf [0] = '\0';
    
    if (printtime)
    {
	time (&now);
	loctime = localtime (&now);
	sprintf (buf, "%2.2d:%2.2d'%2.2d ",
		loctime->tm_hour, loctime->tm_min, loctime->tm_sec);
    }
    if (printname)
    {
	strcat (buf, finfo [i].name);
	strcat (buf, ": ");
    }

    if ( newline && (printtime || printname) )
    {
	addline (buf, finfo [i].colorindex);
	buf [0] = '\0';
    }
    
    fseek (f, old_offset, SEEK_SET);

    bufpos = strlen (buf);
    
    while (1)
    {
	fgets (buf + bufpos, 999 - bufpos, f);
	if (feof (f))
	    break;
            
        /* see if this string is colored */
        for (index = 0; index < ncolorstring; index++)
            if (strstr (buf, colorstring [index].str))
            {
                addline (buf, colorstring [index].colorindex);
                break;
            }
        
        /* otherwise, add with file coloring */
        if (index >= ncolorstring)
            addline (buf, finfo [i].colorindex);
    }

    fclose (f);
}
