/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef FILESAVEASDIALOG_H
#define FILESAVEASDIALOG_H
#include <vdk/FileDialog.h>
/*!
  \class VDKFileSaveAsDialog
  \brief This class is a file "SaveAs" selection modal window.
  \par Usage
  Same as VDKFileDialog but does not hadle multiple files and warns
  user if he/she attempts to overwrite a file.
 */
class VDKFileSaveAsDialog : public VDKFileDialog
{
 protected:
  bool SaveClick(VDKObject*);
  bool SetFileMask(VDKObject*);
  bool FileSelected(VDKObject*);
  bool CheckOverwrite(char*);
 public:
  VDKFileSaveAsDialog(VDKForm* owner,
		FileStringArray* selections,
		char* title = "", 
		GtkWindowType display = GTK_WINDOW_TOPLEVEL);
  virtual ~VDKFileSaveAsDialog();
  DECLARE_SIGNAL_MAP(VDKFileSaveAsDialog);
};
#endif



