/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*  -*- C++ -*-
*  Copyright (C) 2008 <wkai@gmail.com>
*
*
*  Permission is hereby granted, free of charge, to any person obtaining
*  a copy of this software and associated documentation files (the
*  "Software"), to deal in the Software without restriction, including
*  without limitation the rights to use, copy, modify, merge, publish,
*  distribute, sublicense, and/or sell copies of the Software, and to
*  permit persons to whom the Software is furnished to do so, subject to
*  the following conditions:
*
*  The above copyright notice and this permission notice shall be included 
*  in all copies or substantial portions of the Software.
*
*  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
*  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
*  LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
*  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
*  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef CTYPE_TEST_P_H
#define CTYPE_TEST_P_H

enum {
    CTYPE_ALNUM  = 1 << 0,
    CTYPE_ALPHA  = 1 << 1,
    CTYPE_CNTRL  = 1 << 2,
    CTYPE_DIGIT  = 1 << 3,
    CTYPE_GRAPH  = 1 << 4,
    CTYPE_LOWER  = 1 << 5,
    CTYPE_PRINT  = 1 << 6,
    CTYPE_PUNCT  = 1 << 7,
    CTYPE_SPACE  = 1 << 8,
    CTYPE_UPPER  = 1 << 9,
    CTYPE_XDIGIT = 1 << 10,
    CTYPE_NAME   = 1 << 11,
    CTYPE_BINARY = 1 << 12,
    CTYPE_TEXT   = 1 << 13
};


static const short int ctype_data[0x100] = {
  0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, /* 0x00 */
  0x1004, 0x0104, 0x0104, 0x1004, 0x0104, 0x0104, 0x1004, 0x1004, /* 0x08 */
  0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, /* 0x10 */
  0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, /* 0x18 */
  0x0140, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, /* 0x20 */
  0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x08d0, 0x08d0, 0x08d0, /* 0x28 */
  0x0c59, 0x0c59, 0x0c59, 0x0c59, 0x0c59, 0x0c59, 0x0c59, 0x0c59, /* 0x30 */
  0x0c59, 0x0c59, 0x08d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, /* 0x38 */
  0x00d0, 0x2e53, 0x2e53, 0x2e53, 0x2e53, 0x2e53, 0x2e53, 0x2a53, /* 0x40 */
  0x2a53, 0x2a53, 0x2a53, 0x2a53, 0x2a53, 0x2a53, 0x2a53, 0x2a53, /* 0x48 */
  0x2a53, 0x2a53, 0x2a53, 0x2a53, 0x2a53, 0x2a53, 0x2a53, 0x2a53, /* 0x50 */
  0x2a53, 0x2a53, 0x2a53, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x08d0, /* 0x58 */
  0x00d0, 0x2c73, 0x2c73, 0x2c73, 0x2c73, 0x2c73, 0x2c73, 0x2873, /* 0x60 */
  0x2873, 0x2873, 0x2873, 0x2873, 0x2873, 0x2873, 0x2873, 0x2873, /* 0x68 */
  0x2873, 0x2873, 0x2873, 0x2873, 0x2873, 0x2873, 0x2873, 0x2873, /* 0x70 */
  0x2873, 0x2873, 0x2873, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x1004, /* 0x78 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0x80 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0x88 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0x90 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0x98 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0xa0 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0xa8 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0xb0 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0xb8 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0xc0 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0xc8 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0xd0 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0xd8 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0xe0 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0xe8 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0xf0 */
  0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, /* 0xf8 */
};

#define ctype_test(c, t) ((ctype_data[(unsigned short)c] & t) != 0)

#define isalnum(c)  ctype_test((c), CTYPE_ALNUM)
#define isalpha(c)  ctype_test((c), CTYPE_ALPHA)
#define iscntrl(c)  ctype_test((c), CTYPE_CNTRL)
#define isdigit(c)  ctype_test((c), CTYPE_DIGIT)
#define isgraph(c)  ctype_test((c), CTYPE_GRAPH)
#define islower(c)  ctype_test((c), CTYPE_LOWER)
#define isprint(c)  ctype_test((c), CTYPE_PRINT)
#define ispunct(c)  ctype_test((c), CTYPE_PUNCT)
#define isspace(c)  ctype_test((c), CTYPE_SPACE)
#define isupper(c)  ctype_test((c), CTYPE_UPPER)
#define isxdigit(c) ctype_test((c), CTYPE_XDIGIT)
#define isname(c)   ctype_test((c), CTYPE_NAME)
#define isbinary(c) ctype_test((c), CTYPE_BINARY)
#define istext(c)   ctype_test((c), CTYPE_TEXT)

#endif
