############################################################################
##      Copyright (C) 2005 Subredu Manuel  <diablo@iasi.roedu.net>.        #
##                                                                         #
## This program is free software; you can redistribute it and/or modify    #
## it under the terms of the GNU General Public License v2 as published by #
## the Free Software Foundation.                                           #
##                                                                         #
## This program is distributed in the hope that it will be useful,         #
## but WITHOUT ANY WARRANTY; without even the implied warranty of          #
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           #
## GNU General Public License for more details.                            #
##                                                                         #
## You should have received a copy of the GNU General Public License       #
## along with this program; if not, write to the Free Software             #
## Foundation, Inc., 59 Temple Place - Suite 330, Boston,                  #
## MA 02111-1307,USA.                                                      #
############################################################################

package RoPkg::Simba::Exceptions;

use strict;
use warnings;

use vars qw($VERSION);

$VERSION='0.1.3';

use Exception::Class (
    'NotHashRef' => {
      description => 'Parameter is not a hash reference',
    },
    'Mirror::Config' => {
      description => 'Mirror configuration error',
    },
    'Mirror::Inactive' => {
      description => 'Mirror is inactive',
    },
    'Mirror::InProgress' => {
      description => 'Mirror is in progress',
    },
    'Mirror::Many' => {
      description => 'More than 1 mirror matched your query',
    },
    'Command::FileNotFound' => {
      description => 'Command not found (file not found)',
    },
    'Command::NotFound' => {
      description => 'Command with specified id was not found',
    }
);

1;

__END__

=head1 NAME

RoPkg::Simba::Exceptions

=head1 VERSION

0.1.3

=head1 DESCRIPTION

Collection of exceptions used by Simba

=head1 SYNOPSIS

 NotHashRef->throw(
   error    => 'No hash reference found',
   pkg_name => 'RoPkg::Simba'
 );

=head1 DEPENDENCIES

Exception::Class

=head1 SUBROUTINES/METHODS

The following exceptions are defined:

=over 6

=item *) NotHashRef - the parameter is not a hash reference

=item *) Mirror::Config - error in configuration of the mirror

=item *) Mirror::Inactive - the mirror is not active

=item *) Mirror::InProgress - the mirror is in progress

=item *) Mirror::Many - the criteria used to select the mirror, matches multiple mirrors

=item *) Command::FileNotFound - command file name was not found

=back

=head1 DIAGNOSTICS

Unpack the source, and use 'make test' command

=head1 CONFIGURATION AND ENVIRONMENT

This module does not use any configuration files or environment variables

=head1 INCOMPATIBILITIES

None known to the author

=head1 BUGS AND LIMITATIONS

None known to the author

=head1 PERL CRITIC

This module is perl critic level 2 compliant

=head1 AUTHOR

Subredu Manuel <diablo@iasi.roedu.net>

=head1 LICENSE AND COPYRIGHT

Copyright (C) 2005 Subredu Manuel.  All Rights Reserved.
This module is free software; you can redistribute it 
and/or modify it under the same terms as Perl itself.
The LICENSE file contains the full text of the license.

=cut
