% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_events.R
\name{gen_events}
\alias{gen_events}
\title{Generator for tweening the appearance of elements}
\usage{
gen_events(
  .data,
  ease,
  start,
  end = NULL,
  range = NULL,
  enter = NULL,
  exit = NULL,
  enter_length = 0,
  exit_length = 0
)
}
\arguments{
\item{.data}{A data.frame with components at different stages}

\item{ease}{The easing function to use. Either a single string or one for
each column in the data set.}

\item{start, end}{The start (and potential end) of the event encoded in the
row, as unquoted expressions. Will be evaluated in the context of \code{.data} so
can refer to columns in it. If \code{end = NULL} the event will be without extend
and only visible in a single frame, unless \code{enter} and/or \code{exit} is given.}

\item{range}{The range of time points to include in the tween. If \code{NULL} it
will use the range of \code{time}}

\item{enter, exit}{functions that calculate a start state for new observations
that appear in \code{to} or an end state for observations that are not present in
\code{to}. If \code{NULL} the new/old observations will not be part of the tween. The
function gets a data.frame with either the start state of the exiting
observations, or the end state of the entering observations and must return
a modified version of that data.frame. See the \emph{Match, Enter, and Exit}
section for more information.}

\item{enter_length, exit_length}{The lenght of the opening and closing
transitions if \code{enter} and/or \code{exit} is given. Measured in the same units as
\code{time}}
}
\value{
A \code{component_generator} object
}
\description{
This is a generator version of \code{\link[=tween_events]{tween_events()}}. It returns a generator
that can be used with \code{\link[=get_frame]{get_frame()}} and \code{\link[=get_raw_frames]{get_raw_frames()}} to extract frames
for a specific time point scaled between 0 and 1.
}
\examples{
d <- data.frame(
  x = runif(20),
  y = runif(20),
  time = runif(20),
  duration = runif(20, max = 0.1)
)
from_left <- function(x) {
  x$x <- -0.5
  x
}
to_right <- function(x) {
  x$x <- 1.5
  x
}

gen <- gen_events(d, 'cubic-in-out', start = time, end = time + duration,
                  enter = from_left, exit = to_right, enter_length = 0.1,
                  exit_length = 0.05)

get_frame(gen, 0.65)

}
\seealso{
Other Other generators: 
\code{\link{gen_along}()},
\code{\link{gen_at}()},
\code{\link{gen_components}()},
\code{\link{gen_keyframe}()}
}
\concept{Other generators}
