% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_ferarri.R
\name{r2_ferrari}
\alias{r2_ferrari}
\alias{r2_ferrari.default}
\title{Ferrari's and Cribari-Neto's R2}
\usage{
r2_ferrari(model, ...)

\method{r2_ferrari}{default}(model, correct_bounds = FALSE, ...)
}
\arguments{
\item{model}{Generalized linear, in particular beta-regression model.}

\item{...}{Currently not used.}

\item{correct_bounds}{Logical, whether to correct the bounds of the response
variable to avoid 0 and 1. If \code{TRUE}, the response variable is normalized
and "compressed", i.e. zeros and ones are excluded.}
}
\value{
A list with the pseudo R2 value.
}
\description{
Calculates Ferrari's and Cribari-Neto's pseudo R2 (for
beta-regression models).
}
\examples{
\dontshow{if (require("betareg")) withAutoprint(\{ # examplesIf}
data("GasolineYield", package = "betareg")
model <- betareg::betareg(yield ~ batch + temp, data = GasolineYield)
r2_ferrari(model)
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Ferrari, S., and Cribari-Neto, F. (2004). Beta Regression for Modelling Rates
and Proportions. Journal of Applied Statistics, 31(7), 799–815.
\doi{10.1080/0266476042000214501}
}
}
